C--------------------------------------------------------
C     This is an example of using FORTRAN API (FLDF)
C     to set information in a uniform 2 dimensional 2 by 2 mesh 
C     containing one scalar node data component.
C     
C     V-template for this module looks like:
C     
C    module set_fld_unif {
C	Mesh_Unif+Node_Data+Scalar+Float+Oparam out_mesh;
C	fmethod+notify_inst+notify_val update = "set_fld_unif";
C    };
C
C---------------------------------------------------------
      INTEGER function set_fld_unif
     .     (set_fld_unif_id, event_mask, seq_num)
C     This line may need to be changed to:
C     include 'avs/omf.inc' for some platforms
C     include 'avs/fldf.inc' for some platforms

C     Use the new wide API introduced in AVS/Express 7.
C     Some variables that were previously 32-bits wide are now
C     64-bits wide when on a 64-bit platform.
C
C     Note that when on a 64-bit platform, memory pointers/offsets
C     are 64-bits wide even in AVS/Express versions prior to 7.
#define XP_WIDE_API

#include "avs/omf.inc"
#include "avs/fldf.inc"
      integer set_fld_unif_id(OIDSIZ), event_mask, seq_num
C     
C     Declare variables  
C     
      INTEGER id(OIDSIZ)
      INTEGER ndim, nspace 
      XP_LONG_INT npoints
#ifdef WORDLENGTH_64      
C     These are memory pointers or memory offsets and
C     thus must be 64-bits wide on a 64-bit machine.
      INTEGER*8 dims, offset, points, 
#else
      INTEGER dims, offset, points, 
#endif
      XP_LONG_INT dims_base(1)
      REAL pnt_base(1)
      INTEGER ncomp, comp, veclen
      INTEGER data_type
      XP_LONG_INT ndata
#ifdef WORDLENGTH_64      
C     These are memory pointers or memory offsets and
C     thus must be 64-bits wide on a 64-bit machine.
      INTEGER*8 data, data_offset
#else
      INTEGER data, data_offset
#endif

C     The type of the data_base array should be change 
C     to the type of node data
      REAL data_base(1)

C     Set  mesh
C     Get mesh id
      IF (OMFfind_subobj(set_fld_unif_id, 
     .     OMFstr_to_name('out_mesh'),
     .     OM_OBJ_RW, id) .NE. 1) THEN
         PRINT*,'Error finding out_mesh'
         set_fld_unif = 0
         return
      ENDIF

C     Set mesh dimensionality, ndim can be 1,2 or 3
      ndim = 2
      IF (FLDFset_ndim (id, ndim) .NE. 1) THEN
         PRINT*,'Error setting ndim'
         set_fld_unif = 0
         return
      ENDIF

C  Set mesh dims array
      dims = ARRFalloc(0,DTYPE_LONG,ndim,0)
      offset = ARRFoffset(dims,
     .   dims_base,DTYPE_LONG)
      dims_base(offset+1) = 2
      dims_base(offset+2) = 2
      IF (FLDFset_dims (id, 
     .   dims_base(1+offset)) .NE. 1) THEN
         PRINT*,'Error setting dims'
         set_fld_unif = 0
         return
      ENDIF

C  Set mesh nspace, nspace can be 1,2 or 3
      nspace = 2 
      IF (FLDFset_nspace (id, nspace) .NE. 1) THEN
         PRINT*,'Error setting nspace'
         set_fld_unif = 0
         return
      ENDIF

C     Set mesh extents by filling in points array with values for 2 points: 
C     low left and high right corners of the mesh
      npoints = 2*nspace
      points = ARRFalloc(0,DTYPE_FLOAT,nspace,0)
      offset = ARRFoffset(points,
     .     pnt_base,DTYPE_FLOAT)
      pnt_base(offset+1) = 0.0
      pnt_base(offset+2) = 0.0
      pnt_base(offset+3) = 1.0
      pnt_base(offset+4) = 1.0
      IF (FLDFset_points (id, 
     .     pnt_base(1+offset), 
     .     npoints, OM_SET_ARRAY_FREE) .NE. 1) THEN
         PRINT*,'Error setting points'
         set_fld_unif = 0
         return
      ENDIF
C
C     Set out_mesh's node data
C     Get field id
      IF (OMFfind_subobj(set_fld_unif_id, 
     .     OMFstr_to_name('out_mesh'),
     .     OM_OBJ_RW, id) .NE. 1) THEN
         PRINT*,'Error getting data'
         set_fld_unif = 0
         return
      ENDIF
      
C     Get number of node data components
      ncomp = 1
      IF (FLDFset_node_data_ncomp (id, ncomp) .NE. 1) THEN
         PRINT*,'Error getting ndata comp'
         set_fld_unif = 0
         return
      ENDIF
      
C     For each node data component set veclen, type and data arry itself
C     do it for each comp from 0 to ncomp-1
      comp = 0
C     Set veclen 
      veclen = 1
      IF (FLDFset_node_data_veclen (id, 
     .     comp, veclen) .NE. 1) THEN
         PRINT*,'Error getting data veclen'
         set_fld_unif = 0
         return
      ENDIF
      
C     Set data array and data_type which is one of the following: 
C     DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
C     DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE , DTYPE_LONG
      data_type = DTYPE_FLOAT
      IF (FLDFget_node_data (id, comp, 
     .     data_type, data,
     .     ndata, OM_GET_ARRAY_RW) .NE. 1) THEN
         PRINT*,'Error getting data'
         set_fld_unif = 0
         return
      ENDIF
      
      data_offset = ARRFoffset(data,
     .     data_base,data_type)

C     Fill in data_base array with values
C     starting with data_base(1+data_offset)

      data_base(data_offset+1) = 10
      data_base(data_offset+2) = 11
      data_base(data_offset+3) = 12
      data_base(data_offset+4) = 13

C     Other useful calls:
C     CALL FLDFget_node_data_id()
C     CALL FLDFget_node_null_data()
C     CALL FLDFget_node_data_minmax()
C     CALL FLDFget_node_data_label()
      
C  Free output variables 
C
      CALL ARRFfree(data)
C
      set_fld_unif = 1
      return
      end



C--------------------------------------------------------
C     This is an example of using FORTRAN API (FLDF)
C     to get information out of a uniform 2 dimensional 2 by 2 mesh 
C     containing one scalar node data component.
C     
C     V-template for this module looks like:
C     
C    module get_fld_unif {
C	Mesh_Unif+Node_Data+Iparam &in_mesh;
C	fmethod+notify_inst+notify_val update = "get_fld_unif";
C    };
C
C---------------------------------------------------------
      INTEGER function get_fld_unif
     .     (get_fld_unif_id, event_mask, seq_num)
C     This line may need to be changed to:
C     include 'avs/omf.inc' for some platforms
C     include 'avs/fldf.inc' for some platforms

#include "avs/omf.inc"
#include "avs/fldf.inc"
      integer get_fld_unif_id(OIDSIZ), event_mask, seq_num
C     
C     Declare variables  
C     
      INTEGER id(OIDSIZ)
      INTEGER ndim, nspace
      XP_LONG_INT npoints
#ifdef WORDLENGTH_64      
C     These are memory pointers or memory offsets and
C     thus must be 64-bits wide on a 64-bit machine.
      INTEGER*8 dims, offset, points
#else
      INTEGER dims, offset, points
#endif
      XP_LONG_INT dims_base(1)
      REAL pnt_base(1)
      INTEGER ncomp, comp, veclen
      INTEGER data_type
      XP_LONG_INT ndata
#ifdef WORDLENGTH_64      
C     These are memory pointers or memory offsets and
C     thus must be 64-bits wide on a 64-bit machine.
      INTEGER*8 data, data_offset
#else
      INTEGER data, data_offset
#endif
C     The type of the data_base array should be change to the type of node data
      REAL data_base(1)
C     
C     Get input values   
C     
C     Get in_mesh mesh
C     Get mesh id
      IF (OMFfind_subobj(get_fld_unif_id, 
     .     OMFstr_to_name('in_mesh'),
     .     OM_OBJ_RD, id) .NE. 1) THEN
         PRINT*,'Error finding in_mesh'
         get_fld_unif = 0
         return 
      ENDIF
C     Get mesh dims array
      IF (FLDFget_dims(id, dims, ndim)
     .     .NE. 1) THEN
         PRINT*,'Error getting ndims'
         get_fld_unif = 0
         return 
      ENDIF
      
      offset = ARRFoffset(dims,
     .     dims_base,DTYPE_LONG)
      
      PRINT *, 'ndim=', ndim, '  dims=',
     .     dims_base(offset+1),
     .     dims_base(offset+2)
      
C     Get mesh nspace
      IF (FLDFget_nspace (id, nspace) .NE. 1) THEN
         PRINT*,'Error getting nspace'
         get_fld_unif = 0
         return 
      ENDIF
      
      PRINT*, 'nspace=', nspace
      
C     Get mesh extents
      IF (FLDFget_points (id, points, 
     .     npoints, OM_GET_ARRAY_RD) .NE. 1) THEN
         PRINT*,'Error getting points'  
         get_fld_unif = 0
         return 
      ENDIF
      
      offset = ARRFoffset(points,
     .     pnt_base,DTYPE_FLOAT)
      PRINT*, 'points'
      PRINT*, (pnt_base(i+offset),i=1,4)
      
C     
C     Get in_mesh's node data
C     Get field id
      IF (OMFfind_subobj(get_fld_unif_id, 
     .     OMFstr_to_name('in_mesh'),
     .     OM_OBJ_RD, id)  .NE. 1) THEN
         PRINT*,'Error getting mesh' 
         get_fld_unif = 0
         return 
      ENDIF
      
C     Get number of node data components
      IF (FLDFget_node_data_ncomp (id, ncomp) 
     .     .NE. 1) THEN
         PRINT*,'Error getting nnode comp'
         get_fld_unif = 0
         return 
      ENDIF
      
      PRINT*, 'ndata=', ncomp
C     For each node data component get veclen, type and data arry itself
C     do it for each comp from 0 to ncomp-1
      comp = 0
C     Get veclen
      IF (FLDFget_node_data_veclen (id, comp, 
     .     veclen) .NE. 1) THEN
         PRINT*,'Error getting data veclen' 
         get_fld_unif = 0
         return 
      ENDIF
      
      PRINT*, 'veclen=', veclen
      
C     Get data array and data_type which is one of the following: 
C     DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
C     DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE ,DTYPE_LONG 
      IF (FLDFget_node_data (id, comp, 
     .     data_type, data,
     .     ndata, OM_GET_ARRAY_RD) .NE. 1) THEN
         PRINT*,'Error getting data type' 
         get_fld_unif = 0
         return 
      ENDIF
      
      data_offset = ARRFoffset(data,
     .     data_base,data_type)
      
      PRINT*, 'data values'
      PRINT*, (data_base(i+data_offset),i=1,4)
      
C     Other useful calls:
C     CALL FLDFget_node_data_id()
C     CALL FLDFget_node_null_data()
C     CALL FLDFget_node_data_minmax()
C     CALL FLDFget_node_data_label()
      
C  Free input variables
C
      CALL ARRFfree(dims)
      CALL ARRFfree(points)
      CALL ARRFfree(data)
C
      get_fld_unif = 1
      return
      end

