/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/image/libpbm/write.c#1 $
*/

#include "pbm.h"

/* protos for funcs private to this file */
static void writeppm (pbm_t *);
static void writepgm (pbm_t *);
static void writepbm (pbm_t *);

/*-------------------------------------------------------------------------*/
/* top level "write out a PBMplus file" function
 */
int Writepnm(pbm_t *pbm)
{
  int magic;

  /* determine the id number following the "P" in the first byte */
  if (pbm->colortype == DV_IMAGE_COLORTYPE_RGB)
    magic = 3;
  else if (pbm->colortype == DV_IMAGE_COLORTYPE_GREY)
    magic = 2;
  else if (pbm->colortype == DV_IMAGE_COLORTYPE_BW)
    magic = 1;
  else
    return(pbmFAILURE);

  if (pbm->type == DV_IMAGE_FILE_TYPE_BINARY)
    magic += 3;

  /* write the 2 byte id info */
  fprintf(pbm->fp, "P%d\n", magic);

  /* write the width and height - ASCII */
  fprintf(pbm->fp,"%d %d\n", pbm->width, pbm->height);

  /* write the "maxval" for RGB and grey - ASCII */
  if (pbm->colortype != DV_IMAGE_COLORTYPE_BW)
    fprintf(pbm->fp, "255\n");

  if (ferror(pbm->fp))
    return(pbmFAILURE);

  /* write the image data */
  if (pbm->colortype == DV_IMAGE_COLORTYPE_RGB)
    writeppm(pbm);
  else if (pbm->colortype == DV_IMAGE_COLORTYPE_GREY)
    writepgm(pbm);
  else if (pbm->colortype == DV_IMAGE_COLORTYPE_BW)
    writepbm(pbm);

  if (ferror(pbm->fp))
    return(pbmFAILURE);

  return(pbmSUCCESS);
}

/*-------------------------------------------------------------------------*/
/* writes "pixmap" RGB data
 */
static void writeppm(pbm_t *pbm)
{
  int     i, j, len;
  pbmBYTE *data;

  if (pbm->type == DV_IMAGE_FILE_TYPE_BINARY)
  {
    if (pbm->flip)
    {
      len = pbm->width * 4;
      data = pbm->argb_data + ((pbm->height - 1) * len);
      for (i = 0; i < pbm->height; i++)
      {
	for (j = 0; j < pbm->width; j++)
        {
	  data++;
	  putc(*data++, pbm->fp);
	  putc(*data++, pbm->fp);
	  putc(*data++, pbm->fp);
	}
	data -= len * 2;
      }
    }
    else
    {
      data = pbm->argb_data;
      len = pbm->width * pbm->height;
      for (i = 0; i < len; i++)
      {
	data++;
	putc(*data++, pbm->fp);
	putc(*data++, pbm->fp);
	putc(*data++, pbm->fp);
      }
    }
  }
  else
  {
    if (pbm->flip)
    {
      len = pbm->width * 4;
      data = pbm->argb_data + ((pbm->height - 1) * len);
      for (i = 0; i < pbm->height; i++)
      {
	for (j = 1; j <= pbm->width; j++)
        {
	  data++;
	  fprintf(pbm->fp, "%3d %3d %3d ", *data, *(data+1), *(data+2));
	  data += 3;

	  if (!(j & 7))
	    fprintf(pbm->fp, "\n");
	}
	fprintf(pbm->fp, "\n");
	data -= len * 2;
      }
    }
    else
    {
      data = pbm->argb_data;
      len = pbm->width * pbm->height;
      for (i = 1; i <= len; i++)
      {
	data++;
	fprintf(pbm->fp, "%3d %3d %3d ", *data, *(data+1), *(data+2));
	data += 3;

	if (!(i & 7))
	  fprintf(pbm->fp, "\n");
      }
    }
  }
}

/*-------------------------------------------------------------------------*/
/* writes "greymap" index data
 */
static void writepgm(pbm_t *pbm)
{
  int     i, j, len, grey;
  pbmBYTE *data;

  if (pbm->type == DV_IMAGE_FILE_TYPE_BINARY)
  {
    if (pbm->flip)
    {
      len = pbm->width * 4;
      data = pbm->argb_data + ((pbm->height - 1) * len);
      for (i = 0; i < pbm->height; i++)
      {
	for (j = 0; j < pbm->width; j++)
        {
	  data++;
	  grey = (float) *data++ * 0.299;
	  grey += (float) *data++ * 0.587;
	  grey += (float) *data++ * 0.114;
	  grey &= 0xff;
	  putc(grey, pbm->fp);
	}
	data -= len * 2;
      }
    }
    else
    {
      len = pbm->width * pbm->height;
      data = pbm->argb_data;
      for (i = 0; i < len; i++)
      {
	data++;
	grey = (float) *data++ * 0.299;
	grey += (float) *data++ * 0.587;
	grey += (float) *data++ * 0.114;
	grey &= 0xff;
	putc(grey, pbm->fp);
      }
    }
  }
  else
  {
    if (pbm->flip)
    {
      len = pbm->width * 4;
      data = pbm->argb_data + ((pbm->height - 1) * len);
      for (i = 0; i < pbm->height; i++)
      {
	for (j = 1; j <= pbm->width; j++)
        {
	  data++;
	  grey = (float) *data++ * 0.299;
	  grey += (float) *data++ * 0.587;
	  grey += (float) *data++ * 0.114;
	  grey &= 0xff;

	  fprintf(pbm->fp, "%3d ", grey);

	  if (!(j & 15))
	    fprintf(pbm->fp, "\n");
	}
	fprintf(pbm->fp, "\n");
	data -= len * 2;
      }
    }
    else
    {
      len = pbm->width * pbm->height;
      data = pbm->argb_data;
      for (i = 1; i <= len; i++)
      {
	data++;
	grey = (float) *data++ * 0.299;
	grey += (float) *data++ * 0.587;
	grey += (float) *data++ * 0.114;
	grey &= 0xff;

	fprintf(pbm->fp, "%3d ", grey);

	if (!(i & 15))
	  fprintf(pbm->fp, "\n");
      }
    }
  }
}

/*-------------------------------------------------------------------------*/
/* writes "bitmap" 1 bit per pixel (BW) data
 */
static void writepbm(pbm_t *pbm)
{
#if 0
  int     i, len;
  pbmBYTE *data;

  /* this won't work right now: need to dither into 0/1 byte */
  len = pbm->width * pbm->height;
  data = pbm->argb_data;
  if (pbm->type == DV_IMAGE_FILE_TYPE_BINARY)
  {
    int bit, packed;

    packed = bit = 0;

    for (i = 0; i < len; i++, data += 4)
    {
      packed <<= 1;
      if (data[1])
	packed | 1;
      bit++;
      if (bit == 8)
      {
	putc(packed, pbm->fp);
	packed = bit = 0;
      }
    }
    if (bit)
      putc(packed, pbm->fp);
  }
  else
  {
    for (i = 1; i <= len; i++, data += 4)
    {
      if (data[1])
	fprintf(pbm->fp, "1 ");
      else
	fprintf(pbm->fp, "0 ");

      if (!(i & 63))
	fprintf(pbm->fp, "\n");
    }
  }
#endif
}
