/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/integr.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("integr_vol",1,ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024

int FUNCintegr_vol (OMobj_id in, int comp, int dim, 
                    float *volume, float *mass);

int DVintegr_vol_update(OMobj_id elem_id)
{
	OMobj_id in, vol_id, mass_id, comp_id, dim_id;
	float volume, mass;
	int dim, comp;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	vol_id = OMfind_subobj(elem_id, OMstr_to_name("volume"), OM_OBJ_RW);
	mass_id = OMfind_subobj(elem_id, OMstr_to_name("mass"), OM_OBJ_RW);
	comp_id = OMfind_subobj(elem_id, OMstr_to_name("component"), OM_OBJ_RD);
	OMget_int_val(comp_id, &comp);
	dim_id = OMfind_subobj(elem_id, OMstr_to_name("dim"), OM_OBJ_RD);
	OMget_int_val(dim_id, &dim);

	if (FUNCintegr_vol(in, comp, dim, &volume, &mass)) {
		OMset_real_val(vol_id, (double)volume);
		OMset_real_val(mass_id, (double)mass);
		return(1);
	}
	else return(0);
}

/* 64-bit porting. Only Modified Internally */
int FUNCintegr_vol (OMobj_id in, int comp, int dim, float *volume, float *mass)
{
	int   veclen, ncomp, stat, null_flag, data_type;
	xp_long size;
	char   *node_data;
	char   *mesh_info;
	double null_value;

	stat = FLDget_mesh_info(in, &mesh_info);
	if (!stat) {
		ERR_RETURN("cannot create cell table");
	}

	if (FLDget_node_data_ncomp(in, &ncomp) != 1 || ncomp == 0) {
		node_data = NULL;
	}
	else {
		if (comp >= ncomp) {
			ERR_RETURN("invalid data component, no integral calculated");
		}
		if (FLDget_node_data_veclen(in, comp, &veclen) !=1) {
			ERR_RETURN("Error getting veclen");
		}

		if (veclen != 1) {
			ERRerror("integr_vol",1,ERR_ORIG, "first component is not scalar, no mass calculated");
			node_data = NULL;
		}

		if (FLDget_node_data(in, comp, &data_type, &node_data,
				     &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}
		if (FLDget_node_null_data(in, comp, &null_flag, (char *)&null_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
	}
	UTILvol_integr(mesh_info, dim, node_data, data_type, null_flag,
		       (char *)&null_value, volume, mass);
	if (node_data == NULL)
		*mass = 0.0;

	FLDfree_mesh_info(mesh_info);

	if (node_data)
		ARRfree(node_data);
	return(1);
}
