/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/labels.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/db.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/data_utils.h>

#define ERR_RETURN(A) ERRerror("data_labels",1,ERR_ORIG, A); return(0);

#define MAX_LABEL_SIZE  1024
#define MAX_DATA_COMP   256

int DVnode_data_labels_update(OMobj_id elem_id)
{
	OMobj_id in, out;
	int    stat, comp, ncomp;
	char   label[MAX_LABEL_SIZE];

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("labels"), OM_OBJ_RW);

	if ((stat = FLDget_node_data_ncomp(in, &ncomp)) != 1)
		return(stat);
	if (OMset_array_size(out, ncomp) != 1) {
		ERR_RETURN("cannot set size of labels");
	}

	for (comp=0; comp<ncomp; comp++) {
		stat = FLDget_node_data_label(in, comp, label, MAX_LABEL_SIZE);
		if (stat < 0)
			return(stat);
		else if (stat == 0)
			strcpy(label, "NO NAME");
		if ((stat = OMset_str_array_val(out, comp, label)) != 1)
			return(stat);
	}
	return(1);
}

int DVcell_data_labels_update(OMobj_id elem_id)
{
	OMobj_id in, out, min_id, max_id, cell_set;
	int    stat, nsets, cs, comp, ncomp, i, found, count, ndata, first, dtype;
	char   label[MAX_LABEL_SIZE], *data_labels[MAX_DATA_COMP];
	double min, max, dmin[MAX_DATA_COMP], dmax[MAX_DATA_COMP];

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("labels"), OM_OBJ_RW);
	min_id = OMfind_subobj(elem_id, OMstr_to_name("min_data"), OM_OBJ_RW);
	max_id = OMfind_subobj(elem_id, OMstr_to_name("max_data"), OM_OBJ_RW);

	if (FLDget_ncell_sets(in, &nsets) != 1) {
		return(0);
	}
	count = 0;
	ndata = 0;
	for (first=1, cs=0; cs<nsets; cs++) {
		if (FLDget_cell_set(in, cs, &cell_set) != 1) {
			OMset_array_size(out, 0);
			OMset_obj_val(out, OMnull_obj,0);
			return(0);
		}
		if ( FLDget_cell_data_ncomp(cell_set, &ncomp) != 1) {
			OMset_array_size(out, 0);
			OMset_obj_val(out, OMnull_obj,0);
			return(0);
		}
		for (comp=0; comp<ncomp; comp++) {
			stat = FLDget_cell_data_label(cell_set, comp, label, MAX_LABEL_SIZE);
			if (stat < 0)
				return(stat);
			else if (stat == 0) 
				sprintf(label,"Data %d",comp);
			for (found=0, i=0; i<count; i++) {
				if (!strcmp(label, data_labels[i])) {
					found = 1;
					break;
				}
			}
			if (!found) {
				if (count >= MAX_DATA_COMP) {
					ERR_RETURN("number of data components exceeds the limit of 256");
				}
				data_labels[count] = malloc(MAX_LABEL_SIZE*sizeof(char));
				strcpy(data_labels[count++], label);
			}
			if (first) {
				ndata = ncomp;
				if (FLDget_cell_data_type(cell_set, comp, &dtype) != 1) {
					ERR_RETURN("Error getting cell data type");
				}
				if (FLDget_cell_data_minmax_total(in, comp, (char *)&min, (char *)&max) != 1) {
					ERR_RETURN("Error getting cell minmax");
				}
				if (comp >= MAX_DATA_COMP) {
					ERR_RETURN("number of data components exceeds the limit of 256");
				} 
				UTILtype_to_double(dmin+comp, (char *)&min, dtype);
				UTILtype_to_double(dmax+comp, (char *)&max, dtype);
			}
		}
		first = 0;
	}
	if (OMset_array_size(out, count) != 1) {
		ERR_RETURN("cannot set size of labels");
	}
	if (count <= 0) {
		OMset_obj_val(out, OMnull_obj,0);
	}
	for (i=0; i<count; i++) {
		stat = OMset_str_array_val(out, i, data_labels[i]);
		free(data_labels[i]);
		if (stat != 1) {
			ERR_RETURN("cannot set cell name");
		}
	}
	stat = OMset_array(min_id, DTYPE_DOUBLE, (char *)dmin, ndata, OM_SET_ARRAY_COPY);
	if (stat != 1) {
		ERR_RETURN("cannot set cell data min");
	}
	stat = OMset_array(max_id, DTYPE_DOUBLE, (char *)dmax, ndata, OM_SET_ARRAY_COPY);
	if (stat != 1) {
		ERR_RETURN("cannot set cell data max");
	}

	return(1);
}

int DVcell_labels_update(OMobj_id elem_id)
{
	OMobj_id in, out, cell_set;
	int    stat, nsets, cs, l;
	char   label[MAX_LABEL_SIZE], name[MAX_LABEL_SIZE];

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("labels"), OM_OBJ_RW);

	if (FLDget_ncell_sets(in, &nsets) != 1) {
		return(0);
	}
	if (OMset_array_size(out, nsets) != 1) {
		ERR_RETURN("cannot set size of labels");
	}
	if (nsets <= 0) {
		OMset_obj_val(out, OMnull_obj,0);
	}
	for (cs=0; cs<nsets; cs++) {
		if (FLDget_cell_set(in, cs, &cell_set) != 1) {
			OMset_array_size(out, 0);
			return(0);
		}
		sprintf(label, "%d \0", cs);
		l = (int)strlen(label);
		stat = FLDget_cell_set_name(cell_set, name, MAX_LABEL_SIZE);
		if (stat < 0)
			return(stat);
		else if (stat == 0)
			strcpy(name, "Set");
		strcpy(label+l, name);
		strcat(label, " ");
		stat = FLDget_cell_set_user_name(cell_set, name, MAX_LABEL_SIZE);
		if (stat == 1)
			strcat(label, name);
		stat = OMset_str_array_val(out, cs, label);
		if (stat != 1) {
			ERR_RETURN("cannot set cell name");
		}
	}
	return(1);
}



