/*
 		Copyright (c) 1994 by
      		Advanced Visual Systems Inc.
      		All Rights Reserved

      This software comprises unpublished confidential information of
      Advanced Visual Systems Inc. and may not be used, copied or made
      available to anyone, except in accordance with the license
      under which it is furnished.

      This file is under Perforce control
      $Id: //depot/express/fcs70/modules/load_scr.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>

#include <avs/util.h>
#include <avs/om.h>
#include <avs/om_type.h>
#include <avs/f_utils.h>

int DVload_script_update(OMobj_id elem_id)
{
   OMobj_id file_id;
   char val_buf[1024];
   char *file = val_buf;
   OMobj_id dst_id;

   file_id = OMfind_subobj(elem_id, OMstr_to_name("filename"), OM_OBJ_RD);
   if (OMget_str_val(file_id, &file, sizeof(val_buf)) != 1) {
      fprintf(stderr, "[load_script]: Unable to get filename string\n");
      return(0);
   }

   dst_id = OMfind_subobj(elem_id, OMstr_to_name("dst"), OM_OBJ_RD);
   if (OMget_obj_val(dst_id,&dst_id) != 1) {
      if (OMget_array_subobj(OMinst_obj,0,&dst_id,OM_OBJ_RW) != 1)
         dst_id = OMinst_obj;
   }

   /* Mark the stuff in the script as transient so if we
      happen to be recording, we won't log any of the events.
      The fact that we loaded the file is good enough - else
      we will get everything twice.
   */
   OMpush_ctx(elem_id, OM_STATE_TRANSIENT, 0, 0);

   /* Use read desc - we can later expose the option
      to merge or replace to the user - arg3 in the call.
   */
   OMread_desc(dst_id,file,0);

   OMpop_ctx(elem_id);

   return(1);
}

