/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/probe.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/mat.h>
#include <avs/gd.h>

#define ERR_RETURN(A) ERRerror("probe", 0, ERR_ORIG, A); return(0);

static float IXFORM[16] = {1.0, 0.0, 0.0, 0.0,
			   0.0, 1.0, 0.0, 0.0,
			   0.0, 0.0, 1.0, 0.0,
			   0.0, 0.0, 0.0, 1.0};

static float IXYZ[3] = {0.0, 0.0, 0.0};

/* 64-bit porting. Only Modified Internally */
int DVprobe_update(OMobj_id mod_id)
{
	OMobj_id picked_fld, probe_fld, pck_xyz_id, pck_xform_id, probe_xform_id;
	OMobj_id out_xyz_id, e1, e2;
	int   type, stat, seq0, seq1, seq2;
	xp_long size;
	float pck_xfm[4][4], *pck_xyz, xyz[3];

	if (OMis_null_obj(mod_id)) {
		ERR_RETURN(" module id is 0**\n");
	}

	picked_fld = OMfind_subobj(mod_id, OMstr_to_name("picked_fld"), OM_OBJ_RD);
	probe_fld = OMfind_subobj(mod_id, OMstr_to_name("probe_fld"), OM_OBJ_RD);


	if (!OMis_null_obj(picked_fld) && !OMis_null_obj(probe_fld)) {
		if ((stat=OMget_obj_val(picked_fld, &e1)) != 1 ||
		    (stat=OMget_obj_val(probe_fld, &e2)) != 1 )
			return (stat);
	}

	probe_xform_id = OMfind_subobj(mod_id, OMstr_to_name("probe_xform"), OM_OBJ_RW);
	pck_xform_id = OMfind_subobj(mod_id, OMstr_to_name("picked_xform"), OM_OBJ_RD);
	pck_xyz_id = OMfind_subobj(mod_id, OMstr_to_name("picked_xyz"), OM_OBJ_RD);
	out_xyz_id = OMfind_subobj(mod_id, OMstr_to_name("out_xyz"), OM_OBJ_RW);

	if (OMis_null_obj(probe_xform_id)) {
		ERR_RETURN("cannot find probe_xform");
	}
	if (OMis_null_obj(pck_xform_id)) {
		ERR_RETURN("cannot find picked_xform");
	}
	if (OMis_null_obj(pck_xyz_id)) {
		ERR_RETURN("cannot find picked_xyz");
	}
	if (OMis_null_obj(out_xyz_id)) {
		ERR_RETURN("cannot find out xyz");
	}

	seq0 = OMget_obj_seq(pck_xform_id, OMnull_obj, OM_SEQ_VAL);
	seq1 = OMget_obj_seq(pck_xyz_id, OMnull_obj, OM_SEQ_VAL);
	seq2 = OMget_obj_seq(probe_xform_id, OMnull_obj, OM_SEQ_VAL);

	if (seq0 == seq2 && seq1 == seq2)
		return(0);

	if (seq1 > seq2 && OMequal_objs(e1, e2))
		return(1);

	if (seq0 > seq1 && seq0 > seq2) {  /** PICKED FIELD TRANSOFM **/
		size = 0;
		type = DTYPE_FLOAT;
		pck_xyz = (float *)NULL;
		stat = OMget_array_sz(pck_xyz_id, &type, (char **)(&pck_xyz),
				      &size, OM_GET_ARRAY_RD);
		if (stat != 1)
			return(stat);

		memcpy(xyz, pck_xyz, 3*sizeof(float));
	}
	else if (seq1 > seq2)  { /**  USER PICKED **/
		size = 0;
		type = DTYPE_FLOAT;
		pck_xyz = (float *)NULL;
		stat = OMget_array_sz(pck_xyz_id, &type, (char **)(&pck_xyz),
				      &size, OM_GET_ARRAY_RD);
		if (stat != 1)
			return(stat);

		memcpy(xyz, pck_xyz, 3*sizeof(float));

		GDxform_get_comp_matrix(pck_xform_id, (float *)pck_xfm);
		MATvec3_mat4_multiply(xyz, pck_xfm);
	}
	else if (seq2 >= seq0 && seq2 > seq1) {    /**  PROBE TRANSFORM  **/
		size = 0;
		type = DTYPE_FLOAT;
		pck_xyz = (float *)NULL;
		stat = OMget_array_sz(out_xyz_id, &type, (char **)(&pck_xyz),
				      &size, OM_GET_ARRAY_RD);
		if (stat != 1)
			return(stat);
		memcpy(xyz, pck_xyz, 3*sizeof(float));

		GDxform_get_comp_matrix(probe_xform_id, (float *)pck_xfm);
		MATvec3_mat4_multiply(xyz, pck_xfm);
	}
	stat = OMset_array(out_xyz_id, type, (char *)xyz, 3, OM_SET_ARRAY_COPY);
	if (stat != 1)
		return(stat);
	GDxform_set_matrix(probe_xform_id, (Matr4 *)IXFORM);
	GDxform_set_xlate(probe_xform_id, IXYZ);
	GDxform_set_center(probe_xform_id, IXYZ);
	ARRfree(pck_xyz);
	return(1);
}
