/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/sct2unif.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/dtype.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>
#include <avs/data_utils.h>

#define MAX_NAME_SIZE 1024

#define ERR_RETURN(A) \
	ERRerror( "FUNCscat_to_unif", 0, ERR_ORIG, A ); return( 0 );

#define TEST_ID(ID,N) \
	if (OMis_null_obj(ID)) { \
	  sprintf( err_msg, "Error getting subobject id for %s", N ); \
	  ERRerror( "DVscat_to_unif_update", 0, ERR_ORIG, err_msg ); \
	  return( 0 ); }

#define TEST_STAT(S,N) \
	if (S != OM_STAT_SUCCESS) { \
	  sprintf( err_msg, "Error getting subobject value for %s", N ); \
	  ERRerror( "DVscat_to_unif_update", 0, ERR_ORIG, err_msg ); \
	  return(0); }

int FUNCscat_to_unif (OMobj_id in, int ndim, xp_long *dims, float *min_xyz,
                      float *max_xyz, int *cube, int order,
                      int in_null_flag, double in_null_value, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVscat_to_unif_update(OMobj_id elem_id, OMevent_mask event_mask,
                          int seq_num)
{
	OMobj_id in, out,e_id;
	int      stat, ndim;
	xp_long  dims[3], r_dims[3], min_rng[3], max_rng[3];
        int      cube[3], order, null_flag;
	double   null_value;
	float    min_xyz[3], max_xyz[3];
        char     err_msg[128];

	in  = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
        TEST_ID( in, "in" );

	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
        TEST_ID( out, "out" );

	e_id = OMfind_subobj(elem_id, OMstr_to_name("rndim"), OM_OBJ_RW);
        TEST_ID( e_id, "rndim" );

	stat = OMget_int_val(e_id, &ndim);
        TEST_STAT( stat, "ndim" );

	e_id = OMfind_subobj(elem_id, OMstr_to_name("rdims"), OM_OBJ_RW);
        TEST_ID( e_id, "rdims" );

	r_dims[0]  = ndim;
	min_rng[0] = 0;
	max_rng[0] = ndim;

	stat = OMget_sub_larray(e_id, 1, r_dims, min_rng, max_rng, (void *)dims);
        TEST_STAT( stat, "dims" );

	e_id = OMfind_subobj(elem_id, OMstr_to_name("min_xyz"), OM_OBJ_RW);
        TEST_ID( e_id, "min_xyz" );

	r_dims[0]  = ndim;
	min_rng[0] = 0;
	max_rng[0] = ndim;

	stat = OMget_sub_farray(e_id, 1, r_dims, min_rng, max_rng, (void *)min_xyz);
        TEST_STAT( stat, "min_xyz" );

	e_id = OMfind_subobj(elem_id, OMstr_to_name("max_xyz"), OM_OBJ_RW);
        TEST_ID( e_id, "max_xyz" );

	stat = OMget_sub_farray(e_id, 1, r_dims, min_rng, max_rng, (void *)max_xyz);
        TEST_STAT( stat, "max_xyz" );

	e_id = OMfind_subobj(elem_id, OMstr_to_name("search_cube"), OM_OBJ_RW);
        TEST_ID( e_id, "search_cube" );

	r_dims[0]  = ndim;
	min_rng[0] = 0;
	max_rng[0] = ndim;

	stat = OMget_sub_iarray(e_id, 1, r_dims, min_rng, max_rng, (void *)cube);
        TEST_STAT( stat, "search_cube" );

	e_id = OMfind_subobj(elem_id, OMstr_to_name("interp_order"), OM_OBJ_RW);
        TEST_ID( e_id, "interp_order" );

	stat = OMget_int_val(e_id, &order);
        TEST_STAT( stat, "interp_order" );

	e_id = OMfind_subobj(elem_id, OMstr_to_name("null_value"), OM_OBJ_RW);
        TEST_ID( e_id, "null_value" );

	stat = OMget_real_val(e_id, &null_value);
        if (stat == 0) {
		null_flag = 0;
		null_value = 0;
	}
	else if (stat == 1)
		null_flag = 1;
	else {
		TEST_STAT( stat, "null_value" );
	}

	if (FUNCscat_to_unif(in, ndim, dims, min_xyz, max_xyz, cube, order,
			     null_flag, null_value, out))
	     return(1);
	else
             return(0);
}

/* 64-bit porting. Directly Modified */
int FUNCscat_to_unif (OMobj_id in, int ndim, xp_long *dims, float *min_xyz,
                      float *max_xyz, int *cube, int order,
		      int in_null_flag, double in_null_value, OMobj_id out)
{
	xp_long   nnodes;
	int   nspace, ncomp, comp, veclen, null_flag, data_id;
	int   dtype, rnull_flag, stat, i;
	xp_long size;
	char *node_data, *out_node_data;
	float *xyz, *out_xyz;
	char  label[MAX_NAME_SIZE], units[MAX_NAME_SIZE];
	double null_value, rnull_value;

	if (FLDset_node_data_ncomp (out, 0) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}

	for (i=0; i<ndim; i++) {
		if(dims[i] < 2)
			return(0);
		if (cube[i] == 0)
			return(0);
	}
	if (order < 0)
		return(0);
	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	if (FLDget_nspace(in, &nspace) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	if (FLDget_coord(in, &xyz, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get coordinates");
	}
	if (FLDget_points (out, &out_xyz, &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error getting points");
	}
	memcpy(out_xyz, min_xyz, ndim*sizeof(float));
	memcpy(out_xyz+ndim, max_xyz, ndim*sizeof(float));

	if (FLDget_node_data_ncomp (in, &ncomp) != 1) {
		ERR_RETURN("Error getting nnode_data");
	}
	if (FLDset_node_data_ncomp (out, ncomp) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	null_flag = in_null_flag;
	for (comp=0; comp<ncomp; comp++) {
		if (FLDget_node_data_units(in, comp, units, MAX_NAME_SIZE) != 1) {
			strcpy(units, "");
		}
		if (FLDget_node_data_label(in, comp, label, MAX_NAME_SIZE) != 1) {
			strcpy(label, "");
		}
		if (FLDget_node_data_veclen(in, comp, &veclen) != 1) {
			ERR_RETURN("Error getting veclen");
		}
		if (FLDset_node_data_comp (out, comp, veclen, label, units) != 1) {
			ERR_RETURN("Error setting node component");
		}

		if (FLDget_node_data_id(in, comp, &data_id) == 1)
			FLDset_node_data_id(out, comp, data_id);

		if (FLDcopy_node_minmax(in, out, comp, comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDcopy_node_minmax_vec(in, out, comp, comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}

		if (FLDget_node_data(in, comp, &dtype, &node_data,
				     &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}
		if (FLDget_node_data(out, comp, &dtype, &out_node_data,
				     &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("cannot get node data");
		}
		UTILdouble_to_type(&null_value, in_null_value, dtype);
		if (FLDget_node_null_data(in, comp, &rnull_flag, (char *)&rnull_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
		if (rnull_flag && !null_flag) {
			null_value = rnull_value;
			null_flag = 1;
		}
		else if (!rnull_flag && !null_flag) {
			null_flag = 0;
			UTILdouble_to_type(&null_value, (double)0, dtype);
		}
		else if (!rnull_flag && null_flag) {
			null_flag = 0;

		}
		stat = UTILscat_data_interp2 (nnodes, nspace, xyz,
					      dtype, veclen, node_data,
					      min_xyz, max_xyz, ndim, dims, cube, order,
					      &null_flag, (char *)&null_value,
					      out_node_data);
		if (stat != 1) {
			if (FLDset_node_data_ncomp (out, 0) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
			ARRfree(node_data);
			ARRfree(out_node_data);
			ARRfree(xyz);
			ARRfree(out_xyz);
			return(0);
		}
		if (null_flag) {
			if (FLDset_node_null_data(out, comp, (char *)&null_value, dtype) != 1) {
				ERR_RETURN("Error setting null value");
			}
		}
		else {
			if (FLDset_node_null_flag(out, comp, 0) != 1) {
				ERR_RETURN("Error setting null flag");
			}
		}

		ARRfree(node_data);
		ARRfree(out_node_data);

	}

	ARRfree(xyz);
	ARRfree(out_xyz);

	return(1);
}
