/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/set_slc.c#1 $
*/

#include <string.h>

#define XP_WIDE_API	/* Use Wide APIs */
#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>

#define ERR_RETURN(A) ERRerror("set_slice_data", 0, ERR_ORIG, A); return(0);

/* 64-bit porting. Only Modified Internally */
int DVset_slice_data_update(OMobj_id elem_id)
{
   OMobj_id tmp_id, inField_id, sliceField_id;
   int slice, dims_size;
   xp_long *dims, out_index, out_size;
   int i, in_comps, in_type;
   xp_long in_size;
   int slice_comps, slice_len, slice_type;
   xp_long slice_size;
   int slice_id;
   char *slice_value, *in_value;

   /* Get the inputs and outputs to the module. */
   tmp_id = OMfind_subobj(elem_id, OMstr_to_name("inField"), OM_OBJ_RW);
   if (OMget_obj_val(tmp_id, &inField_id) != OM_STAT_SUCCESS)
      return(0);

   tmp_id = OMfind_subobj(elem_id, OMstr_to_name("sliceField"), OM_OBJ_RD);
   if (OMget_obj_val(tmp_id, &sliceField_id) != OM_STAT_SUCCESS)
      return(0);

   tmp_id = OMfind_subobj(elem_id, OMstr_to_name("slice"), OM_OBJ_RD);
   if (OMget_int_val(tmp_id, &slice) != OM_STAT_SUCCESS)
      return(0);

   /* Make sure the input/output field ncomps are the same. */
   if (FLDget_node_data_ncomp(sliceField_id, &slice_comps) != 1)
      return(0);

   if (FLDget_node_data_ncomp(inField_id, &in_comps) != 1) {
      if (FLDset_node_data_ncomp(inField_id, slice_comps) != 1) {
         ERR_RETURN("Can't set output field ncomp");
      }
   }
   /* Make sure we aren't actually making the node data 
      array smaller. A really bad case is if some of the
      input slices doesn't have data but some does - we
      don't want to reset the number of components to 0 !!
   */
   else if (slice_comps >= in_comps) {
      if (FLDset_node_data_ncomp(inField_id, slice_comps) != 1) {
         ERR_RETURN("Can't set output field ncomp");
      }
   }

   /* Calculate the output index for putting the
      slice data to the input/output field.
   */
   if (FLDget_dims(inField_id, &dims, &dims_size) != 1) {
      ERR_RETURN("Can't get output field dims");
   }

   /* Loop over the array of node data */
   for (i=0; i<slice_comps; i++) {
      /* Set the slice field's veclen to the input/output field. */
      if (FLDget_node_data_veclen(sliceField_id, i, &slice_len) != 1)
         return(0);
      if (FLDset_node_data_veclen(inField_id, i, slice_len) != 1) {
         ERR_RETURN("Can't set output field veclen");
      }

      /* Set the slice field's node data id to the input/output field. */
      if (FLDget_node_data_id(sliceField_id, i, &slice_id) == 1) {
         if (FLDset_node_data_id(inField_id, i, slice_id) != 1) {
            ERR_RETURN("Can't set output field node data id");
         }
      }

      /* Get the data from the slice field. This is the
         data to be copied to the input/output field.
      */
      if (FLDget_node_data(sliceField_id, i, &slice_type,
		(char **)&slice_value,
		&slice_size, OM_GET_ARRAY_RD) != 1) {
         ERR_RETURN("Can't get slice field node data");
      }

      /* Get the data from the input/output field.
	 We use set node data type to make sure the output
	 array is the same type as the input. We then ask
	 for the data WR so we are assured that the OM
	 will preserve the previous values in the array.
	 After all, we are only setting a slice of the output.
      */
      in_type = slice_type;
      if (FLDget_node_data(inField_id, i, &in_type,
		(char **)&in_value,
		&in_size, OM_GET_ARRAY_WR) != 1) {
         ERR_RETURN("Can't get output field node data");
      }

      if (slice_type != in_type) {
	 ERR_RETURN("Node data to copy is different data type");
      }

      if (dims_size == 1) {
         out_index = slice * slice_len;
         out_size = slice_len;
      }
      else if (dims_size == 2) {
         out_index = dims[0] * slice * slice_len;
         out_size = dims[0] * slice_len;
      }
      else if (dims_size == 3) {
         out_index = dims[0] * dims[1] * slice * slice_len;
	 out_size = dims[0] * dims[1] * slice_len;
      }
      else {
	 ERR_RETURN("Unsupported dims size");
      }

      switch (slice_type) {
         case OM_TYPE_DOUBLE:
            out_index *= sizeof(double);
            out_size *= sizeof(double);
	    break;
         case OM_TYPE_FLOAT:
            out_index *= sizeof(float);
            out_size *= sizeof(float);
            break;
         case OM_TYPE_INT:
            out_index *= sizeof(int);
            out_size *= sizeof(int);
            break;
         case OM_TYPE_LONG:
            out_index *= sizeof(xp_long);
            out_size *= sizeof(xp_long);
            break;
         case OM_TYPE_SHORT:
            out_index *= sizeof(short);
            out_size *= sizeof(short);
            break;
         case OM_TYPE_CHAR:
         case OM_TYPE_BYTE:
         default:
            break;
      }

      /* Copy the slice data to the right spot in the input/output field. */
      memcpy(&in_value[out_index], slice_value, out_size);

      ARRfree(slice_value);
      ARRfree(in_value);
   }

   ARRfree(dims);
   return(1);
}
