/*
			Copyright (c) 2000 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/slicegen.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>

/* iso.c */
int FUNCiso (OMobj_id in_mesh, OMobj_id in, int comp, double level,
             OMobj_id out, OMobj_id param,
             int ncell_data, int *cell_data);

/* nmap.c */
int FUNCnmap (OMobj_id in, OMobj_id param, int nmap_comp, int *map_comp, 
              int iso_comp, double iso_val, OMobj_id out);

/* pln_dist.c */
int FUNCplane_dist (OMobj_id in, OMobj_id plane, OMobj_id out, float *dist);

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("slice_gen", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

/* 64-bit porting. Only Modified Internally */
int
DV_ARRslice_gen_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_arr;
    OMobj_id plane, plane_out;
    xp_long i, num_fields;
    OMobj_id in, out, level_id, param;
    double level;
    int stat, *cell_data;
    xp_long size;

    /* nMap variables */
    OMobj_id out_comp_id;
    xp_long out_ncomp;
    int *out_comp;
    int type, iso_comp;
    double iso_val;

    OMobj_id in_xform, out_xform;
    OMobj_name xform_name = OMstr_to_name("xform");

    in_arr  = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    plane = OMfind_subobj(elem_id, OMstr_to_name("plane"), OM_OBJ_RD);

    /* Plane Distance temporary */
    plane_out = OMfind_subobj(elem_id, OMstr_to_name("plane_out"), OM_OBJ_RW);

    /* Isosurface temporary */
    param = OMfind_subobj(elem_id, OMstr_to_name("nparam"), OM_OBJ_RW);

    /* Isosurface parameters */

    level_id = OMfind_subobj(elem_id, OMstr_to_name("dist"), OM_OBJ_RD);
    OMget_real_val(level_id, &level);

    cell_data = (int *)OMret_name_array_ptr(elem_id, OMstr_to_name("cell_data"),
                                            OM_GET_ARRAY_RD, &size, NULL);
    if (size == 0) cell_data = NULL;
    if (cell_data == NULL) size = 0;

    /* Node Map parameters */

    out_comp_id = OMfind_subobj(elem_id, OMstr_to_name("map_comp"), OM_OBJ_RD);

    type = OM_TYPE_INT;
    out_ncomp = 0;
    out_comp = (int *)NULL;
    stat = OMget_array_sz(out_comp_id, &type, (char **)(&out_comp),
                          &out_ncomp, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS) {
        out_ncomp = 0;
        out_comp = NULL;
    }

    iso_comp = -1;
    iso_val = 0.0;

    /*  */

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    for( i = 0; i < num_fields; ++i ) {
        float dist;

        stat = OMget_array_val( in_arr, i, &in, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        if( i != 0 ) {
            FLDset_nnodes( plane_out, 0 );
            FLDset_node_data_ncomp( plane_out, 0 ); /* discard old */
            FLDdelete( plane_out, "plane_norm" );
        }

        FLDset_node_data_ncomp( plane_out, 1 );
        stat = FUNCplane_dist(in, plane, plane_out, &dist);

        if( stat == METHOD_SUCCESS )
            stat = FUNCiso(in, plane_out, 0, level+dist, out, param, 
                           (int)size, cell_data);

        if( stat == METHOD_SUCCESS )
            stat = FUNCnmap(in, param, (int)out_ncomp, out_comp,
                            iso_comp, iso_val, out);

        /* FUNCplane_dist doesn't clear out its input */
        FLDset_nnodes( plane_out, 0 );
        FLDset_node_data_ncomp( plane_out, 0 );
        FLDdelete( plane_out, "plane_norm" );
#if 0
        if( stat != METHOD_SUCCESS ) {
            ERRerror( "slice_gen", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif

       /* This can be done easily in V, but its a little faster in C */
       in_xform  = OMfind_subobj(in,  xform_name, OM_OBJ_RD);
       out_xform = OMfind_subobj(out, xform_name, OM_OBJ_RW);
       OMset_obj_ref( out_xform, in_xform, 0 );
    }

    if (cell_data)
        ARRfree(cell_data);
    if (out_comp)
        ARRfree(out_comp);
    return METHOD_SUCCESS;
}
