/*
			Copyright (c) 1993 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/tbl_set.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <string.h>
#include <avs/util.h>
#include <avs/err.h>
#include <avs/dtype.h>
#include <avs/om.h>
#include <avs/arr.h>

#define MAX_NAME_LEN 16
#define ERR_RETURN(A) ERRerror("DVtable_xyz_create", 0, ERR_ORIG, A); \
                      OMset_name_int_val(mod_id, OMstr_to_name("reset"), 1); return(0);

/* 64-bit porting. Only Modified Internally */
int DVtable_xyz_create_update(OMobj_id mod_id, OMevent_mask event_mask, int seq_num)
{
	OMobj_id col_id, val_id, out_val_id, name_id, xyz_name_id, out_id, one_id, two_id;
	int stat, reset = 0, xyz_axis[3], xyz_set[3], dtype;
	xp_long i, nvals, nname, ncol;
	double min, max, bin_size;
	char *col_name, *name, xyz_name[MAX_NAME_LEN+1];
    
	col_id = OMfind_subobj(mod_id, OMstr_to_name("columns"), OM_OBJ_RD);
	if (OMis_null_obj(col_id))
		return(0);
	out_id = OMfind_subobj(mod_id, OMstr_to_name("field_xyz"), OM_OBJ_RW);
	if (OMis_null_obj(out_id))
		return(0);
	if (OMget_array_size(col_id, &ncol) != 1 || ncol == 0) {
		if (!(event_mask & OM_EVENT_INST)) {
			OMset_name_int_val(mod_id, OMstr_to_name("reset"), 1);
			mod_id = OMfind_subobj(mod_id, OMstr_to_name("xyz_select"), OM_OBJ_RW);
			xyz_set[0] = 0;
			xyz_set[1] = 0;
			xyz_set[2] = 0;
			val_id = OMfind_subobj(mod_id, OMstr_to_name("xyz_set"), OM_OBJ_RW);
			if (OMset_array(val_id, DTYPE_INT, (void *)xyz_set, 3, OM_SET_ARRAY_COPY) != 1) {
				ERR_RETURN("cannot set xyz_set array");
			}
		}
		else {
			OMset_name_int_val(mod_id, OMstr_to_name("reset"), 0);
		}
		return(0);
	}

	OMget_name_int_val(mod_id, OMstr_to_name("reset"), &reset);

	name_id = OMfind_subobj(mod_id, OMstr_to_name("names"), OM_OBJ_RW);
	xyz_name_id = OMfind_subobj(mod_id, OMstr_to_name("xyz_names"), OM_OBJ_RW);

	if ( reset == 0) {
		if (OMget_array_size(name_id, &nname) != 1 || nname == 0 || nname != ncol)
			reset = 1;
	}
	if ( reset == 0) {
		for (i=0; i<ncol; i++) {
			if (OMget_array_val(col_id, i, &val_id, OM_OBJ_RD) != 1) {
				ERR_RETURN("cannot get column");
			}
			if (OMget_name_str_val(val_id, OMstr_to_name("labels"), 
					       &col_name, 0) != 1) {
				ERR_RETURN("cannot get column name");
			}
			if (OMget_str_array_val(name_id, i, &name, 0) != 1) {
				ERR_RETURN("cannot get name");
			}
			if (strcmp(col_name, name) != 0) {
				reset = 1;
				free(col_name);
				free(name);
				break;
			}
/*			if (OMget_name_int_val(val_id, OMstr_to_name("nvals"), 
					       &nvals) != 1) {
				ERR_RETURN("cannot get column nvals");
			}
			if (nvals == 0) ERR_RETURN("table has no row data");
*/			free(col_name);
			free(name);
		}
	}

	if (reset) {
		/***
		if (OMset_array_size(out_id, 0) != 1) {
			ERR_RETURN("cannot set field_xyz size");
		}
		***/
		OMset_name_int_val(mod_id, OMstr_to_name("ncol"), (int)ncol);
		if (OMset_array_size(out_id, ncol) != 1) {
			ERR_RETURN("cannot set field_xyz size");
		}
		if (OMset_array_size(name_id, ncol) != 1) {
			ERR_RETURN("cannot set names size");
		}
		if (OMset_array_size(xyz_name_id, ncol) != 1) {
			ERR_RETURN("cannot set xyz_names size");
		}
		for (i=0; i<ncol; i++) {
			if (OMget_array_val(col_id, i, &val_id, OM_OBJ_RD) != 1) {
				ERR_RETURN("cannot get column");
			}       
			if (OMget_name_str_val(val_id, OMstr_to_name("labels"), 
					       &col_name, 0) != 1) {
				ERR_RETURN("cannot get column label");
			}
			if (OMset_str_array_val(name_id, i, col_name) != 1) {
				ERR_RETURN("cannot set col_name");
			}
			sprintf(xyz_name, "%.16s", col_name);
			if (OMset_str_array_val(xyz_name_id, i, xyz_name) != 1) {
				ERR_RETURN("cannot set xyz_name");
			}

			if (OMget_array_val(out_id, i, &out_val_id, OM_OBJ_RW) != 1) {
				ERR_RETURN("cannot get field_xyz element");
			}
			if (OMget_name_long_val(val_id, OMstr_to_name("nvals"), 
					       &nvals) != 1) {
				ERR_RETURN("cannot get column nvals");
			}
			if (nvals == 0) {
				ERRerror("DVtable_xyz_create", 0, ERR_ORIG, "table has no row data");
				return(0);
			}

			one_id = OMfind_subobj(val_id, OMstr_to_name("labels"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("name"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

			one_id = OMfind_subobj(val_id, OMstr_to_name("values"), OM_OBJ_RW);
			if (OMget_data_type(one_id, &dtype) != 1) {
				ERR_RETURN("cannot get values type");
			}
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("values"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

			one_id = OMfind_subobj(val_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

			one_id = OMfind_subobj(val_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);


			switch (dtype) {

			      case DTYPE_LONG:
				OMset_name_int_val(out_val_id, OMstr_to_name("discrete"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("normalize"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("set_labels"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("label_step"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("index_labels"), 1);
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("min"), OM_OBJ_RW);
  
				stat = OMparse_obj_ref(one_id,
				       "cache(min_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse min");
				}
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("max"), OM_OBJ_RW);
       
				stat = OMparse_obj_ref(one_id,
				       "cache(max_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse max");
				}


				OMget_name_real_val(out_val_id, OMstr_to_name("min"), &min);
				OMget_name_real_val(out_val_id, OMstr_to_name("max"), &max);
 				bin_size = (max-min)/10;
				OMset_name_real_val(out_val_id, OMstr_to_name("bin_size"), bin_size);
				break;

			      case DTYPE_INT:
				OMset_name_int_val(out_val_id, OMstr_to_name("discrete"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("normalize"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("set_labels"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("label_step"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("index_labels"), 1);
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("min"), OM_OBJ_RW);
  
				stat = OMparse_obj_ref(one_id,
				       "cache(min_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse min");
				}
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("max"), OM_OBJ_RW);
       
				stat = OMparse_obj_ref(one_id,
				       "cache(max_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse max");
				}


				OMget_name_real_val(out_val_id, OMstr_to_name("min"), &min);
				OMget_name_real_val(out_val_id, OMstr_to_name("max"), &max);
 				bin_size = (max-min)/10;
				OMset_name_real_val(out_val_id, OMstr_to_name("bin_size"), bin_size);
				break;

			      case DTYPE_SHORT:
				OMset_name_int_val(out_val_id, OMstr_to_name("discrete"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("normalize"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("set_labels"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("label_step"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("index_labels"), 1);
       
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("min"), OM_OBJ_RW);
				stat = OMparse_obj_ref(one_id,
				       "cache(min_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse max");
				}

				one_id = OMfind_subobj(out_val_id, OMstr_to_name("max"), OM_OBJ_RW);
				stat = OMparse_obj_ref(one_id,
				       "cache(max_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse max");
				}
				OMget_name_real_val(out_val_id, OMstr_to_name("min"), &min);
				OMget_name_real_val(out_val_id, OMstr_to_name("max"), &max);
 				bin_size = (max-min)/10;
				OMset_name_real_val(out_val_id, OMstr_to_name("bin_size"), bin_size);
				break;

			      case DTYPE_BYTE: 
			      case DTYPE_CHAR: 
				OMset_name_int_val(out_val_id, OMstr_to_name("discrete"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("normalize"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("set_labels"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("label_step"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("index_labels"), 1);
   
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("min"), OM_OBJ_RW);
				stat = OMparse_obj_ref(one_id,
				       "cache(min_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse min");
				}
    
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("max"), OM_OBJ_RW);
				stat = OMparse_obj_ref(one_id,
				       "cache(max_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse max");
				}
				OMget_name_real_val(out_val_id, OMstr_to_name("min"), &min);
				OMget_name_real_val(out_val_id, OMstr_to_name("max"), &max);
 				bin_size = (max-min)/10;
				OMset_name_real_val(out_val_id, OMstr_to_name("bin_size"), bin_size);
   				break;

			      case DTYPE_FLOAT:
				OMset_name_int_val(out_val_id, OMstr_to_name("discrete"), 0);
				OMset_name_int_val(out_val_id, OMstr_to_name("normalize"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("set_labels"), 0);
				OMset_name_int_val(out_val_id, OMstr_to_name("label_step"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("index_labels"), 0);
 
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("min"), OM_OBJ_RW);
				stat = OMparse_obj_ref(one_id,
				       "cache(min_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse min");
				}

				one_id = OMfind_subobj(out_val_id, OMstr_to_name("max"), OM_OBJ_RW);
				stat = OMparse_obj_ref(one_id,
				       "cache(max_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse max");
				}
				OMget_name_real_val(out_val_id, OMstr_to_name("min"), &min);
				OMget_name_real_val(out_val_id, OMstr_to_name("max"), &max);
				bin_size = (max-min)/10;
				OMset_name_real_val(out_val_id, OMstr_to_name("bin_size"), bin_size);
				break;

			      case DTYPE_DOUBLE:
				OMset_name_int_val(out_val_id, OMstr_to_name("discrete"), 0);
				OMset_name_int_val(out_val_id, OMstr_to_name("normalize"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("set_labels"), 0);
				OMset_name_int_val(out_val_id, OMstr_to_name("label_step"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("index_labels"), 0);
    
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("min"), OM_OBJ_RW);
				stat = OMparse_obj_ref(one_id,
				       "cache(min_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse min");
				}
   
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("max"), OM_OBJ_RW);
				stat = OMparse_obj_ref(one_id,
				       "cache(max_array(values, null_flag, null_value))");
				if (stat != 1) {
					ERR_RETURN("cannot parse max");
				}
				OMget_name_real_val(out_val_id, OMstr_to_name("min"), &min);
				OMget_name_real_val(out_val_id, OMstr_to_name("max"), &max);
				bin_size = (max-min)/10;
				OMset_name_real_val(out_val_id, OMstr_to_name("bin_size"), bin_size);
				break;

			      case DTYPE_STRING:
				OMset_name_int_val(out_val_id, OMstr_to_name("discrete"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("normalize"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("set_labels"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("label_step"), 1);
				OMset_name_int_val(out_val_id, OMstr_to_name("index_labels"), 0);
				OMset_name_real_val(out_val_id, OMstr_to_name("bin_size"), (double)0);
    
				one_id = OMfind_subobj(out_val_id, OMstr_to_name("min"), OM_OBJ_RW);
				OMset_name_real_val(out_val_id, OMstr_to_name("min"), (double)0);
				OMset_name_real_val(out_val_id, OMstr_to_name("max"), (double)0);
				break;

			      default:
     
				ERRerror("DVtable_xyz_create", 0, ERR_ORIG, "unknown data type");
				break;
			}
		}
      
		one_id = OMfind_subobj(mod_id, OMstr_to_name("xyz_select"), OM_OBJ_RW);
		xyz_axis[0] = 0;
		xyz_axis[1] = 0;
		xyz_axis[2] = 0;
		xyz_set[0] = 1;
		xyz_set[1] = 0;
		xyz_set[2] = 0;
		val_id = OMfind_subobj(one_id, OMstr_to_name("xyz_axis"), OM_OBJ_RW);
		if (OMset_array(val_id, DTYPE_INT, (void *)xyz_axis, 3, OM_SET_ARRAY_COPY) != 1) {
			ERR_RETURN("cannot set xyz_axis array");
		}
		val_id = OMfind_subobj(one_id, OMstr_to_name("xyz_set"), OM_OBJ_RW);
		if (OMset_array(val_id, DTYPE_INT, (void *)xyz_set, 3, OM_SET_ARRAY_COPY) != 1) {
			ERR_RETURN("cannot set xyz_set array");
		}
		free(col_name);
	}
	else {
		for (i=0; i<ncol; i++) {
			if (OMget_array_val(col_id, i, &val_id, OM_OBJ_RD) != 1) {
				ERR_RETURN("cannot get column");
			}
			if (OMget_array_val(out_id, i, &out_val_id, OM_OBJ_RW) != 1) {
				ERR_RETURN("cannot get field_xyz element");
			}

     
			one_id = OMfind_subobj(val_id, OMstr_to_name("labels"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("name"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

   
			one_id = OMfind_subobj(val_id, OMstr_to_name("values"), OM_OBJ_RW);
			if (OMget_data_type(one_id, &dtype) != 1) {
				ERR_RETURN("cannot get values type");
			}
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("values"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

 
			one_id = OMfind_subobj(val_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);


			one_id = OMfind_subobj(val_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);
		}
	}

	OMset_name_int_val(mod_id, OMstr_to_name("reset"), 0);

	return(1);
}


#undef  ERR_RETURN
#define ERR_RETURN(A) ERRerror("DVtable_data_create", 1, ERR_ORIG, A); \
                      OMset_name_int_val(mod_id, OMstr_to_name("reset"), 1); return(0);

/* 64-bit porting. Only Modified Internally */
int DVtable_data_create_update(OMobj_id mod_id, OMevent_mask event_mask, int seq_num)
{
	OMobj_id col_id, val_id, out_val_id, name_id, data_name_id, one_id, two_id, out_id;
	xp_long i, ncol, nname;
	int reset = 0, data, dtype, count_records;
	char *col_name, *name;

	col_id = OMfind_subobj(mod_id, OMstr_to_name("columns"), OM_OBJ_RD);
	out_id = OMfind_subobj(mod_id, OMstr_to_name("field_data"), OM_OBJ_RW);

	if (OMget_array_size(col_id, &ncol) != 1 || ncol == 0) {
		if (!(event_mask & OM_EVENT_INST)) {
			OMset_name_int_val(mod_id, OMstr_to_name("reset"), 1);
		}
		else {
			OMset_name_int_val(mod_id, OMstr_to_name("reset"), 0);
		}
		return(0);
	}

	data_name_id = OMfind_subobj(mod_id, OMstr_to_name("data_names"), OM_OBJ_RW);

	name_id = OMfind_subobj(mod_id, OMstr_to_name("names"), OM_OBJ_RW);

	OMget_name_int_val(mod_id, OMstr_to_name("reset"), &reset);

	if ( reset == 0) {
		if (OMget_array_size(name_id, &nname) != 1 || nname == 0 || nname != ncol)
			reset = 1;
	}
  
	if ( reset == 0)  {
		for (i=0; i<ncol; i++) {
			if (OMget_array_val(col_id, i, &val_id, OM_OBJ_RD) != 1) {
				ERR_RETURN("cannot get column");
			}
			if (OMget_name_str_val(val_id, OMstr_to_name("labels"), 
					       &col_name, 0) != 1) {
				ERR_RETURN("cannot get column name");
			}
			if (OMget_str_array_val(name_id, i, &name, 0) != 1) {
				ERR_RETURN("cannot get data name");
			}
			if (strcmp(col_name, name) != 0) {
				reset = 1;
				free(col_name);
				free(name);
				break;
			}
			free(col_name);
			free(name);
		}
	}


	OMget_name_int_val(mod_id, OMstr_to_name("count_records"), &count_records);

	if (reset) {
		if (OMset_array_size(name_id, ncol) != 1) {
			ERR_RETURN("cannot set names size");
		}
		if (OMset_array_size(data_name_id, ncol+count_records) != 1) {
			ERR_RETURN("cannot set data_names size");
		}
		/*** Count_Records **/
		if (count_records) {
			if (OMset_str_array_val(data_name_id, 0, "Count Records") != 1) {
				ERR_RETURN("cannot set data name");
			}
			if (OMget_array_val(out_id, 0, &out_val_id, OM_OBJ_RW) != 1) {
				ERR_RETURN("cannot get field_data element");
			}
			OMset_name_int_val(out_val_id, OMstr_to_name("count_records"), 1);
			OMset_name_str_val(out_val_id, OMstr_to_name("name"), "Count Records");
			OMset_name_int_val(out_val_id, OMstr_to_name("valid"), 1);
		}
       
		for (i=0; i<ncol; i++) {
			if (OMget_array_val(col_id, i, &val_id, OM_OBJ_RD) != 1) {
				ERR_RETURN("cannot get column");
			}
			if (OMget_name_str_val(val_id, OMstr_to_name("labels"), 
					       &col_name, 0) != 1) {
				ERR_RETURN("cannot get column name");
			}
			if (OMset_str_array_val(name_id, i, col_name) != 1) {
				ERR_RETURN("cannot set data name");
			}
			if (OMset_str_array_val(data_name_id, i+count_records, col_name) != 1) {
				ERR_RETURN("cannot set data name");
			}

			if (OMget_array_val(out_id, i+count_records, &out_val_id, OM_OBJ_RW) != 1) {
				ERR_RETURN("cannot get field_data element");
			}

			OMset_name_int_val(out_val_id, OMstr_to_name("count_records"), 0);

    
			one_id = OMfind_subobj(val_id, OMstr_to_name("labels"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("name"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

         
			one_id = OMfind_subobj(val_id, OMstr_to_name("values"), OM_OBJ_RW);
			if (OMget_data_type(one_id, &dtype) != 1) {
				ERR_RETURN("cannot get values type");
			}
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("values"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

     
			one_id = OMfind_subobj(val_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

      
			one_id = OMfind_subobj(val_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

			/*** set defaults ****/
			OMset_name_int_val(out_val_id, OMstr_to_name("operation"), 0);

			switch (dtype) {

			      case DTYPE_LONG:
			      case DTYPE_INT:
			      case DTYPE_SHORT:
			      case DTYPE_BYTE: 
			      case DTYPE_CHAR: 
			      case DTYPE_FLOAT:
			      case DTYPE_DOUBLE:
			      case DTYPE_STRING:
      
				OMset_name_int_val(out_val_id, OMstr_to_name("valid"), 1);
				break;

			      default:
       
				OMset_name_int_val(out_val_id, OMstr_to_name("valid"), 0);
				ERRerror("DVtable_data_create", 0, ERR_ORIG, "unknown data type");
				break;
			}
		}
        
		val_id = OMfind_subobj(mod_id, OMstr_to_name("data_select"), OM_OBJ_RW);
		val_id = OMfind_subobj(val_id, OMstr_to_name("data"), OM_OBJ_RW);
		data = 0;
       
		if (OMset_array(val_id, DTYPE_INT, (void *)&data, 1, OM_SET_ARRAY_COPY) != 1) {
			ERR_RETURN("cannot set data array");
		}
		free(col_name);
	}
	else {
       
		for (i=0; i<ncol; i++) {
			if (OMget_array_val(col_id, i, &val_id, OM_OBJ_RD) != 1) {
				ERR_RETURN("cannot get column");
			}

			if (OMget_array_val(out_id, i+count_records, &out_val_id, OM_OBJ_RW) != 1) {
				ERR_RETURN("cannot get field_data");
			}

      
			one_id = OMfind_subobj(val_id, OMstr_to_name("labels"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("name"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

 
			one_id = OMfind_subobj(val_id, OMstr_to_name("values"), OM_OBJ_RW);
			if (OMget_data_type(one_id, &dtype) != 1) {
				ERR_RETURN("cannot get values type");
			}
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("values"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

       
			one_id = OMfind_subobj(val_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);

        
			one_id = OMfind_subobj(val_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			two_id = OMfind_subobj(out_val_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			OMset_obj_ref (two_id, one_id, 0);
		}
	}

       
	OMset_name_int_val(mod_id, OMstr_to_name("reset"), 0);

	return(1);
}

