/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/thresh.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>
#include <avs/data_utils.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("threshold", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

#define MAX_NAME_SIZE 1024

int FUNCthreshold (OMobj_id in, int check_vec, int check_comp, int thresh_vec,
                   int below, double min_val, int above, double max_val,
                   double new_null_value, OMobj_id out);

int DVthreshold_update(OMobj_id elem_id)
{
    OMobj_id in, out, e_id;
    int  check_vec, check_comp, thresh_vec;
    int  below, above;
    double min_val, max_val, null_val;

    in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("check_vector"), OM_OBJ_RW);
    OMget_int_val(e_id, &check_vec);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("check_comp"), OM_OBJ_RW);
    OMget_int_val(e_id, &check_comp);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("thresh_vector"), OM_OBJ_RW);
    OMget_int_val(e_id, &thresh_vec);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("below"), OM_OBJ_RW);
    OMget_int_val(e_id, &below);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("above"), OM_OBJ_RW);
    OMget_int_val(e_id, &above);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("min_value"), OM_OBJ_RW);
    OMget_real_val(e_id, &min_val);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("max_value"), OM_OBJ_RW);
    OMget_real_val(e_id, &max_val);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("null_value"), OM_OBJ_RW);
    OMget_real_val(e_id, &null_val);

    if (FUNCthreshold(in, check_vec, check_comp, thresh_vec,
                      below, min_val, above, max_val, null_val, out) == METHOD_SUCCESS) {
        return METHOD_SUCCESS;
    }
    else return METHOD_FAILURE;
}


/* 64-bit porting. Only Modified Internally */
int
DV_ARRthreshold_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_arr;
    xp_long i, num_fields;
    int stat;
    
    OMobj_id in, out, e_id;
    int  check_vec, check_comp, thresh_vec;
    int  below, above;
    double min_val, max_val, null_val;

    in_arr  = OMfind_subobj(elem_id, OMstr_to_name("in"),  OM_OBJ_RD);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    e_id = OMfind_subobj(elem_id, OMstr_to_name("check_vector"), OM_OBJ_RW);
    OMget_int_val(e_id, &check_vec);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("check_comp"), OM_OBJ_RW);
    OMget_int_val(e_id, &check_comp);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("thresh_vector"), OM_OBJ_RW);
    OMget_int_val(e_id, &thresh_vec);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("below"), OM_OBJ_RW);
    OMget_int_val(e_id, &below);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("above"), OM_OBJ_RW);
    OMget_int_val(e_id, &above);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("min_value"), OM_OBJ_RW);
    OMget_real_val(e_id, &min_val);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("max_value"), OM_OBJ_RW);
    OMget_real_val(e_id, &max_val);
    e_id = OMfind_subobj(elem_id, OMstr_to_name("null_value"), OM_OBJ_RW);
    OMget_real_val(e_id, &null_val);

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr,  i, &in,  OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;
        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FUNCthreshold(in, check_vec, check_comp, thresh_vec,
                             below, min_val, above, max_val, null_val, out);
#if 0
        if( stat != OM_STAT_SUCCESS ) {
            ERRerror( "threhsold", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif
    }

    return METHOD_SUCCESS;
}


/* 64-bit porting. Only Modified Internally */
int FUNCthreshold (OMobj_id in, int check_vec, int check_comp, int thresh_vec,
		   int below, double min_val, int above, double max_val,
                   double new_null_value, OMobj_id out)
{
	xp_long nnodes, size;
	int   check_veclen, thresh_veclen, data_id;
	int   data_type, data_type1, null_flag, ncomp;
	char   *check_data, *thresh_data, *out_node_data;
	double null_value, new_nv;
	char  label[MAX_NAME_SIZE], units[MAX_NAME_SIZE];

	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}

	if (FLDset_nnodes (out, nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (nnodes == 0 || ncomp == 0) {
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		return(1);
	}
	if (check_vec >= ncomp || thresh_vec >= ncomp) {
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		ERR_RETURN("bad data component number, threshold is not performed");
	}

	if (FLDset_node_data_ncomp (out, 1) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDget_node_data_veclen(in, thresh_vec, &thresh_veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (FLDget_node_data_veclen(in, check_vec, &check_veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (check_veclen <= check_comp) {
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		ERR_RETURN("bad vector component number, threshold is not performed");
	}
	if (FLDget_node_data_units(in, thresh_vec,
				   units, MAX_NAME_SIZE) != 1) {
		strcpy(units, "");
	}
	if (FLDget_node_data_label(in, thresh_vec,
				   label, MAX_NAME_SIZE) != 1) {
		strcpy(label, "threholded_data");
	}
	if (FLDset_node_data_comp (out, 0, thresh_veclen, label, units) != 1) {
		ERR_RETURN("Error setting node component");
	}


	if (FLDget_node_data(in, check_vec, &data_type, &check_data,
			     &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}
	if (FLDget_node_data(in, thresh_vec, &data_type1, &thresh_data,
			     &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}
	if (FLDget_node_null_data(in, check_vec, &null_flag, (char *)&null_value) != 1) {
		ERR_RETURN("cannot get null data");
	}
	if (FLDget_node_data(out, 0, &data_type1, &out_node_data,
			     &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error setting node data");
	}
	if (FLDget_node_data_id(in, thresh_vec, &data_id) == 1)
		FLDset_node_data_id(out, 0, data_id);

	if (FLDcopy_node_minmax(in, out, thresh_vec, 0) != 1) {
		ERR_RETURN("Error copying node minmax");
	}
	if (FLDcopy_node_minmax_vec(in, out, thresh_vec, 0) != 1) {
		ERR_RETURN("Error copying node minmax");
	}
	if (FLDget_node_data_type(in, thresh_vec, &data_type1) != 1) {
		ERR_RETURN("Error copying node minmax");
	}

	UTILthreshold(nnodes, check_data, check_veclen, check_comp, data_type,
		      null_flag, (char *)&null_value,
		      below, min_val, above, max_val,
		      thresh_data, thresh_veclen, data_type1, new_null_value, out_node_data);

	UTILdouble_to_type(&new_nv, new_null_value, data_type1);
	if (FLDset_node_null_data(out, 0, (char *)&new_nv, data_type1) != 1) {
		ERR_RETURN("Error setting null value");
	}
	ARRfree(check_data);
	ARRfree(thresh_data);
	ARRfree(out_node_data);
	return(1);
}
