/*
			Copyright (c) 1997 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/xform.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/math.h>
#include <avs/gd.h>

#define ERR_RETURN(A) ERRerror("DVxform_3points", 0, ERR_ORIG, A); return(0);

static float IXFORM[16] = {1.0, 0.0, 0.0, 0.0,
			   0.0, 1.0, 0.0, 0.0,
			   0.0, 0.0, 1.0, 0.0,
			   0.0, 0.0, 0.0, 1.0};

/* 64-bit porting. Only Modified Internally */
int DVxform_3points_update(OMobj_id elem_id)
{
	OMobj_id out;
	float *p[3];
	float  vecx[3], vecy[3], vecz[3], mat[4][4], xlate[3], center[3];
	int i, ix, iy, i0, origin, flip;
	xp_long size;

	if (OMget_name_int_val(elem_id, OMstr_to_name("origin_point"), &origin) != 1)
		origin = 1;
	if (OMget_name_int_val(elem_id, OMstr_to_name("flip"), &flip) != 1)
		flip = 0;

	out = OMfind_subobj(elem_id, OMstr_to_name("xform_out"), OM_OBJ_RW);
	p[0] = NULL;
	p[1] = NULL;
	p[2] = NULL;
	p[0] = (float *)OMret_name_array_ptr(elem_id, OMstr_to_name("point0"),
					    OM_GET_ARRAY_RD, &size, NULL);
	if (p[0] == NULL || size == 0)
		return(0);

	p[1] = (float *)OMret_name_array_ptr(elem_id, OMstr_to_name("point1"),
					    OM_GET_ARRAY_RD, &size, NULL);
	if (p[1] == NULL || size == 0)
		return(0);

	p[2] = (float *)OMret_name_array_ptr(elem_id, OMstr_to_name("point2"),
					    OM_GET_ARRAY_RD, &size, NULL);
	if (p[2] == NULL || size == 0)
		return(0);

	for (i=0; i<3; i++) {
		vecx[i] = 0.0;
		vecy[i] = 0.0;
		vecz[i] = 0.0;
	}
	if (origin == 1) {
		ix = 0;
		iy = 2;
		i0 = 1;
	}
	else if (origin == 0) {
		ix = 2;
		iy = 1;
		i0 = 0;
	}
	else {
		ix = 1;
		iy = 0;
		i0 = 2;
	}
	if (flip) {
		i = ix;
		ix = iy;
		iy = i;
	}
	for (i=0; i<(int)size; i++) {
		vecx[i] = p[ix][i] - p[i0][i];
		vecy[i] = p[iy][i] - p[i0][i];
	}
	VEC_UNITIZE(vecx, 1.0e-32);
	VEC_UNITIZE(vecy, 1.0e-32);
	VEC_CROSS(vecz, vecx, vecy);
	VEC_UNITIZE(vecz, 1.0e-32);
	VEC_CROSS(vecy, vecz, vecx);
	VEC_UNITIZE(vecy, 1.0e-32);

	memcpy(mat, IXFORM, 16*sizeof(float));

	memcpy(mat[0], vecx, 3*sizeof(float));
	memcpy(mat[1], vecy, 3*sizeof(float));
	memcpy(mat[2], vecz, 3*sizeof(float));


	center[0]=center[1]=center[2]=0.0;

	xlate[0] = xlate[1] = xlate[2] = 0.0;
	memcpy(xlate, p[i0], size*sizeof(float));

	GDxform_set_matrix(out, mat);
	GDxform_set_xlate(out, xlate);
	GDxform_set_center(out, center);

	return(1);
}
