//			Copyright (c) 1998 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/motif_ui/UIcursorP.cxx#1 $
//

#include <stdlib.h>

#define XP_WIDE_API	/* Use Wide APIs */
#include <avs/om.h>
#include <avs/f_utils.h>
#include "ui/UIcursorP.h"
#include "ui/cursor.h"

extern int forceUpdate;

void
UIcursorOnCreate( Widget, XtPointer cd, XCreateWindowEvent *event )
{
    if (event->type != CreateNotify) return;
    // Recast the cursor
    UIcursor *cursor = (UIcursor *)cd;
    if( cursor )
        cursor->update( 0, forceUpdate );
}

int
UIcursorP::setCursorColors( UIcolor &color )
{
    if( !_handle ) return 0;

    // Get the new XColor values
    Widget w = _handle->widget();
    int status = 0;
    if( color.foregroundColor.valid_obj() ) {
        status = UIcore::getColorFromString( w, (char *)color.foregroundColor, _fgXcolor );
    }
    else {
        Colormap cmap;
        XtVaGetValues( w,
                       XmNforeground, &_fgXcolor.pixel,
                       XmNcolormap, &cmap, NULL );
        XQueryColor( XtDisplay(w), cmap, &_fgXcolor );
    }

    if( color.backgroundColor.valid_obj() ) {
        status = UIcore::getColorFromString( w, (char *)color.backgroundColor, _bgXcolor );
    }
    else {
        Colormap cmap;
        XtVaGetValues( w,
                       XmNbackground, &_bgXcolor.pixel,
                       XmNcolormap, &cmap,
                       NULL );
        XQueryColor( XtDisplay(w), cmap, &_bgXcolor );
    }
    return status;
}

void
UIcursorP::recolorCursor( UIcolor &color )
{
    if( _cursor ) {
        setCursorColors( color );
        XRecolorCursor( XtDisplay(_handle->widget()),
                        _cursor, &_fgXcolor, &_bgXcolor );
    }
}

void
UIcursorP::attachCursor( int attach )
{
    if( !_handle ) return;
    Widget w = _handle->widget();
    if( UIisBeingDestroyed(w) ) return;
    Window win = _handle->window();
    if( !win ) {
        // CFS PR 19547
        win = XtWindow( w );
        if( !win ) return;
    }
    if( _cursor && attach ) {
        XDefineCursor( XtDisplay(w), win, _cursor );
    }
    else {
        XUndefineCursor( XtDisplay( w ), win );
    }
}

void
UIcursorP::reg_handle( UIwinHandle *h, UIcursor *cursor )
{
    // Set the handle value
    if( _handle != h ) {
        _handle = h;
        if( !_handle->window() ) {
            XtAddEventHandler(_handle->widget(), SubstructureNotifyMask, False,
                              (XtEventHandler)UIcursorOnCreate,
                              (XtPointer)cursor);
        }
        else {
            cursor->update( 0, forceUpdate );
        }
    }
}

void
UIfontCursorP::createCursor( int index, UIcolor &color )
{
    if( !_handle ) return;
    _cursor = XCreateFontCursor( XtDisplay( _handle->widget() ), index );
    recolorCursor( color );
}

void
UIpixmapCursorP::createCursor( UIpixmap &cursor_pixmap, UIpixmap &mask_pixmap, UIcolor &color )
{
    if( !_handle ) return;
    Widget w = _handle->widget();

    setCursorColors( color );

    Pixmap bitmap;
    UtString maskpathname("");

    // Get the file path of the cursor pixmap, if error quit
    char * str =  FILEfind( cursor_pixmap.filename,
                            OMget_path(OM_RUNTIMEPATH),
                            ' ', FILE_READ, NULL, NULL );
    if( !str ) return;

    UtString pathname( str );
    free( str );
    str = NULL;

    if( pathname == "" )
        return;

    // Check the file path of the optional mask pixmap, if error set to NULL
    if( mask_pixmap.filename.valid_obj() ) {
        str = FILEfind( mask_pixmap.filename,
                        OMget_path(OM_RUNTIMEPATH),
                        ' ', FILE_READ, NULL, NULL );
        if( str ) {
            maskpathname = str;
            free( str );
        }
    }

    // Try to read the bitmaps and get the relevant details from the files.
    int status;
    if( (status = XReadBitmapFile( XtDisplay(w), XtWindow(w),
                                   pathname.c_str(),
                                   &_width, &_height, &bitmap,
                                   &_x_hot, &_y_hot)) == BitmapSuccess ) {
        XFreePixmap( XtDisplay(w), bitmap );

        // Try to read the mask pixmap if the path exists
        Pixmap maskpixmap = 0;
        int mx_hot, my_hot;
        unsigned int mwidth, mheight;
        if( (maskpathname != "") &&
            (status = XReadBitmapFile(XtDisplay(w), XtWindow(w),
                                      maskpathname.c_str(),
                                      &mwidth, &mheight, &bitmap,
                                      &mx_hot, &my_hot)) == BitmapSuccess ) {
            XFreePixmap( XtDisplay(w), bitmap );
            // Check that size matches
            if( (mwidth != _width) || (mheight != _height) ) {
                maskpathname = "";
            }
        }
        else {
            maskpathname = "";
        }

        // Create the pixmap to use
        Pixmap pixmap = XmGetPixmapByDepth( XtScreen(w),
                                            (char *)pathname.c_str(),
                                            1, 0, 1 );
        if( maskpathname != "" ) {
            maskpixmap = XmGetPixmapByDepth( XtScreen(w),
                                             (char *)maskpathname.c_str(),
                                             1, 0, 1 );
        }
        if( pixmap != XmUNSPECIFIED_PIXMAP ) {
            _cursor = XCreatePixmapCursor( XtDisplay(w), pixmap, maskpixmap,
                                           &_fgXcolor, &_bgXcolor,
                                           (_x_hot>0) ? _x_hot : 0,
                                           (_y_hot>0) ? _y_hot : 0 );
        }
    }
    else {
#if 0
        UtString errorString;
        if( status == BitmapOpenFailed ) {
            errorString = "Couldn't find file ";
            errorString += pathname;
            errorString += ". No action taken.";
        }
        else if( status == BitmapFileInvalid ) {
            errorString = pathname;
            errorString += " is not a valid bitmap file. No action taken.";
        }
        UIerrorHandler( XmDIALOG_ERROR, obj_id(), errorString.c_str() );
#endif
        return;
    }
}
