/*
			Copyright (c) 1995 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/motif_ui/ui/dpyMgr.h#1 $
*/
//-*-Mode: C++;-*-
#ifndef _dpyMgr_h_
#define _dpyMgr_h_

#define INLINE_DPYCTX
#include "ui.h"
#include <avs/wt_objs.h>

// Window managers Express knows about
enum WMType { WMunknownType, MWMType, SGIType, OLWMType, KWMType, ENLType };

//--------------------GlobalArgs------------------------------------
class GlobalArgs;
extern GlobalArgs *globalArgs; // Global pointer to argc,argv cache

// The GlobalArgs class handles the caching and resetting of the
// commandline args to Express when multiple displays are opened.
// The XtOpenDisplay function strips the argv array when it reads
// it, requiring a cached copy to be used in subsequent calls.
class GlobalArgs {
  public:
	GlobalArgs( int , char ** );
	void		reset(); // Reloads the temp arrays with the static values
	int *		argc() { return &_argc; }
	char **		argv() { return _argv; }

  private:
	// These are static so only set at program init.
	static int 	argcount;
	static char **	argvalues;
	// Temporary values loaded each time ::reset is run...
	int 		_argc;
	char **		_argv;
};

//---- UIdpyContext -----------------------------------------------------------
// Global UI Display Context set and get functions
// Use these to access an existing display context or
// set up a new display context from external GUI's.
extern "C" {
    // Requires valid displayName, returns Display and XtAppContext pointers.
    // in corresponding parameters. Return 0 if no errors.
    int UI_GetDisplayContext( const char *displayName, Display **display, XtAppContext *app);
    // Set the display context associated with "displayName" to the
    // values of "display" and "appContext". Caution, this function
    // assumes that these are valid for the "displayName".
    int UI_SetDisplayContext( const char *displayName, Display *display, XtAppContext app);
}


//------------------- class UIdpyContext ----------------------------
// This class handles the information associated with a X display
// and Xt application context. The methods also create an application
// shell and a manager shell which can parent multiple children.

// Typedefs for UIdpyContext class
typedef unsigned int ScreenNumber;
typedef unsigned int ScreenWidth;
typedef unsigned int ScreenHeight;

class UIdpyContext {
    friend const UIdpyContext &UIgetDisplayContext( const char * );
    friend int UI_SetDisplayContext(String, Display *, XtAppContext );
    friend void UIinitHiddenShell(UIdpyContext &);
    //friend ostream & operator << ( ostream &, UIdpyContext &);

  public:
	UIdpyContext(); // Temp ctor, remove when new ctor operational!!
	UIdpyContext( UtString displayName );
	// Create and open a display context using the standard X displayName
	UIdpyContext( UtString displayName, Display *display, XtAppContext app );
	// Create a display context using the already opened display pointer
	// creates new application shell and manager shell
	UIdpyContext( const UIdpyContext &);
	~UIdpyContext();

	UIdpyContext & operator=(const UIdpyContext &o);

	// Return the Manager Shell widget for the specified Display Context
	Widget			ManagerShell() const { return _managerShell; }
	static Widget		ManagerShell(const UtString &displayName);
	static Widget		ManagerShell(Display *display);

	// Return the Hidden Shell widget for the specified Display Context
	Widget			HiddenShell() const { return _hiddenShell; }
	static Widget		HiddenShell(const UtString &displayName);
	static Widget		HiddenShell(Display *display);

	// Return the Application Context for the specified Display Context
	XtAppContext		appContext() const { return _appContext; }
	//static XtAppContext	appContext(const UtString &displayName);
	//static XtAppContext	appContext(Display *display);

	// Return Application shell
	Widget			appShell() const { return _appShell; }

	// Return the Display pointer for the specified Display Context
	Display *		display() const { return DisplayPtr; }
	//static const Display *	display(const UtString &displayName);

	// String name
	const char *		name() const { return displayName.c_str(); }

	// Width and Height of screen
	ScreenWidth     	width() const { return _width; }
	ScreenHeight    	height() const { return _height; }

	// WT display context accessors
	WText_display_context * getWtDpyContext();
	WTdisp *		getWtDisplay();
	Pixel			getWtPixel( WTcolor color );

	static UtString		cnvtDisplayName( const char *);
	void			closeDisplay();

  private:
	UtString		displayName;
	Display			*DisplayPtr;
	ScreenNumber		screenNumber;
	ScreenWidth		_width;
	ScreenHeight		_height;
	Widget			_appShell;
	static XtAppContext	_appContext; // We only want one of these
	Widget			_managerShell;
	Widget			_hiddenShell;
	WText_display_context *	_wtDpyCtx; // pointer to WT display context

	// private methods
	Widget			createAppShell();
	void			createHiddenShell();
};

//ostream &
//operator << ( ostream &, UIdpyContext &);

// These functions return a pointer to a valid display context
// possibly creating it in the process.
const UIdpyContext & UIgetDisplayContext(Display *display);
const UIdpyContext & UIgetDisplayContext(const UtString &DisplayName);
const UIdpyContext & UIgetDisplayContext(const char * displayName);

#ifdef INLINE_DPYCTX
inline Widget
UIdpyContext::ManagerShell( const UtString &dpyName ) {
	const UIdpyContext &dpyCtx = UIgetDisplayContext(dpyName.c_str());
	return (dpyCtx._managerShell);
}

inline Widget
UIdpyContext::ManagerShell( Display *dpy ) {
	const UIdpyContext &dpyCtx = UIgetDisplayContext(dpy);
	return (dpyCtx._managerShell);
}

inline Widget
UIdpyContext::HiddenShell( const UtString &dpyName ) {
	const UIdpyContext &dpyCtx = UIgetDisplayContext(dpyName.c_str());
	return (dpyCtx._hiddenShell);
}

inline Widget
UIdpyContext::HiddenShell( Display *dpy ) {
	const UIdpyContext &dpyCtx = UIgetDisplayContext(dpy);
	return (dpyCtx._hiddenShell);
}

#if 0 // Not used
inline XtAppContext
UIdpyContext::appContext( const UtString &displayName ) {
	const UIdpyContext &dpyCtx = UIgetDisplayContext(displayName.c_str());
	return (dpyCtx.appContext());
}

inline XtAppContext
UIdpyContext::appContext( Display *display ) {
	const UIdpyContext &dpyCtx = UIgetDisplayContext(display);
	return (dpyCtx.appContext());
}

inline const Display *
UIdpyContext::display( const UtString &displayName ) {
	const UIdpyContext &dpyCtx = UIgetDisplayContext(displayName.c_str());
	return (dpyCtx.display());
}
#endif
#endif

inline WTdisp *
UIdpyContext::getWtDisplay()
{
    if( getWtDpyContext() )
        return _wtDpyCtx->disp;
    else
        return 0;
}

inline Pixel
UIdpyContext::getWtPixel( WTcolor color )
{
    return WTget_pixel( getWtDisplay(), color );
}

void
UI_CloseDisplays();

#endif
