/* PST */
/* pst_decompose.h */
/* by James S Perrin & Paul G Lever */
/* Time-stamp: <Thursday 27/05/04 14:43:41 james> */
/* functions for calculating domains dimensions and sizes */

#ifndef PST_DECOMPOSE_H
#define PST_DECOMPOSE_H

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#include "pst_defs.h"

#ifdef __cplusplus
extern "C" {
#endif
  
  /* Divide global domain of size i,j in to (max)N sub-domains
   of minimum size d as best we can (smallest remainder N-a*b)
   Taking into account ratio i/j and favouring continuous boundaries
   i varies fastest */
  PSTAPI int PST_DecompDomainLayout2D(xp_long i, xp_long j, int N, xp_long s, xp_long *a, xp_long *b);
  /* will call PST_DomainLayout2D until the largest value <N
     is found that returns valid a,b */
  PSTAPI int PST_DecompDomainFindLayout2D(xp_long i, xp_long j, int N, xp_long s, xp_long *a, xp_long *b);
  
#if 0
  /* Divide global domain of size i,j,k in to (max)N sub-domains
   of minimum size d as best we can (smallest remainder N-a*b*c)
   Taking into account ratio i/j/k and favouring continuous boundaries
   i,j varies fastest */
  PSTAPI int PST_DecompDomainLayout3D(int i, int j, int k, int N, int s, int *a, int *b, int *c);
  

  /* will call PST_DomainLayout3D until the largest value <N
   is found that returns valid a,b,c */
  PSTAPI int PST_DecompDomainFindLayout3D(int i, int j, int k, int N, int s, int *a, int *b, int *c);
#endif

  /* Calculate the domain limits for dimension of size split in n domains
   with boundary of b */
  PSTAPI void PST_DecompDomainLimits(xp_long size, int n, int b, xp_long st[], xp_long en[]);
  
#ifdef __cplusplus
}
#endif
#endif
