/* PST */
/* pst_util.h */
/* James S Perrin & Paul G Lever Time-stamp: <Thursday 27/05/04 17:14:42 james> */

#ifndef PST_UTIL_H
#define PST_UTIL_H

#include "mpi.h"
#include "pst_defs.h"

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

  PSTAPI int PST_UtilGetPSTNode(MPI_Comm *comms, int c, int *pstnode_ce, int *npstnodes_ce);

#define PST_UtilGetPSTNodeCE(comms, pstnode_ce, npstnodes_ce) PST_UtilGetPSTNode(comms, 1, pstnode_ce, npstnodes_ce)
#define PST_UtilGetPSTNodeModule(comms, pstnode_mod, npstnodes_mod) PST_UtilGetPSTNode(comms, 0, pstnode_ce, npstnodes_ce)

#define PST_UtilRetCommCE(comms) comms[1]
#define PST_UtilRetCommModule(comms) comms[0]
  
  /* return a runtime unique ID **fudge only works on a single process** */ 
  PSTAPI int PST_UtilGetRTUniqueID();
  
  PSTAPI int PST_UtilCreateID(int nProc, int proc, int comp);
  
  PSTAPI MPI_Datatype PST_UtilXPType2MPIType(int type);

  PSTAPI int PST_UtilMPIType2XPType(MPI_Datatype type);

  PSTAPI int PST_UtilSizeOfXPType(int type);
  
  /* free memory malloc'ed by PST */
  PSTAPI void PST_UtilFree(char *buffer);
  
  PSTAPI int PST_UtilGetPackSize(int nCharParams, int nByteParams, int nShortParams,
				 int nIntParams, int nFloatParams, int nDoubleParams, 
				 int nLongParams, int nLongLongParams, MPI_Comm comm);

  /* convert an Express Obj_id in to something we can use */
#define PST_UtilXPID2PSTID(A) (xp_long)A.elem_id
  
#ifdef __cplusplus
}
#endif
#endif
