/* PSTCE */
/* pst_ce.h */
/* by James S Perrin */
/* Time-stamp: <Monday 05/07/04 17:57:30 james> */
/* List of methods available and there id's */

#ifndef PST_CE_H
#define PST_CE_H



#include "mpi.h"
#include "pst.h"

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif
  
typedef int (*pst_ce_function)(char *, int, int, MPI_Comm *,
			       int, PST_pTag **, PST_pDomain **,
			       int *, PST_pTag ***, PST_pDomain ***);

PSTAPI int PST_CECreateFunctionTable();
PSTAPI int PST_CECallFunction(int ce_id, char *buffer, int size, int count, MPI_Comm *comms,
			      int nTags, PST_pTag **tags, PST_pDomain **domains,
			      int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);
  
/* ############# ADD NEW CE METHOD DECLARATIONS HERE ############# */
#define PST_CE_METHOD_SKELETON 0
PSTAPI int pSkeleton_CE(char *buffer, int size, int count, MPI_Comm *comms,
			int nTags, PST_pTag **tags, PST_pDomain **domains,
			int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);

#define PST_CE_METHOD_CLAMP 1
PSTAPI int pClamp_CE(char *buffer, int size, int count, MPI_Comm *comms,
		     int nTags, PST_pTag **tags, PST_pDomain **domains,
		     int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);
  
#define PST_CE_METHOD_DOWNSIZE_STRUCT 2
PSTAPI int pDownsize_Struct_CE(char *buffer, int size, int count, MPI_Comm *comms,
			int nTags, PST_pTag **tags, PST_pDomain **domains,
			int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);

#define PST_CE_METHOD_READ_FIELD 3
PSTAPI int pRead_Field_CE(char *buffer, int size, int count, MPI_Comm *comms,
			  int nTags, PST_pTag **tags, PST_pDomain **domains,
			  int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);
  
#define PST_CE_METHOD_ISOSURFACE_STRUCT 4
PSTAPI int pIsosurface_Struct_CE(char *buffer, int size, int count, MPI_Comm *comms,
			  int nTags, PST_pTag **tags, PST_pDomain **domains,
			  int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);

#define PST_CE_METHOD_REDISTRIBUTE 5
PSTAPI int pRedistribute_CE(char *buffer, int size, int count, MPI_Comm *comms,
				int nTags, PST_pTag **tags, PST_pDomain **domains,
				int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);
  
#define PST_CE_METHOD_THRESHOLD 6
PSTAPI int pThreshold_CE(char *buffer, int size, int count, MPI_Comm *comms,
				  int nTags, PST_pTag **tags, PST_pDomain **domains,
				  int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);
  
#define PST_CE_METHOD_MAGNITUDE 7
PSTAPI int pMagnitude_CE(char *buffer, int size, int count, MPI_Comm *comms,
				  int nTags, PST_pTag **tags, PST_pDomain **domains,
				  int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);

#define PST_CE_METHOD_CROP_STRUCT 8
PSTAPI int pCrop_Struct_CE(char *buffer, int size, int count, MPI_Comm *comms,
			 int nTags, PST_pTag **tags, PST_pDomain **domains,
			 int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);

#define PST_CE_METHOD_COMBINE_VECTOR 9
PSTAPI int pCombine_Vector_CE(char *buffer, int size, int count, MPI_Comm *comms,
			      int nTags, PST_pTag **tags, PST_pDomain **domains,
			      int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);

#define PST_CE_METHOD_ORTHOSLICE 10
PSTAPI int pOrthoslice_CE(char *buffer, int size, int count, MPI_Comm *comms,
			  int nTags, PST_pTag **tags, PST_pDomain **domains,
			  int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);

#define PST_CE_METHOD_NULL_BRICK 11
PSTAPI int pNull_Brick_CE(char *buffer, int size, int count, MPI_Comm *comms,
			  int nTags, PST_pTag **tags, PST_pDomain **domains,
			  int *nTags_out, PST_pTag ***tags_out, PST_pDomain ***domains_out);
  
/* ############# THIS DEFINE MUST BE UPDATED EACH TIME A NEW CE METHOD IS ADDED ############# */
#define PST_CE_METHOD_MAX_INDEX 12
  
#ifdef __cplusplus
}
#endif
#endif
