/*
                Copyright (c) 1999 by
                Advanced Visual Systems Inc.
                All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/reduct/surfRed.h#1 $
*/

/******************************************************************************
 file:   surfRed.h

 This function does the triangle decimation. For description of parameters see
 the comments below:
 *****************************************************************************/

float SurfaceReduction(xp_ulong in_nnodes,              // # of vertices in source mesh
                       float *in_coordinates,               // vertices in  source mesh
                       xp_ulong in_ncells,              // number of cells in source mesh
                       xp_long *in_connect_list,                // cell definition (source mesh)
                       float bounds[6],                     // extents of the surface
                       float maxSurfTol,                    // max surface Tol of decimated mesh
                       float target,                        // target reduction
                       int maxSubdivisions,                 // max # of subdivisions
                       xp_ulong &decimated_nnodes,      // # of vertices in decimated mesh
                       float *&decimated_coordinates,       // vertices in decimated mesh
                       xp_long *&node_mapping,                  // which old nodes does each new nodes
                                                            // map to this allows node_data to be
                                                            // handled by module
                       xp_ulong &decimated_ncells,      // # of cells in decimated mesh
                       xp_long *&decimated_connect_list);       // cell definition (decimated mesh)

/******************************************************************************
 returns MaxError.
 This function assigns new arrays to the pointers decimated_coordinates and
 decimated_connect_list for the decimated mesh. Delete these pointers when you
 don't need the arrays anymore to free the occupied memory.
 *****************************************************************************/
