/*
			Copyright (c) 2001 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/cfd/xp_mods/cgns_read.h#1 $
*/

#ifdef WIN32
#define NOGDI /* Squash conflict over 'ERROR' */
#define WIN32_LEAN_AND_MEAN
#endif

#include <stdio.h>
#include <string.h>
#include <sys/types.h>  /* time_t */

#include <avs/f_utils.h>
#include <avs/om.h>

#include "../CGNSLib/cgnslib.h"

#define CGNS_NAME_MAX_LEN 33 /* maximal length of strings in CGNS (32+termin) */

#define NGON_MAX NGON_n+21   /* first NGON not supported - support for up to 20 vertices */

/* AVS IDs for cell_sets */

#define Point	1
#define Line	2
#define Line2	12
#define Tri		4
#define Tri2	14
#define Quad	5
#define Quad2	15
#define Tet		6
#define Tet2	16
#define Pyr		9
#define Pyr2	19
#define Prism	8
#define Prism2	18
#define Hex		7
#define Hex2	17
#define PolyH	20 /* actually it's 19 in AVS, but it would conflict with Pyr2 */

void FUNCreset_output_flds(OMobj_id module_id);

int FUNCadd_structured_coords(OMobj_id module_id, const char *file_name,
   int base, int zone, int index_dim, int phys_dim, int *vertex_size,
   int *rind, int *XYZ);

int FUNCadd_structured_cell_data(OMobj_id module_id, const char *file_name,
   int base, int zone, int fld_el_indx, int index_dim, int *vertex_size,
   int *rind, int solution);

int FUNCadd_structured_vrtx_data(OMobj_id module_id, const char *file_name,
   int base, int zone, int fld_el_indx, int index_dim, int *vertex_size,
   int *rind, int solution);


int FUNCadd_unstructured_coords(OMobj_id module_id, const char *file_name,
   int base, int zone, int phys_dim, int *vertex_size, int *XYZ);

int FUNCadd_unstructured_sections(OMobj_id module_id, OMobj_id zone_id,
   const char *file_name, int base, int zone);

int FUNCadd_unstructured_vrtx_data(OMobj_id module_id, const char *file_name,
   int base, int zone, int fld_el_indx, int index_dim, int *vertex_size,
   int solution);

int FUNCadd_unstructured_cell_data(OMobj_id module_id, OMobj_id zone_id,
   const char *file_name, int base, int zone, int fld_el_indx,
   int *vertex_size, int solution);

