//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/cxxutl/attrmgr.cxx#1 $
//

// attrmgr.cxx - Source file for UtAttrMgr class

//----------------------------------------------------------------------
#include <assert.h>
#include <avs/cxxutl/attrmgr.hxx>
#include <avs/cxxutl/string.hxx>

//----------------------------------------------------------------------
// Define the default attribute list
//----------------------------------------------------------------------
UtPtrSortedArray<UtBaseAttr> UtAttrMgr::_defaultAttributes(1);

//----------------------------------------------------------------------
// This is used for find operations
//----------------------------------------------------------------------
UtBaseAttr UtAttrMgr::_findAttr("dummy");

//----------------------------------------------------------------------
// Find the given attribute in given attribute block taking
// alias attributes into account
//----------------------------------------------------------------------
UtBaseAttr*
UtAttrMgr::_findRealAttr(
    UtPtrSortedArray<UtBaseAttr> &attributes,
    const char *name,
    char **realName) // The real attribute name when alias is found
//----------------------------------------------------------------------
{
    _findAttr._name= *realName = (char*)name;
    UtBaseAttr *attr = attributes.find(&_findAttr);
    // If alias then get real name and try again
    while (attr && attr->isState(UtATTR_ALIAS)) {
        _findAttr._name = *realName=(char*)(((UtAliasAttr*)attr)->aliasName());
        attr = attributes.find(&_findAttr);
    }
    return attr;
}
//----------------------------------------------------------------------
// Find the given attribute for this object or in it's parents
//----------------------------------------------------------------------
UtBaseAttr*
UtAttrMgr::_findRecursiveUpAttr(
    const char *name, 
    UtAttrState checkFlag)
//----------------------------------------------------------------------
{
    char *realName;
    UtBaseAttr *attr = _findRealAttr(_attributes, name, &realName);
    // if the attribute is not found or does not match flag then go on
    if (!attr || !attr->isState(checkFlag)) {
        attr = 0;
        UtAttrMgr *parent = _parentUtAttrMgr();
        if (parent) {
            UtBaseAttr *newAttr = 
                parent->_findRecursiveUpAttr(realName, checkFlag);
            if (newAttr) attr = newAttr;
        } 
        // If no more parents then return from default attribute list
        else {
            attr = _findRealAttr(_defaultAttributes, realName, &realName);
            // The attribute MUST be found now
            assert(attr != NULL);
            // It must match flag
            if (!attr->isState(checkFlag)) {
                attr = 0;
            }
        }
    }
    return attr;
}

//----------------------------------------------------------------------
void 
UtAttrMgr::updateAttr() 
//----------------------------------------------------------------------
{
    _userUpdateAttr();
    // Loop over all potential changed attributes
    for (int i=0; i<_newAttributes.size(); i++) {
        // If this new attribute has been set then move it 
        if (_newAttributes[i]->isState(UtATTR_CHANGED)) {
            const int index = _attributes.findIndex(_newAttributes[i]);
            // Delete old one
            delete _attributes[index];
            // Clear changed flag and move to local attributes
            _attributes[index] = (_newAttributes[i]->clearChangedState());
            // Make a new new
            _newAttributes[i] = _attributes[index]->newOf();
        }
    }
}

//----------------------------------------------------------------------
void 
UtAttrMgr::_addAttr(
    UtBaseAttr *baseAttr, int checkUpdate) 
//----------------------------------------------------------------------
{
    _attributes.add(baseAttr);
    // Check is this attribute will be used in _userUpdateAttr
    if (checkUpdate) {
        UtBaseAttr *addToNew = baseAttr->newOf();
        if (addToNew) _newAttributes.add(addToNew);
    }
    // Also add it to the _defaultAttrbutes if not already done
    if (!_defaultAttributes.find(baseAttr)) {
        UtBaseAttr *addToDefault = baseAttr->newOf();
        // Only add it if nonzero pointer returned.
        // Private attributes (start with _) should return zero pointers
        // Public attributes should all return a valid pointer
        if (addToDefault) {
            // Initialize with default value 
            addToDefault->init();
            // Insert into default attributes block
            _defaultAttributes.add(addToDefault);
        }
    }
}

//----------------------------------------------------------------------
UtBaseAttr*
UtAttrMgr::findAttr(
    const char *name, 
    UtAttrSearchType search)
//----------------------------------------------------------------------
{
    char *realName;
    UtBaseAttr *returnValue;
    switch (search) {

      case UtIS_SET:  
        returnValue = _findRecursiveUpAttr(name, UtATTR_SET);
        break;

      case UtDO_CHANGE:
        // If name starts with _ then it is a private attribute
        // so look in local _attributes
        if (*name == '_') {
            returnValue = _findRealAttr(_attributes, name, &realName);
        } else {
            returnValue = _findRealAttr(_newAttributes, name, &realName);
            // if found then set to changed
            if (returnValue) {
                returnValue->setState(UtATTR_SET_CHANGED);
            } else {
                // If not found in new then look in local
                if (!returnValue) returnValue = 
                                      _findRealAttr(_attributes, 
                                          realName, &realName );
            }
        }
        break;

      case UtGET_NEW:
        returnValue = _findRealAttr(_newAttributes, name, &realName);
        break;

      case UtGET_LOCAL:
        returnValue = _findRealAttr(_attributes, name, &realName);
        break;

      case UtDO_SET_CALCULATED:
        returnValue = _findRealAttr(_attributes, name, &realName)->
          setState(UtATTR_CALCULATED);
        break;

      case UtIS_USER_SET:
        returnValue = _findRecursiveUpAttr(name, UtATTR_USER_SET);
        break;
    }
    return returnValue;
}
