//			Copyright (c) 1998 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//	
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//	
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/cxxutl/datetime.cxx#1 $
//

// Source file for UtDateTime and UtDate classes

//----------------------------------------------------------------------

#include <avs/cxxutl/datetime.hxx>


UtDateTime UtDateTime::Now( )
{
    return UtDateTime( time( NULL ) );
}


UtString UtDateTime::PrintString( DateTimePrintForm form ) const
{
    const int buffLen = 100;
    char buffer[buffLen];

    struct tm tm = *localtime( &_time );

    switch( form ) {
    case Date_American:
        strftime( buffer, 100, "%B %d, %Y", &tm );
        break;
    case Date_Numbers:
        strftime( buffer, 100, "%m/%d/%y", &tm );
        break;
    case Date_European:
        strftime( buffer, 100, "%d %B %Y", &tm );
        break;
    case Time_Normal:
        strftime( buffer, 100, "%I:%M %p", &tm );
        break;
    case Time_Military:
        strftime( buffer, 100, "%H:%M:%S", &tm );
        break;
    }

    return UtString( buffer );
}



UtDate::UtDate( short yy, short mm, short dd )
{
    struct tm tm;

    // If 0-38, assume 2000-2038, not 1900-1938.
    if( yy < 38 ) yy += 100;

    // The year slot is years past 1900
    if( yy > 1900 ) yy -= 1900;

    tm.tm_year = yy;
    tm.tm_mon  = mm - 1;
    tm.tm_mday  = dd;
    tm.tm_hour = 0;
    tm.tm_min  = 0;
    tm.tm_sec  = 0;
    tm.tm_isdst = -1;

    _time = mktime( &tm );
}


ostream& operator<< ( ostream& stream, const UtDate& date )
{
    UtString string = date.PrintString( Date_Numbers );
    stream << string;
    return stream;
}

