//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/cxxutl/enum.cxx#1 $
//

// enum.cxx - Source file for UtBaseEnum and UtEnum classes

//----------------------------------------------------------------------
#include <avs/cxxutl/enum.hxx>
#include <avs/cxxutl/string.hxx>

//----------------------------------------------------------------------
UtBaseEnum::operator const char*() 
const 
//----------------------------------------------------------------------
{
    const char *returnValue;
    if (_currentValue) {
        returnValue = _currentValue->_stringValue;
    } else {
        returnValue = "";
    }
//    printf("in operator const char* returning %s\n", returnValue);
    return returnValue;
}

//----------------------------------------------------------------------
UtBaseEnum::operator int() 
const 
//----------------------------------------------------------------------
{
    int returnValue;
    if (_currentValue) {
        returnValue = _currentValue->_intValue;
    } else {
        returnValue = 0;
    }
    return returnValue;
}

//
// UtEnum
//
//----------------------------------------------------------------------
const UtBaseEnum&
UtBaseEnum::operator= (
    const char *value) 
//----------------------------------------------------------------------
{
    UtString stringValue(value);
    stringValue.lower().collapse();
    _currentValue = 0;
    UtEnumObj *ptr = _legalValues;
    do {
        if (stringValue == ptr->_stringValue) {
            _currentValue = ptr;
            break;
        }
    } while ((++ptr)->_stringValue);
    return *this;
}

//----------------------------------------------------------------------
const UtBaseEnum&
UtBaseEnum::operator= (
    int intValue) 
//----------------------------------------------------------------------
{
    _currentValue = 0;
    UtEnumObj *ptr = _legalValues;
    do {
        if (intValue == ptr->_intValue) {
            _currentValue = ptr;
            break;
        }
    } while ((++ptr)->_stringValue);
    return *this;
}

//----------------------------------------------------------------------
// since there is both an operator=(int) and an operator int() 
// we need a default assignment constructor to avoid the above being used
//----------------------------------------------------------------------
UtBaseEnum&
UtBaseEnum::operator= (
    const UtBaseEnum &from) 
//----------------------------------------------------------------------
{
    _currentValue = from._currentValue;
    _legalValues = from._legalValues;
    return *this;
}
