//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/cxxutl/ptrlisto.cxx#1 $
//

// ptrlisto.cxx - Source for UtPtrListObjPtr class

//----------------------------------------------------------------------
#include <avs/cxxutl/ptrlisto.hxx>

//----------------------------------------------------------------------
void 
UtPtrListObj::addLast(
    UtPtrListObjPtr &first,
    UtPtrListObjPtr &last,
    void *element) 
//----------------------------------------------------------------------
{
    // first element in list ?
    if (!first) {
        first = last = new UtPtrListObj;
        first->_element = element;
    }
    else {
        last->_next = new UtPtrListObj;
        last->_next->_previous = last;
        last = last->_next;
        last->_element = element;
    }
}

//----------------------------------------------------------------------
void 
UtPtrListObj::addFirst(
    UtPtrListObjPtr &first,
    UtPtrListObjPtr &last,
    void *element)
//----------------------------------------------------------------------
{
    // first element in list ?
    if (!first) {
        first = last = new UtPtrListObj;
        first->_element = element;
    }
    else {
        first->_previous = new UtPtrListObj;
        first->_previous->_next = first;
        first = first->_previous;
        first->_element = element;
    }
}

//----------------------------------------------------------------------
void 
UtPtrListObj::removeFirst(
    UtPtrListObjPtr &first,
    UtPtrListObjPtr &last)
//----------------------------------------------------------------------
{
    if (first) {
        UtPtrListObj *remove = first;
        first = remove->_next;
        // Any remaining elements in list
        if (first) {
            first->_previous = 0;
        }
        // Was this the only element in the list
        else {
            last = 0;
        } 
        delete remove;
    }
}

//----------------------------------------------------------------------
void 
UtPtrListObj::removeLast(
    UtPtrListObjPtr &first,
    UtPtrListObjPtr &last)
//----------------------------------------------------------------------
{
    if (last) {
        UtPtrListObj *remove = last;
        last = remove->_previous;
        // Any remaining elements in list
        if (last) {
            last->_next = 0;
        }
        // Was this the only element in the list
        else {
            first = 0;
        } 
        delete remove;
    }
}

//----------------------------------------------------------------------
void 
UtPtrListObj::remove(
    UtPtrListObjPtr &first,
    UtPtrListObjPtr &last,
    void *element) 
//----------------------------------------------------------------------
{
    UtPtrListObj *remove;
    // return if empty list
    if (!first) {}
    // special case when first object in list
    else if (element == first->_element) {
        remove = first;
        // only one element in list ?
        if (first == last) {
            first = last = 0;
        } else {
            first = first->_next;
            first->_previous = 0;
        }
        delete remove;
    }
    // not first element
    else {
        UtPtrListObj *next = first->_next;
        while (next) {
            // remove element if found 
            if (element == next->_element) {
                remove = next;
                // special case when last object in list
                if (remove == last) {
                    last = last->_previous;
                    last->_next = 0;
                } 
                // not last element
                else {
                    remove->_previous->_next = remove->_next;
                    remove->_next->_previous = remove->_previous;
                }
                delete remove;
                break;
            }
            next = next->_next;
        }
    }
}
