//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/cxxutl/typeattr.cxx#1 $
//

// typeattr.cxx - Source file for basic type attributes

//----------------------------------------------------------------------

#include <avs/cxxutl/typeattr.hxx>

//----------------------------------------------------------------------
void 
UtBaseEnumAttr::set(
    int value) 
//----------------------------------------------------------------------
{
    _value = value;
    setState(UtATTR_USER_SET);
    // validate value and set to ATTR_UNSET if value is illegal
    _validate();
}

//----------------------------------------------------------------------
void 
UtBaseEnumAttr::set(
    const char *value) 
//----------------------------------------------------------------------
{
    _value = value;
    setState(UtATTR_USER_SET);
    // validate value and set to ATTR_UNSET if value is illegal
    _validate();
}

//----------------------------------------------------------------------
void 
UtBaseEnumAttr::set(
    const UtBaseEnum &value)
//----------------------------------------------------------------------
{
    UtAttr<UtBaseEnum>::set(value);
}

//----------------------------------------------------------------------
UtBaseEnumAttr::UtBaseEnumAttr(
    const char *name) 
    : UtAttr<UtBaseEnum>(name) 
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
void 
UtBaseEnumAttr::_validate() 
//----------------------------------------------------------------------
{
    if (!_value.valid()) setState(UtATTR_UNSET);
}

//----------------------------------------------------------------------
UtBooleanAttr::UtBooleanAttr(
    const char *name) 
    : UtAttr<int>(name) 
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
void 
UtBooleanAttr::_validate() 
//----------------------------------------------------------------------
{
    if (_value != 0) _value = 1;
}

//----------------------------------------------------------------------
UtStringAttr::UtStringAttr(
    const char *name) 
    : UtPtrAttr<UtString>(name) 
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
void 
UtStringAttr::_validate() 
//----------------------------------------------------------------------
{
    if (_value->length()<0) setState(UtATTR_UNSET);
}
