/*
  Copyright (c) 1994 by
  Advanced Visual Systems Inc.
  All Rights Reserved

  This software comprises unpublished confidential information of
  Advanced Visual Systems Inc. and may not be used, copied or made
  available to anyone, except in accordance with the license
  under which it is furnished.

  This file is under Perforce control
  $Id: //depot/express/fcs70/fld/dfuncs.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdlib.h>

#include <avs/math.h>
#include <avs/dll_in.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/om_att.h>
#include <avs/om_type.h>
#include <avs/fld.h>

int FLDget_ncells_polytri (OMobj_id, xp_long *);
int FLDget_connect_polytri (OMobj_id, int *, char **, int *, xp_long *, int);
int FLDget_connect_polytri_dims (OMobj_id elem_id, int *ndim, xp_long *dims);
int FLDget_ncells_polyline (OMobj_id, xp_long *);
int FLDget_connect_polyline (OMobj_id, int *, char **, int *, xp_long *, int);
int FLDget_connect_polyline_dims (OMobj_id elem_id, int *ndim, xp_long *dims);
int FLDget_ncells_polyhedron (OMobj_id, xp_long *);
int FLDget_connect_polyhedron (OMobj_id, int *, char **, int *, xp_long *, int);
int FLDget_connect_polyhedron_dims (OMobj_id elem_id, int *ndim, xp_long *dims);

static int int_type (OMobj_id, int *);
static int long_type (OMobj_id, int *);

static xp_long triangulate_polygon(int nspace, float *xyz, xp_long n, xp_long *plist, xp_long *new_plist);


OMtype_id FLD_type_get_coords_unif,
	  FLD_type_get_coords_rect,
	  FLD_type_get_coords_cyl_unif,
	  FLD_type_get_coords_cyl_rect,
	  FLD_type_get_coords_spher_unif,
	  FLD_type_get_coords_spher_rect,
	  FLD_type_get_connect_struct,
	  FLD_type_get_connect_polytri,
	  FLD_type_get_ncells_polytri,
	  FLD_type_get_connect_polyline,
	  FLD_type_get_ncells_polyline,
	  FLD_type_get_connect_polyhedron,
	  FLD_type_get_ncells_polyhedron;

/* 64-bit porting. Only Modified Internally */
void FLDfunc_init(void)
{
	OMtype_id type;

	type = FLD_type_get_coords_unif =
		OMcreate_type("Tget_coords_unif",OM_type_farray_func, 0);
	OMset_method(OM_METH_GET_SUB_FARRAY,type,FLDget_coords_unif);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_coords_dims);

	type = FLD_type_get_coords_rect =
		OMcreate_type("Tget_coords_rect",OM_type_farray_func, 0);
	OMset_method(OM_METH_GET_SUB_FARRAY,type,FLDget_coords_rect);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_coords_dims);

	type = FLD_type_get_coords_cyl_unif =
		OMcreate_type("Tget_coords_cyl_unif",OM_type_farray_func, 0);
	OMset_method(OM_METH_GET_SUB_FARRAY,type,FLDget_coords_cyl_unif);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_coords_dims);

	type = FLD_type_get_coords_cyl_rect =
		OMcreate_type("Tget_coords_cyl_rect",OM_type_farray_func, 0);
	OMset_method(OM_METH_GET_SUB_FARRAY,type,FLDget_coords_cyl_rect);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_coords_dims);

	type = FLD_type_get_coords_spher_unif =
		OMcreate_type("Tget_coords_spher_unif",OM_type_farray_func, 0);
	OMset_method(OM_METH_GET_SUB_FARRAY,type,FLDget_coords_spher_unif);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_coords_dims);

	type = FLD_type_get_coords_spher_rect =
		OMcreate_type("Tget_coords_spher_rect",OM_type_farray_func, 0);
	OMset_method(OM_METH_GET_SUB_FARRAY,type,FLDget_coords_spher_rect);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_coords_dims);

	type = FLD_type_get_connect_struct =
		OMcreate_type("Tget_connect_struct",OM_type_larray_func, 0);
	OMset_method(OM_METH_GET_SUB_IARRAY,type,OMlarray_get_sub_iarray);
	OMset_method(OM_METH_GET_SUB_LARRAY,type,FLDget_connect_struct);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_connect_dims);

	type = FLD_type_get_connect_polytri =
		OMcreate_type("Tget_connect_polytri",OM_type_val_func, 0);
	OMset_method(OM_METH_GET_SUB_LARRAY,type,OMarray_get_sub_larray);
	OMset_method(OM_METH_GET_SUB_IARRAY,type,OMlarray_get_sub_iarray);
        OMset_method(OM_METH_GET_SUB_BARRAY,type,OMiarray_get_sub_barray);
        OMset_method(OM_METH_GET_SUB_SARRAY,type,OMiarray_get_sub_sarray);
        OMset_method(OM_METH_GET_SUB_FARRAY,type,OMrarray_get_sub_farray);
        OMset_method(OM_METH_GET_SUB_RARRAY,type,OMiarray_get_sub_rarray);
	OMset_method(OM_METH_GET_ARRAY,type,FLDget_connect_polytri);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_connect_polytri_dims);

	type = FLD_type_get_ncells_polytri =
		OMcreate_type("Tget_ncells_polytri",OM_type_val_func, 0);
	OMset_method(OM_METH_GET_LONG_VAL,type,FLDget_ncells_polytri);
	OMset_method(OM_METH_GET_INT_VAL,type,OMlong_get_int_val);
	OMset_method(OM_METH_GET_DATA_TYPE,type,long_type);

	type = FLD_type_get_connect_polyline =
		OMcreate_type("Tget_connect_polyline",OM_type_val_func, 0);
	OMset_method(OM_METH_GET_SUB_LARRAY,type,OMarray_get_sub_larray);
	OMset_method(OM_METH_GET_SUB_IARRAY,type,OMlarray_get_sub_iarray);
        OMset_method(OM_METH_GET_SUB_BARRAY,type,OMiarray_get_sub_barray);
        OMset_method(OM_METH_GET_SUB_SARRAY,type,OMiarray_get_sub_sarray);
        OMset_method(OM_METH_GET_SUB_FARRAY,type,OMrarray_get_sub_farray);
        OMset_method(OM_METH_GET_SUB_RARRAY,type,OMlarray_get_sub_rarray);
	OMset_method(OM_METH_GET_ARRAY,type,FLDget_connect_polyline);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_connect_polyline_dims);

	type = FLD_type_get_ncells_polyline =
		OMcreate_type("Tget_ncells_polyline",OM_type_val_func, 0);
	OMset_method(OM_METH_GET_LONG_VAL,type,FLDget_ncells_polyline);
	OMset_method(OM_METH_GET_INT_VAL,type,OMlong_get_int_val);
	OMset_method(OM_METH_GET_DATA_TYPE,type,long_type);

	type = FLD_type_get_connect_polyhedron =
		OMcreate_type("Tget_connect_polyhedron",OM_type_val_func, 0);
	OMset_method(OM_METH_GET_SUB_LARRAY,type,OMarray_get_sub_larray);
	OMset_method(OM_METH_GET_SUB_IARRAY,type,OMlarray_get_sub_iarray);
        OMset_method(OM_METH_GET_SUB_BARRAY,type,OMiarray_get_sub_barray);
        OMset_method(OM_METH_GET_SUB_SARRAY,type,OMiarray_get_sub_sarray);
        OMset_method(OM_METH_GET_SUB_FARRAY,type,OMrarray_get_sub_farray);
        OMset_method(OM_METH_GET_SUB_RARRAY,type,OMiarray_get_sub_rarray);
	OMset_method(OM_METH_GET_ARRAY,type,FLDget_connect_polyhedron);
	OMset_method(OM_METH_GET_ARRAY_DIMS,type,FLDget_connect_polyhedron_dims);

	type = FLD_type_get_ncells_polyhedron =
		OMcreate_type("Tget_ncells_polyhedron",OM_type_val_func, 0);
	OMset_method(OM_METH_GET_LONG_VAL,type,FLDget_ncells_polyhedron);
	OMset_method(OM_METH_GET_INT_VAL,type,OMlong_get_int_val);
	OMset_method(OM_METH_GET_DATA_TYPE,type,long_type);
}

/*
 * This routine returns the dimensionality of the coordinates array that
 * the FLDget_coords_... routines produce.
 */
/* 64-bit porting. Modified with Parallel  APIs */
int FLDget_coords_dims(OMobj_id elem_id, int *ndim, xp_long *dims)
{
	OMobj_id dims_id, nspace_id;
	int stat;

	*ndim = 2;
	if (dims == NULL) return(1); /* dims not requested, just return ndim */

	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD);
	nspace_id = OMfind_subobj(elem_id,OMstr_to_name("my_nspace"),OM_OBJ_RD);

	if ((stat = OMget_long_val(nspace_id,&dims[0])) != 1) return(stat);
	if ((stat = OMget_list_prod(dims_id,&dims[1])) != 1) return(stat);
	return(1);
}

#ifdef WORDLENGTH_64
int FLDget_coords_dims_n(OMobj_id elem_id, int *ndim, int *dims)
{
	int status;

	if(dims == NULL)
	  status = FLDget_coords_dims(elem_id, ndim, NULL);
	else
	{
	  int i;
	  xp_long dims_w[OM_ARRAY_MAXDIM];

	  status = FLDget_coords_dims(elem_id, ndim, dims_w);
	  for( i = 0; i < *ndim; i++)
		 dims[i] = (int)dims_w[i];
	}

	return status;
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int FLDget_coords_unif(OMobj_id elem_id, int req_ndim, xp_long *idims,
                       xp_long *imin_rng, xp_long *imax_rng, float *array)
{
	OMobj_id ndim_id, dims_id, nspace_id, points_id;
	int ndim;
	xp_long ndim_w, *dims, copy_dims[16];
	float *points;
	int stat, nspace;
	int dims_type, points_type;
	xp_long points_len;
	char buf1[128];
	int i;
	xp_long omin_rng[16], omax_rng[16];

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD),
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD),
	nspace_id = OMfind_subobj(elem_id,OMstr_to_name("my_nspace"),OM_OBJ_RD),
	points_id = OMfind_subobj(elem_id,OMstr_to_name("my_points"),OM_OBJ_RD);

	if (OMis_null_obj(ndim_id) ||
	    OMis_null_obj(dims_id) ||
	    OMis_null_obj(nspace_id) ||
	    OMis_null_obj(points_id)) {
		ERRerror("FLDget_coords_unif", 1, ERR_CHAIN,
			 "can't find required sub-element for element: %s",
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	dims_type = OM_TYPE_LONG;
	dims = NULL;
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1 ||
	    (stat = OMget_array_sz(dims_id,&dims_type,(char **)&dims,
			&ndim_w,OM_GET_ARRAY_RD)) != 1 ||
	    (stat = OMget_int_val(nspace_id,&nspace)) != 1) {
		if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_unif", 1, ERR_CHAIN,
				 "can't get required data from sub-elements for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}
	ndim = (int)ndim_w;

	points_len = 2*nspace;
	points_type = OM_TYPE_FLOAT;
	points = NULL;
	if ((stat = OMget_array_sz(points_id,&points_type,(char **)&points,&points_len,
			OM_GET_ARRAY_RD)) != 1) {
                if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_unif", 1, ERR_CHAIN,
				 "can't get points array for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}
	copy_dims[0] = nspace;
	memcpy(copy_dims+1,dims,ndim*sizeof(xp_long));
        if (dims != NULL) ARRfree(dims);

	if (req_ndim == ndim+1) {
		for (i = 0; i < req_ndim; i++) if (idims[i] != copy_dims[i]) break;
		if (i == req_ndim)  {
			stat = get_coords_unif(ndim+1, copy_dims, points,
					       imin_rng, imax_rng, array);
			if (points != NULL) ARRfree(points);
			return(stat);
		}
	}
	if (req_ndim == 2) { /** check the whole array  **/
		for (i = 0; i < req_ndim; i++)
			if (idims[i] != (imax_rng[i] - imin_rng[i]))
				break;
		if (i == req_ndim) {
			for (i = 0; i < ndim+1; i++) {
				omax_rng[i] = copy_dims[i];
				omin_rng[i] = 0;
			}
			stat = get_coords_unif(ndim+1, copy_dims, points,
					       omin_rng, omax_rng, array);
			if (points != NULL) ARRfree(points);
			return(stat);
		}
	}

	stat = OMcvt_sub_array(elem_id,req_ndim,idims,imin_rng,imax_rng,
			       ndim+1,copy_dims,
			       (char *)array,DTYPEtype_size[DTYPE_FLOAT],
			       (OMsub_array_func) FLDget_coords_unif);
	/* array was converted and dealt with in the cvt func */
	if (stat == -2) {
	   if (points != NULL) ARRfree(points);
	   return(1);
	}

	/* oops.. an error */
	if (stat == 1) {
	   stat = get_coords_unif(ndim+1, copy_dims, points,
			          imin_rng, imax_rng, array);
	}
	if (points != NULL) ARRfree(points);

	return(stat);
}

#ifdef WORDLENGTH_64
int FLDget_coords_unif_n(OMobj_id elem_id, int req_ndim, int *idims,
                       int *imin_rng, int *imax_rng, float *array)
{
	int i, status;
	xp_long idims_w[OM_ARRAY_MAXDIM], imin_rng_w[OM_ARRAY_MAXDIM], imax_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < req_ndim; i++)
	{
		idims_w[i] = (xp_long)idims[i];
		imin_rng_w[i] = (xp_long)imin_rng[i];
		imax_rng_w[i] = (xp_long)imax_rng[i];
	}

	status = FLDget_coords_unif(elem_id, req_ndim, idims_w, imin_rng_w, imax_rng_w, array);

	for( i = 0; i < req_ndim; i++)
		idims[i] = (int)idims_w[i];

	return status;
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int FLDget_coords_rect(OMobj_id elem_id, int req_ndim, xp_long *idims,
                       xp_long *imin_rng, xp_long *imax_rng, float *array)
{
	OMobj_id ndim_id, dims_id, nspace_id, points_id;
	int ndim;
	xp_long ndim_w, *dims;
	float *points;
	int stat, nspace;
	xp_long copy_dims[16];
	int dims_type, points_type;
	xp_long points_len;
	char buf1[128];
	int i;
	xp_long omin_rng[16], omax_rng[16];

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD),
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD),
	nspace_id = OMfind_subobj(elem_id,OMstr_to_name("my_nspace"),OM_OBJ_RD),
	points_id = OMfind_subobj(elem_id,OMstr_to_name("my_points"),OM_OBJ_RD);

	if (OMis_null_obj(ndim_id) ||
	    OMis_null_obj(dims_id) ||
	    OMis_null_obj(nspace_id) ||
	    OMis_null_obj(points_id)) {
		ERRerror("FLDget_coords_rect", 1, ERR_CHAIN,
			 "can't find required sub-element for element: %s",
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	dims_type = OM_TYPE_LONG;
	dims = NULL;
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1 ||
	    (stat = OMget_array_sz(dims_id,&dims_type,(char **)&dims,
				   &ndim_w,OM_GET_ARRAY_RD)) != 1 ||
	    (stat = OMget_int_val(nspace_id,&nspace)) != 1) {
	        if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_rect", 1, ERR_CHAIN,
				 "can't get required data from sub-elements for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}

	ndim = (int)ndim_w;

	points_len = 0;
	points_type = OM_TYPE_FLOAT;
	points = NULL;
	if ((stat = OMget_array_sz(points_id,&points_type,(char **)&points,&points_len,
			OM_GET_ARRAY_RD)) != 1) {
	        if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_rect", 1, ERR_CHAIN,
				 "can't get points array for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}

	copy_dims[0] = nspace;
	memcpy(copy_dims+1,dims,ndim*sizeof(xp_long));
        if (dims != NULL) ARRfree(dims);

	if (req_ndim == ndim+1) {
		for (i = 0; i < req_ndim; i++) if (idims[i] != copy_dims[i]) break;
		if (i == req_ndim)  {
			stat = get_coords_rect(ndim+1, copy_dims, points,
					       imin_rng, imax_rng, array);
			if (points != NULL) ARRfree(points);
			return(stat);
		}
	}
	if (req_ndim == 2) { /** check the whole array  **/
		for (i = 0; i < req_ndim; i++)
			if (idims[i] != (imax_rng[i] - imin_rng[i]))
				break;
		if (i == req_ndim) {
			for (i = 0; i < ndim+1; i++) {
				omax_rng[i] = copy_dims[i];
				omin_rng[i] = 0;
			}
			stat = get_coords_rect(ndim+1, copy_dims, points,
					       omin_rng, omax_rng, array);
			if (points != NULL) ARRfree(points);
			return(stat);
		}
	}


	stat = OMcvt_sub_array(elem_id,req_ndim,idims,imin_rng,imax_rng,
			       ndim+1,copy_dims,
			       (char *)array,DTYPEtype_size[DTYPE_FLOAT],
			       (OMsub_array_func) FLDget_coords_rect);
	/* array was converted and dealt with in the cvt func */
	if (stat == -2) {
	   if (points != NULL) ARRfree(points);
	   return(1);
	}

	/* oops.. an error */
	if (stat == 1) {
	   stat = get_coords_rect(ndim+1, copy_dims, points,
			          imin_rng, imax_rng, array);
	}
	if (points != NULL) ARRfree(points);
	return(stat);
}

#ifdef WORDLENGTH_64
int FLDget_coords_rect_n(OMobj_id elem_id, int req_ndim, int *idims,
                       int *imin_rng, int *imax_rng, float *array)
{
	int i, status;
	xp_long idims_w[OM_ARRAY_MAXDIM], imin_rng_w[OM_ARRAY_MAXDIM], imax_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < req_ndim; i++)
	{
		idims_w[i] = (xp_long)idims[i];
		imin_rng_w[i] = (xp_long)imin_rng[i];
		imax_rng_w[i] = (xp_long)imax_rng[i];
	}

	status = FLDget_coords_rect(elem_id, req_ndim, idims_w, imin_rng_w, imax_rng_w, array);

	for( i = 0; i < req_ndim; i++)
		idims[i] = (int)idims_w[i];

	return status;
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int FLDget_coords_cyl_unif(OMobj_id elem_id, int req_ndim, xp_long *idims,
                           xp_long *imin_rng, xp_long *imax_rng, float *array)
{
	OMobj_id ndim_id, dims_id, nspace_id, points_id;
	int ndim;
	xp_long ndim_w, *dims, copy_dims[16];
	float *points;
	int stat, nspace;
	int dims_type, points_type;
	xp_long points_len;
	char buf1[128];
	int i;
	xp_long omin_rng[16], omax_rng[16];

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD),
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD),
	nspace_id = OMfind_subobj(elem_id,OMstr_to_name("my_nspace"),OM_OBJ_RD),
	points_id = OMfind_subobj(elem_id,OMstr_to_name("my_points"),OM_OBJ_RD);

	if (OMis_null_obj(ndim_id) ||
	    OMis_null_obj(dims_id) ||
	    OMis_null_obj(nspace_id) ||
	    OMis_null_obj(points_id)) {
		ERRerror("FLDget_coords_cyl_unif",1,ERR_CHAIN,
			 "can't find required sub-element for element: %s",
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	dims_type = OM_TYPE_LONG;
	dims = NULL;
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1 ||
	    (stat = OMget_array_sz(dims_id,&dims_type,(char **)&dims,
			&ndim_w,OM_GET_ARRAY_RD)) != 1 ||
	    (stat = OMget_int_val(nspace_id,&nspace)) != 1) {
		if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_cyl_unif",1,ERR_CHAIN,
				 "can't get required data from sub-elements for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}

	ndim = (int)ndim_w;

	points_len = 2*nspace;
	points_type = OM_TYPE_FLOAT;
	points = NULL;
	if ((stat = OMget_array_sz(points_id,&points_type,(char **)&points,&points_len,
			OM_GET_ARRAY_RD)) != 1) {
                if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_cyl_unif",1,ERR_CHAIN,
				 "can't get points array for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}
	copy_dims[0] = nspace;
	memcpy(copy_dims+1,dims,ndim*sizeof(xp_long));
        if (dims != NULL) ARRfree(dims);


	if (req_ndim == ndim+1) {
		for (i = 0; i < req_ndim; i++) if (idims[i] != copy_dims[i]) break;
		if (i == req_ndim)  {
			stat = get_coords_cyl_unif(ndim+1, copy_dims, points,
					       imin_rng, imax_rng, array);
			if (points != NULL) ARRfree(points);
			return(stat);
		}
	}
	if (req_ndim == 2) { /** check the whole array  **/
		for (i = 0; i < req_ndim; i++)
			if (idims[i] != (imax_rng[i] - imin_rng[i]))
				break;
		if (i == req_ndim) {
			for (i = 0; i < ndim+1; i++) {
				omax_rng[i] = copy_dims[i];
				omin_rng[i] = 0;
			}
			stat = get_coords_cyl_unif(ndim+1, copy_dims, points,
					       omin_rng, omax_rng, array);
			if (points != NULL) ARRfree(points);
			return(stat);
		}
	}

	stat = OMcvt_sub_array(elem_id,req_ndim,idims,imin_rng,imax_rng,
			       ndim+1,copy_dims,
			       (char *)array,DTYPEtype_size[DTYPE_FLOAT],
			       (OMsub_array_func) FLDget_coords_cyl_unif);
	/* array was converted and dealt with in the cvt func */
	if (stat == -2) {
	   if (points != NULL) ARRfree(points);
	   return(1);
	}

	/* oops.. an error */
	if (stat == 1) {
	   stat = get_coords_cyl_unif(ndim+1, copy_dims, points,
				      imin_rng, imax_rng, array);
	}
	if (points != NULL) ARRfree(points);

	return(stat);
}

#ifdef WORDLENGTH_64
int FLDget_coords_cyl_unif_n(OMobj_id elem_id, int req_ndim, int *idims,
                           int *imin_rng, int *imax_rng, float *array)
{
	int i, status;
	xp_long idims_w[OM_ARRAY_MAXDIM], imin_rng_w[OM_ARRAY_MAXDIM], imax_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < req_ndim; i++)
	{
		idims_w[i] = (xp_long)idims[i];
		imin_rng_w[i] = (xp_long)imin_rng[i];
		imax_rng_w[i] = (xp_long)imax_rng[i];
	}

	status = FLDget_coords_cyl_unif(elem_id, req_ndim, idims_w, imin_rng_w, imax_rng_w, array);

	for( i = 0; i < req_ndim; i++)
		idims[i] = (int)idims_w[i];

	return status;
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int FLDget_coords_cyl_rect(OMobj_id elem_id, int req_ndim, xp_long *idims,
                           xp_long *imin_rng, xp_long *imax_rng, float *array)
{
	OMobj_id ndim_id, dims_id, nspace_id, points_id;
	int ndim;
	xp_long ndim_w, *dims;
	float *points;
	int stat, nspace;
	xp_long copy_dims[16];
	int dims_type, points_type;
	xp_long points_len;
	char buf1[128];
	int i;
	xp_long omin_rng[16], omax_rng[16];

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD),
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD),
	nspace_id = OMfind_subobj(elem_id,OMstr_to_name("my_nspace"),OM_OBJ_RD),
	points_id = OMfind_subobj(elem_id,OMstr_to_name("my_points"),OM_OBJ_RD);

	if (OMis_null_obj(ndim_id) ||
	    OMis_null_obj(dims_id) ||
	    OMis_null_obj(nspace_id) ||
	    OMis_null_obj(points_id)) {
		ERRerror("FLDget_coords_cyl_rect",1,ERR_CHAIN,
			 "can't find required sub-element for element: %s",
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	dims_type = OM_TYPE_LONG;
	dims = NULL;
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1 ||
	    (stat = OMget_array_sz(dims_id,&dims_type,(char **)&dims,
				   &ndim_w,OM_GET_ARRAY_RD)) != 1 ||
	    (stat = OMget_int_val(nspace_id,&nspace)) != 1) {
	        if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_cyl_rect",1,ERR_CHAIN,
				 "can't get required data from sub-elements for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}

	ndim = (int)ndim_w;

	points_len = 0;
	points_type = OM_TYPE_FLOAT;
	points = NULL;
	if ((stat = OMget_array_sz(points_id,&points_type,(char **)&points,&points_len,
			OM_GET_ARRAY_RD)) != 1) {
	        if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_cyl_rect",1,ERR_CHAIN,
				 "can't get points array for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}

	copy_dims[0] = nspace;
	memcpy(copy_dims+1,dims,ndim*sizeof(xp_long));
        if (dims != NULL) ARRfree(dims);

	if (req_ndim == ndim+1) {
		for (i = 0; i < req_ndim; i++) if (idims[i] != copy_dims[i]) break;
		if (i == req_ndim)  {
			stat = get_coords_cyl_rect(ndim+1, copy_dims, points,
					       imin_rng, imax_rng, array);
			return(stat);
		}
	}
	if (req_ndim == 2) { /** check the whole array  **/
		for (i = 0; i < req_ndim; i++)
			if (idims[i] != (imax_rng[i] - imin_rng[i]))
				break;
		if (i == req_ndim) {
			for (i = 0; i < ndim+1; i++) {
				omax_rng[i] = copy_dims[i];
				omin_rng[i] = 0;
			}
			stat = get_coords_cyl_rect(ndim+1, copy_dims, points,
					       omin_rng, omax_rng, array);
			return(stat);
		}
	}

	stat = OMcvt_sub_array(elem_id,req_ndim,idims,imin_rng,imax_rng,
			       ndim+1,copy_dims,
			       (char *)array,DTYPEtype_size[DTYPE_FLOAT],
			       (OMsub_array_func) FLDget_coords_cyl_rect);
	/* array was converted and dealt with in the cvt func */
	if (stat == -2) {
	   if (points != NULL) ARRfree(points);
	   return(1);
	}

	/* oops.. an error */
	if (stat == 1) {
	   stat = get_coords_cyl_rect(ndim+1, copy_dims, points,
				      imin_rng, imax_rng, array);
	}
	if (points != NULL) ARRfree(points);
	return(stat);
}

#ifdef WORDLENGTH_64
int FLDget_coords_cyl_rect_n(OMobj_id elem_id, int req_ndim, int *idims,
                           int *imin_rng, int *imax_rng, float *array)
{
	int i, status;
	xp_long idims_w[OM_ARRAY_MAXDIM], imin_rng_w[OM_ARRAY_MAXDIM], imax_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < req_ndim; i++)
	{
		idims_w[i] = (xp_long)idims[i];
		imin_rng_w[i] = (xp_long)imin_rng[i];
		imax_rng_w[i] = (xp_long)imax_rng[i];
	}

	status = FLDget_coords_cyl_rect(elem_id, req_ndim, idims_w, imin_rng_w, imax_rng_w, array);

	for( i = 0; i < req_ndim; i++)
		idims[i] = (int)idims_w[i];

	return status;
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int FLDget_coords_spher_unif(OMobj_id elem_id, int req_ndim, xp_long *idims,
                             xp_long *imin_rng, xp_long *imax_rng, float *array)
{
	OMobj_id ndim_id, dims_id, nspace_id, points_id;
	int ndim;
	xp_long ndim_w, *dims, copy_dims[16];
	float *points;
	int stat, nspace;
	int dims_type, points_type;
	xp_long points_len;
	char buf1[128];
	int i;
	xp_long omin_rng[16], omax_rng[16];

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD),
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD),
	nspace_id = OMfind_subobj(elem_id,OMstr_to_name("my_nspace"),OM_OBJ_RD),
	points_id = OMfind_subobj(elem_id,OMstr_to_name("my_points"),OM_OBJ_RD);

	if (OMis_null_obj(ndim_id) ||
	    OMis_null_obj(dims_id) ||
	    OMis_null_obj(nspace_id) ||
	    OMis_null_obj(points_id)) {
		ERRerror("FLDget_coords_spher_unif",1,ERR_CHAIN,
			 "can't find required sub-element for element: %s",
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	dims_type = OM_TYPE_LONG;
	dims = NULL;
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1 ||
	    (stat = OMget_array_sz(dims_id,&dims_type,(char **)&dims,
			&ndim_w,OM_GET_ARRAY_RD)) != 1 ||
	    (stat = OMget_int_val(nspace_id,&nspace)) != 1) {
		if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_spher_unif",1,ERR_CHAIN,
				 "can't get required data from sub-elements for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}
	ndim = (int)ndim_w;

	points_len = 2*nspace;
	points_type = OM_TYPE_FLOAT;
	points = NULL;
	if ((stat = OMget_array_sz(points_id,&points_type,(char **)&points,&points_len,
			OM_GET_ARRAY_RD)) != 1) {
                if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_spher_unif",1,ERR_CHAIN,
				 "can't get points array for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}
	copy_dims[0] = nspace;
	memcpy(copy_dims+1,dims,ndim*sizeof(xp_long));
        if (dims != NULL) ARRfree(dims);

	if (req_ndim == ndim+1) {
		for (i = 0; i < req_ndim; i++) if (idims[i] != copy_dims[i]) break;
		if (i == req_ndim)  {
			stat = get_coords_spher_unif(ndim+1, copy_dims, points,
					       imin_rng, imax_rng, array);
			if (points != NULL) ARRfree(points);
			return(stat);
		}
	}
	if (req_ndim == 2) { /** check the whole array  **/
		for (i = 0; i < req_ndim; i++)
			if (idims[i] != (imax_rng[i] - imin_rng[i]))
				break;
		if (i == req_ndim) {
			for (i = 0; i < ndim+1; i++) {
				omax_rng[i] = copy_dims[i];
				omin_rng[i] = 0;
			}
			stat = get_coords_spher_unif(ndim+1, copy_dims, points,
					       omin_rng, omax_rng, array);
			if (points != NULL) ARRfree(points);
			return(stat);
		}
	}


	stat = OMcvt_sub_array(elem_id,req_ndim,idims,imin_rng,imax_rng,
			       ndim+1,copy_dims,
			       (char *)array,DTYPEtype_size[DTYPE_FLOAT],
			       (OMsub_array_func) FLDget_coords_spher_unif);
	/* array was converted and dealt with in the cvt func */
	if (stat == -2) {
	   if (points != NULL) ARRfree(points);
	   return(1);
	}

	/* oops.. an error */
	if (stat == 1) {
	   stat = get_coords_spher_unif(ndim+1, copy_dims, points,
				      imin_rng, imax_rng, array);
	}
	if (points != NULL) ARRfree(points);

	return(stat);
}

#ifdef WORDLENGTH_64
int FLDget_coords_spher_unif_n(OMobj_id elem_id, int req_ndim, int *idims,
                             int *imin_rng, int *imax_rng, float *array)
{
	int i, status;
	xp_long idims_w[OM_ARRAY_MAXDIM], imin_rng_w[OM_ARRAY_MAXDIM], imax_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < req_ndim; i++)
	{
		idims_w[i] = (xp_long)idims[i];
		imin_rng_w[i] = (xp_long)imin_rng[i];
		imax_rng_w[i] = (xp_long)imax_rng[i];
	}

	status = FLDget_coords_spher_unif(elem_id, req_ndim, idims_w, imin_rng_w, imax_rng_w, array);

	for( i = 0; i < req_ndim; i++)
		idims[i] = (int)idims_w[i];

	return status;
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int FLDget_coords_spher_rect(OMobj_id elem_id, int req_ndim, xp_long *idims,
                             xp_long *imin_rng, xp_long *imax_rng, float *array)
{
	OMobj_id ndim_id, dims_id, nspace_id, points_id;
	int ndim;
	xp_long ndim_w, *dims;
	float *points;
	int stat, nspace;
	xp_long copy_dims[16];
	int dims_type, points_type;
	xp_long points_len;
	char buf1[128];
	int i;
	xp_long omin_rng[16], omax_rng[16];

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD),
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD),
	nspace_id = OMfind_subobj(elem_id,OMstr_to_name("my_nspace"),OM_OBJ_RD),
	points_id = OMfind_subobj(elem_id,OMstr_to_name("my_points"),OM_OBJ_RD);

	if (OMis_null_obj(ndim_id) ||
	    OMis_null_obj(dims_id) ||
	    OMis_null_obj(nspace_id) ||
	    OMis_null_obj(points_id)) {
		ERRerror("FLDget_coords_spher_rect",1,ERR_CHAIN,
			 "can't find required sub-element for element: %s",
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	dims_type = OM_TYPE_LONG;
	dims = NULL;
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1 ||
	    (stat = OMget_array_sz(dims_id,&dims_type,(char **)&dims,
				   &ndim_w,OM_GET_ARRAY_RD)) != 1 ||
	    (stat = OMget_int_val(nspace_id,&nspace)) != 1) {
	        if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_spher_rect",1,ERR_CHAIN,
				 "can't get required data from sub-elements for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}
	ndim = (int)ndim_w;

	points_len = 0;
	points_type = OM_TYPE_FLOAT;
	points = NULL;
	if ((stat = OMget_array_sz(points_id,&points_type,(char **)&points,&points_len,
			OM_GET_ARRAY_RD)) != 1) {
	        if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_coords_spher_rect",1,ERR_CHAIN,
				 "can't get points array for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}

	copy_dims[0] = nspace;
	memcpy(copy_dims+1,dims,ndim*sizeof(xp_long));
        if (dims != NULL) ARRfree(dims);

	if (req_ndim == ndim+1) {
		for (i = 0; i < req_ndim; i++) if (idims[i] != copy_dims[i]) break;
		if (i == req_ndim)  {
			stat = get_coords_spher_rect(ndim+1, copy_dims, points,
					       imin_rng, imax_rng, array);
			return(stat);
		}
	}
	if (req_ndim == 2) { /** check the whole array  **/
		for (i = 0; i < req_ndim; i++)
			if (idims[i] != (imax_rng[i] - imin_rng[i]))
				break;
		if (i == req_ndim) {
			for (i = 0; i < ndim+1; i++) {
				omax_rng[i] = copy_dims[i];
				omin_rng[i] = 0;
			}
			stat = get_coords_spher_rect(ndim+1, copy_dims, points,
					       omin_rng, omax_rng, array);
			return(stat);
		}
	}


	stat = OMcvt_sub_array(elem_id,req_ndim,idims,imin_rng,imax_rng,
			       ndim+1,copy_dims,
			       (char *)array,DTYPEtype_size[DTYPE_FLOAT],
			       (OMsub_array_func) FLDget_coords_spher_rect);
	/* array was converted and dealt with in the cvt func */
	if (stat == -2) {
	   if (points != NULL) ARRfree(points);
	   return(1);
	}

	/* oops.. an error */
	if (stat == 1) {
	   stat = get_coords_spher_rect(ndim+1, copy_dims, points,
				      imin_rng, imax_rng, array);
	}
	if (points != NULL) ARRfree(points);
	return(stat);
}

#ifdef WORDLENGTH_64
int FLDget_coords_spher_rect_n(OMobj_id elem_id, int req_ndim, int *idims,
                             int *imin_rng, int *imax_rng, float *array)
{
	int i, status;
	xp_long idims_w[OM_ARRAY_MAXDIM], imin_rng_w[OM_ARRAY_MAXDIM], imax_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < req_ndim; i++)
	{
		idims_w[i] = (xp_long)idims[i];
		imin_rng_w[i] = (xp_long)imin_rng[i];
		imax_rng_w[i] = (xp_long)imax_rng[i];
	}

	status = FLDget_coords_spher_rect(elem_id, req_ndim, idims_w, imin_rng_w, imax_rng_w, array);

	for( i = 0; i < req_ndim; i++)
		idims[i] = (int)idims_w[i];

	return status;
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int
FLDget_connect_dims(OMobj_id elem_id, int *req_ndim, xp_long *req_dims)
{
	OMobj_id ndim_id, dims_id;
	int stat, i, ndim;
	xp_long lval;

	*req_ndim = 1;
	if (req_dims == NULL) return(1);

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD);
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD);

	/*
	* The number of entries in the connectivity list is the number of
	* nodes/cell times the number of cells (i.e. 2^ndim * prod(dims-1))
	*/
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1) return(stat);
	req_dims[0] = (xp_long) pow( 2.0, (double)ndim );
	for (i = 0; i < ndim; i++) {
		if ((stat = OMget_larray_val(dims_id,i,&lval)) != 1) return(stat);
		req_dims[0] *= lval - 1;
	}
	return(1);
}

#ifdef WORDLENGTH_64
int
FLDget_connect_dims_n(OMobj_id elem_id, int *req_ndim, int *req_dims)
{
	int status;

	if(!req_dims)
		status = FLDget_connect_dims(elem_id, req_ndim, NULL);
	else
	{
		int i;
		xp_long req_dims_w[OM_ARRAY_MAXDIM];

		status = FLDget_connect_dims(elem_id, req_ndim, req_dims_w);

		for( i = 0; i < *req_ndim; i++)
			req_dims[i] = (int)req_dims_w[i];
	}

	return status;
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int FLDget_connect_struct(OMobj_id elem_id, int req_ndim, xp_long *idims,
                          xp_long *imin_rng, xp_long *imax_rng, xp_long *array)
{
	OMobj_id ndim_id, dims_id;
	int stat, ndim;
	xp_long ndim_w, *dims;
	int dims_type;
	char buf1[128];
	xp_long min_rng, max_rng;
	int cell_nnodes;
	double op, expon;

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD);
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD);

	if (OMis_null_obj(ndim_id) || OMis_null_obj(dims_id)) {
		ERRerror("FLDget_connect_struct", 1, ERR_CHAIN,
			 "can't find required sub-element for element: %s",
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	dims_type = OM_TYPE_LONG;
	dims = NULL;
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1 ||  ndim != 0 &&
	    (stat = OMget_array_sz(dims_id,&dims_type,(char **)&dims,
				   &ndim_w,OM_GET_ARRAY_RD)) != 1) {
	        if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_connect_struct", 1, ERR_CHAIN,
				 "can't get required data from sub-elements for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}
        ndim =(int)ndim_w;

	if (req_ndim != 1) {
		ERRerror("FLDget_connect_struct", 2, ERR_ORIG,
			 "bad input dimension: %d for element: %s",req_ndim,
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}
	op = 2.0;
	expon = (double)ndim;
	cell_nnodes = (int) pow(op, expon);
	min_rng = imin_rng[0] / cell_nnodes;
	max_rng = imax_rng[0] / cell_nnodes;
	if ((imin_rng[0] % cell_nnodes) != 0 ||
	    (imax_rng[0] % cell_nnodes) != 0) {
		ERRerror("FLDget_connect_struct", 4, ERR_ORIG,
			 "requested subscripts (%ld:%ld) must be modulo %d, for element: %s",
			 imin_rng[0], imax_rng[0], cell_nnodes,
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	stat = get_connect_struct(ndim, dims, min_rng, max_rng, array);
	if (dims != NULL) ARRfree(dims);
	return(stat);
}

/* Code duplication is done since 'array' is very large */
#ifdef WORDLENGTH_64
int FLDget_connect_struct_n(OMobj_id elem_id, int req_ndim, int *idims,
                          int *imin_rng, int *imax_rng, int *array)
{
	OMobj_id ndim_id, dims_id;
	int stat, ndim, *dims;
	int dims_type;
	char buf1[128];
	int min_rng, max_rng, cell_nnodes;
	double op, expon;

	ndim_id = OMfind_subobj(elem_id,OMstr_to_name("my_ndim"),OM_OBJ_RD);
	dims_id = OMfind_subobj(elem_id,OMstr_to_name("my_dims"),OM_OBJ_RD);

	if (OMis_null_obj(ndim_id) || OMis_null_obj(dims_id)) {
		ERRerror("FLDget_connect_struct_n", 1, ERR_CHAIN,
			 "can't find required sub-element for element: %s",
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	dims_type = OM_TYPE_LONG;
	dims = NULL;
	if ((stat = OMget_int_val(ndim_id,&ndim)) != 1 ||  ndim != 0 &&
	    (stat = OMget_array_sz_n(dims_id,&dims_type,(char **)&dims,
				   &ndim,OM_GET_ARRAY_RD)) != 1) {
	        if (dims != NULL) ARRfree(dims);
		if (stat < 0) {
			ERRerror("FLDget_connect_struct_n", 1, ERR_CHAIN,
				 "can't get required data from sub-elements for element: %s",
				 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		}
		return(stat);
	}

	if (req_ndim != 1) {
		ERRerror("FLDget_connect_struct_n", 2, ERR_ORIG,
			 "bad input dimension: %d for element: %s",req_ndim,
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}
	op = 2.0;
	expon = (double)ndim;
	cell_nnodes = (int) pow(op, expon);
	min_rng = imin_rng[0] / cell_nnodes;
	max_rng = imax_rng[0] / cell_nnodes;
	if ((imin_rng[0] % cell_nnodes) != 0 ||
	    (imax_rng[0] % cell_nnodes) != 0) {
		ERRerror("FLDget_connect_struct_n", 4, ERR_ORIG,
			 "requested subscripts (%d:%d) must be modulo %d, for element: %s",
			 imin_rng[0], imax_rng[0], cell_nnodes,
			 OMret_obj_path(elem_id,buf1,sizeof(buf1)));
		return(-1);
	}

	stat = get_connect_struct_n(ndim, dims, min_rng, max_rng, array);
	if (dims != NULL) ARRfree(dims);
	return(stat);

}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int  get_coords_unif(int ndim, xp_long *dims, float *points,
                     xp_long *min_rng, xp_long *max_rng, float *array)
{
	float *x, *y, f, factor[3], r[3];
	xp_long i, j, k, n, l, m, ijk[3], nspace, count;

	factor[0] = factor[1] = factor[2] = 0.0;
	for (n = min_rng[0]; n < max_rng[0]; n++) {
		if (n >= ndim-1)
			factor[n] = 0;
		else if (dims[n+1] != 1)
			factor[n] = (points[n+dims[0]] - points[n])/
				(dims[n+1] - 1);
		else
			factor[n] = 0;
	}
	nspace = max_rng[0]-min_rng[0];
	ijk[0] = ijk[1] = ijk[2] = 0;
	r[0]=r[1]=r[2]=0.0;

	switch(ndim) {
	      case 2:
		for (n=min_rng[0]; n<max_rng[0]; n++) {
			f = points[n]+min_rng[1]*factor[n];
			for (count=0, i=min_rng[1]; i<max_rng[1]; i++) {
				array[count+n] = f;
				count +=nspace;
				f += factor[n];
			}
		}
		break;

	      case 3:
		if (max_rng[1] == min_rng[1])
			return(0);
		if (max_rng[2] == min_rng[2])
			return(0);
		x = (float *)malloc((max_rng[1]-min_rng[1])*sizeof(float));
		x[0] = points[0]+min_rng[1]*factor[0];
		for (count=1,i=min_rng[1]+1; i<max_rng[1]; i++) {
			x[count] = x[count-1]+factor[0];
			count++;
		}
		r[2] = points[2];
		r[1] = points[1]+min_rng[2]*factor[1];
		for (count=0, j=min_rng[2]; j<max_rng[2]; j++) {
			for (m=0,i=min_rng[1]; i<max_rng[1]; i++) {
				r[0] = x[m++];
				for (n=min_rng[0]; n<max_rng[0]; n++) {
					array[count++] = r[n];
				}
			}
			r[1] += factor[1];
		}
		free(x);
		break;

	      case 4:
		if (max_rng[1] == min_rng[1])
			return(0);
		if (max_rng[2] == min_rng[2])
			return(0);
		x = (float *)malloc((max_rng[1]-min_rng[1])*sizeof(float));
		y = (float *)malloc((max_rng[2]-min_rng[2])*sizeof(float));
		x[0] = points[0]+min_rng[1]*factor[0];
		y[0] = points[1]+min_rng[2]*factor[1];;
		for (count=1,i=min_rng[1]+1; i<max_rng[1]; i++) {
			x[count] = x[count-1]+factor[0];
			count++;
		}
		for (count=1,i=min_rng[2]+1; i<max_rng[2]; i++) {
			y[count] = y[count-1]+factor[1];
			count++;
		}
		r[2] = points[2]+min_rng[3]*factor[2];
		for (count=0, k=min_rng[3]; k<max_rng[3]; k++) {
			for (l=0,j=min_rng[2]; j<max_rng[2]; j++) {
				r[1] = y[l++];
				for (m=0,i=min_rng[1]; i<max_rng[1]; i++) {
					r[0] = x[m++];
					for (n=min_rng[0]; n<max_rng[0]; n++) {
						array[count++] = r[n];
					}
				}
			}
			r[2] += factor[2];
		}
		free(x);
		free(y);
		break;

	      default:
		return(0);
	}
	return(1);
}

#ifdef WORDLENGTH_64
int  get_coords_unif_n(int ndim, int *dims, float *points,
                     int *min_rng, int *max_rng, float *array)
{
	int i;
	xp_long dims_w[OM_ARRAY_MAXDIM], min_rng_w[OM_ARRAY_MAXDIM], max_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < ndim; i++)
	{
		dims_w[i] = (xp_long)dims[i];
		min_rng_w[i] = (xp_long)min_rng[i];
		max_rng_w[i] = (xp_long)max_rng[i];
	}

	return get_coords_unif(ndim, dims_w, points, min_rng_w, max_rng_w, array);
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int  get_coords_rect(int ndim, xp_long *dims, float *points,
                     xp_long *min_rng, xp_long *max_rng, float *array)
{
	xp_long i, j, k, n, ijk[3], mdim, nspace, count, ind[3], pind[3];

	for (count = 0, i = 1; i < ndim; i++) {
		pind[i-1] = count;
		count += dims[i]*dims[0];
	}


	nspace = max_rng[0]-min_rng[0];
	ijk[0] = ijk[1] = ijk[2] = 0;
	if (max_rng[0] < ndim-1)
		mdim = max_rng[0];
	else
		mdim = ndim-1;
	switch(ndim) {
	      case 2:
		for (count=0, i=min_rng[1]; i<max_rng[1]; i++) {
			for (n=min_rng[0]; n<mdim; n++) {
				array[count++] = points[pind[n]+i*dims[0]+n];
			}
			for (; n<max_rng[0]; n++) {
				array[count++] = points[n];
			}
		}
		break;

	      case 3:
		for (count=0, j=min_rng[2]; j<max_rng[2]; j++) {
			ind[1] = pind[1]+j*dims[0];
			ind[0] = min_rng[1]*dims[0];
			for (i=min_rng[1]; i<max_rng[1]; i++) {
				for (n=min_rng[0]; n<mdim; n++) {
					array[count++] = points[ind[n]+n];
				}
				for (; n<max_rng[0]; n++) {
					array[count++] = points[n];
				}
				ind[0] = ind[0]+dims[0];
			}
		}
		break;

	      case 4:
		for (count=0, k=min_rng[3]; k<max_rng[3]; k++) {
			ind[2] = pind[2]+k*dims[0];
			ind[1] = pind[1]+min_rng[2]*dims[0];
			for (j=min_rng[2]; j<max_rng[2]; j++) {
				ind[0] = min_rng[1]*dims[0];
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					for (n=min_rng[0]; n<mdim; n++) {
						array[count++] = points[ind[n]+n];
					}
					for (; n<max_rng[0]; n++) {
						array[count++] = points[n];
					}
					ind[0] = ind[0]+dims[0];
				}
				ind[1] = ind[1]+dims[0];
			}
		}
		break;

	      default:
		return(0);
	}
	return(1);
}

#ifdef WORDLENGTH_64
int  get_coords_rect_n(int ndim, int *dims, float *points,
                     int *min_rng, int *max_rng, float *array)
{
	int i;
	xp_long dims_w[OM_ARRAY_MAXDIM], min_rng_w[OM_ARRAY_MAXDIM], max_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < ndim; i++)
	{
		dims_w[i] = (xp_long)dims[i];
		min_rng_w[i] = (xp_long)min_rng[i];
		max_rng_w[i] = (xp_long)max_rng[i];
	}

	return get_coords_rect(ndim, dims_w, points, min_rng_w, max_rng_w, array);
}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int  get_coords_cyl_unif(int ndim, xp_long *dims, float *points,
                         xp_long *min_rng, xp_long *max_rng, float *array)
{
	float f, r, t, factor[3], *rad, *ang;
	xp_long i, j, k, n, n0, ijk[3], nspace, dimxy, count;

	for (n = min_rng[0]; n < max_rng[0]; n++) {
		if (n >= ndim-1)
			factor[n] = 0;
		else if (dims[n+1] != 1)
			factor[n] = (points[n+dims[0]] - points[n])/
				(dims[n+1] - 1);
		else
			factor[n] = 0;
	}
	nspace = max_rng[0]-min_rng[0];
	ijk[0] = ijk[1] = ijk[2] = 0;

	switch(ndim) {
	      case 2:
		for (n=min_rng[0]; n<max_rng[0]; n++) {
			for (count=0, f=0.0, i=min_rng[1]; i<max_rng[1]; i++) {
				array[count+n] = points[n]+f;
				count +=nspace;
				f += factor[n];
			}
		}
		break;

	      case 3:
		if (max_rng[1] == min_rng[1])
			return(0);
		if (max_rng[2] == min_rng[2])
			return(0);
		rad = (float *)malloc((max_rng[1]-min_rng[1])*sizeof(float));
		ang = (float *)malloc((max_rng[2]-min_rng[2])*sizeof(float));
		rad[0] = points[0] + min_rng[1]*factor[0];
		for (count=1,i=min_rng[1]+1; i<max_rng[1]; i++) {
			rad[count] = rad[count-1]+factor[0];
			count++;
		}
		ang[0] = points[1] + min_rng[2]*factor[1];
		for (count=1,i=min_rng[2]+1; i<max_rng[2]; i++) {
			ang[count] = ang[count-1]+factor[1];
			count++;
		}
		if (min_rng[0] == 0 && max_rng[0] > 0) {
			for (count=0, j=min_rng[2]; j<max_rng[2]; j++) {
				t = cos((double)ang[j-min_rng[2]]);
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					array[count] = t*rad[i-min_rng[1]];
					count += nspace;
				}
			}
		}
		if (min_rng[0] <= 1 && max_rng[0] > 1) {
			for (count=1, j=min_rng[2]; j<max_rng[2]; j++) {
				t = sin((double)ang[j-min_rng[2]]);
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					array[count] = t*rad[i-min_rng[1]];
					count += nspace;
				}
			}
		}
		if (min_rng[0] <= 2 && max_rng[0] > 2) {
			for (count=2, j=min_rng[2]; j<max_rng[2]; j++) {
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					array[count] = points[2];
					count += nspace;
				}
			}
		}
		free(rad);
		free(ang);
		break;

	      case 4:
		dimxy = nspace*(max_rng[2]- min_rng[2])*(max_rng[1] - min_rng[1]);
		if (max_rng[1] == min_rng[1])
			return(0);
		if (max_rng[2] == min_rng[2])
			return(0);
		rad = (float *)malloc((max_rng[1]-min_rng[1])*sizeof(float));
		ang = (float *)malloc((max_rng[2]-min_rng[2])*sizeof(float));
		rad[0] = points[0] + min_rng[1]*factor[0];
		for (count=1,i=min_rng[1]+1; i<max_rng[1]; i++) {
			rad[count] = rad[count-1]+factor[0];
			count++;
		}
		ang[0] = points[1] + min_rng[2]*factor[1];
		for (count=1,i=min_rng[2]+1; i<max_rng[2]; i++) {
			ang[count] = ang[count-1]+factor[1];
			count++;
		}
		if (min_rng[0] == 0 && max_rng[0] > 0) {
			for (n0=0, j=min_rng[2]; j<max_rng[2]; j++) {
				t = cos((double)ang[j-min_rng[2]]);
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					r = t*rad[i-min_rng[1]];
					for (count=n0,k=min_rng[3]; k<max_rng[3]; k++) {
						array[count] = r;
						count += dimxy;
					}
					n0 += nspace;
				}
			}
		}
		if (min_rng[0] <= 1 && max_rng[0] > 1) {
			for (n0=1, j=min_rng[2]; j<max_rng[2]; j++) {
				t = sin((double)ang[j-min_rng[2]]);
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					r = t*rad[i-min_rng[1]];
					for (count=n0,k=min_rng[3]; k<max_rng[3]; k++) {
						array[count] = r;
						count += dimxy;
					}
					n0 += nspace;
				}
			}
		}
		if (min_rng[0] <= 2 && max_rng[0] > 2) {
			for (count=2, k=min_rng[3]; k<max_rng[3]; k++) {
				r = points[2]+k*factor[2];
				for (j=min_rng[2]; j<max_rng[2]; j++) {
					for (i=min_rng[1]; i<max_rng[1]; i++) {
						array[count] = r;
						count += nspace;
					}
				}
			}
		}
		free(rad);
		free(ang);
		break;

	      default:
		return(0);
	}
	return(1);
}

#ifdef WORDLENGTH_64
int  get_coords_cyl_unif_n(int ndim, int *dims, float *points,
                         int *min_rng, int *max_rng, float *array)
{
	int i;
	xp_long dims_w[OM_ARRAY_MAXDIM], min_rng_w[OM_ARRAY_MAXDIM], max_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < ndim; i++)
	{
		dims_w[i] = (xp_long)dims[i];
		min_rng_w[i] = (xp_long)min_rng[i];
		max_rng_w[i] = (xp_long)max_rng[i];
	}

	return get_coords_cyl_unif(ndim, dims_w, points, min_rng_w, max_rng_w, array);

}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int  get_coords_cyl_rect(int ndim, xp_long *dims, float *points,
                         xp_long *min_rng, xp_long *max_rng, float *array)
{
	xp_long i, j, k, n, n0, l, ijk[3], mdim, dimxy, nspace, count, pind[3];
	float t, f;

	for (count = 0, i = 1; i < ndim; i++) {
		pind[i-1] = count;
		count += dims[i]*dims[0];
	}


	nspace = max_rng[0]-min_rng[0];
	ijk[0] = ijk[1] = ijk[2] = 0;
	if (max_rng[0] < ndim-1)
		mdim = max_rng[0];
	else
		mdim = ndim-1;
	switch(ndim) {
	      case 2:
		for (count=0, i=min_rng[1]; i<max_rng[1]; i++) {
			for (n=min_rng[0]; n<mdim; n++) {
				array[count++] = points[pind[n]+i*dims[0]+n];
			}
			for (; n<max_rng[0]; n++) {
				array[count++] = points[n];
			}
		}
		break;

	      case 3:
		if (min_rng[0] == 0 && max_rng[0] > 0) {
			for (count=0, j=min_rng[2]; j<max_rng[2]; j++) {
				t = cos((double)points[pind[1]+j*dims[0]+1]);
				l = min_rng[1]*dims[0];
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					array[count] = points[l]*t;
					count += nspace;
					l += dims[0];
				}
			}
		}
		if (min_rng[0] <= 1 && max_rng[0] > 1) {
			for (count=1, j=min_rng[2]; j<max_rng[2]; j++) {
				t = sin((double)points[pind[1]+j*dims[0]+1]);
				l = min_rng[1]*dims[0];
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					array[count] = points[l]*t;
					count += nspace;
					l += dims[0];
				}
			}
		}
		if (min_rng[0] <= 2 && max_rng[0] > 2) {
			for (count=2, j=min_rng[2]; j<max_rng[2]; j++) {
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					array[count] = points[2];
					count += nspace;
				}
			}
		}
		break;

	      case 4:
		dimxy = nspace*(max_rng[2]- min_rng[2])*(max_rng[1] - min_rng[1]);
		if (min_rng[0] == 0 && max_rng[0] > 0) {
			for (n0=0,j=min_rng[2]; j<max_rng[2]; j++) {
				t = cos((double)points[pind[1]+j*dims[0]+1]);
				l = min_rng[1]*dims[0];
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					f = points[l]*t;
					for (count=n0,k=min_rng[3]; k<max_rng[3]; k++) {
						array[count] = f;
						count += dimxy;
					}
					n0 += nspace;
					l += dims[0];
				}
			}
		}
		if (min_rng[0] <= 1 && max_rng[0] > 1) {
			for (n0=1,j=min_rng[2]; j<max_rng[2]; j++) {
				t = sin((double)points[pind[1]+j*dims[0]+1]);
				l = min_rng[1]*dims[0];
				for (i=min_rng[1]; i<max_rng[1]; i++) {
					f = points[l]*t;
					for (count=n0,k=min_rng[3]; k<max_rng[3]; k++) {
						array[count] = f;
						count += dimxy;
					}
					n0 += nspace;
					l += dims[0];
				}
			}
		}
		if (min_rng[0] <= 2 && max_rng[0] > 2) {
			for (count=2,k=min_rng[3]; k<max_rng[3]; k++) {
				l = pind[2]+k*dims[0]+2;
				for (j=min_rng[2]; j<max_rng[2]; j++) {
					for (i=min_rng[1]; i<max_rng[1]; i++) {
						array[count] = points[l];
						count += nspace;
					}
				}
			}
		}
		break;

	      default:
		return(0);
	}
	return(1);
}

#ifdef WORDLENGTH_64
int  get_coords_cyl_rect_n(int ndim, int *dims, float *points,
                         int *min_rng, int *max_rng, float *array)
{
	int i;
	xp_long dims_w[OM_ARRAY_MAXDIM], min_rng_w[OM_ARRAY_MAXDIM], max_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < ndim; i++)
	{
		dims_w[i] = (xp_long)dims[i];
		min_rng_w[i] = (xp_long)min_rng[i];
		max_rng_w[i] = (xp_long)max_rng[i];
	}

	return get_coords_cyl_rect(ndim, dims_w, points, min_rng_w, max_rng_w, array);

}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int  get_coords_spher_unif(int ndim, xp_long *dims, float *points,
                           xp_long *min_rng, xp_long *max_rng, float *array)
{
	float f, r, t, factor[3], *rad, *s1,*s2,*c1,*c2;
	xp_long i, j, k, n, ijk[3], nspace, count;

	for (n = min_rng[0]; n < max_rng[0]; n++) {
		if (n >= ndim-1)
			factor[n] = 0;
		else if (dims[n+1] != 1)
			factor[n] = (points[n+dims[0]] - points[n])/
				(dims[n+1] - 1);
		else
			factor[n] = 0;
	}
	nspace = max_rng[0]-min_rng[0];
	ijk[0] = ijk[1] = ijk[2] = 0;

	switch(ndim) {
	      case 2:
		for (n=min_rng[0]; n<max_rng[0]; n++) {
			for (count=0, f=0.0, i=min_rng[1]; i<max_rng[1]; i++) {
				array[count+n] = points[n]+f;
				count +=nspace;
				f += factor[n];
			}
		}
		break;

	      case 3:
		return(get_coords_cyl_unif(ndim, dims, points, min_rng, max_rng, array));

	      case 4:
		if (max_rng[1] == min_rng[1])
			return(0);
		if (max_rng[2] == min_rng[2])
			return(0);
		if (max_rng[3] == min_rng[3])
			return(0);
		rad = (float *)malloc((max_rng[1]-min_rng[1])*sizeof(float));
		s1 = (float *)malloc((max_rng[2]-min_rng[2])*sizeof(float));
		c1 = (float *)malloc((max_rng[2]-min_rng[2])*sizeof(float));
		s2 = (float *)malloc((max_rng[3]-min_rng[3])*sizeof(float));
		c2 = (float *)malloc((max_rng[3]-min_rng[3])*sizeof(float));
		rad[0] = points[0] + min_rng[1]*factor[0];
		for (count=1,i=min_rng[1]+1; i<max_rng[1]; i++) {
			rad[count] = rad[count-1]+factor[0];
			count++;
		}
		for (count=0,i=min_rng[2]; i<max_rng[2]; i++) {
			t = points[1] + i*factor[1];
			s1[count] = sin((double)t);
			c1[count] = cos((double)t);
			count++;
		}
		for (count=0,i=min_rng[3]; i<max_rng[3]; i++) {
			t = points[2] + i*factor[2];
			s2[count] = sin((double)t);
			c2[count] = cos((double)t);
			count++;
		}
		if (min_rng[0] == 0 && max_rng[0] > 0) {
			for (count=0, k=min_rng[3]; k<max_rng[3]; k++) {
				t = c2[k-min_rng[3]];
				for (j=min_rng[2]; j<max_rng[2]; j++) {
					r = t*s1[j-min_rng[2]];
					for (i=min_rng[1]; i<max_rng[1]; i++) {
						array[count] = r*rad[i-min_rng[1]];
						count += nspace;
					}
				}
			}
		}
		if (min_rng[0] <= 1 && max_rng[0] > 1) {
			for (count=1, k=min_rng[3]; k<max_rng[3]; k++) {
				t = s2[k-min_rng[3]];
				for (j=min_rng[2]; j<max_rng[2]; j++) {
					r = t*s1[j-min_rng[2]];
					for (i=min_rng[1]; i<max_rng[1]; i++) {
						array[count] = r*rad[i-min_rng[1]];
						count += nspace;
					}
				}
			}
		}
		if (min_rng[0] <= 2 && max_rng[0] > 2) {
			for (count=2, k=min_rng[3]; k<max_rng[3]; k++) {
				for (j=min_rng[2]; j<max_rng[2]; j++) {
					r = c1[j-min_rng[2]];
					for (i=min_rng[1]; i<max_rng[1]; i++) {
						array[count] = r*rad[i-min_rng[1]];
						count += nspace;
					}
				}
			}
		}
		free(rad);
		free(s1);
		free(s2);
		free(c1);
		free(c2);
		break;

	      default:
		return(0);
	}
	return(1);
}

#ifdef WORDLENGTH_64
int  get_coords_spher_unif_n(int ndim, int *dims, float *points,
                           int *min_rng, int *max_rng, float *array)
{
	int i;
	xp_long dims_w[OM_ARRAY_MAXDIM], min_rng_w[OM_ARRAY_MAXDIM], max_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < ndim; i++)
	{
		dims_w[i] = (xp_long)dims[i];
		min_rng_w[i] = (xp_long)min_rng[i];
		max_rng_w[i] = (xp_long)max_rng[i];
	}

	return get_coords_spher_unif(ndim, dims_w, points, min_rng_w, max_rng_w, array);

}
#endif

/* 64-bit porting. Modified with Parallel  APIs */
int  get_coords_spher_rect(int ndim, xp_long *dims, float *points,
                           xp_long *min_rng, xp_long *max_rng, float *array)
{
	xp_long i, j, k, n, ijk[3], mdim, nspace, count, pind[3];
	float t, r;

	for (count = 0, i = 1; i < ndim; i++) {
		pind[i-1] = count;
		count += dims[i]*dims[0];
	}


	nspace = max_rng[0]-min_rng[0];
	ijk[0] = ijk[1] = ijk[2] = 0;
	if (max_rng[0] < ndim-1)
		mdim = max_rng[0];
	else
		mdim = ndim-1;
	switch(ndim) {
	      case 2:
		for (count=0, i=min_rng[1]; i<max_rng[1]; i++) {
			for (n=min_rng[0]; n<mdim; n++) {
				array[count++] = points[pind[n]+i*dims[0]+n];
			}
			for (; n<max_rng[0]; n++) {
				array[count++] = points[n];
			}
		}
		break;

	      case 3:
		return(get_coords_cyl_rect(ndim, dims, points, min_rng, max_rng, array));

	      case 4:
		if (min_rng[0] == 0 && max_rng[0] > 0) {
			for (count=0,k=min_rng[3]; k<max_rng[3]; k++) {
				t = cos((double)points[pind[2]+k*dims[0]+2]);
				for (j=min_rng[2]; j<max_rng[2]; j++) {
					r = t*sin((double)points[pind[1]+j*dims[0]+1]);
					for (i=min_rng[1]; i<max_rng[1]; i++) {
						array[count] = r*points[i*dims[0]];
						count += nspace;
					}
				}
			}
		}
		if (min_rng[0] <= 1 && max_rng[0] > 1) {
			for (count=1,k=min_rng[3]; k<max_rng[3]; k++) {
				t = sin((double)points[pind[2]+k*dims[0]+2]);
				for (j=min_rng[2]; j<max_rng[2]; j++) {
					r = t*sin((double)points[pind[1]+j*dims[0]+1]);
					for (i=min_rng[1]; i<max_rng[1]; i++) {
						array[count] = r*points[i*dims[0]];
						count += nspace;
					}
				}
			}
		}
		if (min_rng[0] <= 2 && max_rng[0] > 2) {
			for (count=2,k=min_rng[3]; k<max_rng[3]; k++) {
				for (j=min_rng[2]; j<max_rng[2]; j++) {
					r = cos((double)points[pind[1]+j*dims[0]+1]);
					for (i=min_rng[1]; i<max_rng[1]; i++) {
						array[count] = r*points[i*dims[0]];
						count += nspace;
					}
				}
			}
		}
		break;

	      default:
		return(0);
	}
	return(1);
}

#ifdef WORDLENGTH_64
int  get_coords_spher_rect_n(int ndim, int *dims, float *points,
                           int *min_rng, int *max_rng, float *array)
{
	int i;
	xp_long dims_w[OM_ARRAY_MAXDIM], min_rng_w[OM_ARRAY_MAXDIM], max_rng_w[OM_ARRAY_MAXDIM];

	for( i = 0; i < ndim; i++)
	{
		dims_w[i] = (xp_long)dims[i];
		min_rng_w[i] = (xp_long)min_rng[i];
		max_rng_w[i] = (xp_long)max_rng[i];
	}

	return get_coords_spher_rect(ndim, dims_w, points, min_rng_w, max_rng_w, array);

}
#endif

/*64-bit porting. Modified with Parallel APIs */
int get_connect_struct(int ndim, xp_long *dims, xp_long min_cell, xp_long max_cell,
                       xp_long *array)
{
	xp_long i, j, n, i1, i2, i3, pdim;

	switch (ndim) {
	      case 0:
	        n = 1;
		for (j=0,i=min_cell; i<max_cell; i++) {
			array[j] = i;
			j+=n;
		}
		break;

	      case 1:
		n = 2;
		for (j=0,i=min_cell; i<max_cell; i++) {
			array[j] = i;
			array[j+1] = i+1;
			j+=n;
		}
		break;
	      case 2:
		n = 4;
		for (j=0,i=min_cell; i<max_cell; i++) {
			i2 = i/(dims[0]-1);
			i1 = i-i2*(dims[0]-1);
			array[j] = i2*dims[0]+i1;
			array[j+1] = array[j]+1;
			array[j+2] = array[j+1]+dims[0];
			array[j+3] = array[j+2]-1;
			j+=n;
		}
		break;
	      case 3:
		n = 8;
		pdim = (dims[0]-1)*(dims[1]-1);
		for (j=0,i=min_cell; i<max_cell; i++) {
			i3 = i/pdim;
			i2 = (i-i3*pdim)/(dims[0]-1);
			i1 = i-i3*pdim-i2*(dims[0]-1);
			array[j] = i3*dims[0]*dims[1]+i2*dims[0]+i1;
			array[j+3] = array[j]+1;
			array[j+2] = array[j+3]+dims[0];
			array[j+1] = array[j+2]-1;
			array[j+4] = array[j]+dims[0]*dims[1];
			array[j+7] = array[j+4]+1;
			array[j+6] = array[j+7]+dims[0];
			array[j+5] = array[j+6]-1;
			j+=n;
		}
		break;
	      default:
		fprintf(stderr, "get_connect_struct: cannot compute connect for ndim %d\n",
			ndim);
		return(0);
	}
	return(1);
}

/* Code duplication is done since 'array' is very large */
#ifdef WORDLENGTH_64
int get_connect_struct_n(int ndim, int *dims, int min_cell, int max_cell,
                       int *array)
{
	int i, j, n, i1, i2, i3, pdim;

	switch (ndim) {
	      case 0:
	        n = 1;
		for (j=0,i=min_cell; i<max_cell; i++) {
			array[j] = i;
			j+=n;
		}
		break;

	      case 1:
		n = 2;
		for (j=0,i=min_cell; i<max_cell; i++) {
			array[j] = i;
			array[j+1] = i+1;
			j+=n;
		}
		break;
	      case 2:
		n = 4;
		for (j=0,i=min_cell; i<max_cell; i++) {
			i2 = i/(dims[0]-1);
			i1 = i-i2*(dims[0]-1);
			array[j] = i2*dims[0]+i1;
			array[j+1] = array[j]+1;
			array[j+2] = array[j+1]+dims[0];
			array[j+3] = array[j+2]-1;
			j+=n;
		}
		break;
	      case 3:
		n = 8;
		pdim = (dims[0]-1)*(dims[1]-1);
		for (j=0,i=min_cell; i<max_cell; i++) {
			i3 = i/pdim;
			i2 = (i-i3*pdim)/(dims[0]-1);
			i1 = i-i3*pdim-i2*(dims[0]-1);
			array[j] = i3*dims[0]*dims[1]+i2*dims[0]+i1;
			array[j+3] = array[j]+1;
			array[j+2] = array[j+3]+dims[0];
			array[j+1] = array[j+2]-1;
			array[j+4] = array[j]+dims[0]*dims[1];
			array[j+7] = array[j+4]+1;
			array[j+6] = array[j+7]+dims[0];
			array[j+5] = array[j+6]-1;
			j+=n;
		}
		break;
	      default:
		fprintf(stderr, "get_connect_struct_n: cannot compute connect for ndim %d\n",
			ndim);
		return(0);
	}
	return(1);
}
#endif

static int int_type (OMobj_id elem_id, int *type)
{
	*type = DTYPE_INT;
	return(1);
}

/* 64-bit porting. Newly Introduced */
static int long_type (OMobj_id elem_id, int *type)
{
	*type = DTYPE_LONG;
	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_ncells_polytri (OMobj_id elem_id, xp_long *value)
{
	int  stat, type;
	xp_long npoly, *conn;
	xp_long i, size;
	OMobj_id sub_id;

	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	type = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&type,(char **)&conn,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);
	*value = 0;
	for (i=0; i<npoly; i++)
		*value += conn[2*i+1] - conn[2*i] - 1;
	ARRfree(conn);

	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_connect_polytri(OMobj_id elem_id, int *type, char **array,
                           int *ndim, xp_long *dims, int mode)
{
	OMobj_id sub_id;
        int  stat, dtype;
        xp_long npoly, *conn, *ptr;
	int rev, alloced, my_ndim;
	xp_long i, j, count, size, my_dims[16];

	if (mode == OM_GET_ARRAY_RW || mode == OM_GET_ARRAY_WR) {
		ERRerror("FLDget_connect_polytri", 1, ERR_ORIG,
			 "array is read only for element: %s",
			 OMret_obj_name(elem_id));
		return(-1);
	}

	if (*type == OM_TYPE_UNSET) *type = OM_TYPE_LONG;

	if (*type != OM_TYPE_LONG) {
		return(OMsub_array_get_array(elem_id,type,array,ndim,dims,mode));
	};

	if ((stat = OMget_array_dims(elem_id,&my_ndim,my_dims)) != 1)
		return(stat);

	/*
	 * If dimensions aren't specified, then we assign them.
	 */
	if (*ndim == 0) {
		*ndim = my_ndim;
		memcpy(dims, my_dims, sizeof(xp_long)*my_ndim);
	}
	else if (OMmatch_dims(*ndim,dims,my_ndim,my_dims) != 1) {
		ERRerror("FLDget_connect_polytri", 1, ERR_ORIG,
			 "mismatch of array dimensions in get_array for element: %s",
			 OMret_obj_name(elem_id));
		return(-1);
	}

	/*
	 * Allocate the array to be the complete size (if we are not already
	 * provided with an allocated array).
	 */
	if (*array == NULL) {
		size = 1;
		for (i = 0; i < my_ndim; i++) size *= my_dims[i];
		ptr = (xp_long *)ARRalloc(NULL,*type,size,NULL);
		if (ptr == NULL) {
			ERRerror("FLDget_connect_polytri", 2, ERR_ORIG,
				 "can't alloc array for: %s in get_array op (size = %d)",
				 OMret_obj_name(elem_id),size);
			return(-1);
		}
		alloced = 1;
		*array = (char *)ptr;
	}
	else {
		alloced = 0;
		ptr = (xp_long *)*array;
	}

	/* fill in array */

	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	dtype = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&dtype,(char **)&conn,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);

	count=0;
	rev=0;
	for (i=0; i<npoly; i++)
		for (j=conn[2*i]; j<conn[2*i+1]-1; j++) {
			if (rev == 0) {
				ptr[count++] = j+2;
				ptr[count++] = j+1;
				ptr[count++] = j;
				rev = 0;
			}
			else {
				ptr[count++] = j;
				ptr[count++] = j+1;
				ptr[count++] = j+2;
				rev = 1;
			}
		}

	ARRfree(conn);

	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_connect_polytri_dims (OMobj_id elem_id, int *ndim, xp_long *dims)
{
	int  stat, type;
	xp_long npoly, *conn;
	xp_long i, size;
	OMobj_id sub_id;

	*ndim = 1;
	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	type = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&type,(char **)&conn,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);
	*dims = 0;
	for (i=0; i<npoly; i++)
		*dims += conn[2*i+1] - conn[2*i] - 1;
	*dims *= 3;

	ARRfree(conn);

	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_ncells_polyline (OMobj_id elem_id, xp_long *value)
{
	int  stat, type;
	xp_long npoly, *conn;
	xp_long i, size;
	OMobj_id sub_id;

	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	type = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&type,(char **)&conn,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);
	*value = 0;
	for (i=0; i<npoly; i++)
		*value += conn[2*i+1] - conn[2*i];
	ARRfree(conn);

	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_connect_polyline(OMobj_id elem_id, int *type, char **array,
                            int *ndim, xp_long *dims, int mode)
{
	OMobj_id sub_id;
        int  stat, dtype;
        xp_long npoly, *conn, *ptr;
	int alloced, my_ndim;
	xp_long i, j, count, size, my_dims[16];

	if (mode == OM_GET_ARRAY_RW || mode == OM_GET_ARRAY_WR) {
		ERRerror("FLDget_connect_polyline", 1, ERR_ORIG,
			 "array is read only for element: %s",
			 OMret_obj_name(elem_id));
		return(-1);
	}

	if (*type == OM_TYPE_UNSET) *type = OM_TYPE_LONG;

	if (*type != OM_TYPE_LONG) {
		return(OMsub_array_get_array(elem_id,type,array,ndim,dims,mode));
	};

	if ((stat = OMget_array_dims(elem_id,&my_ndim,my_dims)) != 1)
		return(stat);

	/*
	 * If dimensions aren't specified, then we assign them.
	 */
	if (*ndim == 0) {
		*ndim = my_ndim;
		memcpy(dims, my_dims, sizeof(xp_long)*my_ndim);
	}
	else if (OMmatch_dims(*ndim,dims,my_ndim,my_dims) != 1) {
		ERRerror("FLDget_connect_polyline", 1, ERR_ORIG,
			 "mismatch of array dimensions in get_array for element: %s",
			 OMret_obj_name(elem_id));
		return(-1);
	}

	/*
	 * Allocate the array to be the complete size (if we are not already
	 * provided with an allocated array).
	 */
	if (*array == NULL) {
		size = 1;
		for (i = 0; i < my_ndim; i++) size *= my_dims[i];
		ptr = (xp_long *)ARRalloc(NULL,*type,size,NULL);
		if (ptr == NULL) {
			ERRerror("FLDget_connect_polyline", 2, ERR_ORIG,
				 "can't alloc array for: %s in get_array op (size = %d)",
				 OMret_obj_name(elem_id),size);
			return(-1);
		}
		alloced = 1;
		*array = (char *)ptr;
	}
	else {
		alloced = 0;
		ptr = (xp_long *)*array;
	}

	/* fill in array */

	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	dtype = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&dtype,(char **)&conn,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);
	count = 0;
	for (i=0; i<npoly; i++)
		for (j=conn[2*i]; j<conn[2*i+1]; j++) {
			ptr[count++] = j;
			ptr[count++] = j+1;
		}

	ARRfree(conn);

	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_connect_polyline_dims (OMobj_id elem_id, int *ndim, xp_long *dims)
{
	int  stat, type;
	xp_long npoly, *conn;
	xp_long i, size;
	OMobj_id sub_id;

	*ndim = 1;
	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	type = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&type,(char **)&conn,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);
	*dims = 0;
	for (i=0; i<npoly; i++)
		*dims += conn[2*i+1] - conn[2*i];
	*dims *= 2;

	ARRfree(conn);

	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_ncells_polyhedron (OMobj_id elem_id, xp_long *value)
{
	int  stat, type;
	xp_long npoly, *conn;
	xp_long i, size;
	OMobj_id sub_id;

	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	type = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&type,(char **)&conn,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);
	if (size != npoly) {
		ARRfree(conn);
		return(-1);
	}
	*value = 0;
	for (i=0; i<npoly; i++)
		*value += conn[i]-2;
	ARRfree(conn);

	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_connect_polyhedron(OMobj_id elem_id, int *type, char **array,
                              int *ndim, xp_long *dims, int mode)
{
	OMobj_id sub_id, tmp;
        int  stat, dtype, search;
        xp_long npoly, conn_ind, *ptr, *list, *conn, *p_nnodes, *out_conn, ntri;
	int  nspace, convex_flag;
	int alloced, my_ndim;
	xp_long i, j, count, arr_size, con_size, size, my_dims[16];
	float  *coord;
	int nrefs;
	OMobj_id *ref_list;

	if (mode == OM_GET_ARRAY_RW || mode == OM_GET_ARRAY_WR) {
		ERRerror("FLDget_connect_polyhedron", 1, ERR_ORIG,
			 "array is read only for element: %s",
			 OMret_obj_name(elem_id));
		return(-1);
	}

	if (*type == OM_TYPE_UNSET) *type = OM_TYPE_LONG;

	if (*type != OM_TYPE_LONG) {
		return(OMsub_array_get_array(elem_id,type,array,ndim,dims,mode));
	};

	if ((stat = OMget_array_dims(elem_id,&my_ndim,my_dims)) != 1)
		return(stat);

	/*
	 * If dimensions aren't specified, then we assign them.
	 */
	if (*ndim == 0) {
		*ndim = my_ndim;
		memcpy(dims, my_dims, sizeof(xp_long)*my_ndim);
	}
	else if (OMmatch_dims(*ndim,dims,my_ndim,my_dims) != 1) {
		ERRerror("FLDget_connect_polyhedron", 1, ERR_ORIG,
			 "mismatch of array dimensions in get_array for element: %s",
			 OMret_obj_name(elem_id));
		return(-1);
	}

	/*
	 * Allocate the array to be the complete size (if we are not already
	 * provided with an allocated array).
	 */
	arr_size = 1;
	for (i = 0; i < my_ndim; i++) arr_size *= my_dims[i];
	if (*array == NULL) {
		ptr = (xp_long *)ARRalloc(NULL,*type,arr_size,NULL);
		if (ptr == NULL) {
			ERRerror("FLDget_connect_polyhedron", 2, ERR_ORIG,
				 "can't alloc array for: %s in get_array op (size = %d)",
				 OMret_obj_name(elem_id),arr_size);
			return(-1);
		}
		alloced = 1;
		*array = (char *)ptr;
	}
	else {
		alloced = 0;
		ptr = (xp_long *)*array;
	}

	/* fill in array */

	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	dtype = DTYPE_LONG;
	p_nnodes = NULL;
	if ((stat = OMget_array_sz(sub_id,&dtype,(char **)&p_nnodes,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);
	if (size != npoly) {
		ARRfree(p_nnodes);
		return(-1);
	}
	if ((stat = OMget_array_subobj(elem_id,2,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	dtype = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&dtype,(char **)&conn,
				   &con_size, OM_GET_ARRAY_RD)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,3,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_int_val(sub_id, &convex_flag)) != 1)
		convex_flag = 1;

	if (convex_flag == 0) {
		count = 0;
		for (i=0, conn_ind=0; i<npoly; i++) {
			if (conn_ind+p_nnodes[i] > con_size) {
				ARRfree(p_nnodes);
				ARRfree(conn);
				return(-1);
			}
			list = conn+conn_ind;
			for (j=0; j<p_nnodes[i]-2; j++) {
				ptr[count++] = list[0];
				ptr[count++] = list[j+1];
				ptr[count++] = list[j+2];
			}
			conn_ind += p_nnodes[i];
		}
	}
	else {
		/** need coordinates to triangulate **/
		if (OMget_obj_val(sub_id, &sub_id) != 1)
			return(0);
		OMget_obj_parent(sub_id, &tmp);
		if (OMis_null_obj(tmp))
			return(0);

		/* if it is array of cell_sets, need 2 levels more
		   to get cell_set   */
		if (OMget_obj_atts(tmp, OM_atts_array_memb) == 1) {
			OMget_obj_parent(tmp, &sub_id);
			if (OMis_null_obj(sub_id))
				return(0);
			OMget_obj_parent(sub_id, &tmp);
			if (OMis_null_obj(tmp))
				return(0);
		}
		OMget_obj_parent(tmp, &sub_id);
		if (OMis_null_obj(sub_id))
			return(0);

		/*
		 * check if we are in the right place that have nspace and coordinates
		 */
		search = 0;
		tmp= OMfind_subobj(sub_id,OMstr_to_name("nspace"),OM_OBJ_RD);
		if (OMis_null_obj(tmp))
			search = 1;
		else {
			tmp = OMfind_subobj(sub_id,OMstr_to_name("coordinates"),OM_OBJ_RD);
			if (OMis_null_obj(tmp))
				search = 1;
		}
		if (search) {
			/*
			 * we should get here only if cell_set => {foo}; or  cell_set => foo;
			 */
			if ((stat = OMget_array_subobj(elem_id,3,&sub_id,OM_OBJ_RD)) != 1)
				return(stat);
			if (OMget_obj_val(sub_id, &sub_id) != 1)
				return(0);
			OMget_obj_parent(sub_id, &tmp);
			if (OMis_null_obj(tmp))
				return(0);

			/* if it is array of cell_sets, need 2 levels more
			   to get cell_set   */
			if (OMget_obj_atts(tmp, OM_atts_array_memb) == 1) {
				OMget_obj_parent(tmp, &sub_id);
				if (OMis_null_obj(sub_id))
					return(0);
				OMget_obj_parent(sub_id, &tmp);
				if (OMis_null_obj(tmp))
					return(0);
			}
			stat = OMget_ref_to_list(tmp, &nrefs, &ref_list, OM_REF_TO_SOURCE);
			if (stat != 1 || nrefs < 1)
				return(0);
			for (stat=1,i=0; i<nrefs; i++) {
				sub_id = ref_list[i];
				if (OMget_obj_val(sub_id, &tmp) != 1)
					return(0);

				OMget_obj_parent(tmp, &sub_id);
				if (OMis_null_obj(sub_id))
					return(0);

				tmp = OMfind_subobj(sub_id,OMstr_to_name("nspace"),OM_OBJ_RD);
				if (!OMis_null_obj(tmp)) {
					tmp = OMfind_subobj(sub_id,OMstr_to_name("coordinates"),OM_OBJ_RD);
					if (!OMis_null_obj(tmp))
						break;
				}
				stat = 0;
			}
			free(ref_list);
			if (stat != 1)
				return(0);
		}
		if ((stat = FLDget_nspace(sub_id, &nspace)) != 1) {
			if (stat < 0) {
				ERRerror("FLDget_connect_polyhedron", 1, ERR_ORIG,
					 "cannot get nspace for element: %s",
					 OMret_obj_name(sub_id));
			}
			return(stat);
		}
		if ((stat = FLDget_coord(sub_id, &coord, &size, OM_GET_ARRAY_RD)) != 1) {
			if (stat < 0) {
				ERRerror("FLDget_connect_polyhedron", 1, ERR_ORIG,
					 "cannot get coordinates for element: %s",
					 OMret_obj_name(sub_id));
			}
			return(stat);
		}
		out_conn = (xp_long *)ptr;
		for (i=0, conn_ind=0; i<npoly; i++) {
			if (conn_ind+p_nnodes[i] > con_size) {
				ARRfree(p_nnodes);
				ARRfree(conn);
				ARRfree(coord);
				return(-1);
			}
			list = conn+conn_ind;
			ntri = triangulate_polygon(nspace, coord, p_nnodes[i], list, out_conn);
			out_conn += ntri*3;
			conn_ind += p_nnodes[i];
			for (j=ntri; j<p_nnodes[i]-2; j++) {
				out_conn[0] = 0;
				out_conn[1] = 0;
				out_conn[2] = 0;
				out_conn += 3;
			}
		}
		if (coord)
			ARRfree(coord);
	}
	if (p_nnodes)
		ARRfree(p_nnodes);
	if (conn)
		ARRfree(conn);

	return(1);
}

/* 64-bit porting. Directly Modified */
int FLDget_connect_polyhedron_dims (OMobj_id elem_id, int *ndim, xp_long *dims)
{
	int  stat, type;
	xp_long npoly, *conn;
	xp_long i, size;
	OMobj_id sub_id;

	*ndim = 1;
	if ((stat = OMget_array_subobj(elem_id,0,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	if ((stat = OMget_long_val(sub_id, &npoly)) != 1)
		return(stat);

	if ((stat = OMget_array_subobj(elem_id,1,&sub_id,OM_OBJ_RD)) != 1)
		return(stat);
	type = DTYPE_LONG;
	conn = NULL;
	if ((stat = OMget_array_sz(sub_id,&type,(char **)&conn,
				   &size, OM_GET_ARRAY_RD)) != 1)
		return(stat);
	if (size != npoly) {
		ARRfree(conn);
		return(-1);
	}
	*dims = 0;
	for (i=0; i<npoly; i++)
		*dims += conn[i] - 2;
	*dims *= 3;

	ARRfree(conn);

	return(1);
}

#define  EPS  1.0e-20

typedef struct _Vertex_List {
	xp_long   pind;
	int   vnorm_valid;
	float vnorm[3];
	struct _Vertex_List *prev;
	struct _Vertex_List *next;
} Vertex_List;

/*************************************************************************/
/*   This function triangulates non-convex polygon                       */
/*   Parameters:                                                         */
/*        float xyz[] - array of coordinates of polygon vertices.        */
/*        int   plist[] - array of (1 based) indices into xyz array      */
/*                        plist[0] is the number of polygon vertices.    */
/*        int  *(new_plist[]) - pointer to new array of indices that     */
/*                              contains a bunch of triangles.           */
/*                              It  follows the same rules as plist      */
/*                              in polygon object.                       */
/* 	  new_plist must be allocated to the right size before calling   */
/* 	  this function.  It should be n-2 verts (although some believe  */
/*        that it could be larger than this sometimes)		   	 */
/*************************************************************************/

/* 64-bit porting. Directly Modified */
static xp_long triangulate_polygon(int nspace, float *xyz, xp_long n, xp_long *plist,
                               xp_long *new_plist)
{
	int k, ix, iy, iz, status;
	xp_long i, ntri, nleft, count, max_count, i1, i2, i0, iv;
	double v0[3], v1[3], v2[3], vnorm[3], l, u, v;

	Vertex_List  *vl_beg, *vl, *vt;

	if (n == 3) {	/* its already a tri */
		memcpy(new_plist, plist, (n)*sizeof(xp_long));
		return(1);
	}
	else if (n < 3) {	/* its a line or point (unusual case) */
		return(0);
	}

	for (i=0; i<3; i++) {
		v0[i] = 0.0;
		v1[i] = 0.0;
		v2[i] = 0.0;
		vnorm[i] = 0.0;
	}

	/**  Calculate area vector of polygon     **/
	/**  by summing area vectors of triangles **/
	/**  from the first vertex  to all others **/
	i0 = plist[0]*nspace;

	for (i=1; i<n-1; i++) {
		i1 = (plist[i])*nspace;
		i2 = (plist[i+1])*nspace;
		for (k=0; k<nspace; k++) {
			v1[k] = xyz[i1+k]-xyz[i0+k];
			v2[k] = xyz[i2+k]-xyz[i0+k];
		}
		VEC_CROSS(v0, v1, v2);
		for (k=0; k<3; k++)
			vnorm[k] += v0[k];
	}

	l = VEC_LEN(vnorm);
	if (l < EPS)       /*  degenerate polygon  */
		return(0);

	VEC_UNITIZE(vnorm, EPS);
	l = fabs(vnorm[0]);
	ix = 0; iy = 1; iz = 2;
	if (fabs(vnorm[1]) > l) {
		l = fabs(vnorm[1]);
		ix = 1; iy = 2; iz = 0;
	}
	if (fabs(vnorm[2]) > l) {
		ix = 2; iy = 0; iz = 1;
	}

	/**  Create vertex list  **/
	vl_beg = (Vertex_List *)malloc(n*sizeof(Vertex_List));
	for (i=0; i<n; i++) {
		vl = vl_beg+i;
		vl->pind = i;
		vl->vnorm_valid = 0;
		vl->prev = (i == 0) ? vl_beg+n-1 : vl-1;
		vl->next = (i == n-1) ? vl_beg : vl+1;
	}

	/**  Eliminate triangles that have angle < 180 **/
	/**  and do not enclose any other vertex       **/
	ntri = 0;
	vl = vl_beg;
	nleft = n;
	count = 0;
	max_count = n*n;
	while (nleft > 3 && count < max_count) {
		i0 = (plist[vl->pind])*nspace;
		i1 = (plist[vl->prev->pind])*nspace;
		i2 = (plist[vl->next->pind])*nspace;
		for (k=0; k<nspace; k++) {
			v1[k] = xyz[i1+k]-xyz[i0+k];
			v2[k] = xyz[i2+k]-xyz[i0+k];
		}
		if (!(vl->vnorm_valid)) {
			VEC_CROSS(vl->vnorm, v2, v1);
			vl->vnorm_valid = 1;
		}
		l = VEC_DOT(vnorm, vl->vnorm);
		if (l == 0.0) {  /** Degenerate triangle **/
			vl->prev->next = vl->next;
			vl->next->prev = vl->prev;
			vl->prev->vnorm_valid = 0;
			vl->next->vnorm_valid = 0;
			nleft--;
		}
		else if (l > 0.0) {         /** Convex vertex       **/
			/** Test if triangle encloses any other verts **/
			status = 1;
			l = (v1[iy]*v2[iz]-v2[iy]*v1[iz]);
			/* Test for a potential divide by zero */
			if (l == 0.0) status = 0;
			vt = vl->next->next;
			for (i=0; status && i<nleft-2; i++) {
				iv = (plist[vt->pind])*nspace;
				for (k=0; k<nspace; k++)
					v0[k] = xyz[iv+k]-xyz[i0+k];
				u = (v0[iy]*v2[iz]-v2[iy]*v0[iz])/l;
				v = (v1[iy]*v0[iz]-v0[iy]*v1[iz])/l;
				if (u<0.0 || v<0.0 || u>1.0 || v>1.0) {
					vt = vt->next;
					continue;
				}
				if ((u+v)<1.0) {
					status = 0;
					break;
				}
				vt = vt->next;
			}
			if (status) {
				new_plist[ntri*3+0] = plist[vl->pind];
				new_plist[ntri*3+1] = plist[vl->next->pind];
				new_plist[ntri*3+2] = plist[vl->prev->pind];
				vl->prev->next = vl->next;
				vl->next->prev = vl->prev;
				vl->prev->vnorm_valid = 0;
				vl->next->vnorm_valid = 0;
				ntri++;
				nleft--;
			}
		}
		vl = vl->next;
		count++;
	}
	count = ntri*3;
        if (nleft) {
	       ntri += nleft/3;
               vt = vl->next;
               while(nleft) {
                       new_plist[count++] = plist[vt->pind];
                       vt = vt->next;
                       nleft--;
               }
	}
	free(vl_beg);

	return(ntri);
}

