/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gd/gd_init.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>

#include <avs/util.h>
#include <avs/om.h>
#include <avs/gd.h>

#if 0
/* Field based render & pick functions */
static OMfunc_table GDfield_funcs[] = {
   { (OMpfi)GDdraw_mesh_unif,		"GDdraw_mesh_unif" },
   { (OMpfi)GDdraw_mesh_rect,		"GDdraw_mesh_rect" },
   { (OMpfi)GDdraw_mesh,		"GDdraw_mesh" },
   { (OMpfi)GDpick_mesh,		"GDpick_mesh" },
   { (OMpfi)GDpick_mesh_unif,		"GDpick_mesh_unif" },
   { (OMpfi)GDdraw_polyh,		"GDdraw_polyh" },
   { (OMpfi)GDpick_polyh,		"GDpick_polyh" },
   { (OMpfi)GDdraw_point_cells,		"GDdraw_point_cells" },
   { (OMpfi)GDpick_point_cells,		"GDpick_point_cells" },
   { (OMpfi)GDdraw_line_cells,		"GDdraw_line_cells" },
   { (OMpfi)GDpick_line_cells,		"GDpick_line_cells" },
   { (OMpfi)GDdraw_polyline_cells,	"GDdraw_polyline_cells" },
   { (OMpfi)GDpick_polyline_cells,	"GDpick_polyline_cells" },
   { (OMpfi)GDdraw_polytri_cells,	"GDdraw_polytri_cells" },
   { (OMpfi)GDpick_polytri_cells,	"GDpick_polytri_cells" },
   { (OMpfi)GDdraw_tri_cells,		"GDdraw_tri_cells" },
   { (OMpfi)GDpick_tri_cells,		"GDpick_tri_cells" },
   { (OMpfi)GDdraw_tri2_cells,		"GDdraw_tri2_cells" },
   { (OMpfi)GDpick_tri2_cells,		"GDpick_tri2_cells" },
   { (OMpfi)GDdraw_quad_cells,		"GDdraw_quad_cells" },
   { (OMpfi)GDpick_quad_cells,		"GDpick_quad_cells" },
   { (OMpfi)GDdraw_quad2_cells,		"GDdraw_quad2_cells" },
   { (OMpfi)GDpick_quad2_cells,		"GDpick_quad2_cells" },
   { (OMpfi)GDdraw_polyh_cells,		"GDdraw_polyh_cells" },
   { (OMpfi)GDpick_polyh_cells,		"GDpick_polyh_cells" },
   { (OMpfi)GDdraw_text,		"GDdraw_text" },
   { (OMpfi)GDpick_text,		"GDpick_text" },
   { (OMpfi)GDdraw_text_array,		"GDdraw_text_array" },
   { (OMpfi)GDpick_text_array,		"GDpick_text_array" },
   { (OMpfi)GDdraw_mesh_array,		"GDdraw_mesh_array" },
   { (OMpfi)GDpick_mesh_array,		"GDpick_mesh_array" },
   { (OMpfi)GDdraw_volume_tiled,	"GDdraw_volume_tiled" },
   { (OMpfi)GDpick_volume_tiled,	"GDpick_volume_tiled" },
   { (OMpfi)GDdraw_volume,		"GDdraw_volume" },
   { (OMpfi)GDpick_volume,		"GDpick_volume" },
};

/* Primitive pick functions */
static OMfunc_table GDpick_funcs[] = {
   { (OMpfi)GDpick_points,	"GDpick_points" },
   { (OMpfi)GDpick_spheres, 	"GDpick_spheres" },
   { (OMpfi)GDpick_lines,	"GDpick_lines" },
   { (OMpfi)GDpick_polyline,	"GDpick_polyline" },
   { (OMpfi)GDpick_polytri,	"GDpick_polytri" },
   { (OMpfi)GDpick_tris,	"GDpick_tris" },
   { (OMpfi)GDpick_wiretris,	"GDpick_wiretris" },
   { (OMpfi)GDpick_quads,	"GDpick_quads" },
   { (OMpfi)GDpick_wirequads,	"GDpick_wirequads" },
   { (OMpfi)GDpick_polygon,	"GDpick_polygon" },
   { (OMpfi)GDpick_2dimage,	"GDpick_2dimage" },
};
#endif

/* Field output functions */
static OMfunc_table GDoutput_funcs[] = {
   { (OMpfi)GDoutput_init,		"GDoutput_init" },
   { (OMpfi)GDoutput_flush,		"GDoutput_flush" },
   { (OMpfi)GDfield_output_write,	"GDfield_output_write" },
   { (OMpfi)GDfile_output_write,	"GDfile_output_write" },
   { (OMpfi)GDoutput_done,		"GDoutput_done" },
};

static int GD_hardware_render = 1;

int GDinit_hardware_renderer(void)
{
   return(GD_hardware_render);
}

void GDinit(int *argc, char **argv)
{
   int i;

   /*
    * If we didn't find the edit_lic property set properly on our library,
    * the user is tampering with it.
    */
   if (OMverify_license("GD","GD") != 1)
      exit(-1); 

   /* look for the no hardware renderering option */
   for (i = 1; i < *argc && i >= 1; i++) {
      if (*argv[i] == '-') {
	 if (!strcmp(argv[i],"-nohw")) {

	    /* it's set */
	    GD_hardware_render = 0;

	    /* shuffle the other options up over it */
	    if ((*argc) > i) {
	       MEMMOVE(&argv[i],&argv[i+1],((*argc)-i) * sizeof(char *));
	    }
	    (*argc)--;
	    i--;
	 }
      }
   }

   /* If env var is set, revert to the old (pre 6.0) default 
    * light positioning.
    */
   if (getenv("XP_OLD_LIGHTS")) {
      OMobj_id library_id, mlights_id;
      library_id = OMfind_subobj(OMtempl_obj, OMstr_to_name("GDM"),
                                 OM_OBJ_RD);
      mlights_id = OMfind_subobj(library_id, OMstr_to_name("Mlights"),
                                 OM_OBJ_RD);
      if (!OMis_null_obj(mlights_id)) {
         OMobj_id lxform_id;
         lxform_id = OMfind_subobj(mlights_id, OMstr_to_name("LightXform"), 
                                   OM_OBJ_RD);
         if (!OMis_null_obj(lxform_id)) {
            float mat[4][4];
            MATmat4_identity(mat);
            GDset_float_array(lxform_id, "mat", 16, &mat[0][0]);
         }
     }
   }

   /* track functions */
   OMadd_named_func((OMpfi)GDtrack_rotate, OMstr_to_name("GDtrack_rotate"));
   OMadd_named_func((OMpfi)GDtrack_scale, OMstr_to_name("GDtrack_scale"));
   OMadd_named_func((OMpfi)GDtrack_xlate, OMstr_to_name("GDtrack_xlate"));
   OMadd_named_func((OMpfi)GDtrack_zlate, OMstr_to_name("GDtrack_zlate"));

   /* Function for field/file output from viewers. */
   OMadd_named_funcs(GDoutput_funcs, sizeof(GDoutput_funcs)/sizeof(OMfunc_table));

#if 0
   OMadd_named_funcs(GDfield_funcs, sizeof(GDfield_funcs)/sizeof(OMfunc_table));
   OMadd_named_funcs(GDpick_funcs, sizeof(GDpick_funcs)/sizeof(OMfunc_table));
#endif
}

