/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gd/ogl/ogl_init.c#1 $
*/
/*---------------------------------------------------------------------*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>
#include <stdlib.h>
#include <avs/om.h>
#include <avs/om_type.h>
#include <avs/gd.h>
#include "gd_ogl.h"

/*---------------------------------------------------------------------*
 *                       ogl global variables                          *
 *---------------------------------------------------------------------*/

OGLRenderer   ogl_renderer;

OGLEnviron    ogl_environ;

GLUquadricObj *sphere = NULL;

GLUquadricObj *cylinder = NULL;

int OGL_2pt_disable = 0;

/*---------------------------------------------------------------------*
 *                     renderer function vectors                       *
 *---------------------------------------------------------------------*/

/* GL renderer view device dependent functions */
static OMfunc_table GDgl_view_funcs[] = {
   { (OMpfi)GDgl_view_available,	"GDgl_view_available" },
   { (OMpfi)GDgl_view_create,		"GDgl_view_create" },
   { (OMpfi)GDgl_view_clear,		"GDgl_view_clear" },
   { (OMpfi)GDgl_view_transp_pass,	"GDgl_view_transp_pass" },
   { (OMpfi)GDgl_view_image_pass,	"GDgl_view_image_pass" },
   { (OMpfi)GDgl_view_accel,		"GDgl_view_accel" },
   { (OMpfi)GDgl_view_accel2d,		"GDgl_view_accel2d" },
   { (OMpfi)GDgl_view_get_buffers,	"GDgl_view_get_buffers" },
   { (OMpfi)GDgl_view_get_image,	"GDgl_view_get_image" },
   { (OMpfi)GDgl_view_put_image,	"GDgl_view_put_image" },
   { (OMpfi)GDgl_view_swap1,		"GDgl_view_swap1" },
   { (OMpfi)GDgl_view_swap2,		"GDgl_view_swap2" },
   { (OMpfi)GDgl_view_refresh,		"GDgl_view_refresh" },
   { (OMpfi)GDgl_view_delete,		"GDgl_view_delete" },
   { (OMpfi)GDgl_view_resize,		"GDgl_view_resize" },
   { (OMpfi)GDgl_view_set_video_mode,	"GDgl_view_set_video_mode" },
   { (OMpfi)GDgl_view_set_left_eye,	"GDgl_view_set_left_eye" },
   { (OMpfi)GDgl_view_set_right_eye,	"GDgl_view_set_right_eye" },
};

/* GL renderer state device dependent functions */
static OMfunc_table GDgl_state_funcs[] = {
   { (OMpfi)GDgl_state_create,		"GDgl_state_create" },
   { (OMpfi)GDgl_state_delete,		"GDgl_state_delete" },
   { (OMpfi)GDgl_state_init,		"GDgl_state_init" },
   { (OMpfi)GDgl_set_color,		"GDgl_set_color" },
   { (OMpfi)GDgl_set_material,		"GDgl_set_material" },
   { (OMpfi)GDgl_set_mode,		"GDgl_set_mode" },
   { (OMpfi)GDgl_set_texture,		"GDgl_set_texture" },
   { (OMpfi)GDgl_set_depth_cue,		"GDgl_set_depth_cue" },
   { (OMpfi)GDgl_set_font,              "GDgl_set_font" },
   { (OMpfi)GDgl_set_line_width,        "GDgl_set_line_width" },
   { (OMpfi)GDgl_set_line_style,        "GDgl_set_line_style" },
   { (OMpfi)GDgl_set_line_aa,           "GDgl_set_line_aa" },
   { (OMpfi)GDgl_set_transparency,	"GDgl_set_transparency" },
   { (OMpfi)GDgl_update_matrix,		"GDgl_update_matrix" },
   { (OMpfi)GDgl_set_specular_color,	"GDgl_set_specular_color" },
   { (OMpfi)GDgl_set_backface_cull,	"GDgl_set_backface_cull" },
   { (OMpfi)GDgl_set_draw_mode,	        "GDgl_set_draw_mode" },
   { (OMpfi)GDstate_set_jitter,		"GDstate_set_jitter" },
   { (OMpfi)GDstate_set_vox_interp,     "GDstate_set_vox_interp" },
   { (OMpfi)GDstate_set_blend_mode,     "GDstate_set_blend_mode" },
   { (OMpfi)GDgl_set_camera_attrs,	"GDgl_set_camera_attrs" },
   { (OMpfi)GDgl_set_lights,		"GDgl_set_lights" },
   { (OMpfi)GDstate_set_dir_pt_size,    "GDstate_set_dir_pt_size" },
   { (OMpfi)GDstate_set_subdiv,         "GDstate_set_subdiv" },
   { (OMpfi)GDstate_set_stereo_attrs,   "GDstate_set_stereo_attrs" },
};

/* GL renderer primitive device dependent functions */
static OMfunc_table GDgl_prim_funcs[] = {
   { (OMpfi)GDgl_points,		"GDgl_points" },
   { (OMpfi)GDgl_lines,			"GDgl_lines" },
   { (OMpfi)GDgl_polyline,		"GDgl_polyline" },
   { (OMpfi)GDgl_polytri,		"GDgl_polytri" },
   { (OMpfi)GDgl_tris,			"GDgl_tris" },
   { (OMpfi)GDgl_quads,			"GDgl_quads" },
   { (OMpfi)GDgl_spheres,		"GDgl_spheres" },
   { (OMpfi)GDgl_text,                  "GDgl_text" },
   { (OMpfi)GDgl_volume,                "GDgl_volume" },
   { (OMpfi)GDgl_polygons,              "GDgl_polygons" },

   { (OMpfi)GDgl_2d_text,               "GDgl_2d_text" },
   { (OMpfi)GDgl_2d_points,             "GDgl_2d_points" },
   { (OMpfi)GDgl_2d_lines,              "GDgl_2d_lines" },
   { (OMpfi)GDgl_2d_polyline,           "GDgl_2d_polyline" },
   { (OMpfi)GDgl_2d_polytri,            "GDgl_2d_polytri" },
   { (OMpfi)GDgl_2d_tris,		"GDgl_2d_tris" },
   { (OMpfi)GDgl_2d_quads,		"GDgl_2d_quads" },
   { (OMpfi)GDgl_2d_polygons,           "GDgl_2d_polygons" },
   { (OMpfi)GDgl_image,                 "GDgl_image" }
};

/* GL renderer geom data device dependent functions */
static OMfunc_table GDgl_geom_funcs[] = {
   { (OMpfi)GDgl_geom_init,		"GDgl_geom_init" },
   { (OMpfi)GDgl_geom_build,		"GDgl_geom_build" },
   { (OMpfi)GDgl_geom_free,		"GDgl_geom_free" },
};

/*---------------------------------------------------------------------*/

void GDgd_init_gl()
{
   OMobj_id obj_id;
   char     *glod;
   char     *gstyle;
   int      nlod;
   int      default_renderer;
   char     *env_str;
   int      active = GDinit_hardware_renderer();

   if (active) {

      /* initialize ogl renderer information */

      memset( &ogl_renderer, 0, sizeof(OGLRenderer) );
      memset( &ogl_environ,  0, sizeof(OGLEnviron)  );

      ogl_environ.glyph_style = GLYPH_OPEN;
      ogl_environ.glyph_lod   = 100;

      /* get environment */

#ifdef OGL_TRACE
      if (getenv("EXPRESS_OGL_TRACE") || getenv("XP_OGL_TRACE") ) {
	 ogl_environ.trace = 1;
	 fprintf( stderr, "Express: OpenGL trace execution\n" );
      }
#endif

#ifdef OGL_DEBUG
      if (getenv("EXPRESS_OGL_DEBUG") || getenv("XP_OGL_DEBUG") ) {
	 ogl_environ.debug = 1;
	 fprintf( stderr, "Express: OpenGL debug checkpoints\n" );
      }
#endif

      if (getenv("EXPRESS_OGL_INFO") || getenv("XP_OGL_INFO")) {
         ogl_environ.info = 1;
         fprintf( stderr, "Express: OpenGL renderer info\n" );
      }

      gstyle = getenv("XP_GLYPH_STYLE");
      if (gstyle) {
         if (!strcmp(gstyle,"OPEN")) {
            ogl_environ.glyph_style = GLYPH_OPEN;
            if (ogl_environ.info)
               fprintf( stderr, "Express: OpenGL glyph style OPEN\n" );
         }
         else if (!strcmp(gstyle,"CLOSED")) {
            ogl_environ.glyph_style = GLYPH_CLOSED;
            if (ogl_environ.info)
               fprintf( stderr, "Express: OpenGL glyph style CLOSED\n" );
            glod = getenv("XP_GLYPH_LOD");
            if (glod) {
               if (sscanf(glod,"%d",&nlod) == 1 && nlod > 0) {
                  ogl_environ.glyph_lod = nlod;
                  if (ogl_environ.info)
                     fprintf( stderr, "Express: OpenGL glyph LOD %d\n", nlod );
               }
            }
         }
      }

      /* Disable two-pass transparency */
      if (getenv("XP_2PT_DISABLE"))
         OGL_2pt_disable = 1;

      /* load function vectors */

      OMadd_named_funcs(GDgl_view_funcs, 
			sizeof(GDgl_view_funcs)/sizeof(OMfunc_table));
      OMadd_named_funcs(GDgl_state_funcs, 
			sizeof(GDgl_state_funcs)/sizeof(OMfunc_table));
      OMadd_named_funcs(GDgl_prim_funcs, 
			sizeof(GDgl_prim_funcs)/sizeof(OMfunc_table));
      OMadd_named_funcs(GDgl_geom_funcs, 
			sizeof(GDgl_geom_funcs)/sizeof(OMfunc_table));

      /* set default renderer as us unless env var overrides */
      default_renderer = 1;
      env_str = getenv("XP_DEFAULT_RENDERER");
      if (env_str)
      {
	if (!strcmp(env_str, "SW")  || !strcmp(env_str, "sw")
#ifdef __sun
	    || !strcmp(env_str, "XGL") || !strcmp(env_str, "xgl")
#endif
#ifdef __hpux
	    || !strcmp(env_str, "PEX") || !strcmp(env_str, "pex")
#endif
#ifdef __sun
	    || !strcmp(env_str, "XIL") || !strcmp(env_str, "xil")
#endif
            )
	  default_renderer = 0;
      }
      else
      {
	/* older style env vars */
	if (getenv("XP_DEFAULT_RENDERER_PEX") ||
	    getenv("XP_DEFAULT_RENDERER_XGL"))
	  default_renderer = 0;
      }

      if (default_renderer)
      {
	default_renderer = GD_GL_RENDERER;

	obj_id = OMfind_str_subobj( OMtempl_obj,
				    "CONFIG.gd_default_renderer", 
				    OM_OBJ_RW );
	if (!OMis_null_obj(obj_id))
	  OMset_int_val( obj_id, default_renderer );
      }
   } /* active */

   obj_id = OMfind_str_subobj( OMtempl_obj,
                               "CONFIG.gd_gl_active", 
			       OM_OBJ_RW );
   if (!OMis_null_obj(obj_id))
      OMset_int_val( obj_id, active );
}

/*---------------------------------------------------------------------*/
