/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gd/sw/swx.h#1 $
*/

#ifndef GD_SWX_H
#define GD_SWX_H

/*---------------------------------------------------------------------*/

typedef struct _SWstate {

  /* frame buffer & Z buffer */
  int            alloced_size;     /* current allocated size frame buffer & Z */
  RPIXEL         *pixmap;          /* SW renderer frame buffer */
  ZPIXEL         *zpixmap;         /* SW renderer Z buffer */

  int            dithered;         /* cleared in view_clear/set in view_swap */

  /* if view is accelerated - 3D accelerate frame buffer & Z buffer */
  int            aalloced_size;    /* current allocated size of accel buffers */
  RPIXEL         *apixmap;         /* accel. frame buffer */
  ZPIXEL         *azpixmap;        /* accel. Z buffer */

#ifndef MSDOS
  /* if view is accelerated - 2D accelerate buffer */
  int           aalloced_size2d;    /* current allocated size of 2D accel buffer */
  Pixmap	abuf2d;
#endif

#ifdef MSDOS
  /* dither buffer */
  int            dalloced_size;    /* current size of dithered pixmap */
  char           *dpixmap;         /* dithered pixmap */
#endif

  float          snxform[4][4];    /* sphere normal transform */
  float          eye_point[3];
  float          amb_color[3];     /* ambient light color */
  float          table_exp;
  float          power_table[GD_POWER_TABLE_SIZE];
  int            ndir_lights;
  GDstate_lights *dir_lights[GD_MAX_LIGHTS];
  int            line_mode;
} SWstate;

#define SW_STATE_ASIZE(s)          (((SWstate*)(state->priv))->alloced_size)
#define SW_STATE_PIX(s)            (((SWstate*)(state->priv))->pixmap)
#define SW_STATE_ZPIX(s)           (((SWstate*)(state->priv))->zpixmap)
#define SW_STATE_DITH(s)           (((SWstate*)(state->priv))->dithered)
#define SW_STATE_AASIZE(s)         (((SWstate*)(state->priv))->aalloced_size)
#define SW_STATE_APIX(s)           (((SWstate*)(state->priv))->apixmap)
#define SW_STATE_AZPIX(s)          (((SWstate*)(state->priv))->azpixmap)

#ifndef MSDOS
#define SW_STATE_AASIZE2D(s)       (((SWstate*)(state->priv))->aalloced_size2d)
#define SW_STATE_ABUF2D(s)         (((SWstate*)(state->priv))->abuf2d)
#endif

#ifdef MSDOS
#define SW_STATE_DSIZE(s)          (((SWstate*)(state->priv))->dalloced_size)
#define SW_STATE_DPIX(s)           (((SWstate*)(state->priv))->dpixmap)
#endif

#define SW_STATE_SNXFORM(s)        (((SWstate*)(state->priv))->snxform)
#define SW_STATE_EYE_PT(s)         (((SWstate*)(state->priv))->eye_point)
#define SW_STATE_AMB_COL(s)        (((SWstate*)(state->priv))->amb_color)
#define SW_STATE_TABLE_EXP(s)      (((SWstate*)(state->priv))->table_exp)
#define SW_STATE_POW_TABLE(s)      (((SWstate*)(state->priv))->power_table)
#define SW_STATE_NDIR_LITE(s)      (((SWstate*)(state->priv))->ndir_lights)
#define SW_STATE_DIR_LITES(s)      (((SWstate*)(state->priv))->dir_lights)
#define SW_STATE_LINE_MODE(s)      (((SWstate*)(state->priv))->line_mode)

/*---------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/* Functions associated with the software renderer - for both X and Windows */

/* Software renderer view specific functions defined in sw_view.c */

int	GDsw_view_available   (GDview *);
void	GDsw_view_accel       (GDview *);
void	GDsw_view_transp_pass (GDview *);
void    GDsw_update_3dbufs    (GDview *, int, int);
void    GDsw_clear_3dbufs     (GDview *);
void    GDsw_restore_3dbufs   (GDview *);
void    GDsw_delete_3dbufs    (GDview *);
char *	GDsw_resize_ipixmap   (GDview *, int, int, int);

#ifndef MSDOS

/* Software renderer view specific functions defined in swx_view.c */

int	GDswx_view_available		(GDview *);
int	GDswx_view2d_common_setup	(GDview *);
int	GDswx_view_create		(GDview *);
void	GDswx_view_clear		(GDview *);
void	GDswx_update_2dbufs		(GDview *, int, int);
void	GDswx_clear_2dbufs		(GDview *);
void	GDswx_restore_2dbufs		(GDview *);
void	GDswx_view_swap1		(GDview *);
void	GDswx_view_accel2d		(GDview *);
void	GDswx_view_image_pass		(GDview *);
void	GDswx_view_swap2		(GDview *);
void	GDswx_view_copy_area2d		(GDview *, GDview *, int, int, int,int, int, int);
void	GDswx_view_refresh		(GDview *);
int	GDswx_view2d_common_setdown	(GDview *);
void	GDswx_view_delete		(GDview *);
void	GDswx_view_resize		(GDview *);
void	GDswx_view_get_buffers		(GDview *);
void	GDswx_view_get_image		(GDview *, LImageForm *);
void	GDswx_view_put_image		(GDview *, LImageForm *);
void	GDswx_view_set_video_mode	(GDview *);
void	GDswx_view_set_left_eye		(GDview *);
void	GDswx_view_set_right_eye	(GDview *);
int	GDswx_putimage			(GDview *, unsigned char *, int, int, int, int);
int	GDconvert_ximage_to_colors	(GDstate *, XImage *);
#else

/* Software renderer view specific functions defined in sww_view.c */

int	GDsww_view_available		(GDview *);
int	GDsww_view_create		(GDview *);
void	GDsww_view_clear		(GDview *);
void	GDsww_update_2dbufs		(GDview *, int, int);
void	GDsww_clear_2dbufs		(GDview *);
void	GDsww_restore_2dbufs		(GDview *);
void	GDsww_dither_image		(GDview *, int *, int, int, unsigned char *, int, int);
void	GDsww_putimage			(GDview *, byte *, int, int, int, int);
void	GDsww_view_swap1		(GDview *);
void    GDsww_resize_dither		(GDview *, int, int);
void	GDsww_view_accel2d		(GDview *);
void	GDsww_view_image_pass		(GDview *);
void	GDsww_view_swap2		(GDview *);
void	GDsww_view_refresh		(GDview *);
void	GDsww_view_delete		(GDview *);
void	GDsww_view_resize		(GDview *);
void	GDsww_view_get_buffers		(GDview *);
void	GDsww_view_get_image		(GDview *, LImageForm *);
void	GDsww_view_put_image		(GDview *, LImageForm *);
void	GDsww_view_set_video_mode	(GDview *);
void	GDsww_view_set_left_eye		(GDview *);
void	GDsww_view_set_right_eye	(GDview *);

#endif

/* Software renderer state specific functions defined in sw_state.c */

void	GDsw_state_create	(GDview *);
void	GDsw_state_delete	(GDview *);
void	GDsw_state_init		(GDview *);
void	GDsw_set_camera_attrs	(GDview *, GDcamera *);
void	GDsw_set_camera_matrix	(GDview *, GDcamera *);
void	GDsw_set_lights		(GDview *);

/* Software renderer primitive specific functions defined in sw_if.c */

void	GDsw_geom_init		(GDgeom_data *, GDstate *);
void	GDsw_geom_build 	(GDobject *, GDgeom_data *, GDstate *);
void	GDsw_geom_free		(GDgeom_data *);
void	GDsw_text		(GDgeom_data *, GDstate *);
void	GDsw_polytri		(GDgeom_data *, GDstate *);
void	GDsw_points		(GDgeom_data *, GDstate *);
void	GDsw_lines		(GDgeom_data *, GDstate *);
void	GDsw_polyline		(GDgeom_data *, GDstate *);
void	GDsw_spheres		(GDgeom_data *, GDstate *);

/* Software renderer primitive specific functions defined in sw_if_2d.c */

void	GDsw_2d_points		(GDgeom_data *, GDstate *);
void	GDsw_2d_lines		(GDgeom_data *, GDstate *);
void	GDsw_2d_polyline	(GDgeom_data *, GDstate *);
void	GDsw_2d_polylines	(GDgeom_data *, GDstate *);
void	GDsw_2d_polytri		(GDgeom_data *, GDstate *);
void	GDsw_2d_polygons	(GDgeom_data *, GDstate *);
void	GDsw_2d_fillrects	(GDgeom_data *, GDstate *);
void	GDsw_2d_rects		(GDgeom_data *, GDstate *);
void	GDsw_2d_text		(GDgeom_data *, GDstate *);
void	GDsw_image		(GDgeom_data *, GDstate *);
void	GDsw_image_tiled	(GDgeom_data *, GDstate *);
void	GDsw_image_free		(GDgeom_data *);

/* Software renderer primitive specific functions defined in sw_2d.c */

unsigned long GD2d_get_color      (GDstate *, float *);
void	      GD2d_validate_gc    (GDstate *);
void	      GD2d_average_color  (FLOAT3[], FLOAT3, int);
void	      GD2d_draw_polytri   (GDstate *, xp_long,
                                   SHORT2[], FLOAT3[], FLOAT3[]);
void	      GD2d_draw_polytri_clipped (GDstate *, xp_long,
                                         SHORT2[], FLOAT3[], FLOAT3[],
                                         unsigned short *);
void	      GD2d_draw_polygon   (GDstate *, xp_long,
                                   SHORT2[], FLOAT3[], FLOAT3[], int);
void	      GD2d_draw_text      (GDstate *, char *,
                                   SHORT2[], FLOAT3[]);
void	      GD2d_draw_points	  (GDstate *, xp_long,
                                   SHORT2[], FLOAT3[], FLOAT3[]);
void          GD2d_draw_points_clipped (GDstate *, xp_long,
                                        SHORT2[], FLOAT3[], FLOAT3[],
                                        unsigned short *);
void	      GD2d_draw_lines     (GDstate *, xp_long,
                                   SHORT2[], FLOAT3[], FLOAT3[]);
void          GD2d_draw_lines_clipped (GDstate *, xp_long,
                                       FLOAT2[], FLOAT3[], FLOAT3[],
                                       unsigned short *);
void	      GD2d_draw_polyline  (GDstate *, xp_long,
                                   SHORT2[], FLOAT3[], FLOAT3[], int);
void          GD2d_draw_polyline_clipped (GDstate *, xp_long,
                                          FLOAT2[], FLOAT3[], FLOAT3[],
                                          int, unsigned short *);
void	      GD2d_draw_fillrects (GDstate *, xp_long, SHORT2[], FLOAT3[]);
void	      GD2d_draw_rects     (GDstate *, xp_long, SHORT2[], FLOAT3[]);
void          GD2d_clip_line      (GDstate *, FLOAT2[]);

/*--------------------- in gd/sw/im_draw.c ------------------------------*/

/* per tile image struct */
typedef struct _im_tile_t
{
  int   visible, dithered;
  int   geom[4];
  byte  *data, *sdata;
  short *scans;
} im_tile_t;

int GDsw_image_draw		(GDgeom_data *, GDstate *,
                                 byte **, int *, short **, int *);
int GDsw_image_draw_tiled	(GDgeom_data *, GDstate *,
                                 byte **, int *, int *, im_tile_t **,
                                 short **, int *);
int GDsw_image_scale		(GDstate *, byte *, byte **, int *,
                                 int, int,
                                 xp_long, int, xp_long, int,
                                 int *, int *,
                                 int *, int *, int *, int *,
                                 int *);
int GDsw_image_resize_draw_buffer (GDview *, int, int, byte **, int *);

/*--------------------- in gd/sw/im_rot.[m,c] ---------------------------*/
int GDsw_image_rotate		(GDstate *, byte *, byte **, int *,
                                 int, int,
                                 xp_long, int, xp_long, int,
                                 int *, int *,
                                 int *, int *, int *, int *,
                                 float, short **, int *);

/*--------------------- in gd/sw/im_pscl.c ------------------------------*/
int GDsw_image_point_scale	(GDstate *, byte *, byte **, int *,
                                 int, int,
                                 xp_long, int, xp_long, int,
                                 int, int, int, int,
                                 int *);
int GDsw_image_get_indices	(xp_long, int, xp_long, int,
                                 int, int, int, int,
                                 unsigned int **, unsigned int **,
                                 int *, int *);

/*--------------------- in gd/sw/im_fscl.c ------------------------------*/
int GDsw_image_flat_scale	(GDstate *, byte *, byte **, int *,
                                 int, int,
                                 xp_long, int, xp_long, int,
                                 int, int, int, int,
                                 int *);

/*--------------------- in gd/sw/im_prgb.[m,c] --------------------------*/
int GDsw_image_point_scale_argb	(GDstate *, byte *, byte **, int,
                                 xp_long, int, xp_long, int,
                                 int, int, int, int,
                                 unsigned int *, unsigned int *,
                                 int *);
int GDsw_image_point_scale_rgb	(GDstate *, byte *, byte **, int,
                                 xp_long, int, xp_long, int,
                                 int, int, int, int,
                                 unsigned int *, unsigned int *,
                                 int *);

/*--------------------- in gd/sw/im_pslr.[m,c] --------------------------*/
int GDsw_image_point_scale_byte	  (GDstate *, byte *, byte **, int,
                                   xp_long, int, xp_long, int,
                                   int, int, int, int,
                                   unsigned int *, unsigned int *,
                                   int *);
int GDsw_image_point_scale_short  (GDstate *, byte *, byte **, int,
                                   xp_long, int, xp_long, int,
                                   int, int, int, int,
                                   unsigned int *, unsigned int *,
                                   int *);
int GDsw_image_point_scale_int	  (GDstate *, byte *, byte **, int,
                                   xp_long, int, xp_long, int,
                                   int, int, int, int,
                                   unsigned int *, unsigned int *,
                                   int *);
int GDsw_image_point_scale_xp_long (GDstate *, byte *, byte **, int,
                                   xp_long, int, xp_long, int,
                                   int, int, int, int,
                                   unsigned int *, unsigned int *,
                                   int *);
int GDsw_image_point_scale_float  (GDstate *, byte *, byte **, int,
                                   xp_long, int, xp_long, int,
                                   int, int, int, int,
                                   unsigned int *, unsigned int *,
                                   int *);
int GDsw_image_point_scale_double (GDstate *, byte *, byte **, int,
                                   xp_long, int, xp_long, int,
                                   int, int, int, int,
                                   unsigned int *, unsigned int *,
                                   int *);

/*--------------------- in gd/sw/im_bscl.c ------------------------------*/
int GDsw_image_bilinear_scale	(GDstate *, byte *, byte **, int *,
                                 int, int,
                                 int *, int *,
                                 xp_long, int, xp_long, int,
                                 int *, int *, int *, int *,
                                 int *);
int GDsw_image_get_fractions	(int **);

/*--------------------- in gd/sw/im_sscl.c ------------------------------*/
int GDsw_image_smooth_scale	(GDstate *, byte *, byte **, int *,
                                 int, int,
                                 int *, int *,
                                 xp_long, int, xp_long, int,
                                 int, int, int, int,
                                 int *);

/*--------------------- in gd/sw/im_brgb.[m,c] --------------------------*/
int GDsw_image_bilinear_scale_argb (GDstate *, byte *, byte **, int,
                                    int, int, xp_long, xp_long,
                                    int *, int, int, int, int,
                                    int *);
int GDsw_image_bilinear_scale_rgb  (GDstate *, byte *, byte **, int,
                                    int, int, xp_long, xp_long,
                                    int *, int, int, int, int,
                                    int *);

/*--------------------- in gd/sw/im_bslr.[m,c] --------------------------*/
int GDsw_image_bilinear_scale_byte   (GDstate *, byte *, byte **, int,
                                      int, int, xp_long, xp_long, xp_long,
                                      int *, int, int, int, int,
                                      int *);
int GDsw_image_bilinear_scale_short  (GDstate *, byte *, byte **, int,
                                      int, int, xp_long, xp_long, xp_long,
                                      int *, int, int, int, int,
                                      int *);
int GDsw_image_bilinear_scale_int    (GDstate *, byte *, byte **, int,
                                      int, int, xp_long, xp_long, xp_long,
                                      int *, int, int, int, int,
                                      int *);
int GDsw_image_bilinear_scale_xp_long(GDstate *, byte *, byte **, int,
                                      int, int, xp_long, xp_long, xp_long,
                                      int *, int, int, int, int,
                                      int *);
int GDsw_image_bilinear_scale_float  (GDstate *, byte *, byte **, int,
                                      int, int, xp_long, xp_long, xp_long,
                                      int *, int, int, int, int,
                                      int *);
int GDsw_image_bilinear_scale_double (GDstate *, byte *, byte **, int,
                                      int, int, xp_long, xp_long, xp_long,
                                      int *, int, int, int, int,
                                      int *);

/* Software renderer dither functions defined in dither.c */

void	GDsw_dither_image_argb      (GDstate *, unsigned char *, 
                                     int, int, unsigned char *, int,
                                     short *);
void	GDsw_dither_image_argb_rw   (GDstate *, unsigned char *, int, 
                                     int, unsigned char *, int, int,
                                     int, int, int, int, int, int, int,
                                     short *);
void	GDsw_dither_image_scalar    (GDstate *, int, unsigned char *, 
                                     int, int, unsigned char *, int,
                                     short *);
void	GDsw_dither_image_scalar_rw (GDstate *, int, unsigned char *, 
                                     int, int, unsigned char *,
                                     int, int, int, int, int,
                                     int, int, int, int,
                                     short *);

/* Software renderer dither functions defined in dith_rmp.c */

void	GDsw_dither_image_double    (GDstate *, double *, int, int, 
                                     unsigned char *,
                                     int, int, int, int, int, int,
                                     short *);
void	GDsw_dither_image_float     (GDstate *, float *, int, int, 
                                     unsigned char *,
                                     int, int, int, int, int, int,
                                     short *);
void	GDsw_dither_image_xp_long   (GDstate *, xp_long *, int, int, 
                                     unsigned char *,
                                     int, int, int, int, int, int,
                                     short *);
void	GDsw_dither_image_int       (GDstate *, int *, int, int, 
                                     unsigned char *,
                                     int, int, int, int, int, int,
                                     short *);
void	GDsw_dither_image_short     (GDstate *, short *, int, int, 
                                     unsigned char *,
                                     int, int, int, int, int, int,
                                     short *);
void	GDsw_dither_image_char      (GDstate *, char *, int, int,
                                     unsigned char *,
                                     int, int, int, int, int, int,
                                     short *);
void	GDsw_dither_image_byte      (GDstate *, byte *, int, int, 
                                     unsigned char *,
                                     int, int, int, int, int, int,
                                     short *);
int	GDsw_dither_find_ramp	(GDstate *, PALvirt *, PALramp **);
int	GDsw_dither_get_ramp_byte_lookup	(GDstate *,
							unsigned short **);
int	GDsw_dither_get_ramp_short_lookup	(GDstate *,
							unsigned short **);
int	GDsw_dither_get_ramp_int_lookup		(GDstate *,
                                                 int *, int *,
                                                 double *, float *);

/* Need to fill in defines for functions in these files too !! */

/* Defined in sw_clip.c */
void	GDsw_pt_clip_draw	(GDstate *, xp_long, FLOAT3[], FLOAT4[], FLOAT3[], unsigned int *);
void	GDsw_tri_clip_draw	(GDstate *, xp_long, FLOAT3[], FLOAT4[], FLOAT3[], FLOAT3[],
					FLOAT3[], float *, float *, FLOAT3[],  int, unsigned int *, int);
void	GDsw_lin_clip_draw	(GDstate *, xp_long, FLOAT3[], FLOAT4[], FLOAT3[], FLOAT3[], int,
					unsigned int *, int);

/* Defined in sw_line.c */
void GDsw_lin_draw	(GDstate *, xp_long, FLOAT3[], FLOAT4[], FLOAT3[], FLOAT3[], int, int);
void GDsw_render_line	(GDstate *, xp_long, FLOAT4[], FLOAT3[], int, int, int);
void GDsw_draw_special_line (GDstate *, INT3[], INT3[]);
void GDsw_draw_line	(GDstate *, INT3[], INT3[]);


/* Defined in sw_pnt.c */
void GDsw_pt_draw	(GDstate *, xp_long, FLOAT3[], FLOAT4[], FLOAT3[]);
void GDsw_render_points	(GDstate *, xp_long, FLOAT4[], FLOAT3[]);
void GDsw_draw_point	(GDstate *, INT3, INT3);

/* Defined in sw_sph.c */
void GDsw_sphere_clip	(GDstate *, xp_long, FLOAT4[], FLOAT3[], FLOAT3[], float *, unsigned int *);
void GDsw_sphere_draw	(GDstate *, xp_long, FLOAT4[], FLOAT3[], FLOAT3[], float *);
void GDsw_draw_sphere	(GDstate *, INT3, INT3, FLOAT3);

/* Defined in sw_tri.c */
void GDsw_tri_draw	(GDstate *, xp_long, FLOAT3[], FLOAT4[], FLOAT3[], FLOAT3[], FLOAT3[],
				float *, float *, float *, int, int);
void GDsw_render_tri_flat (GDstate *, xp_long, FLOAT4[], FLOAT3[], int, int);
void GDsw_render_tri_fill (GDstate *, xp_long, FLOAT4[], FLOAT3, int, int);
void GDsw_render_tri	(GDstate *, xp_long, FLOAT4[], FLOAT3[], FLOAT3[], FLOAT3[], FLOAT3[],
				int, float *, float *, int);
int  GDsw_reorder_tri	(INT3[], xp_long[]);
void GDsw_draw_tri	(GDstate *, xp_long[], INT3[], INT3[], INT3[], int);
void GDsw_draw_tri_flat	(GDstate *, xp_long[], INT3[], INT3[], xp_long, int);

/* Defined in sw_util.c */
void GDsw_flip_normals	(xp_long, FLOAT3[], FLOAT3[]);
void GDsw_xform_radii	(xp_long, float[], FLOAT3, FLOAT3, FLOAT3[], FLOAT4[], float[4][4], FLOAT3[]);
void GDsw_xform_clip_check	(GDstate *, xp_long, FLOAT4[], unsigned int *, unsigned int *);
void GDsw_xform_clip_check_pts	(GDstate *, xp_long, FLOAT4[], unsigned int *, unsigned int *);
void GDsw2d_xform_clip_check	(GDstate *, xp_long, FLOAT2[], unsigned short * , int *, int *);
void GDsw2d_xform_clip_check_pts	(GDstate *, xp_long, FLOAT2[], unsigned short * , int *, int *);
void GDsw_compute_light		(GDstate *, xp_long, FLOAT3[], FLOAT3[], FLOAT3[], int);
void GDsw_compute_facet_light	(GDstate *, xp_long, FLOAT3[], FLOAT3[], FLOAT3[]);
void GDsw_constant_light	(GDstate *, xp_long, FLOAT3[]);
void GDsw_const_c3array		(xp_long, FLOAT3, FLOAT3[]);
void GDsw_project_colors	(xp_long, FLOAT3[], INT3[]);
void GDsw_project_same_color	(xp_long, FLOAT3, INT3[]);
void GDsw_project_uvws		(xp_long, float *, INT3[], int, int, int);
void GDsw_project_vert		(FLOAT4, INT3, int, int, float);
void GDsw_project_verts		(xp_long, FLOAT4[], INT3[], int, int, float);
void GDsw_2d_project_verts	(xp_long, FLOAT2[], SHORT2[], int, int, int, int);
void GDsw_2d_project_verts3d	(xp_long, FLOAT3[], SHORT2[], int, int, int, int);
void GDsw_project_radii		(xp_long, FLOAT3[], INT3[], int);
void GDsw_depth_cue		(GDstate *, xp_long, INT3[], FLOAT3[], FLOAT3[], int);
int GDsw_compute_z_partials	(xp_long[3], INT3[], INT3[], int *, int *);
int GDsw_compute_partials	(xp_long[3], INT3[], INT3[], INT3[], int *, int *, int *, int *, int *, int *,
					int *, int *, int *, int *, int *, int *, int *, int *);
void GDsw_gen_power_table	(GDstate *);
void GDsw_validate_lights	(GDstate *);
void GDsw_compute_norms		(xp_long, FLOAT3[], FLOAT3[], FLOAT3[], int, int);
void GDsw_compute_facet_colors	(xp_long, FLOAT3[], FLOAT3[], int);

/* Defined in sw_text.c */
GDtext_extent *GDsw_draw_text (GDstate *, char *, int, FLOAT3, FLOAT3,
				      int, int, unsigned int, float *, int);


/*********************************************************/
/* image definitions referenced in the im_*.[c|m] source */
/*********************************************************/

/* 0 to 1 fractions table size for bilinear interp, nbits in IMAGE_ONE;
   the size of this effects the scaling accuracy (noticable at "large"
   scale factors)
 */
#define IMAGE_ONE  16384
#define IMAGE_ONEB 14

/* scaled integer precision (decimal places, value and roundup value) for
   fixed point muls used in bilinear interp; watchout for overflow!
 */
#define PREC 11
#define FPREC 2048
#define RPREC 1023

/**********************************************/
/* Pixel definitions (public) in gd_str.h     */
/**********************************************/

/* #define DEBUG */

#ifdef DEBUG
#define CHECK_ZERO_TO_255(V,M)						\
   if ((V)[0] > 255 || (V)[0] < 0 || (V)[1] > 255 || (V)[1] < 0 || 	\
       (V)[2] > 255 || (V)[2] < 0)					\
      fprintf(stderr,"not zero to 255: %s: %d %d %d\n",M,(V)[0],(V)[1],(V)[2])

#define CHECK_ZERO_TO_ONE(V,M)						\
   if ((V)[0] > 1.0 || (V)[0] < 0.0 || (V)[1] > 1.0 || (V)[1] < 0.0 || 	\
       (V)[2] > 1.0 || (V)[2] < 0.0)					\
      fprintf(stderr,"not zero to 1: %s: %f %f %f\n",M,(V)[0],(V)[1],(V)[2])
#else

#define CHECK_ZERO_TO_ONE(V,M)
#define CHECK_ZERO_TO_255(V,M)

#endif

#define MAX_VERT_SIZE	32
#define PTRI_VERTS	32
#define POLYGON_VERTS	256
#define RECT_VERTS	32
#define LIN_VERTS	32
#define PT_VERTS	32
#define SPH_VERTS	32

/* Constants for use by 2D clipping routines. */
#define CLIP_LEFT       0x1
#define CLIP_RIGHT      0x2
#define CLIP_BOTTOM     0x4
#define CLIP_TOP        0x8

/* Don't bother with signed z's since they're converted from floats anyway */
#define ZMAX 0xfffe

#define CVT_WORLD_TO_Z(V,ZOFF)	\
   ((V) * ((ZMAX-ZOFF)>>1) + ((ZMAX-ZOFF)>>1))

#define OUT_OUT(O,N)  \
    ((O)[0] == GD_out_masks[N] || (O)[1] == GD_out_masks[N] || \
     (O)[2] == GD_out_masks[N] || (O)[3] == GD_out_masks[N] || \
     (O)[4] == GD_out_masks[N] || (O)[5] == GD_out_masks[N])

/*
 * Fixed point arithmetic routines for pixels (x, y etc.)
 * The key here is to choose a precision that will prevent the largest
 * value from overflowing, but provide enough precision at the low end.
 * We have a different setup for colors and pixels because they have 
 * different requirements.  Color partials can get real big, real fast.
 */
#define PPREC	16
#ifdef DEBUG
#define PINT_TO_FIXED(V)		\
  ((V) > (1 << (32-PPREC-1) - 1) ? 	\
	fprintf(stderr,"point int too large for fixed: %d\n",V) : (V)<<(PPREC))
#else
#define PINT_TO_FIXED(V)		((V)<<(PPREC))
#endif

#define PFIXED_TO_INT_ROUND(V)   (((V)+((1<<((PPREC)-1))-1))>>(PPREC))
#define PFIXED_TO_INT_CLAMP(V)	((V) >> (PPREC))

/* Fixed point arithmetic for colors */
/* Don't forget to change STORE_PIXEL when CPREC is changed! */
/* If CPREC == 16 it overflows for large polygons with vertex colors! */
#define CPREC	12
#ifdef DEBUG
#define CINT_TO_FIXED(V)		\
  ((V) > (1 << (32-CPREC-1) - 1) ? 	\
	fprintf(stderr,"color int too large for fixed: %d\n",V) : (V)<<(CPREC))
#else
#define CINT_TO_FIXED(V)	((V)<<(CPREC))
#endif

#define CFIXED_TO_INT_CLAMP(V)	((V) >> (CPREC))
#define CFIXED_TO_INT_ROUND(V)   (((V)+((1<<((CPREC)-1))))>>(CPREC))

/* Fixed point arithmetic for uvws */
#define UPREC	12
#define UFLOAT_TO_FIXED(V)	((V)*(float)(1<<UPREC))

#define UFIXED_TO_INT_CLAMP(V)	((V) >> (UPREC))
#define UFIXED_TO_INT_ROUND(V)   (((V)+((1<<((UPREC)-1))))>>(UPREC))

/* 
 * This value can't be any higher than 8 because the partials will overflow
 * somewhere.
 */
#define ZPREC 8

#define ZINT_TO_FIXED(V)	((V)<<(ZPREC))
#define ZFIXED_TO_INT_CLAMP(V)	((V) >> (ZPREC))
#define ZFIXED_TO_INT_ROUND(V)   (((V)+(1<<((ZPREC)-1)))>>(ZPREC))

#define FLOAT_TO_PIXEL(P, F) \
{ \
   P= (F) * 256; \
   if (P > 255) \
       P= 255; \
}

#ifdef REN_PIXEL_IS_NOT_INT

#define STORE_PIXEL_CONST(A,ZA,Z,C) \
{ register int _z = ZFIXED_TO_INT_ROUND(Z);	\
   if (*(ZA) <= (_z)) { 			\
      *(ZA) = _z; 				\
      (A)[0] = 0;				\
      (A)[1] = ((C) >> AVS_RED_SHIFT) & 0xff;	\
      (A)[2] = ((C) >> AVS_GREEN_SHIFT) & 0xff;	\
      (A)[3] = ((C) >> AVS_BLUE_SHIFT) & 0xff;	\
   }					\
}

#else

#define STORE_PIXEL_CONST(A,ZA,Z,C) \
{ register int _z = ZFIXED_TO_INT_ROUND(Z);	\
   if (*(ZA) <= (_z)) { 			\
      *(ZA) = _z; 				\
      *(A) = C;					\
   }					\
}

#endif

/*
 * Warning - this stores the image in ARGB format regardless of byte order. 
 * Since the values are fixed point, we are both converting from fixed point
 * and shifting into place at the same time.
 */

#ifdef REN_PIXEL_IS_NOT_INT

#if CPREC < 16
#else
#endif

#else /* not CRAY */

#ifdef AVS_LITTLEENDIAN

#if CPREC < 16

/* 8 bits of color precision and little endian */

/* The STORE_PIXEL_XXX_TRANS macros are smart enough to be coded to use the
   following definitions.  Need to set the shift direction one way if
   CPREC-AVS_XXX_SHIFT is positive and the other way if it is negative */

#define RSHIFT_ (CPREC-AVS_RED_SHIFT)
#define RDIR >>
#define GSHIFT_ (AVS_GREEN_SHIFT-CPREC)
#define GDIR <<
#define BSHIFT_ (AVS_BLUE_SHIFT-CPREC)
#define BDIR <<

#else

#define RSHIFT_ (CPREC-AVS_RED_SHIFT)
#define RDIR >>
#define GSHIFT_ (CPREC-AVS_GREEN_SHIFT)
#define GDIR >>  
#define BSHIFT_ (AVS_BLUE_SHIFT-CPREC)
#define BDIR <<

#endif

#else

#if CPREC < 16 /* if CPREC is 8 to 16 */
#define RSHIFT_ (AVS_RED_SHIFT-CPREC)
#define RDIR <<
#define GSHIFT_ (CPREC-AVS_GREEN_SHIFT)
#define GDIR >>
#define BSHIFT_ (CPREC-AVS_BLUE_SHIFT)
#define BDIR >>

#else /* if CPREC is 16 to 24 */

#define RSHIFT_ (CPREC-AVS_RED_SHIFT)
#define RDIR >>
#define GSHIFT_ (CPREC-AVS_GREEN_SHIFT)
#define GDIR >>
#define BSHIFT_ (CPREC-AVS_BLUE_SHIFT)
#define BDIR >>

#endif /* CPREC */

#endif /* AVS_BIG/LITTLE_ENDIAN */

#endif /* not CRAY */


#ifdef REN_PIXEL_IS_NOT_INT

#define STORE_PIXEL(A,ZA,Z,R,G,B) \
{ register int _z = ZFIXED_TO_INT_ROUND(Z);	\
   if (*(ZA) <= (_z)) { 			\
      *(ZA) = _z; 				\
      (A)[0]  = 0;			 	\
      (A)[1]  = (R) >> CPREC;		 	\
      (A)[2]  = (G) >> CPREC;		 	\
      (A)[3]  = (B) >> CPREC;		 	\
   }						\
}
   
#else

#define STORE_PIXEL(A,ZA,Z,R,G,B) \
{ register int _z = ZFIXED_TO_INT_ROUND(Z);	\
   if (*(ZA) <= (_z)) { 			\
      *(ZA) = _z; 				\
      *(A) = (((R) RDIR RSHIFT_ ) & AVS_RED_MASK) | 	\
	     (((G) GDIR GSHIFT_ ) & AVS_GREEN_MASK) |   \
	     (((B) BDIR BSHIFT_ ) & AVS_BLUE_MASK);	\
   }						\
}

#endif

/* Just update the color - no z */

#ifdef REN_PIXEL_IS_NOT_INT

#define STORE_PIXEL_NO_Z(A,R,G,B) \
{ \
      (A)[0]  = 0;			 	\
      (A)[1]  = (R) >> CPREC;			 	\
      (A)[2]  = (G) >> CPREC;			 	\
      (A)[3]  = (B) >> CPREC;			 	\
}

#else

#define STORE_PIXEL_NO_Z(A,R,G,B) \
{ \
       *(A) = (((R) RDIR RSHIFT_ ) & AVS_RED_MASK) | 	\
	     (((G) GDIR GSHIFT_ ) & AVS_GREEN_MASK) |   \
	     (((B) BDIR BSHIFT_ ) & AVS_BLUE_MASK);	\
}

#endif

/* Just update the Z value -- don't draw the thing */
#define STORE_PIXEL_Z(ZA,Z) \
{ register int _z = ZFIXED_TO_INT_ROUND(Z);	\
   if (*(ZA) <= (_z)) { 			\
      *(ZA) = _z; 				\
   }						\
}

/* 
   This macro writes a pixel value blending it into the existing one.
   It does not store the z-value as it assumes that transparent objects
   are written after all opaque ones.
   */

#ifdef REN_PIXEL_IS_NOT_INT

#define STORE_PIXEL_TRANS(A,ZA,Z,R,G,B,T,IT) \
{ if (*(ZA) <= ZFIXED_TO_INT_ROUND(Z)) { 		      \
      (A)[0]  = 0;			 		\
      (A)[1]  = ((A)[1] * (T) + ((R)>>CPREC) * (IT)) >> CPREC; 	\
      (A)[2]  = ((A)[2] * (T) + ((G)>>CPREC) * (IT)) >> CPREC; 	\
      (A)[3]  = ((A)[3] * (T) + ((B)>>CPREC) * (IT)) >> CPREC; 	\
   }							\
}

#else

#define STORE_PIXEL_TRANS(A,ZA,Z,R,G,B,T,IT) \
{ if (*(ZA) <= ZFIXED_TO_INT_ROUND(Z)) { 		      \
      *(A)=((((((*(A) & AVS_RED_MASK  )>>AVS_RED_SHIFT  )*(T)) +      \
		(R>>CPREC)*(IT)) RDIR RSHIFT_) & AVS_RED_MASK  ) |       \
           ((((((*(A) & AVS_GREEN_MASK)>>AVS_GREEN_SHIFT)*(T)) +      \
		(G>>CPREC)*(IT)) GDIR GSHIFT_) & AVS_GREEN_MASK) |       \
           ((((((*(A) & AVS_BLUE_MASK )>>AVS_BLUE_SHIFT )*(T)) +      \
		(B>>CPREC)*(IT)) BDIR BSHIFT_) & AVS_BLUE_MASK );       \
   }						\
}

#endif

#ifdef REN_PIXEL_IS_NOT_INT

#define STORE_PIXEL_TRANS_NO_Z(A,R,G,B,T,IT) \
{ \
      (A)[0]  = 0;				 	\
      (A)[1]  = ((A)[1] * (T) + ((R)>>CPREC) * (IT)) >> CPREC; 	\
      (A)[2]  = ((A)[2] * (T) + ((G)>>CPREC) * (IT)) >> CPREC; 	\
      (A)[3]  = ((A)[3] * (T) + ((B)>>CPREC) * (IT)) >> CPREC; 	\
}

#else

#define STORE_PIXEL_TRANS_NO_Z(A,R,G,B,T,IT) \
{ \
      *(A)=((((((*(A) & AVS_RED_MASK  )>>AVS_RED_SHIFT  )*(T)) +      \
		(R>>CPREC)*(IT)) RDIR RSHIFT_) & AVS_RED_MASK  ) |       \
           ((((((*(A) & AVS_GREEN_MASK)>>AVS_GREEN_SHIFT)*(T)) +      \
		(G>>CPREC)*(IT)) GDIR GSHIFT_) & AVS_GREEN_MASK) |       \
           ((((((*(A) & AVS_BLUE_MASK )>>AVS_BLUE_SHIFT )*(T)) +      \
		(B>>CPREC)*(IT)) BDIR BSHIFT_) & AVS_BLUE_MASK );       \
}

#endif

#ifdef REN_PIXEL_IS_NOT_INT

#define STORE_PIXEL_CONST_TRANS(A,ZA,Z,RIT,GIT,BIT,T) \
{ if (*(ZA) <= ZFIXED_TO_INT_ROUND(Z)) { 		      \
      (A)[0]  = 0;				 	\
      (A)[1]  = (A)[1] * (T) + ((RIT) >> CPREC);		 	\
      (A)[2]  = (A)[2] * (T) + ((GIT) >> CPREC); 			\
      (A)[3]  = (A)[3] * (T) + ((BIT) >> CPREC); 			\
   }						\
}

#else

#define STORE_PIXEL_CONST_TRANS(A,ZA,Z,RIT,GIT,BIT,T) \
{ if (*(ZA) <= ZFIXED_TO_INT_ROUND(Z)) { 		      \
      *(A)=((((((*(A) & AVS_RED_MASK  )>>AVS_RED_SHIFT  )*(T)) +      \
		(RIT)) RDIR RSHIFT_) & AVS_RED_MASK  ) |       \
           ((((((*(A) & AVS_GREEN_MASK)>>AVS_GREEN_SHIFT)*(T)) +      \
		(GIT)) GDIR GSHIFT_) & AVS_GREEN_MASK) |       \
           ((((((*(A) & AVS_BLUE_MASK )>>AVS_BLUE_SHIFT )*(T)) +      \
		(BIT)) BDIR BSHIFT_) & AVS_BLUE_MASK );       \
   }						\
}

#endif

/* Find address of pixel at specified coordinates. */

#ifdef REN_PIXEL_IS_NOT_INT

#define CVT_PIXEL_TO_ADDR(X,Y) (((X)+(Y)*state->width) * 4 \
				+ (unsigned char*)SW_STATE_PIX(state))

#else

#define CVT_PIXEL_TO_ADDR(X,Y) ((X)+(Y)*state->width+SW_STATE_PIX(state))

#endif

#define CVT_PIXEL_TO_ZADDR(X,Y) ((X)+(Y)*state->width+SW_STATE_ZPIX(state))


/* Increment a RPIXEL pointer by specified number of pixels. */
/* Versions for in-place and part of expression. */

#ifdef REN_PIXEL_IS_NOT_INT
#define INCR_RPIXEL_PTR(ptr,incr) (ptr) += ((incr) * 4)
#define RPIXEL_PTR_PLUS(ptr,incr) ((ptr) + (incr) * 4)
#else
#define INCR_RPIXEL_PTR(ptr,incr) (ptr) += (incr)
#define RPIXEL_PTR_PLUS(ptr,incr) ((ptr) + (incr))
#endif


#ifndef MIN
#define MIN(A,B)	((A) < (B) ? (A) : (B))
#define MAX(A,B)	((A) > (B) ? (A) : (B))
#endif

#define REN_2D_TEXTURE_MAP 1
#define REN_3D_TEXTURE_MAP 2

#define REN_LINE_NO_DRAW   1
#define REN_LINE_DRAW_FUNC 2
#define REN_LINE_DRAW_FUNC_Z 3

#define REN_LABEL_DRAW_FUNC 1

#define REN_USER_PIXMAP 1
#define REN_USER_ZPIXMAP 2

#ifdef __cplusplus
}
#endif

/*---------------------------------------------------------------------*/

#endif
