/*
			Copyright (c) 2002 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/hdf5/xp_mods/h5_xp.h#1 $
*/

#ifdef WIN32

#if     __STDC__
typedef long off_t;
#endif

/* define this if using the HDF5 DLL: hdf5dll.lib/hdf5dll.dll */
/* #define _HDF5USEDLL_ */

#endif

#include <hdf5.h>


/* h5_utils.c */

hid_t HDF5probe_attribute(hid_t parent_id, const char *name, int close_flag);
hid_t HDF5probe_dataset(hid_t parent_id, const char *name, int close_flag);
hid_t HDF5probe_group(hid_t parent_id, const char *name, int close_flag);

#define probe_attribute HDF5probe_attribute
#define probe_dataset   HDF5probe_dataset
#define probe_group     HDF5probe_group

void HDF5map_dtypes_rd( hid_t h5_dtype_file, hid_t *h5_dtype_app, int *dtype );
void HDF5map_dtypes_wr( hid_t h5_dtype_file, hid_t *h5_dtype_app, int *dtype );

int HDF5read_int_attr( hid_t parent_id, const char *name, int *value );
int HDF5read_string_attr( hid_t parent_id, const char *name, char **value );
int HDF5read_int_array_attr( hid_t h5_root_id, const char *name, xp_long *n, int **arr_ptr );
#ifdef WORDLENGTH_64
int HDF5read_int64_attr( hid_t parent_id, const char *name, xp_long *value );
int HDF5read_int64_array_attr( hid_t h5_root_id, const char *name, xp_long *n, xp_long **arr_ptr );
#endif

void HDF5write_int_attr( hid_t parent_id, const char *name, int value );
void HDF5write_string_attr( hid_t parent_id, const char *name, const char *value );
void HDF5write_int_array_attr( hid_t parent_id, const char *name, int *array, xp_long size );
#ifdef WORDLENGTH_64
void HDF5write_int64_attr( hid_t parent_id, const char *name, xp_long value );
void HDF5write_int64_array_attr( hid_t parent_id, const char *name, xp_long *array, xp_long size );
#endif

int HDF5read_dims( hid_t h5_root_id, xp_long **fld_dims_ptr );

#ifdef WORDLENGTH_64

	/* This may be splitting hairs, but this module has a consistent
	 * convention of distinguishing between the types the application
         * (AVS/Express) uses, e.g., a C long, and the types used to 
	 * represent the data in the files, e.g, int32 or int64.
         * So xx_XP_LONG_g is the application type and XP_LONG_F_g
         * is the file type.  The _g is an HDF5 convention meaning global.
         */

	#define	H5T_NATIVE_XP_LONG_g        H5T_NATIVE_LONG_g
	#define	H5T_NATIVE_XP_LONG_F_g      H5T_NATIVE_INT64_g

	#define	HDF5read_long_attr          HDF5read_int64_attr
	#define	HDF5read_long_array_attr    HDF5read_int64_array_attr

	#define	HDF5write_long_attr         HDF5write_int64_attr
	#define HDF5write_long_array_attr	HDF5write_int64_array_attr

#else /* 32-bit platforms */

	#define	H5T_NATIVE_XP_LONG_g        H5T_NATIVE_INT_g
	#define	H5T_NATIVE_XP_LONG_F_g      H5T_NATIVE_INT32_g

	#define	HDF5read_long_attr          HDF5read_int_attr
	#define	HDF5read_long_array_attr    HDF5read_int_array_attr

	#define	HDF5write_long_attr         HDF5write_int_attr
	#define HDF5write_long_array_attr	HDF5write_int_array_attr

#endif
