/*
  		Copyright (c) 1995 by
  		Advanced Visual Systems Inc.
  		All Rights Reserved

  This software comprises unpublished confidential information of
  Advanced Visual Systems Inc. and may not be used, copied or made
  available to anyone, except in accordance with the license
  under which it is furnished.
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include "ui/import.h"

/*
 * file: import.C
 * purpose: Implement UIimport class, see UIimport.h
 *
 */

// routine: UIimport::UIimport
// purpose: Constructor
//
UIimport::UIimport( OMobj_id object )
         : UIwindow( object )
{
	_classType = "UIimport";
}

// routine: UIimport::~UIimport
// purpose: Destructor
//
UIimport::~UIimport()
{
}

// routine: UIimport::onObjectCreate
// purpose:
//
void UIimport::onObjectCreate( Widget hWnd, OMobj_id )
{
    // Set Core Resources
    //
    UIsetCoreResources( ObjId, hWnd, -1 );

    // Disable the Drag and drop assigned to MB2
    //
    DragAndDropDisable( hWnd );

    // Call UIwindow's onObjectCreate to wrap things up...
    //
    UIwindow::onObjectCreate( hWnd);
}

void UIimport::onObjectCreate( Widget hWnd)
{
    // Set Core Resources
    //
    UIsetCoreResources( ObjId, hWnd, -1 );

    // Disable the Drag and drop assigned to MB2
    //
    DragAndDropDisable( hWnd );

    // Call UIwindow's onObjectCreate to wrap things up...
    //
    UIwindow::onObjectCreate( hWnd);
}

// routine: UIimport::updateObject
// purpose:
//
void UIimport::updateObject( OMobj_id object )
{
    UIwindow::updateObject( GetMaxSeqNum( object, "update") );
}

void UIimport::updateObject( int seqNum )
{
    UIwindow::updateObject( seqNum );
}

// routine: UIimport::destroyObject
// purpose:
//
void UIimport::destroyObject( OMobj_id )
{
    UIwindow::destroyObject();
}

void UIimport::destroyObject()
{
    UIwindow::destroyObject();
}

// routine: UIimport::GetParentWindow
// purpose:
//
Widget UIimport::GetParentWindow( OMobj_id )
{
    return getParentWidget();
}

// routine: UIimport::GetWindowName
// purpose:
//
void UIimport::GetWindowName( OMobj_id object, char *name, int maxlen )
{
    OMobj_name ElemIdName;
    OMget_obj_name( object, &ElemIdName );
    strncpy( name, OMname_to_str(ElemIdName), maxlen );
}

// routine: UIimport::GetWindowSize
// purpose:
//
void UIimport::GetWindowSize( OMobj_id object, int &width, int &height )
{
    if( !UIgetOMWindowWidth( object, &width ) )
      width = 200;

    if( !UIgetOMWindowHeight( object, &height ) )
      height = 200;
}

// routine: UIimport::GetWindowWidth
// purpose:
//
void UIimport::GetWindowWidth( OMobj_id object, int &width, int defaultWidth )
{
    if( !UIgetOMWindowWidth( object, &width ) )
      width = defaultWidth;
}

// routine: UIimport::GetWindowHeight
// purpose:
//
void UIimport::GetWindowHeight( OMobj_id object, int &height, int defaultHeight )
{
    if( !UIgetOMWindowHeight( object, &height ) )
      height = defaultHeight;
}
