/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/motif_ui/ui/wind.h#1 $
*/
//-*-Mode: C++;-*-
#ifndef _wind_h
#define _wind_h

#include "core.h"


// UI_UPDATE macro implements type safe update entry function for OM
// access. If Mask == OM_EVENT_INST, this is always called from an 
// instancing of the module. Otherwise we need to check the validity of
// the object instance and if the actual widget was constructed.

#define UI_UPDATE(TYPE) \
int \
TYPE##Update( OMobj_id ObjId, OMevent_mask Mask, int SeqNum) \
{	TYPE *ui; \
	if(Mask & OM_EVENT_INST) { \
		ui = new TYPE(ObjId); \
		ui->instanceObject(); \
		return 1; \
	} \
	else if(!(ui = (TYPE *)UIobjIdToClass( ObjId ))) { \
		ui = new TYPE(ObjId); \
	} \
	if( !ui->handle.widget() ) \
		ui->instanceObject(); \
	else \
		ui->updateObject( SeqNum ); \
	return 1; \
}

int UIwindDestroy(OMobj_id);

enum MStates { Inactive, Tracking, Translating, Scaling };

class UIinteractor;

class UIwindow : public UIcore {
  public:
    UIwindow(OMobj_id);
    virtual ~UIwindow();

    // Virtual functions common to all UIwindow objects
	virtual Boolean		instanceObject() = 0;
	virtual void		updateObject(int);
	virtual void		rebuildObject(Widget);
	virtual void		onObjectCreate(Widget);
	virtual void		destroyObject();
	virtual void		addLayoutEditorEventHandlers(Widget);
	virtual void		autoPlacementManager(Widget, int *,  int *); 

	// returns UIclass type info for upcast verification
	virtual ClassType &	classType() { return _classType; }
	// Returns NULL if no parent and arg True, else returns HiddenManagerShell
	virtual Widget		getParentWidget();

  private:
	void			destroyFunc();
	Boolean			widgetOK(); // True if realized and not being destroyed
  public:
	Boolean			OK();	// Self check method, call to verify class integrity.
	static Boolean		widgetOK( Widget ); // Static version
	UtString		name(); // return name of object

  public:
	// Xt Event Handlers, must be static void type
	static void		onButDown(Widget, XtPointer, XButtonEvent *);
	static void		onButUp(Widget, XtPointer, XButtonEvent *);
	static void		onMap(Widget, XtPointer, XMapEvent *);
	static void		onMouseMove(Widget, XtPointer, XMotionEvent *);
	static void		drawStatBarText(Widget, String);

	// State variables
  protected:
	int			AlreadyHasChild;
	Widget			ThisWidget; // Where should this be ???? 
	Widget			ParentWnd; // Parent widget (of top widget in class)
	static MStates		MouseState;
	Widget			MessageWindow; // Widget Id of closest message widget
  public:
	UIinteractor *		Interactors;
	int			State;
	Cardinal		InsertPosition;
	ClassType		_classType; // UtString class ID
  private:
	UIwindow *		_self;	// Pointer to self used to check ctor
};

inline UtString
UIwindow::name() {
	if( !OMis_null_obj( ObjId ) ) {
		OMobj_name objName;
		OMget_obj_name( ObjId, &objName );
		return OMname_to_str(objName);
	}
	else return "Null Object";
}

#endif
