//
//  This file is under Perforce control
//  $Id: //depot/express/fcs70/tutor/mfc/geomview.v#1 $
//
//  geomview.v - Defines objects used by the "Integrating with a
//               Microsoft Visual C++ Application" tutorial in the
//               AVS/Express 3.1 Release Notes.
//
//---------------------------------------------------------------------//
//
//  All objects are contained in an flibrary called GEOMVIEW.
//
//  The definition of each OMX class in the flibrary is placed into the
//  file indicated by the out_hdr_file property.
//
//  The implementation of each OMX class in the flibrary is placed into
//  the file indicated by the out_src_file property.
//

flibrary+global GEOMVIEW <
    out_hdr_file = "geomviewOMX.h",
    out_src_file = "geomviewOMX.cxx"
> {

    // The CGeomFileReader object is exported as an OMX class.  It
    // reads an AVS geometry file and produces a renderable object.
    //
    // Inputs:
    //
    //   filename - The name of the AVS geometry file to be read
    //
    // Outputs:
    //
    //   obj - The renderable object, which can be used as an
    //         input for a viewer.

    macro CGeomFileReader <export_cxx=3> {
        string filename <export=2>;
        ACread_geom ACread_geom {
            array_flag = 0;
            filename => <-.filename;
        };
        GDM.DataObject DataObject {
            in => <-.ACread_geom.out_field;
        };
        olink obj <export=2> => .DataObject.obj;
    };

    // The C3DViewer object is exported as an OMX class.  It can render
    // objects produced by the CGeomFileReader object (or any other
    // DataObject).  It can also respond to paint, size, and mouse
    // messages.
    //
    // Inputs:
    //
    //   handle.window
    //   handle.widget - Both of these must be set to the handle (m_hWnd)
    //                   of the MFC window into which rendering is to be
    //                   performed.
    //
    //   handle.event - A trigger object that allows the viewer to respond
    //                  to certain messages.  The object should be set to
    //                  1 when the window handle is assigned.  The object
    //                  should be set to 2 when the window receives a size
    //                  message.  The object should be set to 3 when the
    //                  window receives a paint message.
    //
    //   handle.hdc - This object is currently unused, but its value
    //                should be set to 0 when the window handle is assigned.
    //
    //   objs - This is a reference to the objects that are to be rendered.
    //
    //   The state, x, y, and time and mode inputs can be used for modifying
    //   the transformation of rendered objects using the mouse (see the
    //   reference documentation for GDtrack_edit for more details):
    //
    //   state - Indicates the state of a mouse drag.  The object should be
    //           set to 1 when the window receives a button-down message.
    //           The object should be set to 2 when the mouse moves while
    //           the button is down.  The object should be set to 3 when
    //           the window receives a button-up message.
    //
    //   x, y - Indicates the coordinates of the mouse, relative to the
    //          origin of the window, during a mouse drag.
    //
    //   time - Indicates the current time, during a mouse drag.
    //
    //   mode - Indicates the action to be performed by the mouse drag:
    //            0 - rotate
    //            1 - scale
    //            2 - XY translate

    macro C3DViewer <export_cxx=3> {
        UIwinHandle handle {
            window <export=3>;
            widget <export=3>;
            event <export=3>;
            hdc <export=3>;
        };
        imlink objs <export=2>;
        GDM.Mscene3D scene {
            Top.child_objs => <-.<-.objs;
            View.View.renderer = 0;
            View.View.handle => <-.<-.<-.handle;
        };
        GDtrack_edit track {
            camera => <-.scene.View.View.picked_camera;
            obj => <-.scene.View.View.picked_obj;
            view => <-.scene.View.View;
            mode <export=3>;
            x <export=3>;
            y <export=3>;
            time <export=3>;
            int state <export=3> => .event;
        };
    };
};

//---------------------------------------------------------------------//
//                         End of geomview.v                           //
//---------------------------------------------------------------------//
