/*
	"$Id: //depot/express/fcs70/v/MicroAVS.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS.v#1 $
*/
//
// V definition of the MicroAVS Compatibility Kit
//
$include MicroAVS/defs.v

flibrary+buffered MicroAVS
<
#ifdef MSDOS
   dictionary	= "mavs_sj.dct",	// Hankaku-Katakan included
#else
   dictionary	= "mavs.dct",		// no Hankaku-Katakan included
#endif //MSDOS
   locked	= 1,
   NEvisible	= 0,		// This Release is NOT opened in detail.
   NEeditable	= 0,

   build_dir	= "MicroAVS",
   build_cmd	= "$(MAKE)",
   hdr_code	= "void MAinit (int *argc, char **argv);",
   init_code	= "   MAinit(argc, argv);",
   libdeps	=  "DV GD UI",
#ifdef AC_KIT_V1
   link_files   = "-lmavs -lgeomAPI -lac -lacvt -lgeom -lutil",
#else
   link_files   = "-lmavs -lgeomAPI -lackit -lacvt -lgeom -lutil",
#endif // AC_KIT_V1
   out_hdr_file	= "mavs_gen.h",
   out_src_file	= "mavs_gen.cxx",
   disabled => Templates.CONFIG.mavs_kit_disabled,
   needs_edit_lic="GD DV",
   need_objs    =
"UIdata
 MicroAVS.Functions
 MicroAVS.MAUI
 MicroAVS.MAGD
 MicroAVS.MADV
 MicroAVS.COLORMAP
 MicroAVS.field_cmdtools
 MicroAVS.ucd_cmdtools
 MicroAVS.field_networks
 MicroAVS.ucd_networks
 MicroAVS.readers
 MicroAVS.writers
 MicroAVS.animators
 MicroAVS.viewers
 MicroAVS.applications
 MicroAVS.Demo
 MicroAVS.CONFIG
"
>
{
   $include MicroAVS/data.v
   $include MicroAVS/Funcs/funcs.v
   "MicroAVS/UI/MAUI.v"		MAUI;
   $include MicroAVS/common.v
   "MicroAVS/GD/MAGD.v"		MAGD;
   "MicroAVS/DV/MADV.v"		MADV;
   "MicroAVS/DV/Cmap/cmap.v"	COLORMAP;
   "MicroAVS/Field/fieldnet.v"	field_networks;
   "MicroAVS/Ucd/ucdnet.v"	ucd_networks;
   "MicroAVS/readers.v"		readers;
   "MicroAVS/writers.v"		writers;
   "MicroAVS/DataIO.v"		DataIO;
   "MicroAVS/GD/viewers.v"	viewers;

   "MicroAVS/Appl/appl.v"	applications;
};
