/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Appl/UImenu.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Appl/UImenu.v#1 $
*/
//
// Main Menu
//
macro Menu {
   ilink params => <-.params;

   UImenuSeparator menuSeparator;
   UIcmd Exit {label = "NE_MENU_FILE_EXIT"; message = "NE_MENU_FILE_EXIT_MSG";
               do => params.exit;};
   UIcmdList FileCmdList {
      cmdList => { <-.menuSeparator,<-.Exit };
      label = "MAMFILE_MENU";
   };

#ifdef USE_OPTS_MENU
   UIcmd Config { label = "MAMCFG_MENU";
                 message = "MAMCFG_MSG";
                 do => params.config; };
   UIcmdList OptionsCmdList {
      cmdList => { <-.Config };
      label = "MAMOPTS_MENU";
   };
#endif //USE_OPTS_MENU

   UIcmd Help {label = "MAMHELP_MENU"; message = "MAMHELP_MSG";
               do => params.help; };
#ifdef MSDOS
   UIcmd HelpRW {label = "MAMHELP_RW_MENU"; message = "MAMHELP_RW_MSG";
                 do => params.help_rw; };
   UIhelpCmdList HelpCmdList {
      cmdList => { <-.Help, <-.HelpRW };
      label = "MAMHELP_MENU";
   };
#else
   UIhelpCmdList HelpCmdList {
      cmdList => { <-.Help };
      label = "MAMHELP_MENU";
   };
#endif //MSDOS
   UIcmdList MenuList {
      cmdList => {<-.FileCmdList,
#ifdef USE_OPTS_MENU
                  <-.OptionsCmdList,
#endif //USE_OPTS_MENU
                  <-.HelpCmdList};
   };
};
UIapp+MAUIsizeMinNoCloseDialog MainAppl {
   title  => <-.title;
   x      => <-.params.main_shell_x;
   y      => <-.params.main_shell_y;
   width  => <-.params.main_shell_width;
   height => <-.params.main_shell_height;
   menu   => <-.Menu.MenuList;
   cancel => <-.params.exit_done;
   showStatusBar = 1;
};
AU.AUtoolbar ViewerToolbar<hconnect=2> {
   parent => <-.MainAppl;
   x = 10;
   y = 5;
   width =;
   height =;
   tool_dir = 0;
   templ {
      MAUIbutton button {
         width  = 120;
         int height = 20;
         &labelPixmap;
         color.foregroundColor = MAVS_GREEN;
         color.backgroundColor = "black";
      };
   };
   hconn_list<instanced=0> {
      accept = "viewer_toolbar";
      offer =;
   };
};
