/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Appl/UImstack.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Appl/UImstack.v#1 $
*/
//
// Module Stack
//
macro ModulesStack<ui_global_class=1, export=1> {
   ilink parent => <-.MainAppl;

   MAUIpanel panel {
      parent => <-.parent;
      visible = 1;
      x = 3;
      y => 30 + STATUS_BAR_HEIGHT + 2;
      width => parent.clientWidth - 6;
      height => parent.clientHeight - y;
   };
   MAUIpanel visual {
      parent => <-.panel;
      x = 10;
      y = 0;
      width = 40;
      height = 37;
   };
   MAUIpanel icon {
      parent => <-.visual;
      x = -12;
      y = -2;
      width = 55;
      height = 37;
      pixmap.filename+nres => MAVS_ICON_PATH
         + optionList.cmdList[optionList.selectedItem].icon+".x";
      pixmap.fileType = "avs_image";
   };
   MAUIoptionMenu optionList<hconnect=2,list_class="Modules"> {
      parent => <-.panel;
      radioBehavior = 1;
      x => <-.icon.width + 5;
      y = 5;
      width => parent.clientWidth - .x - 5;
      height = 30;
      GMOD.hconnect hconn_list {
         direction = 1;
         offer_name = "<-";
         accept_name = "<-.cmdList";
         accept = "list (module)";
         offer =;
         skip_levels = 1;
      };
      label = "";
      optionLabel = 0;
      selectedItem = 0;
   };
   MAUIframe frame {
      parent => <-.panel;
      x = 5;
      y => <-.optionList.y + <-.optionList.height + 5; 
      width => .parent.clientWidth - 10;
#ifdef MSDOS
      height => .parent.clientHeight - y - 5;
#else
      height => .parent.clientHeight - y - 15;
#endif //MSDOS
   };
   //
   // Like AVS5, a new module instanced is a most front on ModuleStack.
   //
   GMOD.copy_on_change uptodate_module_panel {
      input => array_size(optionList.cmdList) - 1;
      output => optionList.selectedItem;
      on_inst = 0;
      copy_on_change<weight=3>;
   };
   //
   // UImod_panel connect to a side OutputPort with <widget_class>.
   //
   MAUIscrolledWindow mod_panel<widget_class="widget"> {
      parent => <-.frame;
      width => .parent.clientWidth;
      height => .parent.clientHeight;
      int+nres Vwidth => 
         optionList.cmdList[optionList.selectedItem].width;
      int+nres Vheight => 
         optionList.cmdList[optionList.selectedItem].height + 10;
      virtualWidth =>
       switch(is_valid(Vwidth)+1, .parent.clientWidth * 2, Vwidth);
      virtualHeight =>
       switch(is_valid(Vheight)+1, .parent.clientHeight * 5, Vheight);
   };
};
