/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Appl/UIsbar.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Appl/UIsbar.v#1 $
*/
//
// StatusBar
//
macro StatusBar {
   ilink parent => <-.MainAppl;

   MAUIpanel status_bar_panel {
      parent => <-.parent;
      x = 8;
      y = 30;
      width => STATUS_BAR_WIDTH * 2 + STOP_GO_WIDTH - 2;
      height => STATUS_BAR_HEIGHT;
   };
   MAUIframe running_label_frame {
      parent => <-.status_bar_panel;
      x = 0;
      y = 2;
      width => STATUS_BAR_WIDTH - 4 - 15;
      height = 24;
      update<status=0>;
   };
   GMOD.copy_on_change off_running_message {
      int index => Scheduler.percent_done == 100;
      string run_or_idle[2] => { "MAMRUNNING_MSG", "MAMIDLE_MSG" };
      string on_or_off[2] => { " <------->", run_or_idle[index] };
      string labels[2] => { on_or_off[running_label.set], "MAMDISABLE_MSG" };
      input => labels[StopGoInd];
      output = "MAMIDLE_MSG";
      on_inst = 0;
      copy_on_change<interruptable=0,status=0>;
   };
   MAUIdynamic_toggle running_label {
      parent => <-.running_label_frame;
#ifdef MSDOS
      x = -15;
#else
      x = -20;
#endif //MSDOS
      y = 0;
      width => STATUS_BAR_WIDTH;
      height = 20;
      label => off_running_message.output;
      color.foregroundColor = MAVS_BLUE;
      set => Scheduler.status_check;
      update<interruptable=0,status=0>;
   };
   MAUIframe running_percent_label_frame {
      parent => <-.status_bar_panel;
      x => running_label_frame.x + running_label_frame.width + 2;
      y => running_label_frame.y;
      width => STATUS_BAR_WIDTH;
      height => running_label_frame.height;
      visible => running_label.set;
      update<interruptable=0,status=0>;
   };
   MAUIlabel running_percent_label {
      UImake_dyn_wind UImake_dyn_wind {
         in_handle => <-.handle;
      };
      parent => <-.running_percent_label_frame;
      x => width * (Scheduler.percent_done - 100) / 100;
      y = 0;
      width => running_percent_label_frame.clientWidth;
      height => running_percent_label_frame.clientHeight;
      label = "";
      color.backgroundColor = MAVS_RED;
      visible => Scheduler.percent_done != 100;
      update<interruptable=0,status=0>;
   };
   MAUIlabel running_green_label {
      parent => <-.running_percent_label_frame;
      x = 0;
      y = 1;
      width => running_percent_label_frame.clientWidth;
      height => running_percent_label_frame.clientHeight;
      label => stop_go.label;
      string colors[2] => { MAVS_GREEN, MAVS_YELLOW };
      color.backgroundColor => colors[StopGoInd];
      update<interruptable=0,status=0>;
      alignment = 1;
   };
   MAUIbutton stop_go {
      color.backgroundColor = MAVS_DEF_GRAY;
      UImake_dyn_wind UImake_dyn_wind { in_handle => <-.handle; };
      parent => <-.status_bar_panel;
      x => running_percent_label_frame.x
         + running_percent_label_frame.clientWidth + 8;
      y => running_percent_label_frame.y;
      width => STOP_GO_WIDTH;
      height = 24;
      string labels[] = { "", "MAMINTERRUPT_MSG" };
      label => labels[StopGoInd];
      string pixmaps[] = { MAVS_ICON_PATH+"go.x", MAVS_ICON_PATH+"stop.x" };
      labelPixmap.filename => pixmaps[StopGoInd];
      labelPixmap.fileType = "avs_image";
      update<interruptable=0,status=0>;
      GMOD.parse_v parse_stop_go {
         mode = 0;
         sync = 1;
         v_commands ="$push\nStopGoInd=!StopGoInd;Disabler=StopGoInd;$pop\n";
         trigger => stop_go.do;
         on_inst = 0;
         relative => <-.<-;
         parse_v_relative<interruptable=0,status=0>;
      };
   };
   int Disabler => Scheduler.interrupt;
   boolean StopGoInd = 0;
};
