/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Appl/appl.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Appl/appl.v#1 $
*/
//
// MicroAVS Application of AVS/Express version
//
#define STOP_GO_WIDTH		 38
#define STATUS_BAR_WIDTH	117
#define STATUS_BAR_HEIGHT	 34
#define CONTROL_PANEL_WIDTH	(STATUS_BAR_WIDTH * 2 + STOP_GO_WIDTH)
#define CONTROL_PANEL_HEIGHT	500
//#define USE_OPTS_MENU

flibrary+buffered+sort+global applications <compile_subs=0>
{
   application MicroAVS<NEdisplayMode="maximized">
   {
      GMOD.parse_v init<NEvisible=0> { // why do NOT maximized and unlocked
         v_commands =
            "$push\n"+name_of(<-.<-)+"<NEdisplayMode=\"closed\">;$pop\n"
           +"$push\n"+name_of(<-.<-)+"<NEdisplayMode=\"maximized\">;$pop\n"
           +"$push\n"+name_of(<-.<-)+"<locked=0>;$pop\n"
            ;
//         relative => Root.Applications;
         on_inst = 1;
      };
      MicroAVS.MAdataObj dataObj<NEvisible=0> {
         topWindow => <-.UI.MainAppl;
      };
      macro Params<NEvisible=0> {
         group params {
            UIdecorContainer+nosave *parent => <-.<-.UI.MainAppl;
            boolean         Japanese => !strcmp("MA_LOCALE", "ja_JP");
            boolean+nosave  exit = 0;
            boolean+nosave  exit_done = 0;
            boolean+nosave  help = 0;
            boolean+nosave  help_about = 0;
            boolean+nosave  help_rw = 0;
            boolean+nosave  init_config = 1; // active on_inst
            boolean+nosave  config = 0;
            int+nres main_shell_x => max_array(
              {0, UIdata.UIdisplays[0].width/3-main_shell_width-40});
            int+nres main_shell_y =>
              (UIdata.UIdisplays[0].height-main_shell_height)/2;
            int+nres main_shell_width => min_array(
                        {280, UIdata.UIdisplays[0].width/3});
            int+nres main_shell_height => min_array(
                        {518, UIdata.UIdisplays[0].height*2/3});
         };
         /* add by yasu v7.0
           ̂̕\iMAviewerCX^XꂽMAviwer.MAviewerSetSpecialParamsQƂZbgj*/
         group ModuleParams{
            MAs2t_params s2t_params;
         };
         /* add by yasu v7.0*/
      };
      macro+nosave Control<NEvisible=0>
      {
         ilink dataObj => <-.dataObj;
         ilink params => <-.Params.params;
         macro Exit {
            ilink params => <-.params;
            MAUIquestionDialog ExitDialog {
               parent  => <-.params.parent;
               title   =  "NE_MENU_FILE_EXIT_TITLE";
               message =  "NE_MENU_FILE_EXIT_PROMPT";
               visible => <-.params.exit;
               ok      => <-.params.exit_done;
            };
            GMOD.exit_process ExitMicroAVS {
               do_exit => <-.params.exit_done;
               status = 0;
            };
         };
         macro Help {
            ilink params => <-.params;
            MAmime HelpViewer {
               trigger => <-.params.help;
               stFilename => MAVS_HELP_PATH+"/appl/microavs.htm";
            };
         };
         $include MicroAVS/Appl/helprw.v
#ifdef USE_OPTS_MENU
         $include MicroAVS/Appl/config.v
#endif // USE_OPTS_MENU
      };
      macro+nosave UI <hconnect=2, ui_global_class=1,
                       NEvisible=0, NEx=0, NEy=0>
      {
         ilink params => <-.Params.params;
         string title => "MAMMAIN_TITLE" + " Compatibility";
         $include MicroAVS/Appl/UImenu.v
         $include MicroAVS/Appl/UIsbar.v
         $include MicroAVS/Appl/UImstack.v
      };
   };
};
#undef STATUS_BAR_WIDTH
#undef STATUS_BAR_HEIGHT
#undef STOP_GO_WIDTH
#undef CONTROL_PANEL_WIDTH
#undef CONTROL_PANEL_HEIGHT
