/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/MAcmaplg.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/MAcmaplg.v#1 $
*/
//
// Colormap and Legend
//
MAmacroUI+nosave MAmaplegendUI {
   MAlegend_params_templ &legend_params<NEportLevels={2,1}>;
   MAcolmap_params_templ &colmap_params<NEportLevels={2,1}>;
   //MAGDobject_templ &obj_in<NEportLevels={2,0}>;
   boolean active = 1;

   height => maplegend_panel.height;
   MAUIframe maplegend_panel {
      parent => <-.parent;
      y => <-.y;
      height => 95;
   };
   MAUIlabel label {
      parent => <-.maplegend_panel;
      y = 5;
      label = "MACOLMAP_LABEL";
   };
   MAUIbutton colmap_b {
      parent => <-.maplegend_panel;
      x = 5;
      y => <-.label.y + <-.label.height + 5;
      label = "MACOLMAP_B";
      color.foregroundColor = MAVS_BLUE;
      do => <-.colmap_params.vis;
      active => <-.active;
   };
   MAUIbutton legend_b {
      parent => <-.maplegend_panel;
      x = 5;
      y => <-.colmap_b.y + <-.colmap_b.height + 5;
      label = "MALEGE_B";
#ifdef MSDOS
      color.foregroundColor = "#009900";
#else
      color.foregroundColor = "#006600";
#endif //MSDOS
      do =><-.legend_params.vis;
      active => <-.active;
   };
};

MAmodule MAcmapLegendSet {
   fld_out<NEportLevels=0>;
   MAcolmap_params_templ &colmap_params<NEportLevels={2,1}>;
   MAlegend_params_templ &legend_params<NEportLevels={2,1}>;
   MAGDobject_templ &obj_in<NEportLevels={2,1}>;

   macro MAcolmap {
      ilink fld_in => <-.fld_in;
      MAcolmap_params_templ &colmap_params<NEportLevels={2,1}> => <-.colmap_params;
      MAGDobject_templ &obj_in<NEportLevels={2,0}> => <-.obj_in;
      DatamapTempl &dmap<NEportLevels={1,1}> {
         dataMin<NEportLevels={2,2}> ;
         dataMax<NEportLevels={2,2}> ;
      } => obj_in.dmap;
      //
      // Colormap Process
      //
      $include MicroAVS/DV/Cmap/cmapP.v
      //
      /*** v6.0 ***/
      $include MicroAVS/DV/Cmap/makedmap.v
      /*** end v6.0 ***/
      //
      //
      // Colormap UI
      //
      $include MicroAVS/DV/Cmap/cmapUI.v
   };

   macro MAlegend {
      MAcolmap_params_templ &colmap_params<NEportLevels={2,1}> => <-.colmap_params;
      MAlegend_params_templ &legend_params<NEportLevels={2,1}> => <-.legend_params;
      MAGDobject_templ &obj_in<NEportLevels={2,0}> => <-.obj_in;
      link vis => .legend_params.vis;
      float curMin => switch(legend_params.color_fit+1,
                             colmap_params.curmin,
                             colmap_params.min_col_val);
      float curMax => switch(legend_params.color_fit+1,
                             colmap_params.curmax,
                             colmap_params.max_col_val);

      $include MicroAVS/DV/Cmap/legendP.v
      $include MicroAVS/DV/Cmap/legendUI.v

      olink obj => GroupObject.Top;
   };
   olink legend_out=>MAlegend.obj;
};

//
// Colormap and Legend for Volume Rendering
//
MAcmapLegendSet MAcmapVolLegendSet {
   MAcolmap_params_templ &colmap_params<NEportLevels={2,1}>;
   MAlegend_params_templ &legend_params<NEportLevels={2,1}>;
   MAGDobject_templ &obj_in<NEportLevels={2,1}>;

   MAcolmap {
      max_color_index = 3; // for Volume Rendering

      MAvolren_params &volren_params;

     set_dmap{
        points => (1+(.volren_params.border == .colmap_params.min_col_val) 
                     + ((.volren_params.border == .colmap_params.max_col_val) * 2));

        MAvolren_params &volren_params => <-.volren_params;
        
        
        GMOD.parse_v set_colormap {
            trigger => <-.node_value || <-.coord_value;
            relative => <-.<-;
            on_inst = 0;
            active => ((is_valid(<-.node_value)*is_valid(<-.coord_value)) * <-.colmap_params.UI_active);
            v_commands =>  "$push -usr\n"
                     /**** end v6.0 2002.01.21 add ****/
                     +"copy_Makedmap_max { trigger = 1;};\n"
                     +"copy_Makedmap_min { trigger = 1;};\n"
                     //+"MakeDmap.mode=1;\n"
                     +"$pop\n"
                     +"$push -usr\n"
                     /**** end v6.0 2002.01.21 add ****/
                     +"MakeDmap.regen=1;\n"
                     +"TransferFunction{PointMesh { nnodes = 4 ;};};\n"
                     +"TransferFunction{ PointMesh { coordinates { values = <-.<-.<-.set_dmap.coord_value ;};};}; \n"
                     +"set_dmap{ PointMesh { !node_data[0] { values = <-.<-.<-.set_dmap.node_value; };};};\n"
                     +"$pop\n"
                     +"$push -usr\n"
                     +"MakeDmap.refresh=1;\n"
                     +"$pop\n"
                     +"$push -usr\n"
                     +"colmap_params {UI_active = 1;};"
                     +"$pop\n";
         };
      
         GMOD.hsv_to_rgb min_high_hsv_to_rgb{
            h => switch((((<-.colmap_params.max_col_val - <-.colmap_params.min_col_val) == 0 )+ 1),
            (((<-.colmap_params.max_h * (<-.volren_params.border - <-.colmap_params.min_col_val)) 
            + (<-.colmap_params.min_h * (<-.colmap_params.max_col_val - <-.volren_params.border)))
            / (<-.colmap_params.max_col_val - <-.colmap_params.min_col_val)),<-.colmap_params.max_h);
            s => switch((((<-.colmap_params.max_col_val - <-.colmap_params.min_col_val) == 0 )+ 1),
            (((<-.colmap_params.max_s * (<-.volren_params.border - <-.colmap_params.min_col_val)) 
            + (<-.colmap_params.min_s * (<-.colmap_params.max_col_val - <-.volren_params.border)))
            / (<-.colmap_params.max_col_val - <-.colmap_params.min_col_val)),<-.colmap_params.max_h);
            v =>switch((((<-.colmap_params.max_col_val - <-.colmap_params.min_col_val) == 0 )+ 1),
            (((<-.colmap_params.max_v * (<-.volren_params.border - <-.colmap_params.min_col_val)) 
            + (<-.colmap_params.min_v * (<-.colmap_params.max_col_val - <-.volren_params.border)))
            / (<-.colmap_params.max_col_val - <-.colmap_params.min_col_val)),<-.colmap_params.max_h);
         };
 
         float node_value[] => 
         switch(points,
           switch( ((col_val_size == 0) + 1), 
              {.min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
              .min_high_hsv_to_rgb.r,.min_high_hsv_to_rgb.g,.min_high_hsv_to_rgb.b,
              .min_high_hsv_to_rgb.r,.min_high_hsv_to_rgb.g,.min_high_hsv_to_rgb.b,
              .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b},
              {.min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
              .min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
              .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b,
              .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b}
           ),
           {.min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
            .min_high_hsv_to_rgb.r,.min_high_hsv_to_rgb.g,.min_high_hsv_to_rgb.b,
            .min_high_hsv_to_rgb.r,.min_high_hsv_to_rgb.g,.min_high_hsv_to_rgb.b,
            .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b},
         
           {.min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
            .min_high_hsv_to_rgb.r,.min_high_hsv_to_rgb.g,.min_high_hsv_to_rgb.b,
            .min_high_hsv_to_rgb.r,.min_high_hsv_to_rgb.g,.min_high_hsv_to_rgb.b,
            .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b},
         
           {.min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
            .min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b
            .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b
            .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b}
           );

      coord_value[] => 
       switch( .points,
          {(((.colmap_params.min_col_val - .colmap_params.curmin) * 255.0) / cur_size),
               .volren_params.low_min,
              (((<-.volren_params.border - .colmap_params.curmin) * 255.0) / cur_size),
               .volren_params.low_max,
              (((<-.volren_params.border - .colmap_params.curmin) * 255.0) / cur_size),
               .volren_params.high_min,
              (((.colmap_params.max_col_val - .colmap_params.curmin) * 255.0) / cur_size),
              .volren_params.high_max
             },
             
             {switch(((.colmap_params.curmin == .colmap_params.min_col_val) + 1),0,-1),
             .volren_params.low_min,
             (((<-.volren_params.border - .colmap_params.curmin) * 255.0) / .cur_size),
             .volren_params.low_max,
             (((<-.volren_params.border - .colmap_params.curmin) * 255.0) / .cur_size),
             .volren_params.high_min,
             (((<-.colmap_params.max_col_val - .colmap_params.curmin) * 255.0) / .cur_size),
             .volren_params.high_max
             },
             
             {(((<-.colmap_params.min_col_val - .colmap_params.curmin) * 255.0) / .cur_size),
             .volren_params.low_min,
             (((<-.volren_params.border - .colmap_params.curmin) * 255.0) / .cur_size),
             .volren_params.low_max,
             (((<-.volren_params.border - .colmap_params.curmin) * 255.0) / .cur_size),
             .volren_params.high_min,
             switch(((.colmap_params.curmax == .colmap_params.max_col_val) + 1),255,256),
             .volren_params.high_max
             },
             
             {switch(((cur_size == 0)+(.colmap_params.curmin == .colmap_params.min_col_val)+1),0,-1,-1),
             .volren_params.low_min,
             switch(((cur_size == 0) + 1),(((<-.volren_params.border - .colmap_params.curmin) * 255.0) / .cur_size),0),
             .volren_params.low_max,
             switch(((cur_size == 0) + 1),(((<-.volren_params.border - .colmap_params.curmin) * 255.0) / .cur_size),0),
             .volren_params.low_max,
             switch(((cur_size == 0)+(.colmap_params.curmax == .colmap_params.max_col_val)+1),255,256,256),
             .volren_params.low_max
             }
          );
          
     };
       

      GMOD.copy_on_change copy_model_low {
         input => !(<-.volren_params.model);
         output+nres => <-.dmap.DataRange[0].selectAlphaRange;
      };
      GMOD.copy_on_change copy_model_high {
         input => !(<-.volren_params.model);
         output+nres => <-.dmap.DataRange[1].selectAlphaRange;
      };      

      GMOD.copy_on_change copy_size_low {
         input => <-.colmap_params.color_size/2;
         output =><-.dmap.ranges[0].size;
      };
      GMOD.copy_on_change copy_size_high {
         input => <-.colmap_params.color_size/2;
         output => <-.dmap.ranges[1].size;
      };
      
      /*** v6.0 
      GMOD.copy_on_change copy_min_val {
         input => <-.colmap_params.min_col_val;
         output =><-.dmap.ranges[0].UIMinValue;
      };
      GMOD.copy_on_change copy_max_val {
         input => <-.colmap_params.max_col_val;
         output =><-.dmap.ranges[1].UIMaxValue;
      };
      end v6.0 ***/
      
   };
};
