/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/brick3d.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source:$
*/
//
// Colormap and Legend for Brick3D
//
MAmodule MAcmapBrickLegendSet {
   fld_out<NEportLevels=0>;
   MAcolmap_params_templ &colmap_params<NEportLevels={2,1}>;
   MAlegend_params_templ &legend_params<NEportLevels={2,1}>;
   MAGDobject_templ &obj_in<NEportLevels={2,1}>;

   macro MAcolmap {
      ilink fld_in => <-.fld_in;
      MAcolmap_params_templ &colmap_params<NEportLevels={2,1}> => <-.colmap_params;
      MAGDobject_templ &obj_in<NEportLevels={2,0}> => <-.obj_in;
      DatamapTempl &dmap<NEportLevels={1,1}> {
         dataMin<NEportLevels={2,2}>;
         dataMax<NEportLevels={2,2}>;
      } => obj_in.dmap;
      //
      // Colormap Process
      //
      /*** v6.0 $include MicroAVS/DV/Cmap/cmapP.v ***/
      /*** v6.0b 2001.01.18 add  $include MicroAVS/DV/Cmap/cmapBP1.v  ***/
      $include MicroAVS/DV/Cmap/cmapP.v
      /*** v6.0b 2001.01.18 add   ***/
      $include MicroAVS/DV/Cmap/cmapBP.v
       /*** v6.0b 2001.01.18 add   ***/
      $include MicroAVS/DV/Cmap/makedmap.v
       /*** end v6.0b 2001.01.18 add   ***/
      //
      // Colormap UI
      //
      $include MicroAVS/DV/Cmap/cmapUI.v
      olink colormap_out => colormapA;
   };
   olink colormap_out => MAcolmap.colormap_out;

   macro MAlegend {
      MAcolmap_params_templ &colmap_params<NEportLevels={2,1}> => <-.colmap_params;
      MAlegend_params_templ &legend_params<NEportLevels={2,1}> => <-.legend_params;
      MAGDobject_templ &obj_in<NEportLevels={2,0}> => <-.obj_in;
      link vis => .legend_params.vis;
      float curMin => switch(legend_params.color_fit+1,
                             colmap_params.curmin,
                             colmap_params.min_col_val);
      float curMax => switch(legend_params.color_fit+1,
                             colmap_params.curmax,
                             colmap_params.max_col_val);

      $include MicroAVS/DV/Cmap/legendP.v
      $include MicroAVS/DV/Cmap/legendUI.v

      olink obj => GroupObject.Top;
   };
   olink legend_out=>MAlegend.obj;
};
