/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/echoUI.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/echoUI.v#1 $
*/
macro MAdmapEchoUI {
   ilink parent => <-.shell;
   MAcolmap_params_templ &colmap_params => <-.colmap_params;
   DatamapTempl &dmap<NEportLevels={1,1}> => <-.dmap;
   int width => UI.frame.x + UI.frame.width;

   GMOD.instancer UIinstancer {
      Value => <-.colmap_params.vis;
      Group => <-.UI;
   };
   macro UI<instanced=0> {
      ilink parent => <-.parent;
      MAcolmap_params_templ &colmap_params => <-.colmap_params;
      ilink dmap => <-.dmap;
      float dmapMin => .dmap.dataMin;
      float dmapMax => .dmap.dataMax;

      MAUIframe frame {
         parent => <-.parent;
         visible => <-.colmap_params.vis;
         x = 10;
         y = 10;
         width = 130;
#ifdef MSDOS
         height = 260;
#else
         height = 315;
#endif //MSDOS
      };
      MAUIlabel title {
         x = 0;
         y = 7;
         parent =><-.frame;
         width =>frame.clientWidth;
         label = "MACOLMAP_CURCOL";
         color.backgroundColor =><-.<-.frame.color.backgroundColor;
      };
      MAUIlabel max_label {
         parent =><-.frame;
         label = "MAUI_MAX";
         x = 0;
         y => title.y + title.height + 15;
         width = 45;
         fontAttributes.height = 12;
         color.foregroundColor = MAVS_RED;
         color.backgroundColor =><-.<-.frame.color.backgroundColor;
      };
      MAUIfield2 max_field {
         /*** v6.0 ***/
         active => <-.colmap_params.UI_active;
         /*** end v6.0 ***/
         title = "MAUI_MAX";
         parent =><-.frame;
         y => max_label.y - 8;
         x => max_label.x + max_label.width;
         allwidth = 70;
         color.foregroundColor => max_label.color.foregroundColor;
         min =><-.dmapMax;
         //double max = MAVS_DBL_MAX;
         double max => <-.colmap_params.curmax_max;
         min_oonly = 1;
         max_oonly = 1;
         value => <-.colmap_params.curmax;
         decimalPoints => <-.colmap_params.curmax_deci;
         mode = "real";
         visible => <-.colmap_params.vis;
      };
      max_field min_field {
         title = "MAUI_MIN";
         y => min_label.y - 8;
         color.foregroundColor => min_label.color.foregroundColor;
         min =;
         //double min = MAVS_DBL_MIN;
         double min => <-.colmap_params.curmin_min;
         max =><-.dmapMin;
         value => <-.colmap_params.curmin;
         decimalPoints => <-.colmap_params.curmin_deci;
      };
      GMOD.copy_on_change copy_min {
         input => switch((UI.min_field.value > UI.min_field.max)+1,
                          UI.min_field.value,UI.min_field.max);
         output =><-.colmap_params.curmin;
         on_inst = 0;
      };
      GMOD.copy_on_change copy_max {
         input => switch((UI.max_field.value < UI.max_field.min)+1,
                          UI.max_field.value,UI.max_field.min);
         output =><-.colmap_params.curmax;
         on_inst = 0;
      };
      UIrenderView area {
         parent => <-.frame;
         x => max_field.x;
         y => max_field.y + max_field.height;
         width => max_field.allwidth;
#ifdef MSDOS
         height = 125;
#else
         height = 175;
#endif //MSDOS
      };
//
// Legend
//
      float curMin => colmap_params.curmin;
      float curMax => colmap_params.curmax;
      float dmapIncr => ((.curMax - .curMin) / 256.);
      float arr1[256][1]
         => init_array(256,.curMin,((255. * .dmapIncr) + .curMin));
      Mesh_Unif+Node_Data LegendField<NEportLevels={0,1}> {
         nnodes => prod(.dims);
         dims = {2,256};
         ndim = 2;
         nspace = 3;
         points => {{-1,-1,0}, {1,1,0}};
         nnode_data = 1;
         Data_Array node_data[.nnode_data] {
            nvals => <-.nnodes;
            veclen = 1;
            float values[.nvals][.veclen]
               => combine_array(<-.<-.arr1,<-.<-.arr1);
            float+opt null_value;
            float min;
            float max;
            float min_vec[.veclen];
            float max_vec[.veclen];
         };
      };
      DefaultProps DefaultProps;
      MAdefaultObject Legend<NEportLevels={0,1}> {
         input<NEportLevels={2,0}> => <-.LegendField;
         dmap => <-.dmap;
         props => <-.DefaultProps;
         xform_mode = "Locked";
         name => (name_of(<-.<-.<-) + "Legend");
      };
      MAdefaultCamera2D DmapCamera { objects => {<-.Legend}; update = 1; };
      BestVirtPal DmapPal { gamma = 1.0; };
      MAdefaultView DmapView {
         aspect = "Biggest";
         back_col => {0.5,0.5,0.5};
         cameras => {<-.DmapCamera};
         handle => <-.area.handle;
         virtpal => <-.DmapPal;
      };
//
      max_label min_label {
         label = "MAUI_MIN";
         y => area.y + area.height + 8;
         color.foregroundColor = MAVS_BLUE;
         color.backgroundColor =><-.<-.frame.color.backgroundColor;
      };
      MAUIbutton just_fit_b {
         /*** v6.0 ***/
         active => <-.colmap_params.UI_active;
         /*** end v6.0 ***/
         parent => <-.frame;
         y => min_field.y + min_field.height + 8;
         x => frame.clientWidth/2 - width/2;
         width = 130;
         label = "MACOLMAP_FIT";
         fontAttributes.height = 12;
         do => <-.colmap_params.fit;
      };
   };
};
