/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/legendUI.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/legendUI.v#1 $
*/
//
// Legend Popup UIs
//
GMOD.instancer LegendUIinstancer {
   Value => <-.LegendUI.vis;
   Group => <-.LegendUI;
};
macro+nosave LegendUI<instanced=0> {
   ilink parent;
   MAlegend_params_templ &legend_params<NEportLevels={2,1}>
      => <-.legend_params;
   link vis => .legend_params.vis;
   int horizontal => .legend_params.horizontal+1;

   MAUIokCancelDialog shell {
      visible => <-.vis;
      //parent => <-.parent;
      string t[] => { "MALEGE_TITLE", 
                      "MALEGE_TITLE" + " ("+legend_params.title+")" };
      title => t[is_valid(legend_params.title)];
#ifdef MSDOS
      height = 245 + 30;
#else
      height = 285 + 30;
#endif //MSDOS
      okLabelString => "MAUI_RESET";
      cancelLabelString => "MAUI_CLOSE";
      visible_off.trigger => <-.Cancel.do;
      ok => <-.legend_params.all_reset;
   };
   MAUItoggle legend_vis_toggle {
      parent => <-.shell;
      set => <-.legend_params.legend_vis;
      x = 10;
      y = 10;
      width = 125;
      label => "MALEGE_VIS";
   };
   MAUItoggle legend_color_fit_toggle {
      parent => <-.shell;
      set => <-.legend_params.color_fit;
      x => <-.legend_vis_toggle.x + <-.legend_vis_toggle.width + 10;
      y => <-.legend_vis_toggle.y;
      width = 150;
      label => "MALEGE_COLOR_FIT";
   };
   MAUItoggle legend_horiz_toggle {
      parent => <-.shell;
      set => <-.legend_params.horizontal;
      x = 10;
      y => <-.legend_vis_toggle.y + <-.legend_vis_toggle.height + 10;
      width = 150;
      label => "MALEGE_HORIZ";
   };
   MAUIhelpButton help_b {
      parent => <-.shell;
      x => .parent.clientWidth - width - 10;
      y => .parent.clientHeight - height - 10;
   };
   MAmime HelpViewer {
      trigger => <-.help_b.do;
      stFilename => MAVS_HELP_PATH+"/misc/legend1.htm";
   };
   MAUIframe frame {
      parent => <-.shell;
      x = 10;
      y => <-.legend_horiz_toggle.y + <-.legend_horiz_toggle.height + 10;
      width => .parent.clientWidth - .x * 2;
      height => <-.y_slider.y + <-.y_slider.height + 15;
   };
   MAUIslider2 x_slider {
      parent => <-.frame;
      value => switch(<-.horizontal, <-.legend_params.x,
                                     <-.legend_params.horiz_x);
      min => <-.legend_params.x_min;
      max => <-.legend_params.x_max;
      decimalPoints => <-.legend_params.x_deci;
      title => "MAUI_X";
      allwidth = 120;
      x = 5;
      y = 10;
   };
   MAUIslider2 y_slider {
      parent => <-.frame;
      title => "MAUI_Y";
      allwidth => <-.x_slider.allwidth;
      y => <-.x_slider.y + <-.x_slider.height + 10;
      x => <-.x_slider.x;
      value => switch(<-.horizontal, <-.legend_params.y,
                                     <-.legend_params.horiz_y);
      min => <-.legend_params.y_min;
      max => <-.legend_params.y_max;
      decimalPoints => <-.legend_params.y_deci;
   };
   MAUIslider2 w_slider {
      parent => <-.frame;
      title => "MAUI_WIDTH";
      allwidth => <-.x_slider.allwidth;
      y => <-.x_slider.y;
      x => <-.x_slider.x + <-.x_slider.allwidth + 15;
      value => switch(<-.horizontal, <-.legend_params.width,
                                     <-.legend_params.horiz_w);
      min => <-.legend_params.w_min;
      max => <-.legend_params.w_max;
      decimalPoints => <-.legend_params.w_deci;
   };
   MAUIslider2 h_slider {
      parent => <-.frame;
      title => "MAUI_HEIGHT";
      allwidth => <-.x_slider.allwidth;
      y => <-.w_slider.y + <-.w_slider.height + 10;
      x => <-.w_slider.x;
      value => switch(<-.horizontal, <-.legend_params.height,
                                     <-.legend_params.horiz_h);
      min => <-.legend_params.h_min;
      max => <-.legend_params.h_max;
      decimalPoints => <-.legend_params.h_deci;
   };

   MAUIbutton numlabel_b {
      parent => <-.shell;
      height = 25;
      label => "MALEGE_NLABEL";
      x => <-.frame.x;
      y => <-.frame.y + <-.frame.height + 5;
      width => <-.frame.width;
   };
//
//
//
   GMOD.instancer numlabelUIinstancer {
      Value => <-.numlabelUI.vis;
      Group => <-.numlabelUI;
   };
   macro numlabelUI<instaced=0> {
      //ilink parent;
      ilink vis => <-.numlabel_b.do;
      MAlegend_params_templ &legend_params<NEportLevels={2,1}>
         => <-.legend_params;

      MAUIokCancelDialog shell {
         visible => <-.vis;
         //parent => <-.parent;
         title => "MALEGE_L_TITLE";
         width = 250;
#ifdef MSDOS
         height = 365;
#else
         height = 465;
#endif //MSDOS
         okLabelString => "MAUI_RESET";
         cancelLabelString => "MAUI_CLOSE";
         visible_off.trigger => <-.Cancel.do;
         ok => <-.legend_params.numlabel_reset;
      };
      MAUItoggle label_vis_toggle {
         parent => <-.shell;
         label => "MALEGE_L_VIS";
         set => <-.legend_params.label_vis;
         x = 10;
         y = 10;
      };
      MAUIslider2 label_offset_slider {
         parent => <-.shell;
         title => "MALEGE_L_OFFSET";
         y => <-.frame.y + <-.frame.height + 10;
         x => <-.label_vis_toggle.x;
         value => <-.legend_params.label_offset;
         min => <-.legend_params.label_offset_min;
         max => <-.legend_params.label_offset_max;
         decimalPoints => <-.legend_params.label_offset_deci;
         allwidth => <-.frame.width;
      };
      MAUIslider label_num_slider {
         parent => <-.shell;
         value => <-.legend_params.label_num;
         title => "MAUI_NUM";
         x => <-.label_vis_toggle.x;
         y => <-.label_offset_slider.y + <-.label_offset_slider.height + 10;
         width => <-.frame.width;
         min = 2.;
         max = 32.;
         mode = "integer";
      };
      label_num_slider label_height_slider {
         value => <-.legend_params.label_height;
         title => "MAUI_HEIGHT";
         y => <-.label_num_slider.y + <-.label_num_slider.height + 10;
         min = 0.;
         max = 100.;
      };
      MAUIframe frame {
         parent => <-.shell;
         y => <-.label_vis_toggle.y + <-.label_vis_toggle.height + 10;
         x => <-.label_vis_toggle.x;
         width = 220;
      };
      UIoption e_opt { label => "MALEGE_E_SPEC"; };
      UIoption f_opt { label => "MALEGE_N_SPEC"; set = 1; };
      MAUIradioBox format_radio {
         parent => <-.frame;
         cmdList => {<-.f_opt, <-.e_opt};
         selectedItem => <-.legend_params.format;
         y = 0;
      };
      MAUIslider label_decimal_slider {
         parent => <-.shell;
         value => <-.legend_params.decimal;
         title => "MAUI_DECI";
         x => <-.label_height_slider.x;
         y => <-.label_height_slider.y + <-.label_height_slider.height + 10;
         width => <-.label_height_slider.width;
         height => <-.label_height_slider.height;
         min = 0.;
         max = 10.;
         mode = "integer";
      };
      MAUIbutton label_color_b {
         parent => <-.shell;
         label => "MAUI_COL";
         x => <-.label_decimal_slider.x;
         y => <-.label_decimal_slider.y + <-.label_decimal_slider.height + 10;
         width => <-.label_decimal_slider.width;
      };
//
//
//
      GMOD.instancer labelColorUIinstancer {
         Value => <-.labelColorUI.vis;
         Group => <-.labelColorUI;
      };
      macro+nosave labelColorUI<instanced=0> {
         MAlegend_params_templ &legend_params<NEportLevels={2,1}>
           => <-.legend_params;
         ilink vis   => <-.label_color_b.do;
         float red   => <-.legend_params.red;
         float green => <-.legend_params.green;
         float blue  => <-.legend_params.blue;
   
         MAUIcloseDialog color_shell {
            title => "MALABEL_COL";
            width = 210;
#ifdef MSDOS
            height = 255;
#else
            height = 285;
#endif //MSDOS
            visible => <-.vis;
         };
         MAUIcolor_sliders color_sliders {
            parent => <-.color_shell;
            decimalPoints = 1;
            red   => <-.red;
            green => <-.green;
            blue  => <-.blue;
         };
         MAUIpanel palette {
            parent => <-.color_shell;
            x => <-.color_sliders.red_slider.x;
            y => <-.color_sliders.blue_slider.y
               + <-.color_sliders.blue_slider.height + 15;
            width => <-.color_sliders.red_slider.width;
            height = 40;
            color.backgroundColor =>
               str_format("#%02x%02x%02x", red*255, green*255, blue*255);
         };
      };
   };
};
