/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MA3dgrap.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MA3dgrap.v#1 $
*/
MAparams MA3Dgraph_params {
   int   glyph_comp  = 0;
   int   map_comp    = 0;
   int   scale_comp  = 0;
   float scale       = 1.0;
   int   vector      = 0;
   boolean scale_x   = 0;
   boolean scale_y   = 0;
   boolean scale_z   = 1;
   int   normalize   = 0;
   int   mode1       = GD_NO_POINTS;
   int   mode2       = GD_LINES;
   int   mode3       = GD_SURF_GOURAUD;
   int   mode4       = GD_NO_VOLUME;
   int   mode5       = GD_NO_BOUNDS;
   float width       = 1.0;
   float width_max   = 10;
   int width_deci    = 2;
   float height      = 1.0;
   float height_max  = 10;
   int height_deci   = 2;
   float offset      = 0.0;
   float offset_min  = -10;
   float offset_max  = 10;
   int offset_deci   = 2;
   init_commands = "";
   reset_commands =
      "_3Dgraph_params.glyph_comp=0;"
     +"_3Dgraph_params.map_comp=0;"
     +"_3Dgraph_params.scale_comp=0;"
     +"_3Dgraph_params.scale=1.0;"
     +"_3Dgraph_params.vector=0;"
     +"_3Dgraph_params.scale_x=0;"
     +"_3Dgraph_params.scale_y=0;"
     +"_3Dgraph_params.scale_z=1;"
     +"_3Dgraph_params.normalize=0;"
     +"_3Dgraph_params.mode1="+GD_NO_POINTS+";"
     +"_3Dgraph_params.mode2="+GD_LINES+";"
     +"_3Dgraph_params.mode3="+GD_SURF_GOURAUD+";"
     +"_3Dgraph_params.mode4="+GD_NO_VOLUME+";"
     +"_3Dgraph_params.mode5="+GD_NO_BOUNDS+";"
     +"_3Dgraph_params.width=1.0;"
     +"_3Dgraph_params.width_max=10;"
     +"_3Dgraph_params.width_deci=2;"
     +"_3Dgraph_params.height=1.0;"
     +"_3Dgraph_params.height_max=10;"
     +"_3Dgraph_params.height_deci=2;"
     +"_3Dgraph_params.offset_min=-10;"
     +"_3Dgraph_params.offset_max=10;"
     +"_3Dgraph_params.offset_deci=2;"
     +"_3Dgraph_params.offset=0.0;";
};

MAmacroUI MA3DgraphUI {
   MA3Dgraph_params &_3Dgraph_params<NEportLevels={2,1}>;
   Mesh+Node_Data &fld_in<NEportLevels={2,1}>;
   height => _3Dgraph_panel.height;

   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
      int+nres ncomp => in.nnode_data;
   };
   MAUIframe _3Dgraph_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.norm_scaleUI.norm_scale_frame.y
              + <-.norm_scaleUI.norm_scale_frame.height + 10;
   };
   MAUIradioBoxLabel radioBoxLabel_map {
      parent => <-._3Dgraph_panel;
      labels => <-.node_data_labels.labels;
      &selectedItem => <-._3Dgraph_params.map_comp;
      title = "MAGRA_SEL_COL";
   };
   MAUIradioBoxLabel radioBoxLabel_scale {
      parent => <-._3Dgraph_panel;
      y => <-.radioBoxLabel_map.y + <-.radioBoxLabel_map.height + 14;
      labels => <-.node_data_labels.labels;
      &selectedItem => <-._3Dgraph_params.scale_comp;
      title = "MAGRA_SEL_H";
   };
   macro norm_scaleUI {
      ilink parent => <-._3Dgraph_panel;
      ilink y => <-.radioBoxLabel_scale.y + <-.radioBoxLabel_scale.height;
      MA3Dgraph_params+IPort2 &_3Dgraph_params => <-._3Dgraph_params;

      MAUIframe norm_scale_frame {
         parent => <-.parent;
         x = 5;
         y => <-.y + 15;
         width = 220;
         height =>offset_slider.y + offset_slider.height + 15;
      };
      MAUItoggle norm_toggle {
         x = 5;
         y = 5;
         parent => <-.norm_scale_frame;
         label = "MAGRA_NORM_H";
         set => <-._3Dgraph_params.normalize;
      };
      MAUIslider2 width_slider {
         title = "MAGRA_W";
         parent => <-.norm_scale_frame;
         x = 5;
         y => <-.norm_toggle.y + <-.norm_toggle.height + 5;
         allwidth = 210;
         min = 0;
         max => <-._3Dgraph_params.width_max;
         value => <-._3Dgraph_params.width;
         decimalPoints => <-._3Dgraph_params.width_deci;
      };
      width_slider height_slider {
         title = "MAGRA_H";
         y => <-.width_slider.y + <-.width_slider.height + 5;
         max => <-._3Dgraph_params.height_max;
         value => <-._3Dgraph_params.height;
         decimalPoints => <-._3Dgraph_params.height_deci;
      };
      width_slider offset_slider {
         title = "MAGRA_OFFSET";
         y => <-.height_slider.y + <-.height_slider.height + 5;
         min => <-._3Dgraph_params.offset_min;
         max => <-._3Dgraph_params.offset_max;
         value => <-._3Dgraph_params.offset;
         decimalPoints => <-._3Dgraph_params.offset_deci;
      };
   };
};

MAmodule MA3Dgraph {
   MA3Dgraph_params &_3Dgraph_params<NEportLevels={2,1}>;
   Mesh+Node_Data &fld_in<NEportLevels={2,1}>;
   macro+nosave Box {
      ilink width => <-._3Dgraph_params.width;
      ilink height => <-._3Dgraph_params.height;
      Mesh_Unif box {
         int nspace = 3;
         int ndim = 3;
         dims => {2, 2, 2};
         points => { -1 * <-.width, -1 * <-.width,
                      0, <-.width,
                     <-.width, <-.height
         };
      };
      olink fld_out => .box;
   };
   MADVglyph+nosave glyph {
      in => <-.fld_in;
      glyph => <-.Box.fld_out;
      &glyph_comp => _3Dgraph_params.glyph_comp;
      &map_comp => _3Dgraph_params.map_comp;
      &scale_comp => _3Dgraph_params.scale_comp;
      &vector => _3Dgraph_params.vector;
      &scale => _3Dgraph_params.scale;
      &scale_x => _3Dgraph_params.scale_x;
      &scale_y => _3Dgraph_params.scale_y;
      &scale_z => _3Dgraph_params.scale_z;
      &normalize => _3Dgraph_params.normalize;
   };
   fld_out => glyph.out;
};
