/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAadvect.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAadvect.v#1 $
*/
MAparams MAadvector_params {
   boolean+nosave run = 0;
   boolean+nosave reset = 0;
   boolean cycle = 0;
   boolean color = 1;
   float count = 0.0;
   float scale = 1;
   float scale_max = 10;
   float scale_deci = 2;
   float start = 0;
   float start_max = 100;
   float start_deci = 2;
   float end = 1;
   float end_max = 100;
   float end_deci = 2;
   float incr = 0.2;
   float incr_max = 10;
   float incr_deci = 2;
   int nseg = 2;
   int max_seg = 256;
   int order = 1;
   int mark_type = 0;
   boolean tracer = 0;
   int tracer_style = 0;
   int tracer_active = 1;
   int trace_comp = 0;
   init_commands = "";
   reset_commands = "advector_params.run=0;"
                   +"advector_params.reset=0;"
                   +"advector_params.cycle=0;"
                   +"advector_params.color=1;"
                   +"advector_params.count=0;"
                   +"advector_params.scale=1;"
                   +"advector_params.scale_max=10;"
                   +"advector_params.scale_deci=2;"
                   +"advector_params.start=0;"
                   +"advector_params.start_max=100;"
                   +"advector_params.start_deci=2;"
                   +"advector_params.end=1;"
                   +"advector_params.end_max=100;"
                   +"advector_params.end_deci=2;"
                   +"advector_params.incr=0.2;"
                   +"advector_params.incr_max=10;"
                   +"advector_params.incr_deci=2;"
                   +"advector_params.nseg=2;"
                   +"advector_params.max_seg=256;"
                   +"advector_params.order=1;"
                   +"advector_params.mark_type=0;"
                   +"advector_params.tracer=0;"
                   +"advector_params.tracer_style=0;"
                   +"advector_params.tracer_active=1;"
                   +"advector_params.trace_comp=0;"
                   ;
};

MAmacroUI MAadvectorUI {
   MAadvector_params+IPort2 &advector_params;

   height => advector_panel.height;
   MAUIframe advector_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.tracer_toggle.y + <-.tracer_toggle.height + 5;
   };
   MAUIbutton reset_b {
      parent =><-.advector_panel;
      x = 10;
      y = 5;
      width = 40;
      height = 40;
      label = "reset";
      labelPixmap.filename = MAVS_ICON_PATH + "offset/oreset.x";
      labelPixmap.fileType = "avs_image";
      do =><-.advector_params.reset;
   };
   reset_b stop_b {
      label = "stop";
      x => <-.reset_b.x + width + 15;
      labelPixmap.filename = MAVS_ICON_PATH + "offset/ostop.x";
      labelPixmap.fileType = "avs_image";
      do =>!(<-.advector_params.run);
   };
   reset_b run_b {
      label = "run";
      x => <-.stop_b.x + width + 15;
      labelPixmap.filename = MAVS_ICON_PATH + "offset/orun.x";
      labelPixmap.fileType = "avs_image";
      do =>;
   };
   GMOD.parse_v set_run {
      v_commands = "run=1;\ncycle=0;\n";
      trigger =><-.run_b.do;
      on_inst = 0;
      relative =><-.advector_params;
   };
   set_run set_cycle {
      v_commands = "run=1;\ncycle=1;\n";
      trigger =><-.cycle_b.do;
   };
   reset_b cycle_b {
      label = "run";
      x => <-.run_b.x + width + 15;
      labelPixmap.filename = MAVS_ICON_PATH + "offset/ocycle.x";
      labelPixmap.fileType = "avs_image";
      do =>;
   };
   float rate => (monitor_panel.width - indicator.width)/
                 (advector_params.end - advector_params.start);
   MAUIpanel monitor_panel {
      parent =><-.advector_panel;
      x =><-.reset_b.x;
      y => <-.reset_b.y + <-.reset_b.height + 5;
      width = 200;
      height = 10;
      color.backgroundColor = "white";
   };
   MAUIpanel indicator {
      parent =><-.monitor_panel;
      x =><-.rate * <-.advector_params.count;
      y = 0;
      width = 10;
      height = 15;
      color.backgroundColor = MAVS_RED;
   };
   MAUIslider sphere_slider {
      parent =><-.advector_panel;
      x = 5;
      y =><-.monitor_panel.y + <-.monitor_panel.height + 5;
      min = 0;
      max = 5;
      value =><-.advector_params.mark_type;
      mode = "integer";
      title = "MAADV_GLYPH_SUB";
   };
   MAUItoggle color_toggle {
      parent =><-.advector_panel;
      x = 5;
      y => <-.sphere_slider.y + <-.sphere_slider.height + 5;
      width = 65;
      label = "MAADV_GLYPH_COL";
      set =><-.advector_params.color;
   };
   MAUIslider2 scale_slider {
      parent =><-.advector_panel;
      x = 5;
      y =><-.color_toggle.y + <-.color_toggle.height + 5;
      min = 0;
      max =><-.advector_params.scale_max;
      decimalPoints =><-.advector_params.scale_deci;
      title = "MAADV_GLYPH_SCALE";
      value =><-.advector_params.scale;
      min_oonly = 1;
   };
   scale_slider start_slider {
      y =><-.scale_slider.y + <-.scale_slider.height + 5;
      min = 0;
      max =><-.advector_params.start_max;
      decimalPoints =><-.advector_params.start_deci;
      title = "MAADV_START_TIME";
      value =><-.advector_params.start;
      min_oonly = 1;
   };
   scale_slider end_slider {
      y =><-.start_slider.y + <-.start_slider.height + 5;
      min = 0;
      max =><-.advector_params.end_max;
      decimalPoints =><-.advector_params.end_deci;
      title = "MAADV_END_TIME";
      value =><-.advector_params.end;
      min_oonly = 1;
   };
   scale_slider incr_slider {
      y =><-.end_slider.y + <-.end_slider.height + 5;
      min = 0;
      max =><-.advector_params.incr_max;
      decimalPoints =><-.advector_params.incr_deci;
      title = "MAADV_TIME_STEP";
      value =><-.advector_params.incr;
      min_oonly = 1;
   };
   MAUIslider2 nseg_slider {
      parent =><-.advector_panel;
      x = 5;
      y => <-.incr_slider.y + <-.incr_slider.height + 5;
      min = 1;
      max = 16;
      decimalPoints = 0;
      title = "MAADV_NSEG";
      value =><-.advector_params.nseg;
      min_oonly = 1;
   };
   nseg_slider max_seg_slider {
      y => <-.nseg_slider.y + <-.nseg_slider.height + 5;
      title = "MAADV_MAX_SEG";
      min = 1;
      max = 10000;
      value =><-.advector_params.max_seg;
      min_oonly = 1;
   };
   nseg_slider order_slider {
      y => <-.max_seg_slider.y + <-.max_seg_slider.height + 5;
      title = "MAADV_ORDER";
      min = 1;
      max = 4;
      value =><-.advector_params.order;
      min_oonly = 1;
   };
   MAUItoggle tracer_toggle {
      parent =><-.advector_panel;
      x = 5;
      y => <-.order_slider.y + <-.order_slider.height + 5;
      width = 130;
      label = "MAADV_TRACER_VISIBLE";
      set =><-.advector_params.tracer;
      active => <-.advector_params.tracer_active;
   };
#ifdef OLD
   MAUIradioBoxLabel traser_RadioBox {
      parent =><-.advector_panel;
      labels => {"MAADV_TRACER_CAP","MAADV_TRACER_CYCLE","MAADV_TRACER_ADD"};
      title = "MAADV_TRACER_STYLE";
      x = 5;
      y => <-.tracer_toggle.y + <-.tracer_toggle.height + 5;
      selectedItem =>  <-.advector_params.trace_comp;
      active => <-.advector_params.tracer;
   };
#endif
};

MAmodule MAadvector {
   MAadvector_params+IPort2 &advector_params;
   Mesh+Node_Data+IPort2 &fld_in<NEportLeves={2,1}>;
   Mesh+IPort2 &probe_in<NEportLeves={2,1}>;

   macro Mark {
      MAadvector_params+IPort2 &advector_params => <-.advector_params;
      macro Diamond3D {
         Tri set1 {
            ncells = 8;
            node_connect_list = 
            {2,5,0, 2,1,5, 2,4,1, 2,0,4, 3,0,5, 3,5,1, 3,1,4, 3,4,0};
         };
         Mesh diamond {
            int nnodes = 6;
            int nspace = 3;
            coordinates {
               float values[nvals][veclen] = {
                  {-0.5,0,0},{0.5,0,0},{0,-0.5,0},{0,0.5,0},{0,0,-0.5},{0,0,0.5}
               };
            };
            int ncell_sets = 1;
            cell_set[ncell_sets] => {set1};
         };
         olink fld_out => diamond;
      };
      MAgen_sphere Sphere3D {
         subdiv => <-.advector_params.mark_type * 4;
      };
      olink glyph_out => switch((advector_params.mark_type == 0)+1,
                                Sphere3D.fld_out, Diamond3D.fld_out);
   };
   MADVstream+nosave stream {
      &in =><-.fld_in;
      &probe =><-.probe_in;
      &order =><-.advector_params.order;
      forw_back = 1;
      &nseg =><-.advector_params.nseg;
      min_vel = 0.00001; // never 0.0
      &max_seg =><-.advector_params.max_seg;
      stream_comp = 0;
      ribbons = 0;
      rib_width = 0;
      rib_angle = 0;
   };

   MAtailed_advect tailed_advect {
      in => <-.stream.out;
      time => <-.advector_params.count;
      direction = 1;
      start_time => <-.advector_params.start;
      tracer_style => <-.advector_params.tracer_style;
      release_interval = 0;
      time_step_interval =><-.advector_params.incr;
   };

    GMOD.parse_v set_advect_len {
         trigger    => switch(is_valid(<-.tailed_advect.in.nnodes), 1);
         v_commands =>"tracer_len = in.nnodes;\n";
         relative   => <-.tailed_advect;
         on_inst = 0;
         //parse_v_relative<weight=0>;
   };

   MADVglyph+nosave glyph {
      &in =><-.tailed_advect.out;
      &glyph =><-.Mark.glyph_out;
      vector = 1;
      glyph_comp = 0;
      map_comp = 0;
      scale_comp = 0;
      &scale =><-.advector_params.scale;
      scale_x = 1;
      scale_y = 1;
      scale_z = 1;
      normalize = 1;
   };
   GMOD.loop+nosave MAloop {
      &reset =><-.advector_params.reset;
      &run =><-.advector_params.run;
      &cycle =><-.advector_params.cycle;
      &start_val =><-.advector_params.start;
      &end_val =><-.advector_params.end;
      &incr =><-.advector_params.incr;
      &count =><-.advector_params.count;
   };
   MADVextract_mesh+nosave extract_mesh {
      &in =><-.glyph.out;
   };

   fld_out+nosave;
   int index => advector_params.color;
   GMOD.parse_v set_fld_out{
      v_commands =>"$push \n"
                  + switch(<-.index + 1
                  ,"fld_out => extract_mesh.out;\n"
                  ,"fld_out => glyph.out;\n")
                  +"$pop \n";
      trigger    => <-.index;
      on_inst    = 1;
      relative   => <-.<-;
   };

   olink trace_out => tailed_advect.out_tracer;

};
