/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAcelvec.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source: \\Master/xp4.1/express/v/MicroAVS/DV/MAcelvector.v,v $
*/
//
// Vector
//
MAparams MAcelvector_params {
   int   glyph_comp = 0;
   int   map_comp = 0;
   int   scale_comp = 0;
   int   vector = 1;
   float scale = 1.0;
   int   scale_x = 1;
   int   scale_y = 1;
   int   scale_z = 1;
   boolean all_nodes = 0;
   int   normalize = 1;
   int   mode1 = GD_NO_POINTS;
   int   mode2 = GD_LINES;
   int   mode3 = GD_SURF_GOURAUD;
   int   mode4 = GD_NO_VOLUME;
   int   mode5 = GD_NO_BOUNDS;
   int   arrow_type = 0;
   int   arrow_vis = 0;
   int+nosave   arrow1_apply =;
   int+nosave   arrow1_reset =;
   int+nosave   arrow2_apply =;
   int+nosave   arrow2_reset =;
   int+nosave   arrow3_apply =;
   int+nosave   arrow3_reset =;
   int   arrow1_t = 30;
   int   arrow2_t = 30;
   float arrow1_l = 0.3;
   float arrow2_l = 0.4;
   float arrow3_l = 0.3;
   float arrow2_w = 0.2;
   float arrow3_r = 0.15;
   int   arrow3_s = 4;
   int   color = 1;
   int   center = 0;

/* for MicroAVS5.0 */
   int vector_legend_on = 0;
   int vector_legend_Decimal = 2;
   string vector_legend_Format => (("%." + vector_legend_Decimal) + "f");
   float vector_legend_scale = 1.0;
   float vector_legend_x = -0.77;
   float vector_legend_y = -0.75;
/* for MicroAVS5.0 */

   init_commands = "";
   reset_commands =
 "vector_params.glyph_comp=0;"
+"vector_params.map_comp=0;"
+"vector_params.scale_comp=0;"
+"vector_params.vector=1;"
+"vector_params.scale=1.0;"
+"vector_params.scale_x=1;"
+"vector_params.scale_y=1;"
+"vector_params.scale_z=1;"
+"vector_params.all_nodes=0;"
+"vector_params.normalize=1;"
+"vector_params.mode1="+GD_NO_POINTS+";"
+"vector_params.mode2="+GD_LINES+";"
+"vector_params.mode3="+GD_SURF_GOURAUD+";"
+"vector_params.mode4="+GD_NO_VOLUME+";"
+"vector_params.mode5="+GD_NO_BOUNDS+";"
+"vector_params.arrow_type=0;"
+"vector_params.arrow_vis=0;"
+"vector_params.arrow1_apply=;"
+"vector_params.arrow2_apply=;"
+"vector_params.arrow3_apply=;"
+"vector_params.arrow1_reset=;"
+"vector_params.arrow2_reset=;"
+"vector_params.arrow3_reset=;"
+"vector_params.arrow1_t=30;"
+"vector_params.arrow2_t=30;"
+"vector_params.arrow1_l=0.3;"
+"vector_params.arrow2_l=0.4;"
+"vector_params.arrow3_l=0.3;"
+"vector_params.arrow2_w=0.2;"
+"vector_params.arrow3_r=0.15;"
+"vector_params.arrow3_s=4;"
+"vector_params.color=1;"
+"vector_params.center=0;"

/* for MicroAVS5.0 */
+ "vector_legend_on = 0;"
+ "vector_legend_Decimal = 2;"
+ "float vector_legend_scale = 1.0;"
+ "float vector_legend_x = -0.77;"
+ "float vector_legend_y = -0.75;"
/* for MicroAVS5.0 */
;
   macro arrow1 {
      link t => <-.arrow1_t;
      link l => <-.arrow1_l;
      float lx => (1. - (l * cos(((t * 3.1415) / 180))));
      float ly => (.l * sin(((3.1415 * .t) / 180)));
      float cs => switch(<-.center+1, 0.0, -0.5);
      float ce => switch(<-.center+1, 1.0, 0.5);
      float w => switch(<-.center+1, 0.7, 0.2);
      float ls => switch(<-.center+1,lx, lx - 0.5);
      Line set1 { ncells = 3; node_connect_list = {0,1,1,2,1,3}; };
      Mesh glyph1 {
         int nnodes = 4;
         int nspace = 3;
         coordinates { float values[.nvals][.veclen]; };
         int ncell_sets = 1;
         cell_set => {<-.set1};
      };
      Mesh glyph_out {
         int nnodes = 4;
         int nspace = 3;
         coordinates {
            float values[.nvals][.veclen] = {
               0.,0.,0.,1.,0.,0.,0.7,0.15,0.,0.7,-0.15,0.
            };
         };
         int ncell_sets = 1;
         cell_set => {<-.set1};
      };
      olink fld_out => glyph_out;
   };
   macro arrow2 {
      link l => <-.arrow2_l;
      link w => <-.arrow2_w;
      link t => <-.arrow2_t;
      float lx => 1 - l*cos(t*3.1415/180);
      float ly => l*sin(t*3.1415/180);
      float cs => switch(<-.center+1,0.,-0.5);
      float ce => switch(<-.center+1,1.,0.5);
      float ls => switch(<-.center+1,lx, lx - 0.5 );
      float le => switch(<-.center+1,ly, ly - 0.5 );
      Quad set1 { ncells = 1; node_connect_list = {0,1,2,3}; };
      Tri set2 { ncells = 1; node_connect_list = {4,5,6}; };
      Mesh glyph2 {
         int nnodes = 7;
         int nspace = 3;
         coordinates {
            float values[nvals][veclen] = {
               {0,-0.1,0},{0.7,-0.1,0},{0.7,0.1,0},{0,0.1,0},
               {0.7,-0.17,0},{1,0,0},{0.7,0.17,0}
            };
         };
         int ncell_sets = 2;
         cell_set[ncell_sets] => {set1, set2};
      };
      Mesh glyph_out {
         int nnodes = 7;
         int nspace = 3;
         coordinates {
            float values[.nvals][.veclen] = {
               0.,-0.1,0.,0.7,-0.1,0.,0.7,0.1,0.,0.,0.1,0.,0.7,-0.17,0.,
               1.,0.,0.,0.7,0.17,0.
            };
         };
         int ncell_sets = 2;
         cell_set => {set1,set2};
      };
      olink fld_out => glyph_out;
   };
   macro arrow3 {
      link cone_lenght => <-.arrow3_l;
      link radius      => <-.arrow3_r;
      link subdiv      => <-.arrow3_s;
      float cs => switch(<-.center+1,0.,-0.5);
      float ce => switch(<-.center+1,1.,0.5);

      macro cone {
	float ang[subdiv+1] => init_array(subdiv+1, 0, 2*3.1415);
	float x[subdiv+1][1] => init_array(subdiv+1, (<-.ce)-cone_lenght,
						     (<-.ce)-cone_lenght);
        float y[subdiv+1][1] => radius*cos(ang);
        float z[subdiv+1][1] => radius*sin(ang);
	float xyz_circle[subdiv+1][3] => combine_array(x,y,z);
	float xyz_tip[3] => {ce, 0, 0};
	int conn0[subdiv+1][1] => init_array(subdiv+1, 0, 0);
	int conn1[subdiv+1][1] => init_array(subdiv+1, 1, subdiv+1);
	int c21[subdiv][1]=>conn1[1:subdiv][];
	int c22[1][1] = {1};
	int conn2[subdiv+1][1] => concat_array(c21,c22);

	int+OPort2 nxyz => subdiv+2;
	int+OPort2 ntri => subdiv+1;
	float+OPort2 xyz[nxyz][3] => concat_array(xyz_tip,xyz_circle);
	int+OPort2 connect[3*(subdiv+1)] => combine_array(conn0, conn1,
							  conn2);
       };

       macro hex {
        float cone_height => <-.cone_lenght > 0.1;
        float height => switch(cone_height+1,0.0,0.1);
        float le => switch(<-.<-.center+1, ((1-<-.cone_lenght)+height), ((0.5-<-.cone_lenght)+height));
        float ls => switch(<-.<-.center+1, 0., -0.5);
	int+OPort2 nxyz = 8;
	float xyz[8][3]=> {{ls,-0.05,-0.05},{ls,-0.05,0.05},{ls,0.05,0.05},{ls,0.05,-0.05},{le,-0.05,-0.05},{le,-0.05,0.05},{le,0.05,0.05},{le,0.05,-0.05}};
	int+OPort2 connect[8] => {<-.cone.nxyz,<-.cone.nxyz+1,<-.cone.nxyz+2,<-.cone.nxyz+3,<-.cone.nxyz+4,<-.cone.nxyz+5,<-.cone.nxyz+6,<-.cone.nxyz+7};
       };

       Hex hex_set {
        ncells = 1;
        node_connect_list => <-.hex.connect;
       };
       Tri tri_set {
        ncells => <-.cone.ntri;
        node_connect_list => <-.cone.connect;
       };
       Mesh arrow3 {
        int nnodes => <-.hex.nxyz + <-.cone.nxyz;
        int nspace = 3;
        coordinates {
             float values[.nvals][.veclen] = concat_array(cone.xyz,hex.xyz);
        };
        int ncell_sets = 2;
        cell_set => {hex_set, tri_set};
       };
       Hex hex_apply{
         ncells = <-.hex_set.ncells;
         node_connect_list[(ncells * cell_nnodes)] = <-.hex_set.node_connect_list;
       };
       Tri  tri_apply{
         ncells = <-.tri_set.ncells;
         node_connect_list[(ncells * cell_nnodes)] = <-.tri_set.node_connect_list;
       };
       Mesh glyph_out {
         int nnodes = 14;
         int nspace = 3;
         coordinates {
             float values[.nvals][.veclen] = concat_array(cone.xyz,hex.xyz);
         };
         int ncell_sets = 2;
         cell_set[ncell_sets] => {hex_apply, tri_apply};
        };
        olink fld_out => glyph_out;
     };
};


MAmacroUI+nosave MAcelvector_map_compUI{
   height => .celvector_map_comp_panel.height;
   MAvector_params+IPort2 &vector_params;
   MAUIframe celvector_map_comp_panel {
      parent => <-.parent;
      y => <-.y;
      height =>map_comp_rbl.y + map_comp_rbl.height +15;
   };
   
   Mesh+Node_Data+IPort2 &fld_in;
   
   MADVcell_data_labels cell_data_labels {
      in => <-.fld_in;
      labels[];
   };
   MAUItoggle celvector_color_toggle {
      parent => <-.celvector_map_comp_panel;
      y = 10;
      height = 20;
      set => <-.vector_params.color;
      label = "MASTRM_COL";
   };
   MAUIradioBoxLabel map_comp_rbl {
      labels => combine_array ({"MAVECTOR_MAGNITUDE"},<-.cell_data_labels.labels);
      x = 5;
      y => <-.celvector_color_toggle.y + <-.celvector_color_toggle.height + 5;
      parent => <-.celvector_map_comp_panel;
      title = "MAMAPCOMP_SEL";
      active => <-.vector_params.color;
      &selectedItem => <-.vector_params.map_comp;
   };
};
MAmacroUI+nosave MAcelvectorUI {
   MAcelvector_params+IPort2 &vector_params;

   height => vector_panel.height;
   MAUIframe vector_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.vector_legendUI.vector_legend_frame.y
              + <-.vector_legendUI.vector_legend_frame.height + 5;

   };
   MAUItoggle all_nodes_toggle {
      parent => <-.vector_panel;
      y = 5;
      label = "MAVEC_ALL";
      set => vector_params.all_nodes;
   };
   macro vector_typeUI {
      MAcelvector_params+IPort2 &vector_params => <-.vector_params;
      ilink parent => <-.vector_panel;
      MAUIframe vector_type_frame {
         parent => <-.parent;
         x = 5;
         y =><-.<-.all_nodes_toggle.y + <-.<-.all_nodes_toggle.height + 5;
         width = 220;
         //height = 110;
         height => <-.edit_arrow_b.y + <-.edit_arrow_b.height + 5;
      };
      MAUIradioBoxLabel vector_type_rb {
         parent => <-.vector_type_frame;
         title = "MAVEC_SEL_TYPE";
         x = 5;
         y = 5;
         labels => { "MAVEC_AROW1", "MAVEC_AROW2" ,"MAVEC_AROW3"};
         selectedItem => vector_params.arrow_type;
      };
      MAUIbutton edit_arrow_b {
         parent => <-.vector_type_frame;
         x = 5;
         y => <-.center.y + <-.center.height;
         width = 200;
         label = "MAVEC_EDIT_AROW";
         do => <-.vector_params.arrow_vis <+> 0;
      };
      MAUItoggle center {
         parent => <-.vector_type_frame;
         y => <-.vector_type_rb.y + <-.vector_type_rb.height;
         label = "MAMOD_ARROW_CENTER";
         set => <-.vector_params.center;
      };
      GMOD.instancer MAarrowUIinstancer {
         Value => <-.vector_params.arrow_vis;
         Group => <-.MAarrowUI;
      };
      macro MAarrowUI<instanced=0> {
         MAcelvector_params+IPort2 &vector_params => <-.vector_params;

         MAUIsimpleDialog dialog {
            //parent => <-.parent;
            visible => <-.vector_params.arrow_vis;
            title => switch(vector_params.arrow_type+1,"MAMOD_ARROW1_TITLE",
                                                       "MAMOD_ARROW2_TITLE",
                                                       "MAMOD_ARROW3_TITLE");
            width = 240;
#ifdef MSDOS
            height => switch((<-.vector_params.arrow_type+1),185,185,225);
#else
            height => switch((<-.vector_params.arrow_type+1),230,230,270); //UIslider.height == 60 on Unix
#endif //MSDOS
            color.backgroundColor = "white";
         };
         MAUIbutton apply_button {
            parent => <-.dialog;
            x = 10;
            y => <-.dialog.clientHeight - .height - 5;
            width = 60;
            height = 24;
            label = "MAUI_APPLY";
            do => switch(<-.vector_params.arrow_type+1,
                         <-.vector_params.arrow1_apply,
                         <-.vector_params.arrow2_apply,
                         <-.vector_params.arrow3_apply);
         };
         apply_button reset_button {
            x => (<-.dialog.clientWidth - .width) / 2;
            label = "MAUI_RESET";
            boolean do => switch(<-.vector_params.arrow_type+1,
                                 <-.vector_params.arrow1_reset,
                                 <-.vector_params.arrow2_reset,
                                 <-.vector_params.arrow3_reset);
         };
         apply_button close_button {
            x => dialog.clientWidth - .width - apply_button.x;
            label = "MAUI_CLOSE";
            boolean do =;
         };
         GMOD.copy_on_change set_close {
            trigger => close_button.do;
            input = 0;
            output => vector_params.arrow_vis;
            on_inst = 0;
         };

         GMOD.instancer arrow1UIinstancer {
            Value => <-.vector_params.arrow_type == 0;
            Group => <-.arrow1UI;
         };
         macro arrow1UI<instanced=0> {
            MAcelvector_params+IPort2 &vector_params => <-.vector_params;
            ilink parent => <-.dialog;
            olink height => length_slider.y + length_slider.height;

            MAUIslider angle_slider {
               parent => <-.parent;
               value =><-.<-.vector_params.arrow1_t;
               title => "MAMOD_ARROW_ANGLE";
               y = 5;
               width = 120;
               x = 100;
               min = 0.;
               max = 90.;
               decimalPoints = 0;
               immediateMode = 1;
               color.backgroundColor = "white";
            };
            MAUIslider length_slider {
               parent => <-.parent;
               value =><-.<-.vector_params.arrow1_l;
               title => "MAMOD_ARROW_LENGTH";
               x => angle_slider.x;
               y => angle_slider.y + angle_slider.height + 5;
               width => <-.angle_slider.width;
               min = 0.;
               max = 1.;
               decimalPoints = 2;
               immediateMode = 1;
               color.backgroundColor = "white";
            };
         };
         GMOD.instancer arrow2UIinstancer {
            Value => <-.vector_params.arrow_type == 1;
            Group => <-.arrow2UI;
         };
         macro arrow2UI<instanced=0> {
            MAcelvector_params+IPort2 &vector_params => <-.vector_params;
            ilink parent => <-.dialog;
            olink height => width_slider.y + width_slider.height;

            MAUIslider angle_slider {
               parent => <-.parent;
               value =><-.<-.vector_params.arrow2_t;
               title => "MAMOD_ARROW_ANGLE";
               x = 100;
               y = 5;
               width = 120;
               min = 0.;
               max = 90.;
               decimalPoints = 0;
               immediateMode = 1;
               color.backgroundColor = "white";
            };
            MAUIslider length_slider {
               parent => <-.parent;
               value =><-.<-.vector_params.arrow2_l;
               title => "MAMOD_ARROW_LENGTH";
               x => <-.angle_slider.x;
               y => <-.angle_slider.y + <-.angle_slider.height + 5;
               width => <-.angle_slider.width;
               min = 0.;
               max = 1.;
               decimalPoints = 2;
               immediateMode = 1;
               color.backgroundColor = "white";
            };
            MAUIslider width_slider {
               parent => <-.parent;
               value =><-.<-.vector_params.arrow2_w;
               title => "MAMOD_ARROW_WIDTH";
               x => angle_slider.x;
               y => length_slider.y + length_slider.height + 5;
               width => angle_slider.width;
               color.backgroundColor = "white";
               min = 0.;
               max = 1.;
               decimalPoints = 2;
               immediateMode = 1;
            };
         };
         GMOD.instancer arrow3UIinstancer {
            Value => <-.vector_params.arrow_type == 2;
            Group => <-.arrow3UI;
         };
         macro arrow3UI<instanced=0> {
            MAcelvector_params+IPort2 &vector_params => <-.vector_params;
            ilink parent => <-.dialog;
            olink height => subdiv_slider.y + subdiv_slider.height;

            MAUIslider radius_slider {
               parent => <-.parent;
               value =><-.<-.vector_params.arrow3_r;
               title => "MAMOD_ARROW_RAD";
               x = 100;
               y = 10;
               width = 120;
               min = 0.0;
               max = 1.0;
               decimalPoints = 2;
               immediateMode = 1;
               color.backgroundColor = "white";
            };
            MAUIslider cone_length_slider {
               parent => <-.parent;
               value =><-.<-.vector_params.arrow3_l;
               title => "MAMOD_ARROW_LENGTH";
               x => radius_slider.x;
               y => radius_slider.y + radius_slider.height + 5;
               width => radius_slider.width;
               color.backgroundColor = "white";
               min = 0.;
               max = 1.;
               decimalPoints = 2;
               immediateMode = 1;
            };
            MAUIslider subdiv_slider {
               parent => <-.parent;
               value =><-.<-.vector_params.arrow3_s;
               title => "MAMOD_ARROW_SUB";
               x => radius_slider.x;
               y => cone_length_slider.y + cone_length_slider.height + 5;
               width => radius_slider.width;
               color.backgroundColor = "white";
               min = 3;
               max = 30;
               decimalPoints = 0;
               immediateMode = 1;
            };
         };
         macro renderer {
            MAcelvector_params+IPort2 &vector_params => <-.vector_params;
            ilink parent => <-.dialog;
            MAdefaultObject Obj {
               input => switch(vector_params.arrow_type+1,
                                    vector_params.arrow1.glyph1,
                                    vector_params.arrow2.glyph2,
                                    vector_params.arrow3.arrow3);
               xform => input.xform;
               modes => ModeEditor;
               name => switch(vector_params.arrow_type+1,"MAMOD_ARROW1_TITLE",
                                                         "MAMOD_ARROW2_TITLE",
                                                         "MAMOD_ARROW3_TITLE");
            };
            GMOD.copy_on_change set_share { // this is magic for colormap
               input = 1;
               output => BestVirtPal.share;
               on_inst = 1;
            };
            BestVirtPal BestVirtPal { gamma = 1.0; share = 0; };
            MAdefaultView DefaultView {
               handle => <-.UIrenderView.handle;
               virtpal => <-.BestVirtPal;
               cameras => {<-.DefaultCamera2D};
            };
            UIrenderView UIrenderView {
               parent => <-.parent;
               x = 10;
               y => switch(<-.vector_params.arrow_type+1,25,25,6);
               width = 80;
               height = 80;
            };
            GMOD.copy_on_change set_auto_nrom {
               input = 3;
               output => <-.DefaultCamera2D.auto_norm;
               on_inst = 1;
            };
            MAdefaultCamera2D DefaultCamera2D {
               objects => {<-.Obj};
               auto_norm = "Object Attach";
            };
            GDIF.DefaultModes ModeEditor {
               mode => {<-.vector_params.mode1,<-.vector_params.mode2,
                        <-.vector_params.mode3,<-.vector_params.mode4,
                        <-.vector_params.mode5
                        };
               normals = 0;
               colors  = 0;
               outline = 1;
	   };
	   UIrenderView UIrenderView#1 {
	   	parent =><-.parent;
	   	x = 10;
	   	y = 88;
	   	width = 80;
	   	height = 80;
	   	visible =><-.vector_params.arrow_type == 2;
	   };
	   MAdefaultObject Obj1 {
               input => vector_params.arrow3.arrow3;
               xform => input.xform;
               modes => ModeEditor;
               name => "MAMOD_ARROW3_TITLE";
            };
            MAdefaultCamera3D DefaultCamera2D#1 {
               objects => {<-.Obj1};
               auto_norm = "None";
               from => {11.99,0.7383,0.1174};
               up   => {-0.061539,0.998,0.0008};
               at   => {0.,0.,0.};
               scale      = 1;
               xform {
               	   mat => {0.0097,-0.061539,0.998057,0.,
                           0.00141499,0.998104,0.0615281,0.,
                           -0.999951,0.00081423,0.00978518,0.,
                           0.,0.,0.,1.};
                   xlate => {0.,0.,-12.};
                   center => {0.,0.,0.};
		};
            };
            GDIF.DefaultXform LightXform {
               mat =>{0.386265,-0.156149,-0.909075,0.,
                      -0.172837,0.955857,-0.237623,0.,
                      0.90605,0.248907,0.342226,0.,
                      0.,0.,0.,1.};
               xlate =>{0.,0.,0.};
               center =>{0.,0.,0.};
            };
            GDIF.DefaultLight Lights {
               type = 0;
               state = 1;
               xform => LightXform;
            };
            GDIF.DefaultLightInfo LightInfo {
               lights => Lights;
            };
            MAdefaultView DefaultView#1 {
               handle     => <-.UIrenderView#1.handle;
               virtpal    => <-.BestVirtPal;
               light_info => <-.LightInfo;
               cameras    => {<-.DefaultCamera2D#1};
            };
         };
      };
   };
   macro norm_scaleUI {
      MAcelvector_params+IPort2 &vector_params => <-.vector_params;
      ilink parent => <-.vector_panel;
      MAUIframe norm_scale_frame {
         parent => <-.parent;
         x = 5;
         y => <-.<-.vector_typeUI.vector_type_frame.y
            + <-.<-.vector_typeUI.vector_type_frame.height + 5;
         width = 220;
         height => <-.scale_slider.y + <-.scale_slider.height + 5;
      };
/*      MAUItoggle color_toggle {
 *         parent => <-.norm_scale_frame;
 *         x = 5;
 *         y = 5;
 *         width = 65;
 *         height = 20;
 *         label = "MAVEC_COL";
 *         set => vector_params.color;
 *      };
 */
      MAUItoggle norm_toggle {
         x = 5;
         y = 25;
         height = 20;
         parent => <-.norm_scale_frame;
         label = "MAVEC_NORM_SCALE";
         set => vector_params.normalize;
      };
      MAUIslider2 scale_slider {
         parent => <-.norm_scale_frame;
         x = 5;
         y = 50;
         allwidth = 200;
         min = 0;
         max = 10;
         value => vector_params.scale;
         decimalPoints = 1;
         immediateMode = 0;
         title = "MAVEC_SCALE";
      };
   };
/*  for MicroAVS5.0  */
   macro vector_legendUI {
      MAvector_params+IPort2 &vector_params => <-.vector_params;
      ilink parent => <-.vector_panel;
      MAUIframe vector_legend_frame {
         parent => <-.parent;
         x = 5;
         y => <-.<-.norm_scaleUI.norm_scale_frame.y
            + <-.<-.norm_scaleUI.norm_scale_frame.height + 5;
         width = 220;
         height => <-.vector_legend_decimal.y + <-.vector_legend_decimal.height + 5;
      };
      MAUItoggle vector_legend_toggle {
         parent => <-.vector_legend_frame;
         x = 5;
         y = 5;
         width = 150;
         height = 20;
         label = "MAVEC_LEGEND_ON";
         set => <-.vector_params.vector_legend_on;
         active => (<-.<-.norm_scaleUI.norm_toggle.set == 0);
      };
      GMOD.parse_v set_toggle_disable {
         v_commands => switch((trigger + 1)," ","set = 0;\n");
         trigger => <-.vector_params.normalize;
         on_inst = 0;
         relative => vector_legend_toggle;
      };
      MAUIslider2 vector_legend_scale {
         parent => <-.vector_legend_frame;
         value => <-.vector_params.vector_legend_scale;
         x = 5;
         y = 30;
         allwidth = 200;
         active => (<-.vector_legend_toggle.set == 1 && <-.vector_legend_toggle.active == 1);
         min = 0.;
         max = 8.;
         decimalPoints = 1;
         immediateMode = 1;
         title = "MAVEC_LEGEND_SCALE";
      };
      MAUIslider2 vector_legend_x {
         parent => <-.vector_legend_frame;
         x = 5;
         y = 70;
         allwidth = 200;
         min = -1;
         max = 1;
         value => <-.vector_params.vector_legend_x;
         decimalPoints = 2;
         immediateMode = 0;
         title = "MAVEC_LEGEND_XPOS";
         active => (<-.vector_legend_toggle.set == 1 && <-.vector_legend_toggle.active == 1);
      };
      MAUIslider2 vector_legend_y {
         parent => <-.vector_legend_frame;
         x = 5;
         y = 110;
         allwidth = 200;
         min = -1;
         max = 1;
         value => <-.vector_params.vector_legend_y;
         decimalPoints = 2;
         immediateMode = 0;
         title = "MAVEC_LEGEND_YPOS";
         active => (<-.vector_legend_toggle.set == 1 && <-.vector_legend_toggle.active == 1);
      };
      MAUIslider2 vector_legend_decimal {
         parent => <-.vector_legend_frame;
         x = 5;
         y = 150;
         allwidth = 200;
         min = 0;
         max = 8;
         value => <-.vector_params.vector_legend_Decimal;
         decimalPoints = 0;
         immediateMode = 0;
         title = "MAVEC_LEGEND_DECIMAL";
         active => (<-.vector_legend_toggle.set == 1 && <-.vector_legend_toggle.active == 1);
      };
   };
/*  for MicroAVS5.0  */
};

MAmodule MAcelvector {
   ilink slice_in;
   ilink in_pick;
   MAcelvector_params+IPort2 &vector_params;

   macro MAarrow1 {
      MAcelvector_params+IPort2 &vector_params => <-.vector_params;
      GMOD.parse_v set_preview {
         v_commands = "values=>{0,0,0,1,0,0,lx,ly,0,lx,ly*-1,0};";
         relative => <-.vector_params.arrow1.glyph1.coordinates;
      };
      GMOD.parse_v set_apply {
         v_commands =
            "$push -usr\nvalues={cs,0,0,ce,0,0,ls,ly,0,ls,ly*-1,0};$pop\n";
         trigger => <-.vector_params.arrow1_apply;
         on_inst = 0;
         relative => <-.vector_params.arrow1.glyph_out.coordinates;
      };
      GMOD.parse_v set_reset {
         trigger => <-.vector_params.arrow1_reset;
         on_inst = 0;
         relative => <-.vector_params;
         v_commands = "$push\n"
                     +"arrow1_t=30;arrow1_l=0.3;arrow1_apply=1;"
                     +"$pop\n";
      };
      GMOD.parse_v set_center {
         trigger => <-.vector_params.center;
         on_inst = 0;
         relative => <-.vector_params.arrow1.glyph_out.coordinates;
         v_commands =
             "$push -usr\nvalues={cs,0,0,ce,0,0,ls,ly,0,ls,ly*-1,0};$pop\n";
       };
   };

   macro MAarrow2 {
      MAcelvector_params+IPort2 &vector_params => <-.vector_params;
      GMOD.parse_v set_preview {
         v_commands = "values =>{0.0,-w/2., 0.0, lx,-w/2., 0.0, lx, w/2., 0.0,"
                     +          "0.0, w/2, 0.0, lx, -ly, 0.0, 1.0, 0.0, 0.0,"
                     +          "lx,  ly, 0.0 };";
         relative =><-.vector_params.arrow2.glyph2.coordinates;
      };
      GMOD.parse_v set_apply {
         v_commands = "$push -usr\n"
                     +"values = {cs,-w/2., 0.0, ls,-w/2., 0.0, ls, w/2., 0.0,"
                     +          "cs, w/2., 0.0, ls, -ly, 0.0, ce, 0.0, 0.0,"
                     +          "ls,  ly, 0.0};$pop\n";
         trigger =><-.vector_params.arrow2_apply;
         on_inst = 0;
         relative =><-.vector_params.arrow2.glyph_out.coordinates;
      };
      GMOD.parse_v set_reset {
         trigger => <-.vector_params.arrow2_reset;
         on_inst = 0;
         relative => <-.vector_params;
         v_commands = "$push\n"
                     +"arrow2_t=30;arrow2_l=0.4;arrow2_w=0.2;arrow2_apply=1;"
                     +"$pop\n";
      };
      GMOD.parse_v set_center {
         trigger => <-.vector_params.center;
         on_inst = 0;
         relative => <-.vector_params.arrow2.glyph_out.coordinates;
         v_commands = "$push -usr\n"
                     +"values = {cs,-w/2., 0.0, ls,-w/2., 0.0, ls, w/2., 0.0,"
                     +          "cs, w/2., 0.0, ls, -ly, 0.0, ce, 0.0, 0.0,"
                     +          "ls,  ly, 0.0};$pop\n";
      };
   };
   macro MAarrow3 {
      MAcelvector_params+IPort2 &vector_params => <-.vector_params;
      GMOD.parse_v set_preview {
         v_commands = "values => concat_array(cone.xyz,hex.xyz);";
         relative =><-.vector_params.arrow3.arrow3.coordinates;
      };
      GMOD.parse_v set_apply {
         v_commands = "$push -usr\n"
                     +"glyph_out.nnodes = <-.hex.nxyz + <-.cone.nxyz;glyph_out.coordinates.values[.nvals][.veclen] = concat_array(cone.xyz,hex.xyz);hex_apply.ncells = hex_set.ncells;hex_apply.node_connect_list = hex_set.node_connect_list;tri_apply.ncells = tri_set.ncells;tri_apply.node_connect_list = tri_set.node_connect_list;$pop\n";
         trigger =><-.vector_params.arrow3_apply;
         on_inst = 0;
         relative =><-.vector_params.arrow3;
      };
      GMOD.parse_v set_reset {
      	trigger => <-.vector_params.arrow3_reset;
      	on_inst = 0;
      	relative => <-.vector_params;
      	v_commands = "$push\n"
      		    +"arrow3_r=0.15;arrow3_l=0.3;arrow3_s=4;arrow3_apply=1;"
      		    +"$pop\n";
      };
      GMOD.parse_v set_center {
         trigger => <-.vector_params.center;
         on_inst = 0;
         relative => <-.vector_params.arrow3;
         v_commands = "$push -usr\n"
                     +"glyph_out.nnodes = <-.hex.nxyz + <-.cone.nxyz;glyph_out.coordinates.values[.nvals][.veclen] = concat_array(cone.xyz,hex.xyz);hex_apply.ncells = hex_set.ncells;hex_apply.node_connect_list = hex_set.node_connect_list;tri_apply.ncells = tri_set.ncells;tri_apply.node_connect_list = tri_set.node_connect_list;$pop\n";
         };
   };

   MADVglyph vector {
      MAcelvector_params+IPort2 &vector_params => <-.vector_params;
      in => switch(vector_params.all_nodes+1, <-.slice_in, <-.fld_in);
      glyph => switch(vector_params.arrow_type+1,
                      vector_params.arrow1.fld_out,
                      vector_params.arrow2.fld_out,
                      vector_params.arrow3.fld_out
                     );
      glyph_comp => vector_params.glyph_comp;
      map_comp => vector_params.map_comp;
      scale_comp => vector_params.scale_comp;
      vector => vector_params.vector;
      scale => vector_params.scale;
      scale_x => vector_params.scale_x;
      scale_y => vector_params.scale_y;
      scale_z => vector_params.scale_z;
      normalize => vector_params.normalize;
   };
   MADVextract_mesh extract_color {
      in => vector.out;
   };
   fld_out => switch(vector_params.color+1,.extract_color.out,.vector.out);

/*  for MicroAVS5.0  */
   Mesh &vector_legend<NEportLevels={1,1}> => switch((vector_params.arrow_type + 1),
                                                      vector_params.arrow1.fld_out,
                                                      vector_params.arrow2.fld_out,
                                                      vector_params.arrow3.fld_out);
   MADVcoord_math set_point {
      in1+nres => <-.vector_legend;
      operation_x => "((#1x *" + str_format(<-.vector_params.vector_legend_Format, <-.vector_params.vector_legend_scale)
                      + ") / 5.0) - 0.03 + (" + str_format(<-.vector_params.vector_legend_Format, <-.vector_params.vector_legend_x) + ")";
      operation_y => "((#1y *" + str_format(<-.vector_params.vector_legend_Format, <-.vector_params.vector_legend_scale)
                      + ") / 5.0) - 0.05 + (" + str_format(<-.vector_params.vector_legend_Format, <-.vector_params.vector_legend_y) + ")";
      operation_z => "(#1z / 5.0)";
   };
   MicroAVS.MAGDxform_edit+nosave MAGDxform_edit{
      shell_vis = 1;
      absolute = 1;
      xform+nres => <-.in_pick.xform;
   };
   Text text_fld<NEportLevels={0,1}>{
      align_horiz = 1;
      nspace = 2;
      position[.nspace] => {(((<-.vector_params.vector_legend_scale)/10.0) - 0.03 + <-.vector_params.vector_legend_x)
                          ,<-.vector_params.vector_legend_y};
      str => str_format(<-.vector_params.vector_legend_Format,(((1. / <-.vector_params.scale) / <-.MAGDxform_edit.scale) * <-.vector_params.vector_legend_scale));
   };
   MAdefaultObject vector_obj<NEportLevels={0,1}> {
      input => <-.set_point.out;
      xform_mode = "Locked";
      visible => <-.vector_params.vector_legend_on;
      name = "NOOBJLIST Vector Legend";
   };
   MAdefaultObject text_obj<NEportLevels={0,1}> {
      input => <-.text_fld;
      xform_mode = "Locked";
      visible => <-.vector_params.vector_legend_on;
      name = "NOOBJLIST Vector Legend Text";
   };
   ilink vector_out<NEportLevels={1,2}> => .vector_obj;
   ilink text_out<NEportLevels={1,2}> => .text_obj;

/*  for MicroAVS5.0  */

};
