//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAdmap2img.v#1 $

/* module MADmap2Image */

module MADmap2Image
{
   /* The datamap to be visualized by turning it into an image */
   DMAP.DatamapTempl+IPort2 &dmap;

   /* Dimensions of the output image; */
   int+IPort2 width  = 100;
   int+IPort2 height =  20;

   /* 0 means ordinary dmap, */
   /* 1 means checkerboard underlay to show transparency */
   int+IPort2 Mode = 0;

   /* input paramater for MicroAVS scalar to texture */
   double+IPort2 min = 0;
   double+IPort2 max = 0;
   double+IPort2 curmin = 0;
   double+IPort2 curmax = 0;
   double+IPort2 min_col_val = 0;
   double+IPort2 max_col_val = 0;
	
   omethod+req+notify_inst update
   (
      /* params for MicroAVS */
      min+read+notify+req,
      max+read+notify+req,
      curmin+read+notify+req,
      curmax+read+notify+req,
      min_col_val+read+notify+req,
      max_col_val+read+notify+req,
      /* original */
      width+read+notify+req,
      height+read+notify+req,
      Mode+read+notify+req,
      dmap+read+notify+req,
      out+write
   ) = "MADmap2Image_update";

   FLD.Image_ARGB+OPort2 out;
};
/* end of module MADmap2Image */

/* end of file Madmap2img.v*/
