/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAextedg.v#1 $
*/
MAparams MAext_edges_params {
   int edge_angle = 1;
   boolean color  = 1;
   init_commands = "";
   reset_commands = "ext_edges_params.edge_angle=1;"
                   +"ext_edges_params.color=1;"
                   ;
};

MAmacroUI MAext_edgesUI {
   MAext_edges_params+IPort2 &ext_edges_params;

   height => ext_edges_panel.height;
   MAUIframe ext_edges_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.ang_slider.y + <-.ang_slider.height + 5;
   };
   MAUItoggle color_toggle {
      parent => <-.ext_edges_panel;
      x = 5;
      y = 5;
      width = 65;
      label = "MAEXTEDG_COL";
      set =><-.ext_edges_params.color;
   };
   MAUIslider2 ang_slider {
      parent => <-.ext_edges_panel;
      x = 5;
      y =><-.color_toggle.y + <-.color_toggle.height + 5;
      min = 0;
      max = 180;
      title = "MAEXTEDG_ANGLE";
      decimalPoints = 0;
      immediateMode = 0;
      value =><-.ext_edges_params.edge_angle;
      precision_oonly = 1;
   };
};

MAmodule MAext_edges {
   MAext_edges_params+IPort2 &ext_edges_params;
   Mesh &fld_in<NEportLevels={2,1}>;

   MADVext_edges ext_edges {
      in => <-.fld_in;
      angle => ((<-.ext_edges_params.edge_angle * 3.14) / 180.);
   };
   MADVextract_mesh extract_color {
      in =><-.ext_edges.out;
   };
   MADVswitch switch_data {
      in =>{<-.extract_color.out, <-.ext_edges.out};
      index => <-.ext_edges_params.color;
   };
   fld_out => switch_data.out;
};
