/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAisolin.v#1 $
*/
MAparams MAisoline_params {
   int          linenum = 5;
   float+nosave def_level_min =;
   float+nosave def_level_max =;
   float        level_min =;
   float        level_max =;
   int          level_min_deci = 2;
   int          level_max_deci = 2;
   boolean      color = 1;
   boolean      level_state = 0;
   int          current_level = 0;
   boolean      bounds = 0;
   string       text = "";
   float        level_text[] =;
   float        level[] => init_array(.linenum,.level_min,.level_max);
   float        red = 1;
   float        green = 1;
   float        blue = 1;
   int          palette_vis = 1;
   int          font_index = 0;
   int          height = 12;
   int          decimal = 2;
   int          style = 0;
   boolean+nosave fit = 0; // init. zero
   string+nosave font => FontTable[font_index];
    string+nosave FontTable[] => str_array("MAVLAB_FONTS",";");
    string+nosave SampleFontTable[] => 
                              str_array("MAVLAB_SAMPLEFONTS",";");
    string+nosave sample_font => SampleFontTable[.font_index];
   string style_str => switch(style+1,"medium-r","bold-r","medium-i","bold-i");
   string font_list => "-*-"+font+"-"+style_str+"-*-*-"+height+"-*-*-*-*-*-*-*";

/*  for MicroAVS5.0  */

      int    ContourFrequency = 1;
      int    NodeFrequency = 25;
      string+nosave Format => (("%." + decimal) + "f");

/*  for MicroAVS5.0  */

   init_commands = "";
   reset_commands =
      "isoline_params.linenum=5;"
     +"isoline_params.level_min=isoline_params.def_level_min;"
     +"isoline_params.level_max=isoline_params.def_level_max;"
     +"isoline_params.color=1;"
     +"isoline_params.level=>init_array(<-.isoline_params.linenum,<-.isoline_params.level_min,<-.isoline_params.level_max);"
     +"isoline_params.level_text = ;"
     +"isoline_params.text = \"\";"
     +"isoline_params.current_level = 0;"
     +"isoline_params.font_index = 0;"
     +"isoline_params.height = 12;"
     +"isoline_params.decimal = 2;"
     +"isoline_params.style = 0;"
     +"isoline_params.red = 1;"
     +"isoline_params.green = 1;"
     +"isoline_params.blue = 1;"
     +"isoline_params.palette_vis = 1;"
     +"isoline_params.level_state = 0;"
     +"isoline_params.bounds = 0;"
     +"isoline_params.fit = 1;"
     +"isoline_params.level_min_deci = 2;"
     +"isoline_params.level_max_deci = 2;"
     +"isoline_params.ContourFrequency = 1;"
     +"isoline_params.NodeFrequency = 25;"
     ;
};

MAmacroUI MAisolineUI {
   MAisoline_params+IPort2 &isoline_params;
   Mesh+Node_Data+IPort2 &fld_in;

   height => isoline_panel.height;
   MAUIframe isoline_panel {
      parent => <-.parent;
      y => <-.y;
      height => bounds_toggle.y + bounds_toggle.height + 5;
   };
   MAUIradioBoxLabel level_radioBox {
      parent => <-.isoline_panel;
      title = "MACONT_LABEL";
      labels = {"MACONT_SLIDER","MACONT_TEXT"};
      y = 0;
      selectedItem => <-.isoline_params.current_level;
   };
   MAUIframe level_slider_frame {
      parent => <-.isoline_panel;
      y => <-.level_radioBox.y + <-.level_radioBox.height;
      width = 230;
      height => <-.minmaxLevelUI.height + 5;
   };
   MAUIslider linenum_slider {
      parent => <-.level_slider_frame;
      x = 5;
      y = 0;
      mode="integer";
      min = 1;
      max = 100;
      value =><-.isoline_params.linenum;
      title = "MAISOL_NUM";
   };

   MAUIframe level_text_frame {
      parent => <-.isoline_panel;
      y => <-.level_radioBox.y + <-.level_radioBox.height;
      width => <-.level_slider_frame.width;
      height => <-.level_slider_frame.height;
      visible => <-.isoline_params.current_level;
   };
   MAUIlabel text_label {
      parent => <-.level_text_frame;
      y = 30;
      label = "MACONT_LEVEL_TEXT";
      alignment = "left";
   };
   MAUItext level_text {
      parent => <-.level_text_frame;
      y => <-.text_label.y + <-.text_label.height;
      text => <-.isoline_params.text;
   };
   MAstr_to_double str_to_double {
      strSrc => <-.isoline_params.text;
      dDest => <-.isoline_params.level_text;
   };
   MAUIwarningDialog str_warning {
      title = "MAERR_DIALOG_TITLE";
      message => switch(-err_no, "MACONT_ERROR_BLANK", "MACONT_ERROR_STR");
      visible => <-.str_to_double.err_no < 0;
   };
   MAUItoggle color_toggle {
      parent => <-.isoline_panel;
      x = 5;
      y => <-.level_slider_frame.y + <-.level_slider_frame.height;
      label = "MAISOL_COL";
      set =><-.isoline_params.color;
   };
   boolean level_label_flag = 1; // for Extline
   MAUItoggle level_toggle {
      parent => <-.isoline_panel;
      x = 5;
      y => <-.color_toggle.y + <-.color_toggle.height;
      label = "MACONT_DATA";
      set => <-.isoline_params.level_state;
      active = 1;
      visible => <-.level_label_flag;
      height  => .visible * 24;
   };
   MAUIbutton text_button {
      parent => <-.isoline_panel;
      y => <-.level_toggle.y + <-.level_toggle.height;
      active => <-.level_toggle.set * <-.isoline_params.color;
      label = "MACONT_FONT";
      visible => <-.level_label_flag;
      height  => .visible * 24;
   };
   macro text_font {
      ilink isoline_params => <-.isoline_params;
      ilink visible => <-.text_button.do;
      MAUIcloseDialog font_panel {
         visible => <-.visible;
         width = 490;
         height = 380;
         title = "MACONT_FONT";
      };
      MAUIOptionMenuLabel LabelFont {
         parent => <-.font_panel;
         options => <-.isoline_params.FontTable;
         x = 10;
         y = 10;
         width = 210;
         height = 30;
         selectedItem => <-.isoline_params.font_index;
         label = "MAVLAB_FONT";
      };
      MAUIOptionMenuLabel LabelStyle {
         parent => <-.font_panel;
         options => {
         "MAVLAB_NORMAL", "MAVLAB_BOLD", "MAVLAB_ITALIC", "MAVLAB_BOLDITLIC"
         };
         x = 10;
         y => <-.LabelFont.y + <-.LabelFont.height;
         width = 210;
         height = 20;
         selectedItem => <-.isoline_params.style;
         label = "MAVLAB_STYLE";
      };
      MAcolorEditorUI LabelColorEditorUI {
         parent => <-.font_panel;
         x = 240;
         y = 10;
         label = "MAVLAB_COL";
         red   => <-.isoline_params.red;
         green => <-.isoline_params.green;
         blue  => <-.isoline_params.blue;
         palette_vis  => <-.isoline_params.palette_vis;
      };
      MAUIslider HeightSlider {
         parent => <-.font_panel;
         x = 10;
         width = 210;
#ifdef MSDOS
         y = 60;
         height = 35;
#else
         y => <-.LabelStyle.y + <-.LabelStyle.height + 5;
         height = 60;
#endif //MSDOS
         title = "MAUI_SCALE";
         min = 1;
         max = 72;
         value => <-.isoline_params.height;
         mode = "integer";
         decimalPoints = 0;
      };
      MAUIframe SampleFrame {
         parent => <-.font_panel;
         x = 10;
#ifdef MSDOS
         y = 100;
         height = 70;
#else
         y => <-.HeightSlider.y + <-.HeightSlider.height;
         height = 90;
#endif //MSDOS
         width = 210;
      };
      MAUIpanel SamplePanel {
         parent => <-.SampleFrame;
         x = 0;
         y = 0;
         width =>parent.clientWidth;
         height =>parent.clientHeight;
         color.backgroundColor = "black";
      };
      MAUIlabel SampleLabel {
         parent => <-.SamplePanel;
         width =>parent.clientWidth;
         height =>parent.clientHeight;
         label = "MAVLAB_SAMPLE";
         x = 0;
#ifdef MSDOS
         y => (72 - <-.isoline_params.height * 0.7) / 2;
#else
         y = 0;
#endif //MSDOS
         fontAttributes {
            family => <-.<-.isoline_params.sample_font;
            height => max_array({1, <-.<-.isoline_params.height * 0.7});
            weight => switch(<-.<-.isoline_params.style+1,
                             "medium","bold","medium","bold");
            slant => switch(<-.<-.isoline_params.style+1,
                             "regular","regular","oblique","oblique");
         };
         color.foregroundColor = "white";
         color.backgroundColor = "black";
      };

/*  for MicroAVS5.0  */

      HeightSlider DecimalSlider {
#ifdef MSDOS
         y = 170;
#else
         y => <-.SampleFrame.y + <-.SampleFrame.height;
#endif //MSDOS
         min = 0;
         max = 10;
         title = "MACONT_DECIMAL";
         value => <-.isoline_params.decimal;
      };

      HeightSlider contourFrequencySlider {
#ifdef MSDOS
         y = 210;
#else
         y => <-.DecimalSlider.y + <-.DecimalSlider.height;
#endif //MSDOS
         min = 1.;
         max = 10.;
         title => "MAISOL_CONT_FREQ";
         value => <-.isoline_params.ContourFrequency;
      };

      HeightSlider NodeFrequencySlider {
#ifdef MSDOS
         y = 250;
#else
         y => <-.DecimalSlider.y + <-.DecimalSlider.height;
#endif //MSDOS
         min = 1.;
         max = 250.;
         title => "MAISOL_NODE_FREQ";
         value => <-.isoline_params.NodeFrequency;
      };

/*  for MicroAVS5.0  */


   };
   MAUItoggle bounds_toggle {
      parent => <-.isoline_panel;
      x = 5;
      y => <-.text_button.y + <-.text_button.height + 5;
      label = "MAISOL_BOUNDS";
      set => <-.isoline_params.bounds;
   };
   // MicroAVS 2.0 Compatibility begin
   $include v/MicroAVS/DV/compat2.v
   // MicroAVS 2.0 Compatibility end
   MADVminmaxLevelUI minmaxLevelUI {
      parent         => <-.level_slider_frame;
      y              => <-.linenum_slider.y + <-.linenum_slider.height + 5;
      fld_in         => <-.fld_in;
      level_min      => <-.isoline_params.level_min;
      level_max      => <-.isoline_params.level_max;
      level_min_deci => <-.isoline_params.level_min_deci;
      level_max_deci => <-.isoline_params.level_max_deci;
      fit            => <-.isoline_params.fit;
   };
};

MAmodule MAisoline {
   MAisoline_params+IPort2 &isoline_params;

   MAset_param set_level_min {
      trigger+nres  => is_valid(fld_in.node_data[0].min);
      in_value+nres => <-.fld_in.node_data[0].min;
      def_value     => <-.isoline_params.def_level_min;
      value         => <-.isoline_params.level_min;
   };
   MAset_param set_level_max {
      trigger+nres  => is_valid(fld_in.node_data[0].max);
      in_value+nres => <-.fld_in.node_data[0].max;
      def_value     => <-.isoline_params.def_level_max;
      value         => <-.isoline_params.level_max;
   };
   MADVswitch set_level {
      in => {<-.isoline_params.level, <-.isoline_params.level_text};
      index => <-.isoline_params.current_level;
   };
   MADVisoline isoline {
      in => <-.fld_in;
      component = 0;
      level => <-.set_level.out;
      color = 1;
   };
   MADVextract_mesh extract_iso_mesh {
      in => <-.isoline.out;
   };


/*  for MicroAVS5.0  */

   MAmodule isolabel {
      fld_in => <-.isoline.out;
      MAisoline_params+IPort2+nres &isoline_params => <-.isoline_params;
      MADVdata_math MADVdata_math {
         operation = "#1";
         in1 => <-.fld_in;
      };
      MicroAVS.MADV.MAisolabel MAisolabel {
         in_fld<NEdisplayMode="open"> => <-.MADVdata_math.out;
         params{
            Active => (is_valid(<-.in_fld) && <-.<-.isoline_params.level_state);
            ContourFrequency => <-.<-.isoline_params.ContourFrequency;
            NodeFrequency => <-.<-.isoline_params.NodeFrequency;
            Format => <-.<-.isoline_params.Format;
         };
         out<NEportLevels={0,2}>;
      };
      fld_out => .MAisolabel.out;
      olink out_text => string_vals;
      link out_vals<NEportLevels={1,1}> => MAisolabel.out.node_data[0].values;
      string string_vals<NEportLevels={1,2}>[] => str_format(isoline_params.Format,.out_vals);
   };
   Grid+Xform+TextValues TextField<NEportLevels={0,1}> {
      nnodes+nres => <-.isolabel.fld_out.nnodes;
      nspace+nres => <-.isolabel.fld_out.nspace;
      &coordinates+nres => <-.isolabel.fld_out.coordinates;
      text_values+nres => <-.isolabel.out_text;
      align_horiz = 1;
      align_vert = 2;
   };


/*  for MicroAVS5.0  */


   MAdataObject textObject {
      ilink isoline_params => <-.isoline_params;
      in => <-.TextField;
      Obj {
         name = "NOOBJLIST textObject";
         visible => <-.isoline_params.level_state;
      };
      Props {
         col =>{<-.isoline_params.red,
                <-.isoline_params.green,
                <-.isoline_params.blue};
         font => <-.isoline_params.font_list;
      };
   };
   MADVextract_mesh extract_mesh {
      in => <-.fld_in;
   };
   MADVext_edges ext_edges {
      in => <-.extract_mesh.out;
      angle = 1.0;
   };
   MAdataObject boundsObject {
      ilink isoline_params => <-.isoline_params;
      in => <-.ext_edges.out;
      Obj {
         name = "NOOBJLIST Isoline Bounds";
         visible => <-.isoline_params.bounds;
         xform =>; // must be no xform
      };
   };

   fld_out => switch((.isoline_params.color + 1),extract_iso_mesh.out,isoline.out);
   olink text_out => textObject.obj;
   olink bounds_out => boundsObject.obj;
};
