/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAmodule.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAmodule.v#1 $
*/
//
// MicroAVS Data Visualization Module Templates and Parts
//
MAcommon_params MAmodule_common_params {
   boolean obj_vis = 1;
   boolean+nosave save;
   string+nosave mvg_filename;
   init_commands = "";
   reset_commands = "params.obj_vis=1;params.mvg_filename=;";
};

MAcommonUI MAmoduleCommonUI {
   MAmodule_common_params &params<NEportLevels={2,1}>;

   MAUItoggle obj_show_toggle {
      parent => <-.panel;
      label = "MAUI_DISPLAY";
      x =  5;
      y = 13;
      width = 100;
      height = 24;
      color.foregroundColor = MAVS_RED;
      set => <-.params.obj_vis;
   };
   MAUIbutton save_button {
      parent => <-.panel;
      x = 170;
      y = 10;
      width = 24;
      height = 24;
      label = "MAUI_SAVE_MVG";
      labelPixmap.filename = MAVS_ICON_PATH + "bsave.x";
      labelPixmap.fileType = "avs_image";
      active = 1;
      do => <-.params.save;
   };
};

macro MAmodule/*<hconnect=2, locked=0>*/ {
   ilink fld_in;
   MAmodule_common_params &params<NEportLevels={2,1}>;

   olink fld_out;
};

MAmacro MAnetwork<hconnect=2, export_all=0/*, locked=0*/> {
   ilink fld_in;
   Params {
      MAmodule_common_params params<NEportLevels={0,1}>;
      MAcolmap_params colmap_params { title => <-.<-.title; };
   };
   MAmodule_common_params &params<NEportLevels={1,1}> => .Params.params;
   string titleS;
   GMOD.copy_on_change set_title { // for Unix version bug
      input => <-.title;
      output => <-.titleS;
      on_inst = 1;
      //copy_on_change<weight=3>;
   };
   MAUImod_panel mod_panel { // auto connection to Control Panel
      title => <-.titleS;
      icon => <-.params.name;
      height => <-.UI.height;
      option.set => <-.<-.params.visible;
   };
   UI {
      help_path = "method";
      ilink fld_in => <-.fld_in;
      ilink parent => <-.mod_panel;
      int height => MAmoduleCommonUI.height;
      MAmodule_common_params &params<NEportLevels={2,1}> => <-.Params.params;

      MAmoduleCommonUI MAmoduleCommonUI {
         parent => <-.parent;
         params => <-.params;
         y = 0;
      };
      MAUIfileDialog fileDialog {
         parent+nres => <-.parent.parent;
         visible => <-.params.save;
         isModal = 1;
         filename = "MicroAVS.mvg";
         geom_types = "*.mvg";
         geom_types_name = "MAFT_MVG_NAME";
         confirmFileWrite = 1;
         title = "MAUI_SAVE_MVG";
         current_directory => MAVS_WRITE_DATA_PATH;
      };
      GMOD.copy_on_change set_file {
         input => <-.fileDialog.filename;
         output => <-.params.mvg_filename;
         on_inst = 0;
      };
   };
   macro Modules {
      MAmodule_common_params &params<NEportLevels={2,1}> => <-.Params.params;
      ilink Params => <-.Params;
      ilink fld_in => <-.fld_in;
      ilink obj_in => <-.DataObject.obj;

      MAmvgeo_writer MAsaveMVG {
         in => fld_out;
         filename => <-.params.mvg_filename;
         color_size => <-.Params.colmap_params.color_size;
         curmin => <-.Params.colmap_params.curmin;
         curmax => <-.Params.colmap_params.curmax;
         min_col_val => <-.Params.colmap_params.min_col_val;
         max_col_val => <-.Params.colmap_params.max_col_val;
         min_h => <-.Params.colmap_params.min_h;
         min_s => <-.Params.colmap_params.min_s;
         min_v => <-.Params.colmap_params.min_v;
         max_h => <-.Params.colmap_params.max_h;
         max_s => <-.Params.colmap_params.max_s;
         max_v => <-.Params.colmap_params.max_v;
      };

      //olink legend_out;
      //olink plane_out;
      //olink line_out;
      olink fld_out;
   };
   MAdataObject DataObject {
      MAmodule_common_params &params => <-.Params.params;
      in => <-.Modules.fld_out;
#ifdef BADWAY
      child_objs+nres => switch(
         is_valid(<-.Modules.legend_out)
        +is_valid(<-.Modules.line_out)*2
        +is_valid(<-.Modules.plane_out)*4,
      { <-.Modules.legend_out },
      { <-.Modules.line_out },
      { <-.Modules.legend_out, <-.Modules.line_out },
      { <-.Modules.plane_out },
      { <-.Modules.legend_out , <-.Modules.plane_out },
      { <-.Modules.line_out, <-.Modules.plane_out },
      { <-.Modules.legend_out , <-.Modules.line_out, <-.Modules.plane_out }
      );
#endif //BADWAY
      Obj {
         xform_mode = GD_XFORM_MODE_PARENT;
         name => <-.<-.title;
         visible => <-.params.obj_vis;
      };
   };
   olink obj_out => .DataObject.obj;
};
