/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAorthos.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAorthos.v#1 $
*/
//
// Orthoslice
//
MAparams MAorthoslice_params {
   int axis = 2;
   int planeI =;
   int planeJ =;
   int planeK =;
   int plane[3] => { planeI, planeJ, planeK };
   int+nosave def_planeI =;
   int+nosave def_planeJ =;
   int+nosave def_planeK =;
   int+nosave def_plane[3] => { def_planeI, def_planeJ, def_planeK };
   init_commands = "";
   reset_commands =
        "orthoslice_params.axis=2;"
       +"orthoslice_params.planeI=;"
       +"orthoslice_params.planeJ=;"
       +"orthoslice_params.planeK=orthoslice_params.def_planeK;"
       ;
};

MAmacroUI MAorthosliceUI {
   MAorthoslice_params+IPort2 &orthoslice_params;
   Mesh+Node_Data+IPort2 &fld_in;
   int+nres max_value => fld_in.dims[orthoslice_params.axis] - 1;

   height => orthoslice_panel.height;
   MAUIframe orthoslice_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.plane_slider.y + <-.plane_slider.height + 5;
   };
   MAUIradioBoxLabel axis_button {
      labels => { "MAORTH_I", "MAORTH_J", "MAORTH_K"};
      title = "MAORTH_SEL_AXIS";
      parent => <-.orthoslice_panel;
      x = 5;
      y = 5;
      selectedItem => orthoslice_params.axis;
   };
   MAUIslider plane_slider {
      parent => <-.orthoslice_panel;
      max+nres => <-.max_value;
      value => orthoslice_params.plane[orthoslice_params.axis];
      title = "MAORTH_S_P";
      x = 5;
      y =><-.axis_button.y + <-.axis_button.height;
      decimalPoints = 0;
      immediateMode = 0;
      mode = "integer";
   };
};

MAmodule MAorthoslice {
   MAorthoslice_params+IPort2 &orthoslice_params;

   MAset_param set_plane {
      trigger+nres  => is_valid(fld_in.dims[orthoslice_params.axis]);
      in_value+nres => fld_in.dims[orthoslice_params.axis]/2;
      def_value     => <-.orthoslice_params.def_plane[orthoslice_params.axis];
      value         => <-.orthoslice_params.plane[orthoslice_params.axis];
   };
   macro+nosave orthoslice {
      Mesh_Struct+Node_Data+IPort2 &in { nnodes+req; } => <-.fld_in;
      int+IPort2 axis  => <-.orthoslice_params.axis;
      int+IPort2 plane => <-.orthoslice_params.plane[.axis];
   
      MADVorthoslice_struct MADVorthoslice_struct {
         in => <-.fld_match.links.link2;
         axis => <-.axis;
         plane => <-.plane;
      }; 
      MADVorthoslice_unif+nosave MADVorthoslice_unif {
         in => <-.fld_match.links.link0;
         axis => <-.axis;
         plane => <-.plane;
      };      
      MADVorthoslice_rect MADVorthoslice_rect {
         in => <-.fld_match.links.link1;
         axis => <-.axis;
         plane => <-.plane;
      }; 
      MADVfld_match+nosave fld_match { Mesh_Struct+IPort2 &in=> <-.in; };
      MADVswitch+nosave switch {
         in => {MADVorthoslice_unif.out,
                MADVorthoslice_rect.out,
                MADVorthoslice_struct.out};
         index => fld_match.index;
      };
      olink out => switch.out;
   }; 
   fld_out => orthoslice.out;
};
