/*
			Copyright (c) 1998 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAprobe.v#1 $
*/
//
// Probe
//
MAparams MAprobe_params {
   float scale            = 1.0;
   float decimal_point    = 2;
   int   component[]      = {0};
   int   cell_component[] = {0};
   float red              = 1.0;
   float green            = 1.0;
   float blue             = 1.0;
   float x_pos            = 0.5;
   float y_pos            = 0.5;
   boolean state          = 1;
   boolean underline      = 0;
#ifdef MSDOS
   string font            = "-*-FixedSys-medium-r-*-*-14-*-*-*-*-*-*-*";
#else
   string font            = "-adobe-times-medium-r-*-*-14-*-*-*-*-*-*-*";
#endif //MSDOS

   float normalize        = 1.0;

   int+nosave ncomp;
   string     data[ncomp];
   int+nosave cell_ncomp;
   string     cell_data[cell_ncomp];
   string     label       = "";
   string     cell_label  = "";
   float      coord[3];
   float      cell_coord[3];
   string     cell_type   = "";
   string     node_num    = "";
   string     cell_num    = "";

   boolean+nosave hasnode => ncomp > 0;
   boolean+nosave hascell => cell_ncomp > 0 ;

   init_commands  = "";
   reset_commands = 
           "probe_params{"
          +"scale=1.0;"
          +"decimal_point=2;"
          +"component[]={0};cell_component[]={0};"
          +"red=1;green=1;blue=1;"
          +"x_pos=0.5;y_pos=0.5;state=1;underline=0;"
#ifdef MSDOS
          +"font=\"-*-FixedSys-medium-r-*-*-14-*-*-*-*-*-*-*\";"
#else
          +"font=\"-adobe-times-medium-r-*-*-14-*-*-*-*-*-*-*\";"
#endif //MSDOS
          +"string data[];"
          +"string cell_data[];"
          +"label=\"\";"
          +"cell_label=\"\";"
          +"float coord[3];"
          +"float cell_coord[3];"
          +"cell_type=\"\";cell_num=\"\";node_num=\"\";"
          +"};";
};

MAmacroUI+nosave MAprobeUI {
   MAprobe_params+IPort2 &probe_params;
   ilink fld_in;

   height => probe_panel.height;

   MAUIframe probe_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.title_panel.y + <-.title_panel.height + 5;
   };
   MAUIpanel scale_panel {
      parent => <-.probe_panel;
      x = 0;
      y = 0;
      height = 130;
   };
   MAUIslider2 scale_slider {
      parent => <-.scale_panel;
      x = 5;
      y = 10;
      allwidth = 200;
      min = 0;
      max = 10;
      value => probe_params.scale;
      decimalPoints = 1;
      immediateMode = 0;
      title = "MAPROBE_SCALE";
   };
   MAUIOptionMenuLabel dicimal_menu {
      parent => <-.scale_panel;
      x = 2;
      y = 60;
      label = "MAPROBE_DECIMAL";
      options => { "0","1","2","3","4","5","6","7","8","9","10","E+10" };
      OPmenu {
         x =>((<-.x + (<-.width2 * <-.optionLabel)) + 20);
         width =>((<-.width - (<-.optionLabel * <-.width2)) - 35);
      };
      selectedItem => <-.probe_params.decimal_point;
   };
   MAUIbutton font_button {
      parent => <-.scale_panel;
      x = 10;
      y = 100;
      width = 100;
      label = "MAUI_FONT";
   };
   MAUIbutton move_button {
      parent => <-.scale_panel;
      x => <-.font_button.x + <-.font_button.width + 5;
      y => <-.font_button.y;
      width = 100;
      label = "MAUI_TRANS";
   };
   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
   };
   MADVcell_data_labels cell_data_labels {
      in => <-.fld_in;
   };
   GMOD.copy_on_change set_ncomp {
      input => <-.node_data_labels.ncomp;
      output => <-.probe_params.ncomp;
      on_inst = 1;
   };
   GMOD.copy_on_change set_cell_ncomp {
      input => <-.cell_data_labels.ncomp;
      output => <-.probe_params.cell_ncomp;
      on_inst = 1;
   };
   MAUIframe extract_panel {
      parent => <-.probe_panel;
      x = 0;
      y => <-.scale_panel.y + <-.scale_panel.height + 5;
#ifdef MSDOS
      height => switch(<-.probe_params.hasnode+1, 0, <-.OptionBox.height + 10);
#else
      height => <-.OptionBox.y + <-.OptionBox.height + 10;
#endif //MSDOS
   };
   MAUIoptionBoxLabel OptionBox {
      parent => <-.extract_panel;
      title = "MAEXTSCANODE_SEL";
      selectedItems => <-.probe_params.component;
      labels => <-.node_data_labels.labels;
      x = 5;
      y = 5;
      string &data[] => <-.probe_params.data;
      string label[] =;
      string &data_label[] => <-.node_data_labels.labels;
      GMOD.parse_v concat {
         v_commands="label = data_label + \" : \" + data;\nlabels=label;\n";
         trigger => <-.<-.probe_params.data[0];
         on_inst = 0;
         relative => <-;
      };
   };
   MAUIframe extract_cell_panel {
      parent => <-.probe_panel;
      x = 0;
      y => <-.extract_panel.y + <-.extract_panel.height + 5;
#ifdef MSDOS
      height => <-.probe_params.hascell * 
                (<-.extract_cell_component_rbl.y
                 + <-.extract_cell_component_rbl.height + 10);
#else
      height => <-.extract_cell_component_rbl.y + <-.extract_cell_component_rbl.height + 10;
#endif //MSDOS
   };
   MAUIoptionBoxLabel+nosave extract_cell_component_rbl {
      labels => <-.cell_data_labels.labels;
      x = 5;
      y = 5;
      parent => <-.extract_cell_panel;
      title = "MAEXTCELLCOMP_SEL";
      selectedItems => <-.probe_params.cell_component;
      string &data[] => <-.probe_params.cell_data;
      string label[] = "";
      string &data_label[] => <-.cell_data_labels.labels;
      GMOD.parse_v concat {
         v_commands="label = data_label + \" : \" + data;\nlabels=label;\n";
         trigger => <-.<-.probe_params.cell_data[0];
         on_inst = 0;
         relative => <-;
      };
   };
   MAUIpanel title_panel {
      parent => <-.probe_panel;
      x = 0;
#ifdef MSDOS
      y => 5 + switch(<-.probe_params.hascell+1,
                  <-.extract_panel.y + <-.extract_panel.height, 
                  <-.extract_cell_panel.y + <-.extract_cell_panel.height);
#else
      y => <-.extract_cell_panel.y + <-.extract_cell_panel.height + 5;
#endif //MSDOS
      height => <-.cell_num_label.y + <-.cell_num_label.height + 10;
   };
   macro coord_label {
      ilink parent => <-.title_panel;
      MAUIlabel xcoord_label {
         parent => <-.parent;
         x = 10;
         y = 10;
         label => "MAPROBE_X_LABEL" + " : "
                 + switch(is_valid(probe_params.coord[0])+1, "",
                          str_format("%f", probe_params.coord[0]));
         alignment = "left";
      };
      xcoord_label ycoord_label {
         y => <-.xcoord_label.y + 25;
         label => "MAPROBE_Y_LABEL" + " : "
                 + switch(is_valid(probe_params.coord[1])+1, "",
                          str_format("%f", probe_params.coord[1]));
      };
      xcoord_label zcoord_label {
         y => ycoord_label.y + 25;
         label => "MAPROBE_Z_LABEL" + " : "
                 + switch(is_valid(probe_params.coord[2])+1, "",
                          str_format("%f", probe_params.coord[2]));
      };
   };
   /////////// 10/7
   MAUIlabel connection_label {
      parent => <-.title_panel;
      x = 10;
      y => <-.coord_label.zcoord_label.y
         + <-.coord_label.zcoord_label.height + 5;
      label => "MAPROBE_CONNECTION_LABEL" + " : " + probe_params.node_num;
      alignment = "left";
   };
   connection_label cell_label {
      parent => <-.title_panel;
      x = 10;
      y => <-.connection_label.y + <-.connection_label.height + 5;
      label => "MAPROBE_CELL_LABEL" + " : " + probe_params.cell_type;
   };
   connection_label cell_num_label {
      parent => <-.title_panel;
      x = 10;
      y => <-.cell_label.y + <-.cell_label.height + 5;
      label => "MAPROBE_CELLNUM_LABEL" + " : " + probe_params.cell_num;
   };
   /////////////////////////
/////
#ifdef MSDOS
   MAUIfontDialog font_dialog
#else
   MAGDfontDialogUnix font_dialog
#endif //MSDOS
   {
      parent    => <-.probe_panel;
      visible   => <-.font_button.do;
      red       => <-.probe_params.red;
      green     => <-.probe_params.green;
      blue      => <-.probe_params.blue;
      underline => <-.probe_params.underline;
      font      => <-.probe_params.font;
   };
   MAUIlabelMoveDialog move_dialog {
#ifdef MSDOS
      parent         => <-.probe_panel;
#else
      // on Unix, it makes a crash.
#endif //MSDOS
      visible        => <-.move_button.do;
      xpos           => <-.probe_params.x_pos;
      ypos           => <-.probe_params.y_pos;
      front_back_vis = 0;
      reset_commands = "xpos=0.5;ypos=0.5;";
   };
};

MAmodule MAprobe {
   MAGDobject_templ+IPort2 &in_pick;
   MAprobe_params+IPort2   &probe_params;

   MADVprobe DVprobe {
      picked_fld+nres => in_pick.input;
      probe_fld => DVglyph.out;
      picked_xyz+nres => in_pick.pick_info.pick_data[0].point;
      picked_xform+nres => in_pick.xform;
      out_xyz[3] => {<-.probe_params.coord[0],
                     <-.probe_params.coord[1],
                     <-.probe_params.coord[2]};
   };
   Mesh fprobe {
      nnodes = 1;
      nspace = 3;
      coordinates.values => DVprobe.out_xyz;
      &xform => DVprobe.probe_xform;
   };
   MADVinterp_data DVinterp_data {
      in => switch(<-.probe_params.hasnode,<-.fld_in);
      probe => fprobe;
      comps[] => init_array(in.nnode_data, 0, in.nnode_data - 1);
   };
   MADVinterp_cell_data DVinterp_celldata {
      in => switch(<-.probe_params.hasnode+1,<-.fld_in);
      probe => fprobe;
      component => 0; //array_size(<-.probe_params.cell_component)-1;
   };
   MADVinterp_cell_data interp_cell_data[probe_params.cell_ncomp] {
      in => switch(<-.probe_params.hascell,<-.fld_in);
      probe => fprobe;
      component => index_of(interp_cell_data);
   };
   macro+nosave title_label {
      ilink node_data => <-.DVinterp_data.out.node_data;
      ilink probe_params => <-.probe_params;
      int   ncomp => .probe_params.ncomp;
      int   component => array_size(.probe_params.component);
      group in[ncomp] {
         float values => <-.node_data[index_of(in)].values[0][0];
         string data => values;
      };
      group in_comp[component] {
         int idx => <-.probe_params.component[index_of(in_comp)];
         float values => <-.in[idx].values;
         string fmt[] => {
                "%.0f", "%.1f", "%.2f", "%.3f", "%.4f",
                "%.5f", "%.6f", "%.7f", "%.8f", "%.9f", "%.10f", "%12.5E"};
         string data => str_format(fmt[<-.probe_params.decimal_point], values);
      };
      string title => probe_params.label;
      string label[ncomp] => probe_params.data;
      GMOD.parse_v copy_labels {
         on_inst = 0;
         v_commands => switch((component > 0) + 1,
                              "title=\"\";", "label=in.data;");
         trigger => <-.in.data;
         relative => <-;
      };
      MAcombine_str combine_str {
         str_in[] => switch(component > 0, <-.in_comp.data);
         str_out => <-.probe_params.label;
      };
   };
   macro+nosave title_cell_label {
      ilink probe_params => <-.probe_params;
      ilink cell_data => <-.interp_cell_data;
      int   ncomp => .probe_params.cell_ncomp;
      int   component => array_size(.probe_params.cell_component);
      group in[ncomp] {
         float values =>
            <-.cell_data[index_of(in)].out.node_data[0].values[0][0];
         string data => values;
      };
      group in_comp[component] {
         int idx => <-.probe_params.cell_component[index_of(in_comp)];
         float values => <-.in[idx].values;
         string fmt[] => {
                "%.0f", "%.1f", "%.2f", "%.3f", "%.4f",
                "%.5f", "%.6f", "%.7f", "%.8f", "%.9f", "%.10f", "%12.5E"};
         string data => str_format(fmt[<-.probe_params.decimal_point], values);
      };
      string title => probe_params.cell_label;
      string label[ncomp] => probe_params.cell_data;
      GMOD.parse_v copy_labels {
         on_inst = 0;
         v_commands => switch((component > 0) + 1,
                              "title=\"\";", "label=in.data;");
         trigger => <-.in.data;
         relative => <-;
      };
      MAcombine_str combine_str {
         str_in[] => switch(component > 0, <-.in_comp.data);
         str_out => <-.probe_params.cell_label;
      };
   };
//
   macro Cross {
      Line set1 {
         ncells = 3;
         node_connect_list = {0,1,2,3,4,5};
      };
      Mesh cross {
         int nnodes = 6;
         int nspace = 3;
         coordinates {
            float values[nvals][veclen] = {
               {-0.5,0,0},{0.5,0,0},{0,-0.5,0},{0,0.5,0},{0,0,-0.5},{0,0,0.5}
            };
         };
         int ncell_sets = 1;
         cell_set[ncell_sets] => {set1};
      };
      olink fld_out => .cross;
   };
//
   MADVglyph DVglyph {
      in => switch(<-.probe_params.hasnode+1,
                   DVinterp_celldata.out, DVinterp_data.out);
      glyph => <-.Cross.fld_out;
      glyph_comp = 0;
      map_comp = 0;
      scale_comp = 0;
      vector = 0;
      scale => probe_params.scale;
      normalize => probe_params.normalize;
      scale_x = 1;
      scale_y = 1;
      scale_z = 1;
      out {
          &xform+nonotify => fprobe.xform;
      };
   };
//   MADVextract_mesh+nosave extract_mesh {
//      in => <-.DVglyph.out;
//   };
//   MAmarkerObject markerObject{
//      in => <-.DVglyph.out;
//   };
   MAdataObjectNoTexture+nosave markerObject{
      in => <-.DVglyph.out;
      Props{
         jitter = 1;
      };
      Datamap{
         DatamapValue = {{v2=0.,v3=0.,,},{v3=0.,,,}};
      };
      Obj{
        name => ("NOOBJLIST " + name_of(<-.<-));
        type = 1;
        pickable = 0;
      };
   };
   MAlabelObject labelObject {
      obj.name   => "NOOBJLIST "+name_of(<-.<-);
      red        => <-.probe_params.red;
      green      => <-.probe_params.green;
      blue       => <-.probe_params.blue;
      label      => <-.probe_params.label;
      x_pos      => <-.probe_params.x_pos;
      y_pos      => <-.probe_params.y_pos
                   - 0.15 * array_size(<-.probe_params.component);
      state      => <-.probe_params.state;
      underline  => <-.probe_params.underline;
      font_list  => <-.probe_params.font;
   };
   labelObject Cell_labelObject {
      label      => <-.probe_params.cell_label;
      x_pos      => <-.probe_params.x_pos - 1.3;
      y_pos      => <-.probe_params.y_pos
                   - 0.15 * array_size(<-.probe_params.cell_component);
   };
   macro PickInfo {
      ilink in_pick_data => <-.in_pick.pick_info.pick_data[0];
      ilink probe_params => <-.probe_params;

      string cell_type => switch(is_valid(in_pick_data.data_id.cell_name)+1, 
                                "", in_pick_data.data_id.cell_name);
      string node_num => switch(is_valid(in_pick_data.verti)+1,
                                "", str_format("%d", in_pick_data.verti));
      string cell_num => switch(is_valid(in_pick_data.primi)+1,
                                "", str_format("%d", in_pick_data.primi));
      GMOD.copy_on_change set_cell_type {
         on_inst = 0;
         input => <-.cell_type;
         output => <-.probe_params.cell_type;
      };
      GMOD.copy_on_change set_node_num {
         on_inst = 0;
         input => <-.node_num;
         output => <-.probe_params.node_num;
      };
      GMOD.copy_on_change set_cell_num {
         on_inst = 0;
         input => <-.cell_num;
         output => <-.probe_params.cell_num;
      };
   };

   fld_out=;
//   fld_out => extract_mesh.out;
   olink marker_out => markerObject.obj;
   olink label_out => labelObject.obj;
   olink cell_label_out => Cell_labelObject.obj;
};
